function [mgdmseg, mgdmDecomp] = mgdm3d(inputVol, mgdmForces, mgdmRepo, mgdmMaxItersIn, mgdmReinitItersIn) 
% MGDM3D Runs Multiple object geometric deformable model (MGDM).
% [mgdmseg, mgdmDecomp]  = MGDM3D(inputVol)
%
% John Bogovic
% January 2013


narginchk(3,5);

% Default values for iteration count and reinitialization
mgdmMaxIters    = 100;
mgdmReinitIters = 10;

% set max iters if given as an input
if(nargin>3)
    mgdmMaxIters=mgdmMaxItersIn;
end

% set max number of iters before reinitialization if given as an input
if(nargin==5)
    mgdmReinitIters=mgdmReinitItersIn;
end


% build mgdm decomposition
mgdmDecomp = edu.jhu.ece.iacl.algorithms.MGDM.MgdmDecomposition(inputVol);


mgdmevo = edu.jhu.ece.iacl.algorithms.MGDM.MgdmEvolution(mgdmDecomp);
mgdmevo.setForce(mgdmForces); 			% set forces for mgdm 
mgdmevo.setDataRepository(mgdmRepo);		% set data for mgdm 

mgdmevo.evolveNarrowBand(mgdmMaxIters,mgdmReinitIters);

mgdmseg = mgdmDecomp.exportSegmentation3d();