function [obj tMarkAmp] = drawPlotProbeTimeMarkers(obj, hParent, tMarkInt, tMarkAmp, tMarkShow, hFig)
global plotprobe;


if plotprobe.plotConc==1
    tMarkAmp = tMarkAmp*1e6;
    tMarkUnits='(micro-molars)';
elseif plotprobe.plotOD==1
    tMarkUnits='(AU)';
end

if ~isempty(obj.h) && ishandle(obj.h(1))
    return;
end

figure(hFig);
color_fig = get(hFig,'color');

obj.h(1) = uipanel('parent',hParent,'title','Time Markers','position',obj.pos,...
                   'fontsize',10,'backgroundcolor',color_fig);


obj.h(2) = uicontrol('parent',obj.h(1),'style','edit','Tag','editPlotProbeTimeMarkersInt',...
                     'units','normalized','position',[.10 .70 .40 .20],...
                     'string',sprintf('%0.1f', tMarkInt),...
                     'backgroundcolor',color_fig,...                 
                     'callback',@editPlotProbeTimeMarkersInt_Callback);
obj.h(3) = uicontrol('parent',obj.h(1),'style','text','Tag','textTimeMarkersInt',...
                     'units','normalized','position',[.52 .70 .40 .20],...
                     'string','Interval',...
                     'horizontalalignment','left',...
                     'backgroundcolor',color_fig);

tMarkAmpStr='';
if length(tMarkAmp)==1
    tMarkAmpStr = sprintf('%0.5g', tMarkAmp);
elseif length(tMarkAmp)==2
    tMarkAmpStr = sprintf('%0.5g  %0.5g', tMarkAmp(1), tMarkAmp(2));
end

obj.h(4) = uicontrol('parent',obj.h(1),'style','edit','Tag','editPlotProbeTimeMarkersAmp',...
                     'units','normalized','position',[.10 .45 .40 .20],...
                     'string',tMarkAmpStr,...
                     'backgroundcolor',color_fig,...                     
                     'callback',@editPlotProbeTimeMarkersAmp_Callback);
obj.h(5) = uicontrol('parent',obj.h(1),'style','text','Tag','textTimeMarkersAmp',...
                     'units','normalized','position',[.52 .53 .40 .15],...
                     'string','Amplitude',...
                     'horizontalalignment','left',...
                     'backgroundcolor',color_fig);
fontsize = get(obj.h(5),'fontsize');
obj.h(6) = uicontrol('parent',obj.h(1),'style','text','Tag','textTimeMarkersAmpUnits',...
                     'units','normalized','position',[.52 .40 .45 .15],...
                     'string',tMarkUnits,...
                     'fontsize',fontsize-1,...
                     'horizontalalignment','left',...
                     'backgroundcolor',color_fig);

                  
obj.h(7) = uicontrol('parent',obj.h(1),'style','radiobutton','Tag','radiobuttonShowTimeMarkers',...
                     'units','normalized','position',[.10 .15 .70 .20],...
                     'string','show Time Markers',...
                     'value',tMarkShow, ...
                     'backgroundcolor',color_fig,...
                     'callback',@radiobuttonShowTimeMarkers_Callback);

