function axesv = initAxesv(handles, mode)

if ~exist('handles','var')
    axesv = struct(...
        'name', 'axesv', ...
        'handles', struct(...
              'axesSurfDisplay', [], ...
              'panelRotate', [], ...
              'menuItemLight1',[], ...
              'menuItemLight2',[], ...
              'menuItemLight3',[], ...
              'menuItemLight4',[], ...
              'menuItemLight5',[], ...
              'menuItemLight6',[], ...
              'menuItemLight7',[], ...
              'menuItemLight8',[], ...
              'menuItemViewOrigin',[], ...
              'lighting', [], ...
              'pushbuttonRotVerticalLeft', [], ...
              'pushbuttonRotVerticalRight', [], ...
              'pushbuttonRotUp', [], ...
              'pushbuttonRotDown', [], ...
              'pushbuttonRotHorizontalLeft', [], ...
              'pushbuttonRotHorizontalRight', [], ...
              'pushbuttonZoomIn', [], ...
              'pushbuttonZoomOut', [], ...
              'editDegRotation', [], ...
              'pushbuttonStandardViewsAnterior', [], ...
              'pushbuttonStandardViewsPosterior', [], ...
              'pushbuttonStandardViewsRight', [], ...
              'pushbuttonStandardViewsLeft', [], ...
              'pushbuttonStandardViewsSuperior', [], ...
              'pushbuttonStandardViewsInferior', [], ...
              'editViewAnglesAzimuth', [], ...
              'editViewAnglesElevation', [], ...
              'axes',[] ...
        ), ...
        'zoominitfactor', 5, ...
        'zoomincr', 1.2, ...
        'rotation', struct('degrees',10), ...
        'lighting', ones(8,2), ...
        'azimuth',150, ...
        'elevation', 30, ...
        'cameratarget', [], ...
        'cameraposition', [], ...
        'cameraupvector',[0 1 0], ...
        'mode', 'surface', ...
        'checkCompatability',@checkCompatability, ...
        'prepObjForSave',[], ...
        'errmsg', {{}} ...
        );
    return;
end

if ~exist('mode','var') | isempty(mode)
    mode=0;
end

axesv = struct(...
               'name', 'axesv', ...
               'handles', struct(...
                                 'axesSurfDisplay', handles.axesSurfDisplay, ...
                                 'panelRotate', handles.panelRotateZoomAxes, ...
                                 'menuItemLight1',handles.menuItemLight1, ...
                                 'menuItemLight2',handles.menuItemLight2, ...
                                 'menuItemLight3',handles.menuItemLight3, ...
                                 'menuItemLight4',handles.menuItemLight4, ...
                                 'menuItemLight5',handles.menuItemLight5, ...
                                 'menuItemLight6',handles.menuItemLight6, ...
                                 'menuItemLight7',handles.menuItemLight7, ...
                                 'menuItemLight8',handles.menuItemLight8, ...
                                 'menuItemViewAxesXYZ',handles.menuItemViewAxesXYZ, ...
                                 'menuItemViewAxesRAS',handles.menuItemViewAxesRAS, ...
                                 'lighting', [], ...
                                 'pushbuttonRotVerticalLeft', handles.pushbuttonRotVerticalLeft, ...
                                 'pushbuttonRotVerticalRight', handles.pushbuttonRotVerticalRight, ...
                                 'pushbuttonRotUp', handles.pushbuttonRotUp, ...
                                 'pushbuttonRotDown', handles.pushbuttonRotDown, ...
                                 'pushbuttonRotHorizontalLeft', handles.pushbuttonRotHorizontalLeft, ...
                                 'pushbuttonRotHorizontalRight', handles.pushbuttonRotHorizontalRight, ...
                                 'pushbuttonZoomIn', handles.pushbuttonZoomIn, ...
                                 'pushbuttonZoomOut', handles.pushbuttonZoomOut, ...
                                 'editDegRotation', handles.editDegRotation, ...
                                 'pushbuttonStandardViewsAnterior', handles.pushbuttonStandardViewsAnterior, ...
                                 'pushbuttonStandardViewsPosterior', handles.pushbuttonStandardViewsPosterior, ...
                                 'pushbuttonStandardViewsRight', handles.pushbuttonStandardViewsRight, ...
                                 'pushbuttonStandardViewsLeft', handles.pushbuttonStandardViewsLeft, ...
                                 'pushbuttonStandardViewsSuperior', handles.pushbuttonStandardViewsSuperior, ...
                                 'pushbuttonStandardViewsInferior', handles.pushbuttonStandardViewsInferior, ...
                                 'editViewAnglesAzimuth', handles.editViewAnglesAzimuth, ...
                                 'editViewAnglesElevation', handles.editViewAnglesElevation, ...
                                 'axes',[] ...
                                ), ...
               'zoominitfactor', 5, ...
               'zoomincr', 1.2, ...
               'rotation', struct('degrees',10), ...
               'lighting', ones(8,2), ...
               'azimuth',150, ...
               'elevation', 30, ...
               'cameratarget', [], ...
               'cameraposition', [], ...
               'cameraupvector',[0 1 0], ... 
               'mode', 'surface', ...
               'checkCompatability',[], ...
               'prepObjForSave',[], ...
               'errmsg', {{}} ...
              );


          
axesv(1).errmsg{1} = sprintf('This volume is missing orientation setting. To use this function the head orientation has to be set.\nUse the Find Ref Pts menu option in the Tools menu to select reference points to set head orientation');          
          
          
cla(handles.axesSurfDisplay,'reset');
set(handles.axesSurfDisplay,{'xgrid','ygrid','zgrid'},{'on','on','on'});
set(handles.axesSurfDisplay,'visible','off');
set(handles.axesSurfDisplay,'cameraviewangle', axesv.zoominitfactor);

set(handles.pushbuttonRotVerticalLeft, 'callback', @pushbuttonRotVerticalLeft_Callback);
set(handles.pushbuttonRotHorizontalLeft, 'callback', @pushbuttonRotHorizontalLeft_Callback);
set(handles.pushbuttonRotDown, 'callback', @pushbuttonRotDown_Callback);
set(handles.pushbuttonRotHorizontalRight, 'callback', @pushbuttonRotHorizontalRight_Callback);
set(handles.pushbuttonRotUp, 'callback', @pushbuttonRotUp_Callback);
set(handles.pushbuttonRotVerticalRight, 'callback', @pushbuttonRotVerticalRight_Callback);
set(handles.editDegRotation, 'callback', @editDegRotation_Callback);
set(handles.pushbuttonZoomIn, 'callback', @buttonZoomIn_Callback);
set(handles.pushbuttonZoomOut, 'callback', @buttonZoomOut_Callback);

% Set axes pan style to camera. Unfortunately setAxes3DPanAndZoomStyle only
% exists since R2016a
if verGreaterThanOrEqual('matlab','9.0')
    setAxes3DPanAndZoomStyle(zoom(handles.axesSurfDisplay), handles.axesSurfDisplay, 'camera')
end


axesv.rotation.degrees                     = str2num(get(handles.editDegRotation,'string'));
axesv.handles.panelRotate                  = handles.panelRotateZoomAxes;
axesv.handles.axesSurfDisplay              = handles.axesSurfDisplay;

setappdata(axesv.handles.axesSurfDisplay, 'hOrigin',zeros(2,6)-1);
setappdata(axesv.handles.axesSurfDisplay, 'hViewOrigin',[handles.menuItemViewAxesXYZ, handles.menuItemViewAxesRAS]);

axes(axesv.handles.axesSurfDisplay);

% Set XYZ and RAS view axes colors
c = [ ...
    1.00, 0.00, 0.00; ...
    0.00, 1.00, 0.00; ...
    0.00, 0.00, 1.00 ...
    ];

setappdata(axesv.handles.axesSurfDisplay, 'colors', c);

