function imgrecon = initImgRecon(handles)
 
if ~exist('./imagerecon','dir')
    mkdir('./imagerecon');
end

imgrecon = struct(...
      'name', 'imgrecon', ...
      'pathname', '', ...
      'handles',struct(...
          'surf', [], ...
          'hLighting', [], ...          
          'pushbuttonCalcMetrics_new',[], ...
          'editColormapThreshold',[], ...
          'textColormapThreshold',[], ...
          'popupmenuImageDisplay',[], ...
          'menuItemImageReconGUI',[], ...
          'hLocalizationError', [], ...
          'hResolution', [], ...
          'hHbO', [], ...
          'hHbR', [], ...
          'ImageRecon', [], ...
          'axes',[] ...
      ),...
      'imageParams', struct(...
            'Regularization',0.01, ...
            'Sensitivity_Threshold',0.01, ...
            'Image_Threshold',0.1 ...
      ), ...
      'menuoffset',3, ...
      'localizationError',[], ...
      'resolution',[], ...
      'mesh_orig',initMesh(), ...
      'mesh',initMesh(), ...
      'cmThreshold',[0,10; 0,10; 0,10; 0,10], ...
      ... %'colormin',[.74 .47 .40], ...
      'colormin',[.80, .80, .80], ...
      'subjData',[], ...
      'iSubj', 1, ...
      'Aimg_conc', initAimg_conc(), ...
      'Aimg_conc_scalp', initAimg_conc(), ...
      'center',[], ...
      'orientation', '', ...
      'checkCompatability',[], ...
      'isempty',@isempty_loc, ...
      'prepObjForSave',@prepImgReconForSave ...
);

% imgrecon.cmThresholdMetrics = str2num(get(imgrecon.handles.editColormapThreshold,'string'));
imgrecon = resetImgRecon(imgrecon);

if exist('handles','var')
    imgrecon.handles.pushbuttonCalcMetrics_new = handles.pushbuttonCalcMetrics_new;
    imgrecon.handles.editColormapThreshold = handles.editColormapThreshold;
    imgrecon.handles.textColormapThreshold = handles.textColormapThreshold;
    imgrecon.handles.popupmenuImageDisplay = handles.popupmenuImageDisplay;
    imgrecon.handles.menuItemImageReconGUI = handles.menuItemImageReconGUI;
    imgrecon.handles.axes = handles.axesSurfDisplay;
    if ishandles(handles.hGroupList)
        idx = get(handles.hGroupList, 'value');
        if idx==1
            imgrecon.iSubj = 0;
        elseif idx > 1
            imgrecon.iSubj = idx-1;
        end
    end
    
    if ishandles(handles.ImageRecon)
        imgrecon.handles.ImageRecon = handles.ImageRecon;
    end
end


% ------------------------------------------------------
function imgrecon = prepImgReconForSave(imgrecon)

imgrecon = rmfield(imgrecon, 'iSubj');




% --------------------------------------------------------------
function b = isempty_loc(imgrecon)

b = false;
if isempty(imgrecon)
    b = true;
elseif (isempty(imgrecon.Aimg_conc.HbO) & isempty(imgrecon.Aimg_conc.HbR)) & ...
       (isempty(imgrecon.Aimg_conc_scalp.HbO) & isempty(imgrecon.Aimg_conc_scalp.HbR)) & ...
       (isempty(imgrecon.localizationError) & isempty(imgrecon.resolution))  
    b = true;
end

