function obj = drawPlotProbeScale(obj,hParent,axScl,hFig)

if ~isempty(obj.h)
    return;
end

figure(hFig);
color_fig = get(hFig,'color');

obj.h = uipanel('parent',hParent,'title','Scaling','units','normalized',...
                'position',obj.pos,'fontsize',10,'backgroundcolor',color_fig);
                
axSclStr = sprintf('%0.1f %0.1f', axScl(1), axScl(2));
h_edit=uicontrol('parent',obj.h, 'style','edit','Tag','editPlotProbeAxScl','units','normalized',...
                 'position',[.6 .4 .35 .3],'string',axSclStr,...
                 'backgroundcolor',color_fig,...
                 'callback',@editPlotProbeAxScl_Callback);

h_ydec=uicontrol('parent',obj.h,'style','pushbutton','Tag','pushbuttonPlotProbeYdec','units','normalized',...
                 'position',[.1  .65 .1 .2],'string','-',...
                 'callback',@pushbuttonPlotProbeYdec_Callback);
h_ytxt=uicontrol('parent',obj.h,'style','text','tag','textPlotProbeY','units','normalized',...
                 'backgroundcolor',color_fig,...
                 'position',[.25 .65 .1 .2],'string','Y');
h_yinc=uicontrol('parent',obj.h,'style','pushbutton','tag','pushbuttonPlotProbeYinc','units','normalized',...
                 'position',[.4  .65 .1 .2],'string','+',...
                 'callback',@pushbuttonPlotProbeYinc_Callback);

h_xdec=uicontrol('parent',obj.h,'style','pushbutton','tag','pushbuttonPlotProbeXdec','units','normalized',...
                 'position',[.1  .25 .1 .2],'string','-',...
                 'callback',@pushbuttonPlotProbeXdec_Callback);
h_xtxt=uicontrol('parent',obj.h,'style','text','Tag','textPlotProbeX','units','normalized',...
                 'backgroundcolor',color_fig,...
                 'position',[.25 .25 .1 .2],'string','X');
h_xinc=uicontrol('parent',obj.h,'style','pushbutton','tag','pushbuttonPlotProbeXinc','units','normalized',...
                 'position',[.4  .25 .1 .2],'string','+',...
                 'callback',@pushbuttonPlotProbeXinc_Callback);


