function [paths, wspaths, paths_excl_str] = getpaths(options)

DEBUG = 0;

paths = {...
    '/'; ...
    '/DISPLAY'; ...
    '/DISPLAY/plotProbeGUI'; ...
    '/INSTALL'; ...
    '/PACKAGES'; ...
    '/PACKAGES/AtlasViewerGUI'; ...
    '/PACKAGES/AtlasViewerGUI/Axesv'; ...
    '/PACKAGES/AtlasViewerGUI/Data'; ...
    '/PACKAGES/AtlasViewerGUI/Data/Colin'; ...
    '/PACKAGES/AtlasViewerGUI/Digpts'; ...
    '/PACKAGES/AtlasViewerGUI/ForwardModel'; ...
    '/PACKAGES/AtlasViewerGUI/Group'; ...
    '/PACKAGES/AtlasViewerGUI/Guiobj'; ...
    '/PACKAGES/AtlasViewerGUI/HbConc'; ...
    '/PACKAGES/AtlasViewerGUI/Headsurf'; ...
    '/PACKAGES/AtlasViewerGUI/Headvol'; ...
    '/PACKAGES/AtlasViewerGUI/ImgRecon'; ...
    '/PACKAGES/AtlasViewerGUI/Labelssurf'; ...
    '/PACKAGES/AtlasViewerGUI/Pialsurf'; ...
    '/PACKAGES/AtlasViewerGUI/Pialvol'; ...
    '/PACKAGES/AtlasViewerGUI/Probe'; ...
    '/PACKAGES/AtlasViewerGUI/Probe/registerDigpts'; ...
    '/PACKAGES/AtlasViewerGUI/Probe/registerSprings'; ...
    '/PACKAGES/AtlasViewerGUI/Refpts'; ...
    '/PACKAGES/AtlasViewerGUI/Tools'; ...
    '/PACKAGES/AtlasViewerGUI/Utils'; ...
    '/PACKAGES/AtlasViewerGUI/Utils/fs2viewer'; ...
    '/PACKAGES/AtlasViewerGUI/ezmapper'; ...
    '/PACKAGES/AtlasViewerGUI/freesurfer'; ...
    '/PACKAGES/AtlasViewerGUI/iso2mesh'; ...
    '/PACKAGES/AtlasViewerGUI/iso2mesh/bin'; ...
    '/PACKAGES/AtlasViewerGUI/metch'; ...
    '/PACKAGES/EasyNIRS'; ...
    '/PACKAGES/EasyNIRS/Export'; ...
    '/PACKAGES/EasyNIRS/LoadSaveData'; ...
    '/PACKAGES/EasyNIRS/NirsFiles'; ...
    '/PACKAGES/EasyNIRS/PlotProbe'; ...
    '/PACKAGES/EasyNIRS/Processing'; ...
    '/PACKAGES/NIRS_Probe_Designer_V1'; ...
    '/PACKAGES/NIRS_Probe_Designer_V1/functions'; ...
    '/PACKAGES/SDgui'; ...
    '/PACKAGES/SDgui/lambda'; ...
    '/PACKAGES/SDgui/optode_tbls'; ...
    '/PACKAGES/SDgui/optode_tbls2'; ...
    '/PACKAGES/SDgui/probe_geometry_axes'; ...
    '/PACKAGES/SDgui/probe_geometry_axes2'; ...
    '/PACKAGES/SDgui/sample_data'; ...
    '/PACKAGES/SDgui/sd_data'; ...
    '/PACKAGES/SDgui/sd_file'; ...
    '/PACKAGES/SDgui/utils'; ...
    '/PACKAGES/Utils'; ...
    '/PACKAGES/stimGUI'; ...
    '/PACKAGES/tMCimg'; ...
    '/PACKAGES/tMCimg/bin/Darwin'; ...
    '/PACKAGES/tMCimg/bin/Linux'; ...
    '/PACKAGES/tMCimg/bin/Win'; ...
    '/UTILITIES'; ...
    '/UTILITIES/REGRESSORS'; ...
    '/UTILITIES/Wavelet'; ...
    '/UTILITIES/iWLS' ...
    };


wspaths = {};
paths_excl_str = {};

if options.conflcheck
        
    % Get all workspace paths that have similar functions sets with current applications
    appmainfunc = {'Homer2_UI.m','Homer3.m','brainScape.m'};
    
    kk=1;
    wsidx = [];
    for ii=1:length(appmainfunc)
        
        while 1
            
            [paths_excl, foo] = getactivewspace(appmainfunc{ii});
            if isempty(paths_excl)
                break;
            end
            
            wspaths{kk,1} = foo;
            if pathscompare(wspaths{kk}, pwd)
                wsidx = kk;
            end
            
            paths_excl_str{kk} = '';
            for jj=1:length(paths_excl)
                if DEBUG
                    fprintf('Removing path %s\n', paths_excl{jj});
                end
                if isempty(paths_excl_str{kk})
                    paths_excl_str{kk} = paths_excl{jj};
                else
                    paths_excl_str{kk} = [paths_excl_str{kk}, delimiter, paths_excl{jj}];
                end
            end
            rmpath(paths_excl_str{kk});
            kk=kk+1;
            
        end
        
    end

    
    % Change the order of precedence of all the conflicting workspaces to
    % the current one as primary workspace
    if ~isempty(wsidx)
        strtmp = wspaths{1};
        celltmp = paths_excl_str{1};
        
        wspaths{1} = wspaths{wsidx};
        paths_excl_str{1} = paths_excl_str{wsidx};
        
        wspaths{wsidx} = strtmp;
        paths_excl_str{wsidx} = celltmp;        
    end
    
end

