function pialsurf = initPialsurf(handles)

pialsurf = struct( ...
    'pathname','', ...
    'name','pialsurf', ...
    'handles',struct(...
                  'surf',[], ...
                  'hLighting',[], ...
                  'editTransparency',[], ...
                  'radiobuttonShowPial',[], ...
                  'axes',[] ...
               ), ...
    'mesh',initMesh(), ...
    'mesh_reduced',initMesh(), ...
    'T_2vol',eye(4), ...
    'color',[.74 .47 .40], ...
    'center',[], ...    
    'orientation', '', ...    
    'checkCompatability',[], ...
    'isempty',@isempty_loc, ...
    'prepObjForSave',[] ...
    );


if exist('handles','var')
    pialsurf.handles.editTransparency = handles.editBrainTransparency;
    set(pialsurf.handles.editTransparency,'enable','off');
    
    pialsurf.handles.radiobuttonShowPial = handles.radiobuttonShowPial;
    set(pialsurf.handles.radiobuttonShowPial,'enable','off');
    
    pialsurf.handles.axes = handles.axesSurfDisplay;
end



% --------------------------------------------------------------
function b = isempty_loc(pialsurf)

b = false;
if isempty(pialsurf)
    b = true;
elseif isempty(pialsurf.mesh.vertices) | isempty(pialsurf.mesh.faces)
    b = true;
end

