function Hd = respFilter
%RESPFILTER Returns a discrete-time filter object.

%
% M-File generated by MATLAB(R) 7.7 and the Signal Processing Toolbox 6.10.
%
% Generated on: 10-Feb-2009 10:16:33
%

% Butterworth Bandpass filter designed using the BUTTER function.

% All frequency values are in Hz.
Fs = 25;  % Sampling Frequency

Fstop1 = 0.06;   % First Stopband Frequency
Fpass1 = 0.083;  % First Passband Frequency
Fpass2 = 0.5;    % Second Passband Frequency
Fstop2 = 0.8;    % Second Stopband Frequency
Astop1 = 60;     % First Stopband Attenuation (dB)
Apass  = 1;      % Passband Ripple (dB)
Astop2 = 80;     % Second Stopband Attenuation (dB)

% Calculate the order from the parameters using BUTTORD.
[N,Fc] = buttord([Fpass1 Fpass2]/(Fs/2), [Fstop1 Fstop2]/(Fs/2), Apass, ...
                 max(Astop1, Astop2));

% Calculate the zpk values using the BUTTER function.
[z,p,k] = butter(N, Fc);

% To avoid round-off errors, do not use the transfer function.  Instead
% get the zpk representation and convert it to second-order sections.
[sos_var,g] = zp2sos(z, p, k);
Hd          = dfilt.df2sos(sos_var, g);

% [EOF]
