function dx = sg_getDeriv(x)
% given signal x, we take a 25 point Savitzky-Golay smoothing filter based
% derivative across a moving window to obtain a smoothed derivative of the
% data. The first 12 and last 12 points are given value 0. 
% NOTE: x must be in the form of a column vector

%initialize dx
dx = 0*x;

% using the signal processing toolbox, gd was formed like this:
%[b,g] = sgolay(2,25);
%gd = g(:,2);
gd = [...
   -0.0092 ...
   -0.0085 ...
   -0.0077 ...
   -0.0069 ...
   -0.0062 ...
   -0.0054 ...
   -0.0046 ...
   -0.0038 ...
   -0.0031 ...
   -0.0023 ...
   -0.0015 ...
   -0.0008 ...
    0.0000 ...
    0.0008 ...
    0.0015 ...
    0.0023 ...
    0.0031 ...
    0.0038 ...
    0.0046 ...
    0.0054 ...
    0.0062 ...
    0.0069 ...
    0.0077 ...
    0.0085 ...
    0.0092];
% note that here a faster method would be to implement a convolution
for i=13:(length(x)-13)
    smallX = x((i-12):(i+12));
    dx(i) = gd * smallX;
end