/* 
 * convert FreeSurfer Surface Files to VTK PolyData files
 *
 * author:  Ipek Oguz 
 *
 */

#include "vtkPolyData.h"
#include "vtkPointData.h"
#include "vtkPolyDataWriter.h"
#include "vtkFSSurfaceReader.h"
#include "vtkFSSurfaceScalarReader.h"

#include <fstream>
#include <iostream>
#include <vector>
using namespace std ;

int main(int argc, const char **argv)
{
  if (argc <=2) 
  {
    std::cout << std::endl << "usage: FS2VTK infile outfile [wfile]" << std::endl;
    std::cout << "infile:  input freesurfer file" << std::endl;
    std::cout << "outfile: output vtk  file" << std::endl;
    std::cout << "wfile: input freesurfer w file" << std::endl;
    std::cout << std::endl << std::endl;
    exit(0);
  }

  char * infile = strdup(argv[1]);
  char * outfile = strdup(argv[2]);
  char * wfile = NULL ;
  if ( argc == 4 )
  {
    wfile = strdup ( argv[3] ) ;
  }
  
  // read the FreeSurfer mesh
  vtkFSSurfaceReader *reader = vtkFSSurfaceReader::New () ;
  reader->SetFileName ( infile ) ;
  reader->Update () ;

  vtkPolyData *mesh = reader->GetOutput() ;

  if ( wfile )
  {
    vtkFloatArray *scalars = vtkFloatArray::New() ;
    vtkFSSurfaceScalarReader *scalarReader = vtkFSSurfaceScalarReader::New () ;
    scalarReader->SetFileName ( wfile ) ;
    scalarReader->SetOutput ( scalars ) ;
    scalarReader->ReadFSScalars () ;
    scalars = scalarReader->GetOutput () ;
    //std::cout << scalars->GetNumberOfTuples() << std::endl ;
    mesh->GetPointData()->SetScalars ( scalars ) ;
  }

  // write out the vtk mesh
  vtkPolyDataWriter *writer = vtkPolyDataWriter::New () ;
  writer->SetInput ( mesh ) ;
  writer->SetFileName ( outfile ) ;
  writer->Update () ;
  
  writer->Delete () ;
  return 0 ;
}
