#ifndef __vtkKWMeshVisu_h
#define __vtkKWMeshVisu_h

#include "vtkKWObject.h"

#define MAX_NUM_POINTS 50

class vtkKWRenderWidget;
class vtkImageViewer2;
class vtkKWScale;
class vtkKWWindowLevelPresetSelector;
class vtkKWColorTransferFunctionEditor;
class vtkKWScaleWithEntry;
class vtkKWMenuButton;
class vtkKWWindow;
class vtkColorTransferFunction;
class vtkPolyData ;
class vtkPolyDataMapper;
class vtkActor;
class vtkPolyDataNormals;
class vtkGlyph3D ;
class vtkTensorGlyph ;
class vtkArrowSource ;
class vtkSphereSource ;
class vtkLoopSubdivisionFilter ;
class vtkFloatArray ;
class vtkBitArray ;
class vtkObject ;
class vtkKWCheckButton ;
class vtkKWListBoxWithScrollbarsWithLabel ;

class vtkKWMeshVisu : public vtkKWObject
{
public:
  static vtkKWMeshVisu* New();
  
  vtkTypeRevisionMacro(vtkKWMeshVisu,vtkKWObject);

  // Description:
  // Run the example.
  int Run(int argc, char *argv[]);

  // Description:
  // Callbacks
  virtual void LoadMeshCallback();
  virtual void Load1DAttributeCallback();
  virtual void Load3DAttributeCallback();
  virtual void LoadEllipsoidFieldCallback();
  virtual void LoadCurveCallback();
  virtual void LoadROICallback();
  virtual void SaveROICallback();
  virtual void CleanAttributesCallback();
  virtual void LoadAttributeMeshCallback();
  virtual void SaveAttributeMeshCallback();
  virtual void SaveColorsCallback();
  virtual void PValueCallback();
  virtual void SignedDistanceMapCallback();
  virtual void DistanceMapCallback();
  virtual void ROIMapCallback();
  virtual void OpacityCallback(double d);
  virtual void FeatureScaleCallback (double d);
  virtual void GetCameraCallback ();
  virtual void LoadParticleSetCallback () ;
  virtual void LoadParticleScalarsCallback () ;
  virtual void MakeVideoCallback () ;

  virtual void ROIMaskCheckBoxCallback ( int state ) ; 
  virtual void ROIDisableBackPickCheckBoxCallback ( int state ) ;
  virtual void ParticleVisualizationCheckBoxCallback (int state) ;
  virtual void ParticleListBoxCallback () ;
  
  int CommandLine (int argc, const char *argv[]);
  static void GenerateXMLDescription () ;

protected:
  vtkKWMeshVisu();
  ~vtkKWMeshVisu();

  vtkKWMenuButton *ColorMode ;

  vtkKWScaleWithEntry *opacityScale ;
  vtkKWScaleWithEntry *featureScale ;

  vtkKWRenderWidget *RenderWidget;
  vtkKWWindow *win;
  vtkKWColorTransferFunctionEditor *TFuncEditor;
  vtkColorTransferFunction *PValueTFunc;
  vtkColorTransferFunction *DistanceMapTFunc;
  vtkColorTransferFunction *FixedTFunc ;
  vtkColorTransferFunction *SignedDistanceMapTFunc;
  vtkColorTransferFunction *ROIMapTFunc ;

  void UpdateTFunc () 
  {
    this->UpdateDistanceMapTFunc () ;
    this->UpdateSignedDistanceMapTFunc () ;
    this->UpdateROIMapTFunc () ;
  }

  void UpdateDistanceMapTFunc ();
  void UpdateSignedDistanceMapTFunc ();
  void UpdateROIMapTFunc () ;
  void GetAttributeRange (double *r ) ;
  void Stabilize1DVisualization();
  void SaveRenderAsBMP(const char *filename) ;

  void LoadMesh(const char *fileName);
  void LoadScalarField(const char *fileName);
  void LoadVectorField(const char *fileName);
  void LoadCurve (const char *fileName);
  void LoadEllipsoidField(const char *fileName);
  void LoadROI (const char *fileName);
  void SaveROI (const char *fileName);
  void SaveColors (const char *fileName);
  void LoadParticleSet(const char *fileName);
  void LoadParticleScalars(const char *fileName);
  void MakeVideo ( const char *fileName ) ;

  vtkPolyData *vtkMesh ;
  
  vtkPolyDataMapper *meshMapper ;
  vtkActor *meshActor ;

  vtkPolyDataNormals *normalFilter ;

  vtkArrowSource *arrowSource ;
  vtkGlyph3D *arrowGlyphFilter;
  vtkPolyDataMapper *arrowGlyphMapper ;
  vtkActor *arrowGlyphActor ;

  vtkSphereSource *ellipsoidSource ;
  vtkTensorGlyph *ellipsoidGlyphFilter ;
  vtkPolyDataMapper *ellipsoidGlyphMapper ;
  vtkActor *ellipsoidGlyphActor ;

  vtkActor *aPolyLineActor ;

  void AddBall (int vertexId) ;
  void RemoveBall ( int vertexId=0) ;
  bool HasBall (int vertexId) ;
  void SwitchBall (int vertexId) ;

  void SetupInteractor () ;
  static void PointSelector (vtkObject *,unsigned long eid, void* clientdata, void *calldata) ;

  int attributeDimension ;

  bool commandLine ;

  vtkKWCheckButton *ROIMaskCheckBox ;
  vtkKWCheckButton *ROIDisableBackPickCheckBox ;
  bool ROIMaskEnabled ;
  bool ROIBackPickEnabled ;

  vtkBitArray *ROIMask ;
  vtkFloatArray *ROImaskedScalars ;
  vtkFloatArray *unmaskedScalars ;
  void ResetROIMask () ;
  void UpdateROIMaskedScalars ( int id ) ;
  double currentScalarRange[2] ;

  vtkKWCheckButton *ParticleVisualizationCheckBox ;
  vtkKWListBoxWithScrollbarsWithLabel *ParticleListBox ;
  vtkPolyData **particleSets ;
  int nParticleSets ;
  vtkFloatArray *particleScalars ;
  vtkPolyDataMapper *particleMapper ;
  vtkActor *particleActor ;
  void ResetParticleScalars() ;
private:
  vtkKWMeshVisu(const vtkKWMeshVisu&);   // Not implemented.
  void operator=(const vtkKWMeshVisu&);  // Not implemented.

  
};

#endif
