/*
 * Relax polygons: from VTK Polydata To VTK
 *
 * author:  Pengdong Xiao
 *
 */

#include "RelaxPolygonCLP.h"

#include "vtkPolyData.h"
#include "vtkPolyDataWriter.h"
#include "vtkPolyDataReader.h"
//#include "vtkGenericDataObjectWriter.h"
#include "vtkSmoothPolyDataFilter.h"
#include "vtkWindowedSincPolyDataFilter.h"

#include <fstream>
#include <iostream>
#include <vector>
using namespace std;

int main(int argc, const char * *argv)
{
  PARSE_ARGS;

  if( argc <= 4)
    {
    std::cout << "RelaxPolygon " << endl;
    std::cout << "usage: RelaxPolygon --inFile --outFile [-v]" << endl;
    std::cout << endl;
    std::cout << "inFile               input vtk file" << endl;
    std::cout << "outFile              output vtk file" << endl;
    std::cout << endl << endl;
    exit(0);
    }

  char* infile = const_cast<char*>(inFile.c_str());
  char* outfile = const_cast<char*>(outFile.c_str());

  // read in the vtk polydata filevtkPolyDataToitkMesh.cxx
  vtkPolyDataReader *reader = vtkPolyDataReader::New();
  reader->SetFileName( infile );
  reader->Update();
  vtkPolyData *polydata = reader->GetOutput();

  // smooth polydata
  /*vtkSmoothPolyDataFilter* smoother = vtkSmoothPolyDataFilter::New();
  smoother->SetInput( polydata );
  smoother->SetNumberOfIterations(20);
  smoother->SetFeatureAngle(60);
  smoother->SetRelaxationFactor(0.05);
  smoother->FeatureEdgeSmoothingOff();*/

  vtkWindowedSincPolyDataFilter* smoother = vtkWindowedSincPolyDataFilter::New();
  smoother->SetInput( polydata );
  smoother->SetNumberOfIterations(NoIteration);//20
  smoother->SetFeatureAngle(FeatureAngle);//60
  smoother->SetPassBand(PassBand);//0.05
  if (FeatureEdgeSmoothing == true)
    smoother->FeatureEdgeSmoothingOn();//true
  else
    smoother->FeatureEdgeSmoothingOff();//false
  smoother->BoundarySmoothingOff();//false
  smoother->NonManifoldSmoothingOn();//true
  smoother->NormalizeCoordinatesOn();//true
  smoother->GenerateErrorScalarsOn();//true
  smoother->GenerateErrorVectorsOn();//true
  smoother->Update();

  // write out the vtk polydata to an output file
  /*vtkGenericDataObjectWriter* writer = vtkGenericDataObjectWriter::New();
  writer->SetFileName( outfile );
  writer->SetInput( polydata );
  writer->Write();*/

  vtkPolyDataWriter* writer = vtkPolyDataWriter::New();
  writer->SetFileName( outfile );
  //writer->SetInput( polydata );
  writer->SetInput( smoother->GetOutput() );
  writer->Update();

  // cleanup memory
  reader->Delete();
  smoother->Delete();
  writer->Delete();

  return 0;
}
