#include "vtkKWMeshVisu.h"
#include "vtkKWApplication.h"
#include <vtksys/SystemTools.hxx>
#include "logo.h"
#include "argio.hh"


extern "C" int Vtkkwmeshvisulib_Init(Tcl_Interp *interp);
int my_main(int argc, char *argv[])
{
  int xml = ipExistsArgument ( (const char**)argv, "--xml" ) ;
  if (xml)
  {
  vtkKWMeshVisu::GenerateXMLDescription () ;
  return 0 ;
  }

  int logo = ipExistsArgument ( (const char**)argv, "--logo" ) ;
  if (logo)
  {
    std::cout << "LOGO" << std::endl ;
    std::cout << image_logo_width << std::endl ;
    std::cout << image_logo_height << std::endl ;
    std::cout << image_logo_pixel_size << std::endl ;
    std::cout << image_logo_length << std::endl ;
    std::cout << image_logo << std::endl ;
    
    return 0 ;
  }

  // Initialize Tcl
  char *cleanArguments = new char[500];
  strcpy ( cleanArguments, argv[0] ) ;

  Tcl_Interp *interp = vtkKWApplication::InitializeTcl(argc, argv, &cerr);
  if (!interp)
    {
    cerr << "Error: InitializeTcl failed" << endl ;
    return 1;
    }
  Vtkkwmeshvisulib_Init(interp);

  // Create an application object, then create an example object
  // and let it run the demo

  vtkKWApplication *app = vtkKWApplication::New();
  
  vtkKWMeshVisu *example = vtkKWMeshVisu::New();
  example->SetApplication(app);
  
  int res ;
  if ( argc > 1 )
  {
    res = example->CommandLine(argc, (const char **)argv);
  }
  else
  {
    res = example->Run(argc, argv);
  }

  example->Delete();
  app->Delete();

  return res;
}

#ifdef _WIN32
#include <windows.h>
int __stdcall WinMain(HINSTANCE, HINSTANCE, LPSTR lpCmdLine, int)
{
  //cout << "i'm here" << endl;
  int argc;
  char **argv;
  vtksys::SystemTools::ConvertWindowsCommandLineToUnixArguments(
    lpCmdLine, &argc, &argv);
  int ret = my_main(argc, argv);
  for (int i = 0; i < argc; i++) { delete [] argv[i]; }
  delete [] argv;
  return ret;
}
#else
int main(int argc, char *argv[])
{
  return my_main(argc, argv);
}
#endif
