/*=========================================================================

  Author: Ipek Oguz

  This is a converter from the attribute file format (generated by shape 
  analysis tools such as StatNonParamTestPDM and readable by KWMeshVisu 
  tool) into a feature file format required for our feature based 
  correspondence analysis. 
  
  nInput scalar attribute files are input to this converter, and they are 
  merged together to generate a single feature file.

  The input attribute files should be 1D each (no vectors, etc)

=========================================================================*/

#include <fstream>
#include <iostream>
#include <vector>
#include <string>
#include <assert.h>
using namespace std ;

vector < vector < double > > data ;

void readAttributeFile (string fileName) 
{
  // read in the file
  ifstream attrFile ;
  attrFile.open ( fileName.c_str() ) ;
  
  // check the header
  int nPts, nDim ;

  // This is a quite sloppy implementation of reading keyword/value pairs!
  bool found;
  char * valuePtr;
  char typeString[1001], line[1001];

  attrFile.seekg(0,std::ios::beg);
  found = false ;
  while ( !found && !attrFile.eof())
  { attrFile.getline ( line, 1000 ) ;
    if (line[0] != '#' && strstr ( line, "NUMBER_OF_POINTS" )) found = true;
  }
  valuePtr=strchr(line, '=');
  if (!valuePtr) return;
  valuePtr++;
  sscanf(valuePtr, " %d ", &nPts);

  attrFile.seekg(0,std::ios::beg);
  found = false ;
  while ( !found && !attrFile.eof())
  { attrFile.getline ( line, 1000 ) ;
    if (line[0] != '#' && strstr ( line, "DIMENSION" )) found = true;
  }
  valuePtr=strchr(line, '=');
  if (!valuePtr) return;
  valuePtr++;
  sscanf(valuePtr, " %d ", &nDim);

  assert ( ( data.size() == 0 ) || ( nPts == data[0].size() ) ) ;
  
  attrFile.seekg(0,std::ios::beg);
  const int numEntries = 3;
  int counter = 0;
  while ( counter < numEntries && !attrFile.eof())
  { attrFile.getline ( line, 1000 ) ;
    if ((line[0] != '#')) counter++;
  }

  int startIndex = data.size() ;
  data.resize ( startIndex + nDim ) ;
  int i ;
  for ( i = 0 ; i < nDim ; i++ )
  {
	data[startIndex+i].resize ( nPts ) ;
  }

  for ( i = 0 ; i < nPts ; i++ )
  {
	  for ( int j = 0 ; j < nDim ; j++ )
	  {
		attrFile >> data[startIndex+j][i] ;
	  }
  }
  
  attrFile.close () ;
}

void writeFeatureFile ( string fileName ) 
{
  int nPts = data[0].size() ;
  int nDim = data.size () ;

  ofstream featureFile ;
  featureFile.open ( fileName.c_str() ) ;
  featureFile << "NUMBER_OF_POINTS= " << nPts << endl ;
  featureFile << "DIMENSION= " << nDim << endl ;
  featureFile << "FEATURES= UNKNOWN" << endl ;

  for ( int i = 0 ; i < nPts ; i++ )
  {
    for ( int j = 0 ; j < nDim ; j++ )
    {
      featureFile << data[j][i] << " " ;
    }
    featureFile << endl ;
  }

  featureFile.close () ;
}

int main (int argc, char *argv[])
{
  string inputFileName, outputFileName ;
  int nInputs ;
  
  if ( argc < 2 ) 
  {
    cout << "Usage: " << argv[0] << " nInputs Input0 Input1 ... Output" << endl ;
    return 0 ;
  }

  nInputs = atoi (argv[1]) ;
  if ( nInputs <= 0 ) 
  {
    cout << "Usage: " << argv[0] << " nInputs Input0 Input1 ... Output" << endl ;
    return 0 ;
  }

  data.resize ( 0 ) ;

  for ( int i = 0 ; i < nInputs ; i++ )
  {
    inputFileName = argv[i+2];  
    readAttributeFile ( inputFileName ) ;
  }

  outputFileName = argv[nInputs+2] ;
  writeFeatureFile ( outputFileName ) ;
  
  return 0 ;
}