// ===========================================================================
// Copyright (c) Insight Software Consortium
// Copyright (c) 2011-2012 University of Pennsylvania
// Copyright (c) 2013-2014 Andreas Schuh
// All rights reserved.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//        http://www.apache.org/licenses/LICENSE-2.0.txt
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
// ===========================================================================

/**
 * @file  testdriver-before-test.inc
 * @brief Default implementation of test driver.
 *
 * This file is included in the test driver generated by the CMake command
 * <a href="http://www.cmake.org/cmake/help/cmake-2-8-docs.html#command:create_test_sourcelist">
 * create_test_sourcelist()</a> directly before the call to the test main function.
 *
 * This file is a modified version of the itkTestDriverBeforeTest.inc file
 * which is part of the TestKernel module of the ITK 4 project.
 */

//int main(int, char*)
//{
    // [...]
    try {
        // redirect standard output to file
        ofstream   redirectstream;
        streambuf* redirectbuf = NULL;
        streambuf* oldcoutbuf  = NULL;
        if (redirect_output.isSet()) {
            cout << "Test output has been redirected to: " << redirect_output.getValue() << endl;
            redirectstream.open(redirect_output.getValue().c_str(), ios::out);
            redirectbuf = redirectstream.rdbuf();
            oldcoutbuf  = cout.rdbuf();
            cout.rdbuf(redirectbuf);
        }
        // empty current working directory
        if (clean_cwd_before_test.getValue()) {
            os::emptydir(os::getcwd().c_str());
        }
        // remove all test output images if existent from previous test run
        if (testcmd.isSet()) {
            for (size_t i = 0; i < regression_tests.size(); i++) {
                const char* test_file = regression_tests[i].test_file.c_str();
                if (os::path::isfile(test_file)) {
                    if (remove(test_file) == 0) {
                        if (verbose.getValue() > 0) {
                            cout << "Removed already existing test output file " << test_file << endl;
                        }
                    } else {
                        cerr << "Warning: Failed to remove already existing output image " << test_file << endl;
                    }
                }
            }
        }
        // execute test in a try block
        // [...]
    // #include <sbia/basis/testdriver-after-test.inc>
//}
