#! /bin/bash

##############################################################################
# @file  test_MatchHistograms.sh
# @brief Test for the auxiliary executable MatchHistograms.
#
# Copyright (c) 2012 University of Pennsylvania. All rigths reserved.<br />
# See http://www.rad.upenn.edu/sbia/software/license.html or COPYING file.
#
# Contact: SBIA Group <sbia-software at uphs.upenn.edu>
##############################################################################

. ${BASIS_BASH_UTILITIES} || { echo "Failed to load BASIS utilities from file '${BASIS_BASH_UTILIITES}'!" 1>&2; exit 1; }

# input arguments
image_A_in="$1"
image_B_in="$2"

# test may overwrite either image A or image B, thus copy input images first
image_A=`basename "$image_A_in"`
image_B=`basename "$image_B_in"`
\cp -f "$image_A_in" "$image_A"
\cp -f "$image_B_in" "$image_B"
execute -v -- MatchHistograms "$image_A" "$image_B"
