/*
 * Decompiled with CFR 0.152.
 */
package org.globus.ftp.extended;

import java.io.DataOutputStream;
import java.io.IOException;
import java.net.Socket;
import java.net.UnknownHostException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.globus.ftp.DataChannelAuthentication;
import org.globus.ftp.DataSink;
import org.globus.ftp.DataSource;
import org.globus.ftp.GridFTPSession;
import org.globus.ftp.HostPort;
import org.globus.ftp.HostPort6;
import org.globus.ftp.HostPortList;
import org.globus.ftp.Options;
import org.globus.ftp.RetrieveOptions;
import org.globus.ftp.dc.EBlockImageDCWriter;
import org.globus.ftp.dc.EBlockParallelTransferContext;
import org.globus.ftp.dc.ManagedSocketBox;
import org.globus.ftp.dc.SocketBox;
import org.globus.ftp.dc.SocketOperator;
import org.globus.ftp.dc.SocketPool;
import org.globus.ftp.dc.StripeContextManager;
import org.globus.ftp.dc.TransferContext;
import org.globus.ftp.dc.TransferThreadManager;
import org.globus.ftp.exception.ClientException;
import org.globus.ftp.exception.DataChannelException;
import org.globus.ftp.extended.GridFTPControlChannel;
import org.globus.ftp.vanilla.FTPServerFacade;
import org.globus.gsi.GSIConstants;
import org.globus.gsi.gssapi.GSSConstants;
import org.globus.gsi.gssapi.auth.IdentityAuthorization;
import org.globus.gsi.gssapi.auth.SelfAuthorization;
import org.globus.gsi.gssapi.net.GssSocket;
import org.globus.gsi.gssapi.net.GssSocketFactory;
import org.globus.net.ServerSocketFactory;
import org.globus.util.Util;
import org.gridforum.jgss.ExtendedGSSContext;
import org.gridforum.jgss.ExtendedGSSManager;
import org.ietf.jgss.GSSContext;
import org.ietf.jgss.GSSCredential;
import org.ietf.jgss.GSSManager;

public class GridFTPServerFacade
extends FTPServerFacade {
    private static Log logger = LogFactory.getLog(GridFTPServerFacade.class.getName());
    protected GridFTPSession gSession = new GridFTPSession();
    protected SocketPool socketPool = null;
    protected TransferThreadManager transferThreadManager = null;
    protected StripeContextManager stripeRetrContextManager = null;

    public GridFTPServerFacade(GridFTPControlChannel remoteControlChannel) {
        super(remoteControlChannel);
        this.session = this.gSession;
        this.dataChannelFactory = null;
        this.socketPool = new SocketPool();
        this.transferThreadManager = this.createTransferThreadManager();
    }

    public void setCredential(GSSCredential cred) {
        this.gSession.credential = cred;
    }

    public void setDataChannelProtection(int protection) {
        this.gSession.dataChannelProtection = protection;
    }

    public void setDataChannelAuthentication(DataChannelAuthentication authentication) {
        this.gSession.dataChannelAuthentication = authentication;
    }

    @Override
    public void setOptions(Options opts) {
        if (opts instanceof RetrieveOptions) {
            this.gSession.parallel = ((RetrieveOptions)opts).getStartingParallelism();
            logger.debug("parallelism set to " + this.gSession.parallel);
        }
    }

    public void setTCPBufferSize(final int size) throws ClientException {
        logger.debug("Changing local TCP buffer setting to " + size);
        this.gSession.TCPBufferSize = size;
        SocketOperator op = new SocketOperator(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void operate(SocketBox s) throws Exception {
                SocketBox socketBox = s;
                synchronized (socketBox) {
                    logger.debug("Changing local socket's TCP buffer to " + size);
                    Socket mySocket = s.getSocket();
                    if (mySocket != null) {
                        mySocket.setReceiveBufferSize(size);
                        mySocket.setSendBufferSize(size);
                    } else {
                        logger.debug("the socket is null. probably being initialized");
                    }
                }
            }
        };
        try {
            this.socketPool.applyToAll(op);
        }
        catch (Exception e) {
            ClientException ce = new ClientException(14);
            ce.setRootCause(e);
            throw ce;
        }
    }

    @Override
    protected void transferAbort() {
        if (this.session.serverMode == 1) {
            this.unblockServer();
            this.transferThreadManager.stopTaskThread();
        }
    }

    private void closeOutgoingSockets() throws ClientException {
        SocketOperator op = new SocketOperator(){

            @Override
            public void operate(SocketBox sb) throws Exception {
                Socket s;
                if (((ManagedSocketBox)sb).isReusable() && (s = sb.getSocket()) != null) {
                    EBlockImageDCWriter.close(new DataOutputStream(s.getOutputStream()));
                }
            }
        };
        try {
            this.socketPool.applyToAll(op);
        }
        catch (IOException e) {
        }
        catch (Exception e) {
            ClientException ce = new ClientException(14);
            ce.setRootCause(e);
            throw ce;
        }
    }

    @Override
    public void setActive(HostPort hp) throws UnknownHostException, ClientException, IOException {
        if (logger.isDebugEnabled()) {
            logger.debug("hostport: " + hp.getHost() + " " + hp.getPort());
        }
        if (this.session.serverMode == 2) {
            this.closeOutgoingSockets();
        }
        this.socketPool.flush();
        this.session.serverMode = 2;
        this.remoteServerAddress = hp;
        this.transferThreadManager.activeConnect(hp, this.gSession.parallel);
    }

    public void setStripedActive(HostPortList hpl) throws UnknownHostException, IOException {
        if (hpl == null) {
            throw new IllegalArgumentException("null HostPortList");
        }
        int stripes = hpl.size();
        if (stripes < 1) {
            throw new IllegalArgumentException("empty HostPortList");
        }
        this.socketPool.flush();
        this.stripeRetrContextManager = new StripeContextManager(stripes, this.socketPool, this);
        int pathes = this.gSession.parallel;
        this.gSession.serverMode = 4;
        for (int stripe = 0; stripe < stripes; ++stripe) {
            this.transferThreadManager.activeConnect(hpl.get(stripe), pathes);
        }
    }

    @Override
    public HostPort setPassive(int port, int queue) throws IOException {
        this.socketPool.flush();
        return super.setPassive(port, queue);
    }

    public HostPortList setStripedPassive() throws IOException {
        return this.setStripedPassive(0, 100);
    }

    public HostPortList setStripedPassive(int port, int queue) throws IOException {
        this.socketPool.flush();
        if (this.serverSocket == null) {
            ServerSocketFactory factory = ServerSocketFactory.getDefault();
            this.serverSocket = factory.createServerSocket(port, queue);
        }
        this.gSession.serverMode = 3;
        this.gSession.serverAddressList = new HostPortList();
        String address = Util.getLocalHostAddress();
        int localPort = this.serverSocket.getLocalPort();
        HostPort hp = null;
        if (this.remoteControlChannel.isIPv6()) {
            String version = HostPort6.getIPAddressVersion(address);
            hp = new HostPort6(version, address, localPort);
        } else {
            hp = new HostPort(address, localPort);
        }
        this.gSession.serverAddressList.add(hp);
        logger.debug("started single striped passive server at port " + this.gSession.serverAddressList.get(0).getPort());
        return this.gSession.serverAddressList;
    }

    @Override
    public void store(DataSink sink) {
        try {
            this.localControlChannel.resetReplyCount();
            if (this.session.transferMode != 3) {
                EBlockParallelTransferContext context = (EBlockParallelTransferContext)this.createTransferContext();
                context.setEodsTotal(0);
                if (this.session.serverMode == 1) {
                    this.transferThreadManager.passiveConnect(sink, context, 1, this.serverSocket);
                } else {
                    this.transferThreadManager.startTransfer(sink, (TransferContext)context, 1, false);
                }
            } else if (this.session.serverMode != 3 && this.session.serverMode != 1) {
                this.exceptionToControlChannel(new DataChannelException(2), "refusing to store with active mode");
            } else {
                EBlockParallelTransferContext context = (EBlockParallelTransferContext)this.createTransferContext();
                int willReuseConnections = this.socketPool.countFree();
                int needNewConnections = 0;
                if (this.gSession.parallel > willReuseConnections) {
                    needNewConnections = this.gSession.parallel - willReuseConnections;
                }
                logger.debug("will reuse " + willReuseConnections + " connections and start " + needNewConnections + " new ones.");
                this.transferThreadManager.startTransfer(sink, (TransferContext)context, willReuseConnections, true);
                if (needNewConnections > 0) {
                    this.transferThreadManager.passiveConnect(sink, context, needNewConnections, this.serverSocket);
                }
            }
        }
        catch (Exception e) {
            this.exceptionToControlChannel(e, "ocurred during store()");
        }
    }

    @Override
    public void retrieve(DataSource source) {
        block11: {
            try {
                this.localControlChannel.resetReplyCount();
                if (this.session.transferMode != 3) {
                    EBlockParallelTransferContext context = (EBlockParallelTransferContext)this.createTransferContext();
                    context.setEodsTotal(0);
                    logger.debug("starting outgoing transfer without mode E");
                    if (this.session.serverMode == 1) {
                        this.transferThreadManager.passiveConnect(source, context, this.serverSocket);
                    } else {
                        this.transferThreadManager.startTransfer(source, (TransferContext)context, 1, false);
                    }
                    return;
                }
                if (this.session.serverMode == 2) {
                    EBlockParallelTransferContext context = (EBlockParallelTransferContext)this.createTransferContext();
                    int total = this.gSession.parallel;
                    context.setEodsTotal(total);
                    int free = this.socketPool.countFree();
                    int willReuseConnections = total > free ? free : total;
                    int willCloseConnections = free > total ? free - total : 0;
                    int needNewConnections = total > free ? total - free : 0;
                    logger.debug("will reuse " + willReuseConnections + " connections, start " + needNewConnections + " new ones, and close " + willCloseConnections);
                    if (needNewConnections > 0) {
                        this.transferThreadManager.activeConnect(this.remoteServerAddress, needNewConnections);
                    }
                    if (willCloseConnections > 0) {
                        this.transferThreadManager.activeClose(context, willCloseConnections);
                    }
                    this.transferThreadManager.startTransfer(source, (TransferContext)context, willReuseConnections + needNewConnections, true);
                    break block11;
                }
                if (this.session.serverMode == 4) {
                    if (this.stripeRetrContextManager == null) {
                        throw new IllegalStateException();
                    }
                    int stripes = this.stripeRetrContextManager.getStripes();
                    for (int stripe = 0; stripe < stripes; ++stripe) {
                        EBlockParallelTransferContext context = this.stripeRetrContextManager.getStripeContext(stripe);
                        context.setEodsTotal(this.gSession.parallel);
                        this.transferThreadManager.startTransfer(source, (TransferContext)context, this.gSession.parallel, true);
                    }
                    break block11;
                }
                throw new DataChannelException(2);
            }
            catch (Exception e) {
                this.exceptionToControlChannel(e, "ocurred during retrieve()");
            }
        }
    }

    @Override
    public void abort() throws IOException {
        super.abort();
        if (this.socketPool != null) {
            this.socketPool.flush();
        }
    }

    @Override
    public void close() throws IOException {
        super.close();
        if (this.transferThreadManager != null) {
            this.transferThreadManager.close();
        }
    }

    public static Socket authenticate(Socket simpleSocket, boolean isClientSocket, GSSCredential credential, int protection, DataChannelAuthentication dcau) throws Exception {
        GSSContext gssContext = null;
        GSSManager manager = ExtendedGSSManager.getInstance();
        gssContext = isClientSocket ? manager.createContext(null, GSSConstants.MECH_OID, credential, 0) : manager.createContext(credential);
        if (protection != 1) {
            ((ExtendedGSSContext)gssContext).setOption(GSSConstants.GSS_MODE, GSIConstants.MODE_SSL);
        }
        gssContext.requestConf(protection == 4);
        logger.debug("Creating secure socket");
        GssSocketFactory factory = GssSocketFactory.getDefault();
        GssSocket secureSocket = (GssSocket)factory.createSocket(simpleSocket, null, 0, gssContext);
        secureSocket.setUseClientMode(isClientSocket);
        if (dcau == null) {
            secureSocket.setAuthorization(null);
        } else if (dcau == DataChannelAuthentication.SELF) {
            secureSocket.setAuthorization(SelfAuthorization.getInstance());
        } else if (dcau != DataChannelAuthentication.NONE && dcau instanceof DataChannelAuthentication) {
            secureSocket.setAuthorization(new IdentityAuthorization(dcau.toFtpCmdArgument()));
        }
        secureSocket.getOutputStream().flush();
        if (protection == 2 || protection == 4) {
            logger.debug("Data channel protection: on");
            return secureSocket;
        }
        logger.debug("Data channel protection: off");
        return simpleSocket;
    }

    @Override
    protected TransferContext createTransferContext() {
        EBlockParallelTransferContext context = new EBlockParallelTransferContext();
        context.setSocketPool(this.socketPool);
        context.setTransferThreadManager(this.transferThreadManager);
        return context;
    }

    public TransferThreadManager createTransferThreadManager() {
        return new TransferThreadManager(this.socketPool, this, this.localControlChannel, this.gSession);
    }
}

