/*
 * Decompiled with CFR 0.152.
 */
package org.globus.util.http;

import java.io.IOException;
import java.io.InputStream;

public class HTTPChunkedInputStream
extends InputStream {
    protected byte[] _buf;
    protected int _index;
    protected int _max;
    protected boolean _eof;
    protected InputStream _in;

    public HTTPChunkedInputStream(InputStream in) {
        this._in = in;
        this._buf = new byte[2048];
        this._index = 0;
        this._max = 0;
        this._eof = false;
    }

    private void readChunk() throws IOException {
        String line = this.readLine(this._in).trim();
        int length = Integer.parseInt(line, 16);
        if (length > 0) {
            if (length > this._buf.length) {
                this._buf = new byte[length];
            }
            int bytesLeft = length;
            int reqBytes = 0;
            int off = 0;
            int read = 0;
            while (bytesLeft != 0 && (read = this._in.read(this._buf, off, reqBytes = bytesLeft)) != -1) {
                bytesLeft -= read;
                off += read;
            }
            this._max = off;
            this._index = 0;
        } else {
            this._eof = true;
        }
        this._in.read();
        this._in.read();
    }

    private String readLine(InputStream in) throws IOException {
        int c;
        StringBuffer buf = new StringBuffer();
        for (int length = 0; (c = in.read()) != -1 && c != 10 && length <= 512; ++length) {
            if (c == 13) {
                in.read();
                return buf.toString();
            }
            buf.append((char)c);
        }
        return buf.toString();
    }

    @Override
    public int read(byte[] buffer, int off, int len) throws IOException {
        if (this._eof) {
            return -1;
        }
        if (this._max == this._index) {
            this.readChunk();
        }
        if (this._index + len <= this._max) {
            System.arraycopy(this._buf, this._index, buffer, off, len);
            this._index += len;
            return len;
        }
        int maximum = this._max - this._index;
        System.arraycopy(this._buf, this._index, buffer, off, maximum);
        this._index += maximum;
        int read = this.read(buffer, off + maximum, len - maximum);
        if (read == -1) {
            return maximum;
        }
        return maximum + read;
    }

    @Override
    public int read() throws IOException {
        if (this._eof) {
            return -1;
        }
        if (this._max == this._index) {
            this.readChunk();
        }
        return this._buf[this._index++] & 0xFF;
    }

    @Override
    public int available() throws IOException {
        return this._in.available();
    }

    @Override
    public void close() throws IOException {
        this._in.close();
    }
}

