/*
 * Decompiled with CFR 0.152.
 */
package org.globus.gsi.gssapi;

import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.util.Hashtable;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.globus.common.CoGProperties;

public class KeyPairCache {
    private static Log logger = LogFactory.getLog((class$org$globus$gsi$gssapi$GlobusGSSContextImpl == null ? (class$org$globus$gsi$gssapi$GlobusGSSContextImpl = KeyPairCache.class$("org.globus.gsi.gssapi.GlobusGSSContextImpl")) : class$org$globus$gsi$gssapi$GlobusGSSContextImpl).getName());
    public static final String DEFAULT_ALGORITHM = "RSA";
    public static final String DEFAULT_PROVIDER = "BC";
    private final String algorithm;
    private final String provider;
    private final long lifetime;
    private static KeyPairCache keyPairCache;
    private final Map entries = new Hashtable();
    static /* synthetic */ Class class$org$globus$gsi$gssapi$GlobusGSSContextImpl;

    private KeyPairCache(String algorithm, String provider, long lifetime) {
        this.algorithm = algorithm;
        this.provider = provider;
        this.lifetime = lifetime;
    }

    public static synchronized KeyPairCache getKeyPairCache() {
        if (keyPairCache == null) {
            keyPairCache = new KeyPairCache(DEFAULT_ALGORITHM, DEFAULT_PROVIDER, CoGProperties.getDefault().getDelegationKeyCacheLifetime());
        }
        return keyPairCache;
    }

    public static synchronized KeyPairCache getKeyPairCache(String algorithm, String provider, long lifetime) {
        if (keyPairCache == null) {
            keyPairCache = new KeyPairCache(algorithm, provider, lifetime);
        }
        return keyPairCache;
    }

    public KeyPair getKeyPair(int bits) throws NoSuchAlgorithmException, NoSuchProviderException {
        if (this.lifetime < 1L) {
            logger.debug("Cache lifetime is less than 1, generating new keypair each time");
            KeyPairGenerator generator = KeyPairGenerator.getInstance(this.algorithm, this.provider);
            generator.initialize(bits);
            return generator.generateKeyPair();
        }
        long st = System.currentTimeMillis();
        Integer keysize = new Integer(bits);
        KeyPairCacheEntry entry = (KeyPairCacheEntry)this.entries.get(keysize);
        if (entry == null || st - entry.getCreatedAt() >= this.lifetime) {
            logger.debug("Creating " + bits + " bits keypair");
            KeyPairGenerator generator = KeyPairGenerator.getInstance(this.algorithm, this.provider);
            generator.initialize(bits);
            logger.debug("Time to generate key pair: " + (System.currentTimeMillis() - st));
            entry = new KeyPairCacheEntry(generator.generateKeyPair(), st);
            this.entries.put(keysize, entry);
        }
        return entry.getKeyPair();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static class KeyPairCacheEntry {
        private long created_at;
        private KeyPair keys;

        public KeyPairCacheEntry(KeyPair keys, long created_at) {
            this.keys = keys;
            this.created_at = created_at;
        }

        public long getCreatedAt() {
            return this.created_at;
        }

        public KeyPair getKeyPair() {
            return this.keys;
        }
    }
}

