/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmed.apps;

import com.pixelmed.database.DatabaseInformationModel;
import com.pixelmed.database.PatientStudySeriesConcatenationInstanceModel;
import com.pixelmed.dicom.Attribute;
import com.pixelmed.dicom.AttributeList;
import com.pixelmed.dicom.AttributeTag;
import com.pixelmed.dicom.CodeStringAttribute;
import com.pixelmed.dicom.DicomException;
import com.pixelmed.dicom.DicomInputStream;
import com.pixelmed.dicom.InformationEntity;
import com.pixelmed.dicom.SpecificCharacterSet;
import com.pixelmed.dicom.StoredFilePathStrategy;
import com.pixelmed.dicom.TagFromName;
import com.pixelmed.dicom.UniqueIdentifierAttribute;
import com.pixelmed.network.DicomNetworkException;
import com.pixelmed.network.MoveSOPClassSCU;
import com.pixelmed.network.NetworkConfigurationFromMulticastDNS;
import com.pixelmed.network.ReceivedObjectHandler;
import com.pixelmed.network.StorageSOPClassSCPDispatcher;
import com.pixelmed.query.QueryInformationModel;
import com.pixelmed.query.QueryTreeModel;
import com.pixelmed.query.QueryTreeRecord;
import com.pixelmed.query.StudyRootQueryInformationModel;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;

public class SynchronizeFromRemoteSCP {
    private static final String identString = "@(#) $Header: /userland/cvs/pixelmed/imgbook/com/pixelmed/apps/SynchronizeFromRemoteSCP.java,v 1.3 2008/01/29 11:46:34 dclunie Exp $";
    private static int sleepTimeBetweenCheckingForNothingExpectedBeforeExiting = 10000;
    private static int sleepTimeAfterRegisteringWithBonjour = 10000;
    private DatabaseInformationModel databaseInformationModel;
    private File savedInstancesFolder;
    private String remoteHost;
    private int remotePort;
    private String remoteAE;
    private int localPort;
    private String localAE;
    private int verbosityLevel;
    private int debugLevel;
    private QueryInformationModel queryInformationModel;
    private Set setofInstancesExpected;

    private void walkTreeDownToInstanceLevelAndRetrieve(QueryTreeRecord queryTreeRecord, AttributeList attributeList, boolean bl) throws DicomException, DicomNetworkException, IOException {
        MoveSOPClassSCU moveSOPClassSCU;
        int n;
        int n2;
        Object object;
        Object object2;
        InformationEntity informationEntity = queryTreeRecord.getInformationEntity();
        Attribute attribute = queryTreeRecord.getUniqueKey();
        AttributeList attributeList2 = null;
        AttributeList attributeList3 = null;
        ArrayList arrayList = null;
        if (informationEntity != null && attribute != null) {
            attributeList2 = new AttributeList();
            if (attributeList != null) {
                attributeList2.putAll(attributeList);
            }
            AttributeTag attributeTag = this.queryInformationModel.getUniqueKeyForInformationEntity(informationEntity);
            object2 = attribute.getSingleStringValueOrNull();
            if (object2 == null) {
                System.err.println("Could not get UID to use");
            } else {
                arrayList = this.databaseInformationModel.findAllAttributeValuesForAllRecordsForThisInformationEntityWithSpecifiedUID(informationEntity, (String)object2);
                object = new UniqueIdentifierAttribute(attributeTag);
                ((Attribute)object).addValue((String)object2);
                attributeList2.put((Attribute)object);
                if (!bl && arrayList.size() == 0) {
                    if (this.verbosityLevel > 0) {
                        System.err.println("Performing retrieve for " + queryTreeRecord);
                    }
                    object = new SpecificCharacterSet((String[])null);
                    attributeList3 = new AttributeList();
                    attributeList3.putAll(attributeList2);
                    String string = this.queryInformationModel.getQueryLevelName(informationEntity);
                    CodeStringAttribute codeStringAttribute = new CodeStringAttribute(TagFromName.QueryRetrieveLevel);
                    ((Attribute)codeStringAttribute).addValue(string);
                    attributeList3.put(codeStringAttribute);
                    bl = true;
                }
            }
        }
        if ((n2 = queryTreeRecord.getChildCount()) > 0) {
            for (int i = 0; i < n2; ++i) {
                this.walkTreeDownToInstanceLevelAndRetrieve((QueryTreeRecord)queryTreeRecord.getChildAt(i), attributeList2, bl);
            }
        } else if (informationEntity != null && informationEntity.equals(InformationEntity.INSTANCE) && arrayList.size() == 0) {
            object2 = queryTreeRecord.getAllAttributesReturnedInIdentifier();
            object = Attribute.getSingleStringValueOrNull((AttributeList)object2, TagFromName.SOPInstanceUID);
            this.setofInstancesExpected.add(object);
        }
        if (attributeList3 != null && (n = (moveSOPClassSCU = new MoveSOPClassSCU(this.remoteHost, this.remotePort, this.remoteAE, this.localAE, this.localAE, "1.2.840.10008.5.1.4.1.2.2.2", attributeList3, this.debugLevel)).getStatus()) != 0) {
            System.err.println("SynchronizeFromRemoteSCP: unsuccessful move status = " + "0x" + Integer.toHexString(n));
        }
    }

    private void performQueryAndWalkTreeDownToInstanceLevelAndRetrieve() throws DicomException, DicomNetworkException, IOException {
        SpecificCharacterSet specificCharacterSet = new SpecificCharacterSet((String[])null);
        AttributeList attributeList = new AttributeList();
        attributeList.putNewAttribute(TagFromName.StudyInstanceUID);
        attributeList.putNewAttribute(TagFromName.SeriesInstanceUID);
        attributeList.putNewAttribute(TagFromName.SOPInstanceUID);
        if (this.verbosityLevel > 0) {
            attributeList.putNewAttribute(TagFromName.PatientName, specificCharacterSet);
            attributeList.putNewAttribute(TagFromName.PatientID, specificCharacterSet);
            attributeList.putNewAttribute(TagFromName.StudyDate);
            attributeList.putNewAttribute(TagFromName.StudyID, specificCharacterSet);
            attributeList.putNewAttribute(TagFromName.StudyDescription, specificCharacterSet);
            attributeList.putNewAttribute(TagFromName.SeriesNumber);
            attributeList.putNewAttribute(TagFromName.SeriesDescription, specificCharacterSet);
            attributeList.putNewAttribute(TagFromName.Modality);
            attributeList.putNewAttribute(TagFromName.InstanceNumber);
        }
        QueryTreeModel queryTreeModel = this.queryInformationModel.performHierarchicalQuery(attributeList);
        this.walkTreeDownToInstanceLevelAndRetrieve((QueryTreeRecord)queryTreeModel.getRoot(), null, false);
    }

    public SynchronizeFromRemoteSCP(DatabaseInformationModel databaseInformationModel, File file, String string, int n, String string2, int n2, String string3, int n3, int n4) throws DicomException, DicomNetworkException, IOException, InterruptedException {
        this.databaseInformationModel = databaseInformationModel;
        this.savedInstancesFolder = file;
        this.remoteHost = string;
        this.remotePort = n;
        this.remoteAE = string2;
        this.localPort = n2;
        this.localAE = string3;
        this.verbosityLevel = n3;
        this.debugLevel = n4;
        if (!file.exists() || !file.isDirectory()) {
            throw new DicomException("Folder in which to save received instances does not exist or is not a directory - " + file);
        }
        new Thread(new StorageSOPClassSCPDispatcher(n2, string3, file, StoredFilePathStrategy.BYSOPINSTANCEUIDHASHSUBFOLDERS, new OurReceivedObjectHandler(), n4)).start();
        this.setofInstancesExpected = new HashSet();
        this.queryInformationModel = new StudyRootQueryInformationModel(string, n, string2, string3, n4);
        this.performQueryAndWalkTreeDownToInstanceLevelAndRetrieve();
        while (!this.setofInstancesExpected.isEmpty()) {
            System.err.println("Sleeping since " + this.setofInstancesExpected.size() + " remaining");
            Thread.currentThread();
            Thread.sleep(sleepTimeBetweenCheckingForNothingExpectedBeforeExiting);
        }
    }

    public static void main(String[] stringArray) {
        block5: {
            try {
                if (stringArray.length >= 7 && stringArray.length <= 9) {
                    String string = stringArray[0];
                    String string2 = stringArray[1];
                    String string3 = stringArray[2];
                    int n = Integer.parseInt(stringArray[3]);
                    String string4 = stringArray[4];
                    int n2 = Integer.parseInt(stringArray[5]);
                    String string5 = stringArray[6];
                    int n3 = stringArray.length > 7 ? Integer.parseInt(stringArray[7]) : 0;
                    int n4 = stringArray.length > 8 ? Integer.parseInt(stringArray[8]) : 0;
                    File file = new File(string2);
                    PatientStudySeriesConcatenationInstanceModel patientStudySeriesConcatenationInstanceModel = new PatientStudySeriesConcatenationInstanceModel(string);
                    try {
                        NetworkConfigurationFromMulticastDNS networkConfigurationFromMulticastDNS = new NetworkConfigurationFromMulticastDNS(n4);
                        networkConfigurationFromMulticastDNS.activateDiscovery();
                        networkConfigurationFromMulticastDNS.registerDicomService(string5, n2, "WSD");
                        Thread.currentThread();
                        Thread.sleep(sleepTimeAfterRegisteringWithBonjour);
                    }
                    catch (Exception exception) {
                        System.err.println(exception);
                    }
                    new SynchronizeFromRemoteSCP(patientStudySeriesConcatenationInstanceModel, file, string3, n, string4, n2, string5, n3, n4);
                    patientStudySeriesConcatenationInstanceModel.close();
                    System.exit(0);
                    break block5;
                }
                System.err.println("Usage: java -cp ./pixelmed.jar:./lib/additional/hsqldb.jar:./lib/additional/commons-codec-1.3.jar:./lib/additional/jmdns.jar com.pixelmed.apps.SynchronizeFromRemoteSCP databasepath savedfilesfolder remoteHost remotePort remoteAET ooutPort ourAET [verbositylevel [debuglevel]]");
            }
            catch (Exception exception) {
                exception.printStackTrace(System.err);
                System.exit(0);
            }
        }
    }

    private class OurReceivedObjectHandler
    extends ReceivedObjectHandler {
        private OurReceivedObjectHandler() {
        }

        public void sendReceivedObjectIndication(String string, String string2, String string3) throws DicomNetworkException, DicomException, IOException {
            if (string != null) {
                if (SynchronizeFromRemoteSCP.this.verbosityLevel > 1) {
                    System.err.println("Received: " + string + " from " + string3 + " in " + string2);
                }
                try {
                    FileInputStream fileInputStream = new FileInputStream(string);
                    DicomInputStream dicomInputStream = new DicomInputStream(new BufferedInputStream(fileInputStream));
                    AttributeList attributeList = new AttributeList();
                    attributeList.read(dicomInputStream, TagFromName.PixelData);
                    dicomInputStream.close();
                    fileInputStream.close();
                    String string4 = Attribute.getSingleStringValueOrNull(attributeList, TagFromName.SOPInstanceUID);
                    if (string4 != null) {
                        if (!SynchronizeFromRemoteSCP.this.setofInstancesExpected.contains(string4)) {
                            throw new DicomException("Unrequested SOPInstanceUID in received object ... ignoring");
                        }
                    } else {
                        throw new DicomException("Missing SOPInstanceUID in received object ... ignoring");
                    }
                    SynchronizeFromRemoteSCP.this.setofInstancesExpected.remove(string4);
                    SynchronizeFromRemoteSCP.this.databaseInformationModel.insertObject(attributeList, string);
                }
                catch (Exception exception) {
                    exception.printStackTrace(System.err);
                }
            }
        }
    }
}

