/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmed.database;

import com.pixelmed.database.DatabaseInformationModel;
import com.pixelmed.database.DatabaseTreeModel;
import com.pixelmed.database.DatabaseTreeRecord;
import com.pixelmed.database.MapTableBrowser;
import com.pixelmed.dicom.DicomException;
import com.pixelmed.dicom.InformationEntity;
import com.pixelmed.utils.JTreeWithAdditionalKeyStrokeActions;
import java.awt.Container;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Vector;
import javax.swing.JFrame;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTree;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.TreePath;

public class DatabaseTreeBrowser {
    private static final String identString = "@(#) $Header: /userland/cvs/pixelmed/imgbook/com/pixelmed/database/DatabaseTreeBrowser.java,v 1.13 2005/01/26 22:26:31 dclunie Exp $";
    private JTree tree;
    private DatabaseTreeModel treeModel;
    private DatabaseInformationModel databaseInformationModel;
    private Map descriptiveNameMap;

    public DatabaseTreeBrowser(DatabaseInformationModel databaseInformationModel, JScrollPane jScrollPane, JScrollPane jScrollPane2) throws DicomException {
        this.databaseInformationModel = databaseInformationModel;
        this.descriptiveNameMap = databaseInformationModel == null ? null : databaseInformationModel.getDescriptiveNameMap();
        this.treeModel = new DatabaseTreeModel(databaseInformationModel);
        this.tree = new JTreeWithAdditionalKeyStrokeActions(this.treeModel);
        jScrollPane.setViewportView(this.tree);
        this.tree.addTreeSelectionListener(this.buildTreeSelectionListenerToDisplayAttributesOfSelectedRecord(jScrollPane2));
        this.tree.addTreeSelectionListener(this.buildTreeSelectionListenerToDoSomethingWithSelectedFiles());
        this.tree.addMouseListener(this.buildMouseListenerToDetectDoubleClickEvents());
    }

    public DatabaseTreeBrowser(DatabaseInformationModel databaseInformationModel, JFrame jFrame) throws DicomException {
        this.databaseInformationModel = databaseInformationModel;
        this.descriptiveNameMap = databaseInformationModel == null ? null : databaseInformationModel.getDescriptiveNameMap();
        this.treeModel = new DatabaseTreeModel(databaseInformationModel);
        this.tree = new JTreeWithAdditionalKeyStrokeActions(this.treeModel);
        Container container = jFrame.getContentPane();
        JScrollPane jScrollPane = new JScrollPane(this.tree);
        JScrollPane jScrollPane2 = new JScrollPane();
        JSplitPane jSplitPane = new JSplitPane(0, jScrollPane, jScrollPane2);
        jSplitPane.setOneTouchExpandable(true);
        jSplitPane.setResizeWeight(0.7);
        container.add(jSplitPane);
        this.tree.addTreeSelectionListener(this.buildTreeSelectionListenerToDisplayAttributesOfSelectedRecord(jScrollPane2));
        this.tree.addTreeSelectionListener(this.buildTreeSelectionListenerToDoSomethingWithSelectedFiles());
        this.tree.addMouseListener(this.buildMouseListenerToDetectDoubleClickEvents());
    }

    protected TreeSelectionListener buildTreeSelectionListenerToDoSomethingWithSelectedFiles() {
        return new TreeSelectionListener(){

            public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
                TreePath treePath = treeSelectionEvent.getNewLeadSelectionPath();
                if (treePath != null) {
                    Vector vector = null;
                    Object object = treePath.getLastPathComponent();
                    if (object instanceof DatabaseTreeRecord) {
                        DatabaseTreeRecord databaseTreeRecord = (DatabaseTreeRecord)object;
                        vector = new Vector();
                        DatabaseTreeBrowser.this.recurseThroughChildrenGatheringFileNames(databaseTreeRecord, vector);
                    }
                    DatabaseTreeBrowser.this.doSomethingWithSelectedFiles(vector);
                }
            }
        };
    }

    private void recurseThroughChildrenGatheringFileNames(DatabaseTreeRecord databaseTreeRecord, Vector vector) {
        Object object;
        InformationEntity informationEntity = databaseTreeRecord.getInformationEntity();
        if (informationEntity == InformationEntity.INSTANCE && (object = databaseTreeRecord.getLocalFileNameValue()) != null) {
            vector.add(object);
        }
        if ((object = databaseTreeRecord.children()) != null) {
            while (object.hasMoreElements()) {
                DatabaseTreeRecord databaseTreeRecord2 = (DatabaseTreeRecord)object.nextElement();
                if (databaseTreeRecord2 == null) continue;
                this.recurseThroughChildrenGatheringFileNames(databaseTreeRecord2, vector);
            }
        }
    }

    protected TreeSelectionListener buildTreeSelectionListenerToDisplayAttributesOfSelectedRecord(final JScrollPane jScrollPane) {
        return new TreeSelectionListener(){

            public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
                Object object;
                TreePath treePath = treeSelectionEvent.getNewLeadSelectionPath();
                if (treePath != null && (object = treePath.getLastPathComponent()) instanceof DatabaseTreeRecord) {
                    DatabaseTreeRecord databaseTreeRecord = (DatabaseTreeRecord)object;
                    InformationEntity informationEntity = databaseTreeRecord.getInformationEntity();
                    String string = databaseTreeRecord.getLocalPrimaryKeyValue();
                    if (informationEntity != null && string != null) {
                        Map map = null;
                        try {
                            map = DatabaseTreeBrowser.this.databaseInformationModel.findAllAttributeValuesForSelectedRecord(informationEntity, string);
                            HashSet hashSet = null;
                            HashSet hashSet2 = DatabaseTreeBrowser.this.databaseInformationModel.getLocalColumnExcludeList();
                            MapTableBrowser mapTableBrowser = new MapTableBrowser(map, DatabaseTreeBrowser.this.descriptiveNameMap, hashSet, hashSet2);
                            mapTableBrowser.setAutoResizeMode(0);
                            mapTableBrowser.setColumnWidths();
                            jScrollPane.setViewportView(mapTableBrowser);
                        }
                        catch (Exception exception) {
                            exception.printStackTrace(System.err);
                        }
                    }
                }
            }
        };
    }

    protected MouseListener buildMouseListenerToDetectDoubleClickEvents() {
        return new MouseAdapter(){

            public void mousePressed(MouseEvent mouseEvent) {
                if (mouseEvent != null && mouseEvent.getClickCount() == 2) {
                    DatabaseTreeBrowser.this.doSomethingMoreWithWhateverWasSelected();
                }
            }
        };
    }

    protected void doSomethingWithSelectedFiles(Vector vector) {
        if (vector != null) {
            Iterator iterator = vector.iterator();
            while (iterator.hasNext()) {
                System.err.println("DatabaseTreeBrowser.doSomethingWithSelectedFiles(): " + (String)iterator.next());
            }
        }
    }

    protected void doSomethingMoreWithWhateverWasSelected() {
        System.err.println("DatabaseTreeBrowser.doSomethingMoreWithWhateverWasSelected(): Double click on current selection");
    }
}

