/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmed.database;

import com.pixelmed.dicom.Attribute;
import com.pixelmed.dicom.AttributeList;
import com.pixelmed.dicom.AttributeTag;
import com.pixelmed.dicom.DateAttribute;
import com.pixelmed.dicom.DicomException;
import com.pixelmed.dicom.StringAttribute;
import com.pixelmed.dicom.TagFromName;
import com.pixelmed.dicom.TimeAttribute;
import com.pixelmed.dicom.ValueRepresentation;
import java.util.HashSet;
import java.util.Set;

public class DateTimeRangeMatch {
    private static final String identString = "@(#) $Header: /userland/cvs/pixelmed/imgbook/com/pixelmed/database/DateTimeRangeMatch.java,v 1.2 2005/07/30 13:02:03 dclunie Exp $";
    private static final String earliestPossibleSQLDate = "19000101";
    private static final String latestPossibleSQLDate = "20990101";
    private static final String earliestPossibleSQLTime = "000000";
    private static final String latestPossibleSQLTime = "235959.999999";
    private static final String earliestPossibleSQLDateTime = "19000101000000";
    private static final String latestPossibleSQLDateTime = "20990101235959.999999";
    boolean useTimeStampRatherThanDicomAttribute;
    RangeMatch rangeMatch;
    String matchColumnName;
    Set alreadyUsed;

    private static final String convertToSQLTimestampFormat(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("'");
        int n = string.length();
        if (n >= 4) {
            stringBuffer.append(string.substring(0, 4));
        }
        if (n >= 6) {
            stringBuffer.append("-");
            stringBuffer.append(string.substring(4, 6));
        }
        if (n >= 8) {
            stringBuffer.append("-");
            stringBuffer.append(string.substring(6, 8));
        }
        if (n >= 10) {
            stringBuffer.append(" ");
            stringBuffer.append(string.substring(8, 10));
        }
        if (n >= 12) {
            stringBuffer.append(":");
            stringBuffer.append(string.substring(10, 12));
        }
        if (n >= 14) {
            stringBuffer.append(":");
            stringBuffer.append(string.substring(12, 14));
        }
        if (n >= 14) {
            stringBuffer.append(string.substring(14, n));
        }
        stringBuffer.append("'");
        return stringBuffer.toString();
    }

    private DateTimeRangeMatch(AttributeTag attributeTag, AttributeList attributeList, String string) {
        String string2;
        AttributeTag attributeTag2 = null;
        AttributeTag attributeTag3 = null;
        AttributeTag attributeTag4 = null;
        this.matchColumnName = null;
        this.alreadyUsed = new HashSet();
        if (attributeTag.equals(TagFromName.StudyDate) || attributeTag.equals(TagFromName.StudyTime)) {
            attributeTag2 = TagFromName.StudyDate;
            attributeTag3 = TagFromName.StudyTime;
            this.matchColumnName = "PM_StudyDateTime";
            this.alreadyUsed.add(TagFromName.StudyDate);
            this.alreadyUsed.add(TagFromName.StudyTime);
        } else if (attributeTag.equals(TagFromName.SeriesDate) || attributeTag.equals(TagFromName.SeriesTime)) {
            attributeTag2 = TagFromName.SeriesDate;
            attributeTag3 = TagFromName.SeriesTime;
            this.matchColumnName = "PM_SeriesDateTime";
            this.alreadyUsed.add(TagFromName.SeriesDate);
            this.alreadyUsed.add(TagFromName.SeriesTime);
        } else if (attributeTag.equals(TagFromName.ContentDate) || attributeTag.equals(TagFromName.ContentTime)) {
            attributeTag2 = TagFromName.ContentDate;
            attributeTag3 = TagFromName.ContentTime;
            this.matchColumnName = "PM_ContentDateTime";
            this.alreadyUsed.add(TagFromName.ContentDate);
            this.alreadyUsed.add(TagFromName.ContentTime);
        } else if (attributeTag.equals(TagFromName.AcquisitionDateTime)) {
            attributeTag4 = TagFromName.AcquisitionDateTime;
            this.matchColumnName = "PM_AcquisitionDateTime";
            this.alreadyUsed.add(TagFromName.AcquisitionDateTime);
            this.alreadyUsed.add(TagFromName.AcquisitionDate);
            this.alreadyUsed.add(TagFromName.AcquisitionTime);
        } else if (attributeTag.equals(TagFromName.AcquisitionDate) || attributeTag.equals(TagFromName.AcquisitionTime)) {
            attributeTag2 = TagFromName.AcquisitionDate;
            attributeTag3 = TagFromName.AcquisitionTime;
            this.matchColumnName = "PM_AcquisitionDateTime";
            this.alreadyUsed.add(TagFromName.AcquisitionDateTime);
            this.alreadyUsed.add(TagFromName.AcquisitionDate);
            this.alreadyUsed.add(TagFromName.AcquisitionTime);
        }
        String string3 = attributeTag2 == null ? null : Attribute.getSingleStringValueOrNull(attributeList, attributeTag2);
        String string4 = attributeTag3 == null ? null : Attribute.getSingleStringValueOrNull(attributeList, attributeTag3);
        String string5 = string2 = attributeTag4 == null ? null : Attribute.getSingleStringValueOrNull(attributeList, attributeTag4);
        if (string2 != null && string2.length() > 0) {
            this.rangeMatch = new RangeMatch(string2);
            this.useTimeStampRatherThanDicomAttribute = true;
        } else if (string3 != null) {
            if (string4 != null) {
                this.useTimeStampRatherThanDicomAttribute = true;
                this.rangeMatch = new RangeMatch(new RangeMatch(string3), new RangeMatch(string4));
                this.rangeMatch.lowerValue = DateTimeRangeMatch.convertToSQLTimestampFormat(this.rangeMatch.lowerValue);
                this.rangeMatch.upperValue = DateTimeRangeMatch.convertToSQLTimestampFormat(this.rangeMatch.upperValue);
            } else {
                this.useTimeStampRatherThanDicomAttribute = false;
                this.rangeMatch = new RangeMatch(string3);
                if (this.rangeMatch.lowerValue == null) {
                    this.rangeMatch.lowerValue = earliestPossibleSQLDate;
                }
                if (this.rangeMatch.upperValue == null) {
                    this.rangeMatch.upperValue = latestPossibleSQLDate;
                }
                this.matchColumnName = string;
            }
        } else if (string4 != null) {
            this.useTimeStampRatherThanDicomAttribute = false;
            this.rangeMatch = new RangeMatch(string4);
            if (this.rangeMatch.lowerValue == null) {
                this.rangeMatch.lowerValue = earliestPossibleSQLTime;
            }
            if (this.rangeMatch.upperValue == null) {
                this.rangeMatch.upperValue = latestPossibleSQLTime;
            }
            this.matchColumnName = string;
        } else {
            String string6;
            this.useTimeStampRatherThanDicomAttribute = false;
            Attribute attribute = attributeList.get(attributeTag);
            if (attribute != null && (string6 = attribute.getSingleStringValueOrNull()) != null && string6.length() > 0) {
                byte[] byArray = attribute.getVR();
                this.rangeMatch = new RangeMatch(string6);
                if (this.rangeMatch.lowerValue == null) {
                    this.rangeMatch.lowerValue = ValueRepresentation.isDateVR(byArray) ? earliestPossibleSQLDate : (ValueRepresentation.isTimeVR(byArray) ? earliestPossibleSQLTime : earliestPossibleSQLDateTime);
                }
                if (this.rangeMatch.upperValue == null) {
                    this.rangeMatch.lowerValue = ValueRepresentation.isDateVR(byArray) ? latestPossibleSQLDate : (ValueRepresentation.isTimeVR(byArray) ? latestPossibleSQLTime : latestPossibleSQLDateTime);
                }
                this.matchColumnName = string;
            }
        }
    }

    static boolean addToMatchClause(StringBuffer stringBuffer, String string, String string2, AttributeTag attributeTag, AttributeList attributeList, Set set) {
        boolean bl = false;
        if (!set.contains(attributeTag)) {
            DateTimeRangeMatch dateTimeRangeMatch = new DateTimeRangeMatch(attributeTag, attributeList, string2);
            if (dateTimeRangeMatch.matchColumnName != null) {
                bl = true;
                set.addAll(dateTimeRangeMatch.alreadyUsed);
                if (stringBuffer.length() != 0) {
                    stringBuffer.append(" AND ");
                }
                stringBuffer.append(string);
                stringBuffer.append(".");
                stringBuffer.append(dateTimeRangeMatch.matchColumnName);
                stringBuffer.append(" >= ");
                stringBuffer.append(dateTimeRangeMatch.rangeMatch.lowerValue);
                stringBuffer.append(" AND ");
                stringBuffer.append(string);
                stringBuffer.append(".");
                stringBuffer.append(dateTimeRangeMatch.matchColumnName);
                stringBuffer.append(" <= ");
                stringBuffer.append(dateTimeRangeMatch.rangeMatch.upperValue);
            }
        }
        return bl;
    }

    public static void main(String[] stringArray) {
        StringAttribute stringAttribute;
        AttributeTag attributeTag;
        AttributeList attributeList;
        HashSet hashSet;
        StringBuffer stringBuffer;
        try {
            stringBuffer = new StringBuffer();
            hashSet = new HashSet();
            attributeList = new AttributeList();
            attributeTag = TagFromName.StudyDate;
            stringAttribute = new DateAttribute(attributeTag);
            ((Attribute)stringAttribute).addValue("20030728");
            attributeList.put(attributeTag, stringAttribute);
            attributeTag = TagFromName.StudyTime;
            stringAttribute = new TimeAttribute(attributeTag);
            ((Attribute)stringAttribute).addValue("173500");
            attributeList.put(attributeTag, stringAttribute);
            DateTimeRangeMatch.addToMatchClause(stringBuffer, "STUDY", "STUDYDATE", TagFromName.StudyDate, attributeList, hashSet);
            DateTimeRangeMatch.addToMatchClause(stringBuffer, "STUDY", "STUDYTIME", TagFromName.StudyTime, attributeList, hashSet);
            System.err.println(stringBuffer.toString());
            System.err.println(attributeList);
        }
        catch (DicomException dicomException) {
            dicomException.printStackTrace(System.err);
        }
        try {
            stringBuffer = new StringBuffer();
            hashSet = new HashSet();
            attributeList = new AttributeList();
            attributeTag = TagFromName.StudyDate;
            stringAttribute = new DateAttribute(attributeTag);
            ((Attribute)stringAttribute).addValue("20030728-");
            attributeList.put(attributeTag, stringAttribute);
            attributeTag = TagFromName.StudyTime;
            stringAttribute = new TimeAttribute(attributeTag);
            ((Attribute)stringAttribute).addValue("173500-");
            attributeList.put(attributeTag, stringAttribute);
            DateTimeRangeMatch.addToMatchClause(stringBuffer, "STUDY", "STUDYDATE", TagFromName.StudyDate, attributeList, hashSet);
            DateTimeRangeMatch.addToMatchClause(stringBuffer, "STUDY", "STUDYTIME", TagFromName.StudyTime, attributeList, hashSet);
            System.err.println(stringBuffer.toString());
            System.err.println(attributeList);
        }
        catch (DicomException dicomException) {
            dicomException.printStackTrace(System.err);
        }
        try {
            stringBuffer = new StringBuffer();
            hashSet = new HashSet();
            attributeList = new AttributeList();
            attributeTag = TagFromName.StudyDate;
            stringAttribute = new DateAttribute(attributeTag);
            ((Attribute)stringAttribute).addValue("-20030728");
            attributeList.put(attributeTag, stringAttribute);
            attributeTag = TagFromName.StudyTime;
            stringAttribute = new TimeAttribute(attributeTag);
            ((Attribute)stringAttribute).addValue("-173500");
            attributeList.put(attributeTag, stringAttribute);
            DateTimeRangeMatch.addToMatchClause(stringBuffer, "STUDY", "STUDYDATE", TagFromName.StudyDate, attributeList, hashSet);
            DateTimeRangeMatch.addToMatchClause(stringBuffer, "STUDY", "STUDYTIME", TagFromName.StudyTime, attributeList, hashSet);
            System.err.println(stringBuffer.toString());
            System.err.println(attributeList);
        }
        catch (DicomException dicomException) {
            dicomException.printStackTrace(System.err);
        }
        try {
            stringBuffer = new StringBuffer();
            hashSet = new HashSet();
            attributeList = new AttributeList();
            attributeTag = TagFromName.StudyDate;
            stringAttribute = new DateAttribute(attributeTag);
            ((Attribute)stringAttribute).addValue("20030701-20030728");
            attributeList.put(attributeTag, stringAttribute);
            attributeTag = TagFromName.StudyTime;
            stringAttribute = new TimeAttribute(attributeTag);
            ((Attribute)stringAttribute).addValue("010101-173500");
            attributeList.put(attributeTag, stringAttribute);
            DateTimeRangeMatch.addToMatchClause(stringBuffer, "STUDY", "STUDYDATE", TagFromName.StudyDate, attributeList, hashSet);
            DateTimeRangeMatch.addToMatchClause(stringBuffer, "STUDY", "STUDYTIME", TagFromName.StudyTime, attributeList, hashSet);
            System.err.println(stringBuffer.toString());
            System.err.println(attributeList);
        }
        catch (DicomException dicomException) {
            dicomException.printStackTrace(System.err);
        }
        try {
            stringBuffer = new StringBuffer();
            hashSet = new HashSet();
            attributeList = new AttributeList();
            attributeTag = TagFromName.StudyDate;
            stringAttribute = new DateAttribute(attributeTag);
            ((Attribute)stringAttribute).addValue("20030728");
            attributeList.put(attributeTag, stringAttribute);
            DateTimeRangeMatch.addToMatchClause(stringBuffer, "STUDY", "STUDYDATE", TagFromName.StudyDate, attributeList, hashSet);
            System.err.println(stringBuffer.toString());
            System.err.println(attributeList);
        }
        catch (DicomException dicomException) {
            dicomException.printStackTrace(System.err);
        }
        try {
            stringBuffer = new StringBuffer();
            hashSet = new HashSet();
            attributeList = new AttributeList();
            attributeTag = TagFromName.StudyDate;
            stringAttribute = new DateAttribute(attributeTag);
            ((Attribute)stringAttribute).addValue("20030728-");
            attributeList.put(attributeTag, stringAttribute);
            DateTimeRangeMatch.addToMatchClause(stringBuffer, "STUDY", "STUDYDATE", TagFromName.StudyDate, attributeList, hashSet);
            System.err.println(stringBuffer.toString());
            System.err.println(attributeList);
        }
        catch (DicomException dicomException) {
            dicomException.printStackTrace(System.err);
        }
        try {
            stringBuffer = new StringBuffer();
            hashSet = new HashSet();
            attributeList = new AttributeList();
            attributeTag = TagFromName.StudyDate;
            stringAttribute = new DateAttribute(attributeTag);
            ((Attribute)stringAttribute).addValue("-20030728");
            attributeList.put(attributeTag, stringAttribute);
            DateTimeRangeMatch.addToMatchClause(stringBuffer, "STUDY", "STUDYDATE", TagFromName.StudyDate, attributeList, hashSet);
            System.err.println(stringBuffer.toString());
            System.err.println(attributeList);
        }
        catch (DicomException dicomException) {
            dicomException.printStackTrace(System.err);
        }
        try {
            stringBuffer = new StringBuffer();
            hashSet = new HashSet();
            attributeList = new AttributeList();
            attributeTag = TagFromName.StudyDate;
            stringAttribute = new DateAttribute(attributeTag);
            ((Attribute)stringAttribute).addValue("20030701-20030728");
            attributeList.put(attributeTag, stringAttribute);
            DateTimeRangeMatch.addToMatchClause(stringBuffer, "STUDY", "STUDYDATE", TagFromName.StudyDate, attributeList, hashSet);
            System.err.println(stringBuffer.toString());
            System.err.println(attributeList);
        }
        catch (DicomException dicomException) {
            dicomException.printStackTrace(System.err);
        }
        try {
            stringBuffer = new StringBuffer();
            hashSet = new HashSet();
            attributeList = new AttributeList();
            attributeTag = TagFromName.StudyTime;
            stringAttribute = new TimeAttribute(attributeTag);
            ((Attribute)stringAttribute).addValue("173500");
            attributeList.put(attributeTag, stringAttribute);
            DateTimeRangeMatch.addToMatchClause(stringBuffer, "STUDY", "STUDYDATE", TagFromName.StudyDate, attributeList, hashSet);
            System.err.println(stringBuffer.toString());
            System.err.println(attributeList);
        }
        catch (DicomException dicomException) {
            dicomException.printStackTrace(System.err);
        }
        try {
            stringBuffer = new StringBuffer();
            hashSet = new HashSet();
            attributeList = new AttributeList();
            attributeTag = TagFromName.StudyTime;
            stringAttribute = new TimeAttribute(attributeTag);
            ((Attribute)stringAttribute).addValue("173500-");
            attributeList.put(attributeTag, stringAttribute);
            DateTimeRangeMatch.addToMatchClause(stringBuffer, "STUDY", "STUDYTIME", TagFromName.StudyDate, attributeList, hashSet);
            System.err.println(stringBuffer.toString());
            System.err.println(attributeList);
        }
        catch (DicomException dicomException) {
            dicomException.printStackTrace(System.err);
        }
        try {
            stringBuffer = new StringBuffer();
            hashSet = new HashSet();
            attributeList = new AttributeList();
            attributeTag = TagFromName.StudyTime;
            stringAttribute = new TimeAttribute(attributeTag);
            ((Attribute)stringAttribute).addValue("-173500");
            attributeList.put(attributeTag, stringAttribute);
            DateTimeRangeMatch.addToMatchClause(stringBuffer, "STUDY", "STUDYTIME", TagFromName.StudyDate, attributeList, hashSet);
            System.err.println(stringBuffer.toString());
            System.err.println(attributeList);
        }
        catch (DicomException dicomException) {
            dicomException.printStackTrace(System.err);
        }
        try {
            stringBuffer = new StringBuffer();
            hashSet = new HashSet();
            attributeList = new AttributeList();
            attributeTag = TagFromName.StudyTime;
            stringAttribute = new TimeAttribute(attributeTag);
            ((Attribute)stringAttribute).addValue("010101-173500");
            attributeList.put(attributeTag, stringAttribute);
            DateTimeRangeMatch.addToMatchClause(stringBuffer, "STUDY", "STUDYTIME", TagFromName.StudyDate, attributeList, hashSet);
            System.err.println(stringBuffer.toString());
            System.err.println(attributeList);
        }
        catch (DicomException dicomException) {
            dicomException.printStackTrace(System.err);
        }
    }

    private class RangeMatch {
        String lowerValue;
        String upperValue;

        RangeMatch(String string) {
            this.lowerValue = null;
            this.upperValue = null;
            if (string != null) {
                int n = string.indexOf("-");
                int n2 = string.length();
                if (n == 0) {
                    this.upperValue = string.substring(1, n2);
                } else if (n == n2 - 1) {
                    this.lowerValue = string.substring(0, n2 - 1);
                } else if (n != -1) {
                    this.lowerValue = string.substring(0, n);
                    this.upperValue = string.substring(n + 1, n2);
                }
                if (this.lowerValue != null && this.lowerValue.length() == 0) {
                    this.lowerValue = null;
                }
                if (this.upperValue != null && this.upperValue.length() == 0) {
                    this.upperValue = null;
                }
                if (this.lowerValue == null && this.upperValue == null) {
                    this.lowerValue = this.upperValue = string;
                }
            }
        }

        RangeMatch(RangeMatch rangeMatch, RangeMatch rangeMatch2) {
            this.lowerValue = rangeMatch == null || rangeMatch.lowerValue == null ? (rangeMatch2 == null || rangeMatch2.lowerValue == null ? DateTimeRangeMatch.earliestPossibleSQLDateTime : DateTimeRangeMatch.earliestPossibleSQLDate + rangeMatch2.lowerValue) : (rangeMatch2 == null || rangeMatch2.lowerValue == null ? rangeMatch.lowerValue + DateTimeRangeMatch.earliestPossibleSQLTime : rangeMatch.lowerValue + rangeMatch2.lowerValue);
            this.upperValue = rangeMatch == null || rangeMatch.upperValue == null ? (rangeMatch2 == null || rangeMatch2.upperValue == null ? DateTimeRangeMatch.latestPossibleSQLDateTime : DateTimeRangeMatch.latestPossibleSQLDate + rangeMatch2.upperValue) : (rangeMatch2 == null || rangeMatch2.upperValue == null ? rangeMatch.upperValue + DateTimeRangeMatch.latestPossibleSQLTime : rangeMatch.upperValue + rangeMatch2.upperValue);
        }
    }
}

