/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmed.dicom;

public abstract class ArrayCopyUtilities {
    private static final String identString = "@(#) $Header: /userland/cvs/pixelmed/imgbook/com/pixelmed/dicom/ArrayCopyUtilities.java,v 1.9 2007/01/25 22:58:43 dclunie Exp $";

    public static int[] copyUnsignedShortToIntArray(short[] sArray) {
        if (sArray == null) {
            return null;
        }
        int n = sArray.length;
        int[] nArray = new int[n];
        for (int i = 0; i < n; ++i) {
            nArray[i] = sArray[i] & 0xFFFF;
        }
        return nArray;
    }

    public static int[] copySignedShortToIntArray(short[] sArray) {
        if (sArray == null) {
            return null;
        }
        int n = sArray.length;
        int[] nArray = new int[n];
        for (int i = 0; i < n; ++i) {
            nArray[i] = sArray[i];
        }
        return nArray;
    }

    public static long[] copyUnsignedShortToLongArray(short[] sArray) {
        if (sArray == null) {
            return null;
        }
        int n = sArray.length;
        long[] lArray = new long[n];
        for (int i = 0; i < n; ++i) {
            lArray[i] = sArray[i] & 0xFFFF;
        }
        return lArray;
    }

    public static long[] copySignedShortToLongArray(short[] sArray) {
        if (sArray == null) {
            return null;
        }
        int n = sArray.length;
        long[] lArray = new long[n];
        for (int i = 0; i < n; ++i) {
            lArray[i] = sArray[i];
        }
        return lArray;
    }

    public static long[] copyUnsignedIntToLongArray(int[] nArray) {
        if (nArray == null) {
            return null;
        }
        int n = nArray.length;
        long[] lArray = new long[n];
        for (int i = 0; i < n; ++i) {
            lArray[i] = (long)nArray[i] & 0xFFFFFFFFL;
        }
        return lArray;
    }

    public static long[] copySignedIntToLongArray(int[] nArray) {
        if (nArray == null) {
            return null;
        }
        int n = nArray.length;
        long[] lArray = new long[n];
        for (int i = 0; i < n; ++i) {
            lArray[i] = nArray[i];
        }
        return lArray;
    }

    public static short[] copyUnsignedIntToShortArray(int[] nArray) {
        if (nArray == null) {
            return null;
        }
        int n = nArray.length;
        short[] sArray = new short[n];
        for (int i = 0; i < n; ++i) {
            sArray[i] = (short)nArray[i];
        }
        return sArray;
    }

    public static short[] copySignedIntToShortArray(int[] nArray) {
        if (nArray == null) {
            return null;
        }
        int n = nArray.length;
        short[] sArray = new short[n];
        for (int i = 0; i < n; ++i) {
            sArray[i] = (short)nArray[i];
        }
        return sArray;
    }

    private static boolean isLeadingPadding(char c) {
        return c == ' ';
    }

    private static boolean isTrailingPadding(char c) {
        return c == ' ' || c == '\u0000';
    }

    public static String[] copyStringArrayRemovingLeadingAndTrailingPadding(String[] stringArray) {
        if (stringArray == null) {
            return null;
        }
        int n = stringArray.length;
        String[] stringArray2 = new String[n];
        for (int i = 0; i < n; ++i) {
            int n2;
            int n3;
            if (stringArray[i] == null) {
                stringArray2[i] = null;
                continue;
            }
            int n4 = stringArray[i].length();
            for (n3 = 0; n3 < n4 && ArrayCopyUtilities.isLeadingPadding(stringArray[i].charAt(n3)); ++n3) {
            }
            for (n2 = n4; n2 > n3 && ArrayCopyUtilities.isTrailingPadding(stringArray[i].charAt(n2 - 1)); --n2) {
            }
            stringArray2[i] = stringArray[i].substring(n3, n2);
        }
        return stringArray2;
    }

    public static int[] copyStringToIntArray(String[] stringArray) {
        if (stringArray == null) {
            return null;
        }
        int n = stringArray.length;
        int[] nArray = new int[n];
        for (int i = 0; i < n; ++i) {
            int n2 = 0;
            try {
                n2 = Integer.valueOf(stringArray[i]);
            }
            catch (NumberFormatException numberFormatException) {
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
            nArray[i] = n2;
        }
        return nArray;
    }

    public static long[] copyStringToLongArray(String[] stringArray) {
        if (stringArray == null) {
            return null;
        }
        int n = stringArray.length;
        long[] lArray = new long[n];
        for (int i = 0; i < n; ++i) {
            long l = 0L;
            try {
                l = Long.valueOf(stringArray[i]);
            }
            catch (NumberFormatException numberFormatException) {
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
            lArray[i] = l;
        }
        return lArray;
    }

    public static float[] copyStringToFloatArray(String[] stringArray) {
        if (stringArray == null) {
            return null;
        }
        int n = stringArray.length;
        float[] fArray = new float[n];
        for (int i = 0; i < n; ++i) {
            float f = 0.0f;
            try {
                f = Float.valueOf(stringArray[i]).floatValue();
            }
            catch (NumberFormatException numberFormatException) {
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
            fArray[i] = f;
        }
        return fArray;
    }

    public static double[] copyStringToDoubleArray(String[] stringArray) {
        if (stringArray == null) {
            return null;
        }
        int n = stringArray.length;
        double[] dArray = new double[n];
        for (int i = 0; i < n; ++i) {
            double d = 0.0;
            try {
                d = Double.valueOf(stringArray[i]);
            }
            catch (NumberFormatException numberFormatException) {
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
            dArray[i] = d;
        }
        return dArray;
    }

    public static short[] expandArray(short[] sArray) {
        return ArrayCopyUtilities.expandArray(sArray, 1);
    }

    public static short[] expandArray(short[] sArray, int n) {
        short[] sArray2;
        if (sArray == null) {
            sArray2 = new short[n];
        } else {
            int n2 = sArray.length;
            sArray2 = new short[n2 + n];
            for (int i = 0; i < n2; ++i) {
                sArray2[i] = sArray[i];
            }
        }
        return sArray2;
    }

    public static short[][] expandArray(short[][] sArray) {
        return ArrayCopyUtilities.expandArray(sArray, 1);
    }

    public static short[][] expandArray(short[][] sArray, int n) {
        short[][] sArrayArray;
        if (sArray == null) {
            sArrayArray = new short[n][];
        } else {
            int n2 = sArray.length;
            sArrayArray = new short[n2 + n][];
            for (int i = 0; i < n2; ++i) {
                sArrayArray[i] = sArray[i];
            }
        }
        return sArrayArray;
    }

    public static int[] expandArray(int[] nArray) {
        return ArrayCopyUtilities.expandArray(nArray, 1);
    }

    public static int[] expandArray(int[] nArray, int n) {
        int[] nArray2;
        if (nArray == null) {
            nArray2 = new int[n];
        } else {
            int n2 = nArray.length;
            nArray2 = new int[n2 + n];
            for (int i = 0; i < n2; ++i) {
                nArray2[i] = nArray[i];
            }
        }
        return nArray2;
    }

    public static long[] expandArray(long[] lArray) {
        return ArrayCopyUtilities.expandArray(lArray, 1);
    }

    public static long[] expandArray(long[] lArray, int n) {
        long[] lArray2;
        if (lArray == null) {
            lArray2 = new long[n];
        } else {
            int n2 = lArray.length;
            lArray2 = new long[n2 + n];
            for (int i = 0; i < n2; ++i) {
                lArray2[i] = lArray[i];
            }
        }
        return lArray2;
    }

    public static float[] expandArray(float[] fArray) {
        return ArrayCopyUtilities.expandArray(fArray, 1);
    }

    public static float[] expandArray(float[] fArray, int n) {
        float[] fArray2;
        if (fArray == null) {
            fArray2 = new float[n];
        } else {
            int n2 = fArray.length;
            fArray2 = new float[n2 + n];
            for (int i = 0; i < n2; ++i) {
                fArray2[i] = fArray[i];
            }
        }
        return fArray2;
    }

    public static double[] expandArray(double[] dArray) {
        return ArrayCopyUtilities.expandArray(dArray, 1);
    }

    public static double[] expandArray(double[] dArray, int n) {
        double[] dArray2;
        if (dArray == null) {
            dArray2 = new double[n];
        } else {
            int n2 = dArray.length;
            dArray2 = new double[n2 + n];
            for (int i = 0; i < n2; ++i) {
                dArray2[i] = dArray[i];
            }
        }
        return dArray2;
    }

    public static String[] expandArray(String[] stringArray) {
        return ArrayCopyUtilities.expandArray(stringArray, 1);
    }

    public static String[] expandArray(String[] stringArray, int n) {
        String[] stringArray2;
        if (stringArray == null) {
            stringArray2 = new String[n];
        } else {
            int n2 = stringArray.length;
            stringArray2 = new String[n2 + n];
            for (int i = 0; i < n2; ++i) {
                stringArray2[i] = stringArray[i];
            }
        }
        return stringArray2;
    }

    public static boolean arraysAreEqual(double[] dArray, double[] dArray2) {
        boolean bl = true;
        if (dArray == null || dArray2 == null || dArray.length != dArray2.length) {
            bl = false;
        } else {
            for (int i = 0; i < dArray.length; ++i) {
                if (!(Math.abs(dArray[i] - dArray2[i]) > 1.0E-6)) continue;
                bl = false;
                break;
            }
        }
        return bl;
    }
}

