/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmed.dicom;

import com.pixelmed.dicom.AttributeList;
import com.pixelmed.dicom.AttributeTree;
import com.pixelmed.dicom.DicomException;
import com.pixelmed.display.ApplicationFrame;
import com.pixelmed.utils.JTreeWithAdditionalKeyStrokeActions;
import java.awt.Component;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.JViewport;
import javax.swing.tree.TreeModel;

public class AttributeTreeBrowser {
    private static final String identString = "@(#) $Header: /userland/cvs/pixelmed/imgbook/com/pixelmed/dicom/AttributeTreeBrowser.java,v 1.8 2007/12/19 22:44:14 dclunie Exp $";
    private JTree tree;
    private AttributeTree treeModel;

    public AttributeTreeBrowser(AttributeList attributeList, JScrollPane jScrollPane) throws DicomException {
        this.treeModel = new AttributeTree(attributeList);
        this.tree = new JTreeWithAdditionalKeyStrokeActions(this.treeModel);
        jScrollPane.setViewportView(this.tree);
    }

    public static void setSortByName(JScrollPane jScrollPane, boolean bl) {
        JTree jTree;
        TreeModel treeModel;
        Component component;
        JViewport jViewport;
        if (jScrollPane != null && (jViewport = jScrollPane.getViewport()) != null && (component = jViewport.getView()) != null && component instanceof JTree && (treeModel = (jTree = (JTree)component).getModel()) != null && treeModel instanceof AttributeTree) {
            AttributeTree attributeTree = (AttributeTree)treeModel;
            attributeTree.setSortByName(bl);
        }
    }

    public static void main(String[] stringArray) {
        AttributeList attributeList = new AttributeList();
        try {
            attributeList.read(stringArray[0]);
        }
        catch (Exception exception) {
            System.err.println(exception);
            exception.printStackTrace(System.err);
            System.exit(0);
        }
        ApplicationFrame applicationFrame = new ApplicationFrame();
        JScrollPane jScrollPane = new JScrollPane();
        try {
            AttributeTreeBrowser attributeTreeBrowser = new AttributeTreeBrowser(attributeList, jScrollPane);
        }
        catch (DicomException dicomException) {
            dicomException.printStackTrace(System.err);
            System.exit(0);
        }
        applicationFrame.getContentPane().add(jScrollPane);
        applicationFrame.pack();
        applicationFrame.setVisible(true);
    }
}

