/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmed.dicom;

import com.pixelmed.dicom.Attribute;
import com.pixelmed.dicom.AttributeList;
import com.pixelmed.dicom.DicomInputStream;
import com.pixelmed.dicom.TagFromName;
import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.util.HashMap;
import java.util.Vector;

public class CoercionModel {
    private static final String identString = "@(#) $Header: /userland/cvs/pixelmed/imgbook/com/pixelmed/dicom/CoercionModel.java,v 1.2 2005/11/12 14:03:51 dclunie Exp $";
    private HashMap patients = new HashMap();

    public CoercionModel(Vector vector) {
        if (vector != null) {
            for (int i = 0; i < vector.size(); ++i) {
                String string = (String)vector.get(i);
                if (string == null) continue;
                try {
                    DicomInputStream dicomInputStream = new DicomInputStream(new BufferedInputStream(new FileInputStream(string)));
                    AttributeList attributeList = new AttributeList();
                    attributeList.read(dicomInputStream, TagFromName.PixelData);
                    dicomInputStream.close();
                    Patient patient = new Patient(attributeList);
                    String string2 = patient.getKey();
                    if (this.patients.get(string2) != null) continue;
                    this.patients.put(string2, patient);
                    continue;
                }
                catch (Exception exception) {
                    exception.printStackTrace(System.err);
                }
            }
        }
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        for (Patient patient : this.patients.values()) {
            stringBuffer.append(patient);
            stringBuffer.append("\n");
        }
        return stringBuffer.toString();
    }

    private class PatientConvertor {
        Patient oldPatientIdentifiers;
        Patient newPatientIdentifiers;

        private PatientConvertor() {
        }
    }

    private class Patient {
        String patientName;
        String patientID;
        String patientBirthDate;
        String patientSex;

        Patient(AttributeList attributeList) {
            this.patientName = Attribute.getSingleStringValueOrEmptyString(attributeList, TagFromName.PatientName);
            this.patientID = Attribute.getSingleStringValueOrEmptyString(attributeList, TagFromName.PatientID);
            this.patientBirthDate = Attribute.getSingleStringValueOrEmptyString(attributeList, TagFromName.PatientBirthDate);
            this.patientSex = Attribute.getSingleStringValueOrEmptyString(attributeList, TagFromName.PatientSex);
        }

        Patient(String string, String string2, String string3, String string4) {
            this.patientName = string;
            this.patientID = string2;
            this.patientBirthDate = string3;
            this.patientSex = string4;
        }

        String getKey() {
            return this.patientName + ":" + this.patientID + ":" + this.patientBirthDate + ":" + this.patientSex;
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(this.getKey());
            return stringBuffer.toString();
        }
    }
}

