/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmed.dicom;

import com.pixelmed.dicom.BinaryInputStream;
import com.pixelmed.dicom.TransferSyntax;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;

public class DicomInputStream
extends BinaryInputStream {
    private static final String identString = "@(#) $Header: /userland/cvs/pixelmed/imgbook/com/pixelmed/dicom/DicomInputStream.java,v 1.10 2006/02/11 13:48:23 dclunie Exp $";
    private TransferSyntax TransferSyntaxToReadDataSet;
    private TransferSyntax TransferSyntaxToReadMetaHeader;
    private TransferSyntax TransferSyntaxInUse;
    private boolean readingDataSet;
    private long byteOffsetOfStartOfData;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void initializeTransferSyntax(String string, boolean bl) throws IOException {
        this.TransferSyntaxToReadMetaHeader = null;
        this.TransferSyntaxToReadDataSet = null;
        byte[] byArray = new byte[8];
        if (string != null) {
            TransferSyntax transferSyntax = new TransferSyntax(string);
            if (bl) {
                this.TransferSyntaxToReadMetaHeader = transferSyntax;
            } else {
                this.TransferSyntaxToReadDataSet = transferSyntax;
            }
        }
        if (bl) {
            if (this.markSupported()) {
                this.mark(140);
            }
            boolean bl2 = true;
            try {
                this.skipInsistently(128L);
            }
            catch (IOException iOException) {
                bl2 = false;
            }
            if (bl2 && this.read(byArray, 0, 4) == 4 && new String(byArray, 0, 4).equals("DICM")) {
                if (this.TransferSyntaxToReadMetaHeader == null) {
                    if (this.markSupported()) {
                        this.mark(8);
                        this.TransferSyntaxToReadMetaHeader = this.read(byArray, 0, 6) == 6 ? (Character.isUpperCase((char)byArray[4]) && Character.isUpperCase((char)byArray[5]) ? new TransferSyntax("1.2.840.10008.1.2.1") : new TransferSyntax("1.2.840.10008.1.2")) : new TransferSyntax("1.2.840.10008.1.2.1");
                        this.reset();
                    } else {
                        this.TransferSyntaxToReadMetaHeader = new TransferSyntax("1.2.840.10008.1.2.1");
                    }
                }
                this.byteOffsetOfStartOfData = 132L;
            } else {
                if (!this.markSupported()) throw new IOException("Not a DICOM PS 3.10 file - no DICM after preamble in metaheader, and can't rewind input");
                this.reset();
                this.TransferSyntaxToReadDataSet = this.TransferSyntaxToReadMetaHeader;
                this.byteOffsetOfStartOfData = 0L;
            }
        }
        if (this.TransferSyntaxToReadDataSet == null && this.TransferSyntaxToReadMetaHeader == null) {
            boolean bl3 = false;
            boolean bl4 = false;
            if (this.markSupported()) {
                this.mark(10);
                if (this.read(byArray, 0, 8) == 8) {
                    if (byArray[0] < byArray[1]) {
                        bl3 = true;
                    } else if (byArray[0] == 0 && byArray[1] == 0 && byArray[4] < byArray[7]) {
                        bl3 = true;
                    }
                    if (Character.isUpperCase((char)byArray[4]) && Character.isUpperCase((char)byArray[5])) {
                        bl4 = true;
                    }
                }
                this.reset();
            }
            if (bl3) {
                if (!bl4) throw new IOException("Not a DICOM file (masquerades as explicit VR big endian)");
                this.TransferSyntaxToReadDataSet = new TransferSyntax("1.2.840.10008.1.2.2");
            } else {
                this.TransferSyntaxToReadDataSet = bl4 ? new TransferSyntax("1.2.840.10008.1.2.1") : new TransferSyntax("1.2.840.10008.1.2");
            }
        }
        if (this.TransferSyntaxToReadMetaHeader != null) {
            this.setReadingMetaHeader();
        } else {
            this.setReadingDataSet();
        }
        if (this.TransferSyntaxInUse != null) return;
        throw new IOException("Not a DICOM file (or can't detect Transfer Syntax)");
    }

    public DicomInputStream(InputStream inputStream) throws IOException {
        super(inputStream, true);
        this.initializeTransferSyntax(null, true);
    }

    public DicomInputStream(File file) throws IOException {
        super(file, true);
        this.initializeTransferSyntax(null, true);
    }

    public DicomInputStream(InputStream inputStream, String string, boolean bl) throws IOException {
        super(inputStream, true);
        this.initializeTransferSyntax(string, bl);
    }

    public DicomInputStream(File file, String string, boolean bl) throws IOException {
        super(file, true);
        this.initializeTransferSyntax(string, bl);
    }

    public void setTransferSyntaxToReadDataSet(TransferSyntax transferSyntax) {
        this.TransferSyntaxToReadDataSet = transferSyntax;
    }

    public void setReadingDataSet() {
        this.TransferSyntaxInUse = this.TransferSyntaxToReadDataSet;
        this.setEndian(this.TransferSyntaxInUse.isBigEndian());
        this.readingDataSet = true;
    }

    public boolean areReadingDataSet() {
        return this.readingDataSet;
    }

    public void setReadingMetaHeader() {
        this.TransferSyntaxInUse = this.TransferSyntaxToReadMetaHeader;
        this.setEndian(this.TransferSyntaxInUse.isBigEndian());
        this.readingDataSet = false;
    }

    public boolean areReadingMetaHeader() {
        return !this.readingDataSet;
    }

    public boolean haveMetaHeader() {
        return this.TransferSyntaxToReadMetaHeader != null;
    }

    public TransferSyntax getTransferSyntaxInUse() {
        return this.TransferSyntaxInUse;
    }

    public TransferSyntax getTransferSyntaxToReadDataSet() {
        return this.TransferSyntaxToReadDataSet;
    }

    public TransferSyntax getTransferSyntaxToReadMetaHeader() {
        return this.TransferSyntaxToReadMetaHeader;
    }

    public long getByteOffsetOfStartOfData() {
        return this.byteOffsetOfStartOfData;
    }
}

