/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmed.dicom;

import com.pixelmed.dicom.Attribute;
import com.pixelmed.dicom.AttributeList;
import com.pixelmed.dicom.DicomException;
import com.pixelmed.dicom.GeometryOfSliceFromAttributeList;
import com.pixelmed.dicom.TagFromName;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

class FrameSet {
    private static final String identString = "@(#) $Header: /userland/cvs/pixelmed/imgbook/com/pixelmed/dicom/FrameSet.java,v 1.1 2005/06/18 21:02:06 dclunie Exp $";
    private Map sharedAttributes;
    private ArrayList perFrameAttributes;
    private static final String Rows = "Rows";
    private static final String Columns = "Columns";
    private static final String Modality = "Modality";
    private static final String SOPClassUID = "SOPClassUID";
    private static final String SOPInstanceUID = "SOPInstanceUID";
    private static final String SeriesInstanceUID = "SeriesInstanceUID";
    private static final String StudyInstanceUID = "StudyInstanceUID";
    private static final String FrameOfReferenceUID = "FrameOfReferenceUID";
    private static final String SliceThickness = "SliceThickness";
    private static final String BodyPartExamined = "BodyPartExamined";
    private static final String ImageOrientationPatientRowX = "ImageOrientationPatientRowX";
    private static final String ImageOrientationPatientRowY = "ImageOrientationPatientRowY";
    private static final String ImageOrientationPatientRowZ = "ImageOrientationPatientRowZ";
    private static final String ImageOrientationPatientColumnX = "ImageOrientationPatientColumnX";
    private static final String ImageOrientationPatientColumnY = "ImageOrientationPatientColumnY";
    private static final String ImageOrientationPatientColumnZ = "ImageOrientationPatientColumnZ";
    private static final String ImageOrientationPatientNormalX = "ImageOrientationPatientNormalX";
    private static final String ImageOrientationPatientNormalY = "ImageOrientationPatientNormalY";
    private static final String ImageOrientationPatientNormalZ = "ImageOrientationPatientNormalZ";
    private static final String ImagePositionPatientX = "ImagePositionPatientX";
    private static final String ImagePositionPatientY = "ImagePositionPatientY";
    private static final String ImagePositionPatientZ = "ImagePositionPatientZ";
    private static final String VoxelSpacingX = "VoxelSpacingX";
    private static final String VoxelSpacingY = "VoxelSpacingY";
    private static final String VoxelSpacingZ = "VoxelSpacingZ";

    private static Map getSharedAttributes(AttributeList attributeList) {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put(Rows, new Integer(Attribute.getSingleIntegerValueOrDefault(attributeList, TagFromName.Rows, 0)));
        hashMap.put(Columns, new Integer(Attribute.getSingleIntegerValueOrDefault(attributeList, TagFromName.Columns, 0)));
        hashMap.put(Modality, Attribute.getSingleStringValueOrEmptyString(attributeList, TagFromName.Modality));
        hashMap.put(SOPClassUID, Attribute.getSingleStringValueOrEmptyString(attributeList, TagFromName.SOPClassUID));
        hashMap.put(SeriesInstanceUID, Attribute.getSingleStringValueOrEmptyString(attributeList, TagFromName.SeriesInstanceUID));
        hashMap.put(StudyInstanceUID, Attribute.getSingleStringValueOrEmptyString(attributeList, TagFromName.StudyInstanceUID));
        hashMap.put(FrameOfReferenceUID, Attribute.getSingleStringValueOrEmptyString(attributeList, TagFromName.FrameOfReferenceUID));
        hashMap.put(BodyPartExamined, Attribute.getSingleStringValueOrEmptyString(attributeList, TagFromName.BodyPartExamined));
        double[] dArray = null;
        double[] dArray2 = null;
        double[] dArray3 = null;
        double[] dArray4 = null;
        double d = 0.0;
        try {
            GeometryOfSliceFromAttributeList geometryOfSliceFromAttributeList = new GeometryOfSliceFromAttributeList(attributeList);
            dArray = geometryOfSliceFromAttributeList.getRowArray();
            dArray2 = geometryOfSliceFromAttributeList.getColumnArray();
            dArray3 = geometryOfSliceFromAttributeList.getNormalArray();
            dArray4 = geometryOfSliceFromAttributeList.getVoxelSpacingArray();
            d = geometryOfSliceFromAttributeList.getSliceThickness();
        }
        catch (DicomException dicomException) {
            // empty catch block
        }
        if (dArray != null && dArray.length == 3) {
            hashMap.put(ImageOrientationPatientRowX, new Double(dArray[0]));
            hashMap.put(ImageOrientationPatientRowY, new Double(dArray[1]));
            hashMap.put(ImageOrientationPatientRowZ, new Double(dArray[2]));
        }
        if (dArray2 != null && dArray2.length == 3) {
            hashMap.put(ImageOrientationPatientColumnX, new Double(dArray2[0]));
            hashMap.put(ImageOrientationPatientColumnY, new Double(dArray2[1]));
            hashMap.put(ImageOrientationPatientColumnZ, new Double(dArray2[2]));
        }
        if (dArray3 != null && dArray3.length == 3) {
            hashMap.put(ImageOrientationPatientNormalX, new Double(dArray3[0]));
            hashMap.put(ImageOrientationPatientNormalY, new Double(dArray3[1]));
            hashMap.put(ImageOrientationPatientNormalZ, new Double(dArray3[2]));
        }
        if (dArray4 != null && dArray4.length == 3) {
            hashMap.put(VoxelSpacingX, new Double(dArray4[0]));
            hashMap.put(VoxelSpacingY, new Double(dArray4[1]));
            hashMap.put(VoxelSpacingZ, new Double(dArray4[2]));
        }
        hashMap.put(SliceThickness, new Double(d));
        return hashMap;
    }

    private static Map getPerFrameAttributes(AttributeList attributeList) {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put(SOPInstanceUID, Attribute.getSingleStringValueOrEmptyString(attributeList, TagFromName.SOPInstanceUID));
        double[] dArray = null;
        try {
            GeometryOfSliceFromAttributeList geometryOfSliceFromAttributeList = new GeometryOfSliceFromAttributeList(attributeList);
            dArray = geometryOfSliceFromAttributeList.getTLHCArray();
        }
        catch (DicomException dicomException) {
            // empty catch block
        }
        if (dArray != null && dArray.length == 3) {
            hashMap.put(ImagePositionPatientX, new Double(dArray[0]));
            hashMap.put(ImagePositionPatientY, new Double(dArray[1]));
            hashMap.put(ImagePositionPatientZ, new Double(dArray[2]));
        }
        return hashMap;
    }

    boolean eligible(AttributeList attributeList) {
        Map map = FrameSet.getSharedAttributes(attributeList);
        return ((Object)map).equals(this.sharedAttributes);
    }

    void insert(AttributeList attributeList) {
        this.perFrameAttributes.add(FrameSet.getPerFrameAttributes(attributeList));
    }

    FrameSet(AttributeList attributeList) {
        this.sharedAttributes = FrameSet.getSharedAttributes(attributeList);
        this.perFrameAttributes = new ArrayList();
        this.insert(attributeList);
    }

    private static String toString(Map.Entry entry) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append((String)entry.getKey());
        stringBuffer.append(" = ");
        stringBuffer.append(entry.getValue().toString());
        return stringBuffer.toString();
    }

    public String toString() {
        Iterator<Object> iterator;
        StringBuffer stringBuffer = new StringBuffer();
        if (this.sharedAttributes != null) {
            stringBuffer.append("\tShared:\n");
            Set set = this.sharedAttributes.entrySet();
            iterator = set.iterator();
            while (iterator.hasNext()) {
                stringBuffer.append("\t\t");
                stringBuffer.append(FrameSet.toString((Map.Entry)iterator.next()));
                stringBuffer.append("\n");
            }
        }
        if (this.perFrameAttributes != null) {
            int n = 0;
            iterator = this.perFrameAttributes.iterator();
            while (iterator.hasNext()) {
                stringBuffer.append("\tFrame [");
                stringBuffer.append(Integer.toString(n));
                stringBuffer.append("]:\n");
                Map map = (Map)iterator.next();
                if (map != null) {
                    Set set = map.entrySet();
                    Iterator iterator2 = set.iterator();
                    while (iterator2.hasNext()) {
                        stringBuffer.append("\t\t\t");
                        stringBuffer.append(FrameSet.toString(iterator2.next()));
                        stringBuffer.append("\n");
                    }
                }
                ++n;
            }
        }
        return stringBuffer.toString();
    }
}

