/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmed.dicom;

import com.pixelmed.dicom.Attribute;
import com.pixelmed.dicom.AttributeList;
import com.pixelmed.dicom.CodeStringAttribute;
import com.pixelmed.dicom.DateAttribute;
import com.pixelmed.dicom.DicomException;
import com.pixelmed.dicom.FileMetaInformation;
import com.pixelmed.dicom.IntegerStringAttribute;
import com.pixelmed.dicom.LongStringAttribute;
import com.pixelmed.dicom.OtherByteAttribute;
import com.pixelmed.dicom.OtherWordAttribute;
import com.pixelmed.dicom.PersonNameAttribute;
import com.pixelmed.dicom.ShortStringAttribute;
import com.pixelmed.dicom.StringAttribute;
import com.pixelmed.dicom.TagFromName;
import com.pixelmed.dicom.TimeAttribute;
import com.pixelmed.dicom.UIDGenerator;
import com.pixelmed.dicom.UniqueIdentifierAttribute;
import com.pixelmed.dicom.UnsignedShortAttribute;
import com.pixelmed.utils.XPathQuery;
import java.awt.image.BufferedImage;
import java.awt.image.DataBuffer;
import java.awt.image.DataBufferByte;
import java.awt.image.DataBufferShort;
import java.awt.image.DataBufferUShort;
import java.awt.image.WritableRaster;
import java.io.File;
import java.io.IOException;
import java.util.Iterator;
import javax.imageio.ImageIO;
import javax.imageio.ImageReader;
import javax.imageio.metadata.IIOMetadata;
import javax.imageio.stream.FileImageInputStream;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class ImageToDicom {
    private static final String identString = "@(#) $Header: /userland/cvs/pixelmed/imgbook/com/pixelmed/dicom/ImageToDicom.java,v 1.8 2008/01/18 22:19:36 dclunie Exp $";

    private static String dumpTree(Node node, int n) {
        StringBuffer stringBuffer = new StringBuffer();
        String string = node.getNodeName();
        for (int i = 0; i < n; ++i) {
            stringBuffer.append("    ");
        }
        stringBuffer.append("<");
        stringBuffer.append(string);
        if (node.hasAttributes()) {
            NamedNodeMap namedNodeMap = node.getAttributes();
            for (int i = 0; i < namedNodeMap.getLength(); ++i) {
                Node node2 = namedNodeMap.item(i);
                if (node2 == null) continue;
                stringBuffer.append(" ");
                stringBuffer.append(node2.getNodeName());
                stringBuffer.append("=\"");
                stringBuffer.append(node2.getNodeValue());
                stringBuffer.append("\"");
            }
        }
        stringBuffer.append(">");
        String string2 = node.getNodeValue();
        if (string2 != null) {
            stringBuffer.append(string2);
        }
        stringBuffer.append("\n");
        for (Node node3 = node.getFirstChild(); node3 != null; node3 = node3.getNextSibling()) {
            stringBuffer.append(ImageToDicom.dumpTree(node3, n + 1));
        }
        for (int i = 0; i < n; ++i) {
            stringBuffer.append("    ");
        }
        stringBuffer.append("</");
        stringBuffer.append(string);
        stringBuffer.append(">\n");
        return stringBuffer.toString();
    }

    private static String dumpTree(Node node) {
        return ImageToDicom.dumpTree(node, 0);
    }

    protected static String getCompressionType(Node node) {
        String string = null;
        try {
            string = XPathQuery.getNamedAttributeValueOfElementNode((Node)XPathFactory.newInstance().newXPath().evaluate("//CompressionTypeName", node, XPathConstants.NODE), "value");
        }
        catch (XPathExpressionException xPathExpressionException) {
            xPathExpressionException.printStackTrace(System.err);
        }
        return string;
    }

    protected static short getBitsPerSample(Node node) {
        short s = 0;
        try {
            String string = XPathQuery.getNamedAttributeValueOfElementNode((Node)XPathFactory.newInstance().newXPath().evaluate("//BitsPerSample", node, XPathConstants.NODE), "value");
            if (string != null && string.length() > 0) {
                s = (short)Integer.parseInt(string);
            }
        }
        catch (NumberFormatException numberFormatException) {
            numberFormatException.printStackTrace(System.err);
        }
        catch (XPathExpressionException xPathExpressionException) {
            xPathExpressionException.printStackTrace(System.err);
        }
        return s;
    }

    public static AttributeList generateDICOMPixelModuleFromConsumerImageFile(String string, AttributeList attributeList) throws IOException, DicomException {
        return ImageToDicom.generateDICOMPixelModuleFromConsumerImageFile(new File(string), attributeList);
    }

    public static AttributeList generateDICOMPixelModuleFromConsumerImageFile(File file, AttributeList attributeList) throws IOException, DicomException {
        int n;
        Object object;
        int n2;
        Object object2;
        String[] stringArray;
        BufferedImage bufferedImage = null;
        Node node = null;
        FileImageInputStream fileImageInputStream = new FileImageInputStream(file);
        Iterator<ImageReader> iterator = ImageIO.getImageReaders(fileImageInputStream);
        if (iterator.hasNext()) {
            ImageReader imageReader = iterator.next();
            imageReader.setInput(fileImageInputStream);
            bufferedImage = imageReader.read(0);
            IIOMetadata iIOMetadata = imageReader.getImageMetadata(0);
            if (iIOMetadata != null && (stringArray = iIOMetadata.getMetadataFormatNames()) != null) {
                for (String string : stringArray) {
                    if (string == null) continue;
                    if (string.equals("javax_imageio_1.0")) {
                        node = iIOMetadata.getAsTree(string);
                        continue;
                    }
                    object2 = iIOMetadata.getAsTree(string);
                }
            }
        }
        if (bufferedImage == null) {
            throw new DicomException("Unrecognized image file type");
        }
        int n3 = bufferedImage.getWidth();
        int n4 = bufferedImage.getHeight();
        stringArray = bufferedImage.getSampleModel();
        int n5 = stringArray.getDataType();
        WritableRaster writableRaster = bufferedImage.getRaster();
        DataBuffer dataBuffer = writableRaster.getDataBuffer();
        int n6 = writableRaster.getNumBands();
        object2 = null;
        object2 = stringArray.getPixels(0, 0, n3, n4, (int[])object2, dataBuffer);
        short s = ((int[])object2).length;
        short s2 = (short)n4;
        short s3 = (short)n3;
        short s4 = 1;
        Attribute attribute = null;
        short s5 = 0;
        short s6 = 0;
        short s7 = 0;
        short s8 = (short)n6;
        short s9 = 0;
        String string = n6 == 3 ? "RGB" : (n6 == 1 ? "MONOCHROME2" : "");
        short s10 = 0;
        if (dataBuffer instanceof DataBufferByte) {
            n2 = n3 * n4 * n6;
            object = new byte[n2];
            n = 0;
            short s11 = 0;
            while (s11 < s) {
                object[n++] = (byte)object2[s11++];
            }
            attribute = new OtherByteAttribute(TagFromName.PixelData);
            attribute.setValues((byte[])object);
            s5 = 8;
            s6 = 8;
            s7 = 7;
        } else if (dataBuffer instanceof DataBufferShort || dataBuffer instanceof DataBufferUShort) {
            String string2;
            n2 = n3 * n4 * n6;
            object = new short[n2];
            n = 0;
            short s12 = 0;
            while (s12 < s) {
                object[n++] = (short)object2[s12++];
            }
            attribute = new OtherWordAttribute(TagFromName.PixelData);
            attribute.setValues((short[])object);
            s12 = ImageToDicom.getBitsPerSample(node);
            if (s12 == 0 && (string2 = ImageToDicom.getCompressionType(node)) != null && string2.equals("JPEG")) {
                s12 = 12;
            }
            s5 = s12;
            s6 = s12;
            s7 = (short)(s12 - 1);
            s9 = (short)(dataBuffer instanceof DataBufferShort ? 1 : 0);
        } else {
            throw new DicomException("Unsupported pixel data form (" + n6 + " bands)");
        }
        if (attributeList == null) {
            attributeList = new AttributeList();
        }
        if (attribute != null) {
            Object object3;
            int n7;
            attributeList.put(attribute);
            n2 = Attribute.getSingleIntegerValueOrDefault(attributeList, TagFromName.BitsStored, -1);
            if (n2 == -1) {
                object = new UnsignedShortAttribute(TagFromName.BitsStored);
                ((Attribute)object).addValue(s6);
                attributeList.put((Attribute)object);
            }
            if ((n7 = Attribute.getSingleIntegerValueOrDefault(attributeList, TagFromName.HighBit, -1)) == -1) {
                if (n2 != -1) {
                    s7 = (short)(n2 - 1);
                }
                UnsignedShortAttribute unsignedShortAttribute = new UnsignedShortAttribute(TagFromName.HighBit);
                ((Attribute)unsignedShortAttribute).addValue(s7);
                attributeList.put(unsignedShortAttribute);
            }
            if ((n2 = Attribute.getSingleIntegerValueOrDefault(attributeList, TagFromName.PixelRepresentation, -1)) == -1) {
                UnsignedShortAttribute unsignedShortAttribute = new UnsignedShortAttribute(TagFromName.PixelRepresentation);
                ((Attribute)unsignedShortAttribute).addValue(s9);
                attributeList.put(unsignedShortAttribute);
            }
            if ((object3 = Attribute.getSingleStringValueOrNull(attributeList, TagFromName.PhotometricInterpretation)) == null) {
                CodeStringAttribute codeStringAttribute = new CodeStringAttribute(TagFromName.PhotometricInterpretation);
                ((Attribute)codeStringAttribute).addValue(string);
                attributeList.put(codeStringAttribute);
            }
            attributeList.remove(TagFromName.BitsAllocated);
            object3 = new UnsignedShortAttribute(TagFromName.BitsAllocated);
            ((Attribute)object3).addValue(s5);
            attributeList.put((Attribute)object3);
            attributeList.remove(TagFromName.Rows);
            object3 = new UnsignedShortAttribute(TagFromName.Rows);
            ((Attribute)object3).addValue(s2);
            attributeList.put((Attribute)object3);
            attributeList.remove(TagFromName.Columns);
            object3 = new UnsignedShortAttribute(TagFromName.Columns);
            ((Attribute)object3).addValue(s3);
            attributeList.put((Attribute)object3);
            attributeList.remove(TagFromName.NumberOfFrames);
            object3 = new IntegerStringAttribute(TagFromName.NumberOfFrames);
            ((Attribute)object3).addValue(s4);
            attributeList.put((Attribute)object3);
            attributeList.remove(TagFromName.SamplesPerPixel);
            object3 = new UnsignedShortAttribute(TagFromName.SamplesPerPixel);
            ((Attribute)object3).addValue(s8);
            attributeList.put((Attribute)object3);
            attributeList.remove(TagFromName.PlanarConfiguration);
            if (s8 > 1) {
                object3 = new UnsignedShortAttribute(TagFromName.PlanarConfiguration);
                ((Attribute)object3).addValue(s10);
                attributeList.put((Attribute)object3);
            }
        }
        return attributeList;
    }

    public static AttributeList generateDICOMPixelModuleFromConsumerImageFile(String string) throws IOException, DicomException {
        return ImageToDicom.generateDICOMPixelModuleFromConsumerImageFile(string, null);
    }

    public ImageToDicom(String string, String string2, String string3, String string4, String string5, String string6, String string7) throws IOException, DicomException {
        AttributeList attributeList = ImageToDicom.generateDICOMPixelModuleFromConsumerImageFile(string);
        UIDGenerator uIDGenerator = new UIDGenerator();
        StringAttribute stringAttribute = new UniqueIdentifierAttribute(TagFromName.SOPClassUID);
        ((Attribute)stringAttribute).addValue("1.2.840.10008.5.1.4.1.1.7");
        attributeList.put(stringAttribute);
        stringAttribute = new UniqueIdentifierAttribute(TagFromName.SOPInstanceUID);
        ((Attribute)stringAttribute).addValue(uIDGenerator.getNewSOPInstanceUID(string5, string6, string7));
        attributeList.put(stringAttribute);
        stringAttribute = new UniqueIdentifierAttribute(TagFromName.SeriesInstanceUID);
        ((Attribute)stringAttribute).addValue(uIDGenerator.getNewSeriesInstanceUID(string5, string6));
        attributeList.put(stringAttribute);
        stringAttribute = new UniqueIdentifierAttribute(TagFromName.StudyInstanceUID);
        ((Attribute)stringAttribute).addValue(uIDGenerator.getNewStudyInstanceUID(string5));
        attributeList.put(stringAttribute);
        stringAttribute = new PersonNameAttribute(TagFromName.PatientName);
        ((Attribute)stringAttribute).addValue(string3);
        attributeList.put(stringAttribute);
        stringAttribute = new LongStringAttribute(TagFromName.PatientID);
        ((Attribute)stringAttribute).addValue(string4);
        attributeList.put(stringAttribute);
        stringAttribute = new DateAttribute(TagFromName.PatientBirthDate);
        attributeList.put(stringAttribute);
        stringAttribute = new CodeStringAttribute(TagFromName.PatientSex);
        attributeList.put(stringAttribute);
        stringAttribute = new ShortStringAttribute(TagFromName.StudyID);
        ((Attribute)stringAttribute).addValue(string5);
        attributeList.put(stringAttribute);
        stringAttribute = new DateAttribute(TagFromName.StudyDate);
        attributeList.put(stringAttribute);
        stringAttribute = new TimeAttribute(TagFromName.StudyTime);
        attributeList.put(stringAttribute);
        stringAttribute = new PersonNameAttribute(TagFromName.ReferringPhysicianName);
        ((Attribute)stringAttribute).addValue("^^^^");
        attributeList.put(stringAttribute);
        stringAttribute = new ShortStringAttribute(TagFromName.AccessionNumber);
        attributeList.put(stringAttribute);
        stringAttribute = new IntegerStringAttribute(TagFromName.SeriesNumber);
        ((Attribute)stringAttribute).addValue(string6);
        attributeList.put(stringAttribute);
        stringAttribute = new IntegerStringAttribute(TagFromName.InstanceNumber);
        ((Attribute)stringAttribute).addValue(string7);
        attributeList.put(stringAttribute);
        stringAttribute = new CodeStringAttribute(TagFromName.Modality);
        ((Attribute)stringAttribute).addValue("OT");
        attributeList.put(stringAttribute);
        stringAttribute = new CodeStringAttribute(TagFromName.ConversionType);
        ((Attribute)stringAttribute).addValue("WSD");
        attributeList.put(stringAttribute);
        stringAttribute = new LongStringAttribute(TagFromName.Manufacturer);
        attributeList.put(stringAttribute);
        stringAttribute = new CodeStringAttribute(TagFromName.PatientOrientation);
        attributeList.put(stringAttribute);
        FileMetaInformation.addFileMetaInformation(attributeList, "1.2.840.10008.1.2.1", "OURAETITLE");
        attributeList.write(string2, "1.2.840.10008.1.2.1", true, true);
    }

    public static void main(String[] stringArray) {
        try {
            new ImageToDicom(stringArray[0], stringArray[1], stringArray[2], stringArray[3], stringArray[4], stringArray[5], stringArray[6]);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }
}

