/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmed.dicom;

import com.pixelmed.dicom.Attribute;
import com.pixelmed.dicom.AttributeList;
import com.pixelmed.dicom.DicomInputStream;
import com.pixelmed.dicom.TagFromName;
import com.pixelmed.dicom.TransferSyntax;
import java.io.BufferedInputStream;
import java.io.FileInputStream;

public class LossyImageCompression {
    private static final String identString = "@(#) $Header: /userland/cvs/pixelmed/imgbook/com/pixelmed/dicom/LossyImageCompression.java,v 1.4 2005/12/21 13:32:30 dclunie Exp $";

    public static boolean hasEverBeenLossyCompressed(AttributeList attributeList) {
        return Attribute.getSingleIntegerValueOrDefault(attributeList, TagFromName.LossyImageCompression, -1) > 0 || Attribute.getSingleDoubleValueOrDefault(attributeList, TagFromName.LossyImageCompressionRatio, -1.0) > 1.0 || Attribute.getSingleStringValueOrEmptyString(attributeList, TagFromName.LossyImageCompressionMethod).length() > 0 || Attribute.getDelimitedStringValuesOrEmptyString(attributeList, TagFromName.DerivationDescription).toLowerCase().indexOf("lossy") > -1 || new TransferSyntax(Attribute.getSingleStringValueOrEmptyString(attributeList, TagFromName.TransferSyntaxUID)).isLossy();
    }

    public static String describeLossyCompression(AttributeList attributeList) {
        String string;
        if (LossyImageCompression.hasEverBeenLossyCompressed(attributeList)) {
            String string2;
            String string3 = Attribute.getSingleStringValueOrNull(attributeList, TagFromName.LossyImageCompressionRatio);
            if (string3 != null) {
                string3 = string3.replaceFirst("0*$", "");
                string3 = string3.replaceFirst("[.]$", "");
            }
            if ((string2 = Attribute.getSingleStringValueOrNull(attributeList, TagFromName.LossyImageCompressionMethod)) != null) {
                if (string2.equals("ISO_10918_1")) {
                    string2 = "JPEG";
                } else if (string2.equals("ISO_14495_1")) {
                    string2 = "JLS";
                } else if (string2.equals("ISO_15444_1")) {
                    string2 = "J2K";
                } else if (string2.equals("ISO_13818_2")) {
                    string2 = "MPEG2";
                }
            }
            string = string2 == null && string3 == null ? "Lossy" : (string3 == null ? "Lossy " + string2 : (string2 == null ? "Lossy " + string3 + ":1" : string2 + " " + string3 + ":1"));
        } else {
            string = "";
        }
        return string;
    }

    public static void main(String[] stringArray) {
        String string = stringArray[0];
        try {
            AttributeList attributeList = new AttributeList();
            DicomInputStream dicomInputStream = new DicomInputStream(new BufferedInputStream(new FileInputStream(string)));
            attributeList.read(dicomInputStream, TagFromName.PixelData);
            dicomInputStream.close();
            System.out.println(LossyImageCompression.hasEverBeenLossyCompressed(attributeList));
        }
        catch (Exception exception) {
            exception.printStackTrace(System.err);
        }
    }
}

