/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmed.dicom;

import com.pixelmed.dicom.Attribute;
import com.pixelmed.dicom.AttributeTag;
import com.pixelmed.dicom.DicomDictionary;
import com.pixelmed.dicom.DicomException;
import com.pixelmed.dicom.DicomInputStream;
import com.pixelmed.dicom.DicomOutputStream;
import com.pixelmed.dicom.ValueRepresentation;
import com.pixelmed.utils.CopyStream;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;

public class OtherByteAttributeOnDisk
extends Attribute {
    private static final String identString = "@(#) $Header: /userland/cvs/pixelmed/imgbook/com/pixelmed/dicom/OtherByteAttributeOnDisk.java,v 1.4 2008/02/21 04:45:04 dclunie Exp $";
    protected long byteOffset;
    protected File file;

    public OtherByteAttributeOnDisk(AttributeTag attributeTag) {
        super(attributeTag);
        this.byteOffset = 0L;
        this.file = null;
    }

    public OtherByteAttributeOnDisk(AttributeTag attributeTag, long l, DicomInputStream dicomInputStream, long l2) throws IOException, DicomException {
        super(attributeTag);
        this.doCommonConstructorStuff(l, dicomInputStream, l2);
    }

    public OtherByteAttributeOnDisk(AttributeTag attributeTag, Long l, DicomInputStream dicomInputStream, Long l2) throws IOException, DicomException {
        super(attributeTag);
        this.doCommonConstructorStuff(l, dicomInputStream, l2);
    }

    private void doCommonConstructorStuff(long l, DicomInputStream dicomInputStream, long l2) throws IOException, DicomException {
        this.valueLength = l;
        this.byteOffset = l2;
        this.file = dicomInputStream.getFile();
        if (this.file == null) {
            throw new DicomException("Cannot have an OtherByteAttributeOnDisk without a file available in the DicomInputStream");
        }
        if (l > 0L) {
            try {
                dicomInputStream.skipInsistently(l);
            }
            catch (IOException iOException) {
                throw new DicomException("Failed to skip value (length " + l + " dec) in " + ValueRepresentation.getAsString(this.getVR()) + " attribute " + this.getTag());
            }
        }
    }

    public long getPaddedVL() {
        long l = this.getVL();
        if (l % 2L != 0L) {
            ++l;
        }
        return l;
    }

    public void write(DicomOutputStream dicomOutputStream) throws DicomException, IOException {
        this.writeBase(dicomOutputStream);
        if (this.valueLength > 0L) {
            BufferedInputStream bufferedInputStream = new BufferedInputStream(new FileInputStream(this.file));
            CopyStream.skipInsistently(bufferedInputStream, this.byteOffset);
            CopyStream.copy(bufferedInputStream, dicomOutputStream, this.valueLength);
            bufferedInputStream.close();
            long l = this.getPaddedVL() - this.valueLength;
            while (l-- > 0L) {
                dicomOutputStream.write(0);
            }
        }
    }

    public String toString(DicomDictionary dicomDictionary) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(super.toString(dicomDictionary));
        stringBuffer.append(" []");
        return stringBuffer.toString();
    }

    public long getByteOffset() {
        return this.byteOffset;
    }

    public File getFile() {
        return this.file;
    }

    public void setFile(File file) {
        this.file = file;
    }

    public void removeValues() {
        this.file = null;
        this.byteOffset = 0L;
        this.valueMultiplicity = 0;
        this.valueLength = 0L;
    }

    public byte[] getVR() {
        return ValueRepresentation.OB;
    }
}

