/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmed.dicom;

import com.pixelmed.dicom.AttributeList;
import com.pixelmed.dicom.ContentItem;
import com.pixelmed.dicom.DicomException;
import com.pixelmed.dicom.SpatialCoordinateAndImageReference;
import com.pixelmed.dicom.StructuredReport;
import com.pixelmed.utils.JTreeWithAdditionalKeyStrokeActions;
import java.awt.Component;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.JFrame;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.TreePath;

public class StructuredReportBrowser
extends JFrame {
    private static final String identString = "@(#) $Header: /userland/cvs/pixelmed/imgbook/com/pixelmed/dicom/StructuredReportBrowser.java,v 1.8 2005/12/21 13:34:45 dclunie Exp $";
    private JTree tree;
    private StructuredReport treeModel;

    public StructuredReportBrowser(AttributeList attributeList) throws DicomException {
        super("SR Tree example");
        this.setSize(400, 800);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                StructuredReportBrowser.this.dispose();
            }
        });
        this.treeModel = new StructuredReport(attributeList);
        this.tree = new JTreeWithAdditionalKeyStrokeActions(this.treeModel);
        this.tree.addTreeSelectionListener(this.buildTreeSelectionListener());
        JScrollPane jScrollPane = new JScrollPane(this.tree);
        this.getContentPane().add((Component)jScrollPane, "Center");
    }

    private TreeSelectionListener buildTreeSelectionListener() {
        return new TreeSelectionListener(){

            public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
                TreePath treePath = treeSelectionEvent.getNewLeadSelectionPath();
                if (treePath != null) {
                    Vector vector;
                    Object object = treePath.getPathComponent(0);
                    Object object2 = treePath.getLastPathComponent();
                    if (object instanceof ContentItem && object2 instanceof ContentItem && (vector = StructuredReport.findAllContainedSOPInstances((ContentItem)object, (ContentItem)object2)) != null) {
                        StructuredReportBrowser.this.doSomethingWithSelectedSOPInstances(vector);
                    }
                }
            }
        };
    }

    protected void doSomethingWithSelectedSOPInstances(Vector vector) {
        Iterator iterator = vector.iterator();
        while (iterator.hasNext()) {
            System.err.println((SpatialCoordinateAndImageReference)iterator.next());
        }
    }

    public static void main(String[] stringArray) {
        AttributeList attributeList = new AttributeList();
        try {
            String string = stringArray[0];
            System.err.println("test reading SR Document");
            attributeList.read(string);
            System.err.println("building tree");
            StructuredReportBrowser structuredReportBrowser = new StructuredReportBrowser(attributeList);
            System.err.println("display tree");
            structuredReportBrowser.setVisible(true);
        }
        catch (Exception exception) {
            exception.printStackTrace(System.err);
            System.exit(0);
        }
    }
}

