/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmed.dicom;

import com.pixelmed.dicom.Attribute;
import com.pixelmed.dicom.AttributeFactory;
import com.pixelmed.dicom.AttributeList;
import com.pixelmed.dicom.AttributeTag;
import com.pixelmed.dicom.DicomDictionary;
import com.pixelmed.dicom.DicomException;
import com.pixelmed.dicom.FileMetaInformation;
import com.pixelmed.dicom.SequenceAttribute;
import com.pixelmed.dicom.SequenceItem;
import com.pixelmed.dicom.TagFromName;
import com.pixelmed.dicom.ValueRepresentation;
import com.pixelmed.utils.HexDump;
import com.pixelmed.utils.StringUtilities;
import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Iterator;
import java.util.Properties;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

public class XMLRepresentationOfDicomObjectFactory {
    private static final String identString = "@(#) $Header: /userland/cvs/pixelmed/imgbook/com/pixelmed/dicom/XMLRepresentationOfDicomObjectFactory.java,v 1.17 2007/12/01 16:47:55 dclunie Exp $";
    private DocumentBuilder db;

    private String makeElementNameFromHexadecimalGroupElementValues(AttributeTag attributeTag) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("HEX");
        String string = Integer.toHexString(attributeTag.getGroup());
        for (int i = string.length(); i < 4; ++i) {
            stringBuffer.append("0");
        }
        stringBuffer.append(string);
        String string2 = Integer.toHexString(attributeTag.getElement());
        for (int i = string2.length(); i < 4; ++i) {
            stringBuffer.append("0");
        }
        stringBuffer.append(string2);
        return stringBuffer.toString();
    }

    void addAttributesFromNodeToList(AttributeList attributeList, Node node) throws NumberFormatException, DicomException {
        if (node != null) {
            for (Node node2 = node.getFirstChild(); node2 != null; node2 = node2.getNextSibling()) {
                Object object;
                String string;
                Node node3;
                Attribute attribute;
                String string2 = node2.getNodeName();
                NamedNodeMap namedNodeMap = node2.getAttributes();
                if (namedNodeMap == null) continue;
                Node node4 = namedNodeMap.getNamedItem("vr");
                Node node5 = namedNodeMap.getNamedItem("group");
                Node node6 = namedNodeMap.getNamedItem("element");
                if (node4 == null || node5 == null || node6 == null) continue;
                String string3 = node4.getNodeValue();
                String string4 = node5.getNodeValue();
                String string5 = node6.getNodeValue();
                if (string3 == null || string4 == null || string5 == null) continue;
                byte[] byArray = string3.getBytes();
                int n = Integer.parseInt(string4, 16);
                int n2 = Integer.parseInt(string5, 16);
                AttributeTag attributeTag = new AttributeTag(n, n2);
                if (n % 2 == 0 && n2 == 0 || n == 8 && n2 == 1 || n == 65532 && n2 == 65532) continue;
                if (string3.equals("SQ")) {
                    attribute = new SequenceAttribute(attributeTag);
                    if (node2.hasChildNodes()) {
                        for (node3 = node2.getFirstChild(); node3 != null; node3 = node3.getNextSibling()) {
                            string = node3.getNodeName();
                            if (string == null || !string.equals("Item")) continue;
                            object = new AttributeList();
                            this.addAttributesFromNodeToList((AttributeList)object, node3);
                            ((SequenceAttribute)attribute).addItem((AttributeList)object);
                        }
                    }
                    attributeList.put(attributeTag, attribute);
                    continue;
                }
                attribute = AttributeFactory.newAttribute(attributeTag, byArray);
                if (node2.hasChildNodes()) {
                    for (node3 = node2.getFirstChild(); node3 != null; node3 = node3.getNextSibling()) {
                        string = node3.getNodeName();
                        if (string == null || !string.equals("value") || (object = node3.getTextContent()) == null) continue;
                        object = StringUtilities.removeLeadingOrTrailingWhitespaceOrISOControl((String)object);
                        attribute.addValue((String)object);
                    }
                }
                attributeList.put(attributeTag, attribute);
            }
        }
    }

    void addAttributesFromListToNode(AttributeList attributeList, Document document, Node node) {
        DicomDictionary dicomDictionary = attributeList.getDictionary();
        for (Attribute attribute : attributeList.values()) {
            Node node2;
            Object object;
            AttributeTag attributeTag = attribute.getTag();
            String string = dicomDictionary.getNameFromTag(attributeTag);
            if (string == null) {
                string = this.makeElementNameFromHexadecimalGroupElementValues(attributeTag);
            }
            Element element = document.createElement(string);
            node.appendChild(element);
            String[] stringArray = document.createAttribute("group");
            stringArray.setValue(HexDump.shortToPaddedHexString(attributeTag.getGroup()));
            element.getAttributes().setNamedItem((Node)stringArray);
            stringArray = document.createAttribute("element");
            stringArray.setValue(HexDump.shortToPaddedHexString(attributeTag.getElement()));
            element.getAttributes().setNamedItem((Node)stringArray);
            stringArray = document.createAttribute("vr");
            stringArray.setValue(ValueRepresentation.getAsString(attribute.getVR()));
            element.getAttributes().setNamedItem((Node)stringArray);
            if (attribute instanceof SequenceAttribute) {
                int n = 0;
                Iterator iterator = ((SequenceAttribute)attribute).iterator();
                while (iterator.hasNext()) {
                    object = (SequenceItem)iterator.next();
                    node2 = document.createElement("Item");
                    Attr attr = document.createAttribute("number");
                    attr.setValue(Integer.toString(++n));
                    node2.getAttributes().setNamedItem(attr);
                    element.appendChild(node2);
                    this.addAttributesFromListToNode(((SequenceItem)object).getAttributeList(), document, node2);
                }
                continue;
            }
            stringArray = null;
            try {
                stringArray = attribute.getStringValues();
            }
            catch (DicomException dicomException) {
                // empty catch block
            }
            if (stringArray == null) continue;
            for (int i = 0; i < stringArray.length; ++i) {
                object = document.createElement("value");
                node2 = document.createAttribute("number");
                node2.setValue(Integer.toString(i + 1));
                object.getAttributes().setNamedItem(node2);
                object.appendChild(document.createTextNode(stringArray[i]));
                element.appendChild((Node)object);
            }
        }
    }

    public XMLRepresentationOfDicomObjectFactory() throws ParserConfigurationException {
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        documentBuilderFactory.setNamespaceAware(true);
        this.db = documentBuilderFactory.newDocumentBuilder();
    }

    public Document getDocument(AttributeList attributeList) {
        Document document = this.db.newDocument();
        Element element = document.createElement("DicomObject");
        document.appendChild(element);
        this.addAttributesFromListToNode(attributeList, document, element);
        return document;
    }

    public AttributeList getAttributeList(Document document) throws DicomException {
        AttributeList attributeList = new AttributeList();
        Element element = document.getDocumentElement();
        this.addAttributesFromNodeToList(attributeList, element);
        return attributeList;
    }

    public AttributeList getAttributeList(InputStream inputStream) throws IOException, SAXException, DicomException {
        Document document = this.db.parse(inputStream);
        return this.getAttributeList(document);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AttributeList getAttributeList(String string) throws IOException, SAXException, DicomException {
        FileInputStream fileInputStream = new FileInputStream(string);
        BufferedInputStream bufferedInputStream = new BufferedInputStream(fileInputStream);
        AttributeList attributeList = null;
        try {
            attributeList = this.getAttributeList(bufferedInputStream);
        }
        finally {
            bufferedInputStream.close();
            ((InputStream)fileInputStream).close();
        }
        return attributeList;
    }

    public static String toString(Node node, int n) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < n; ++i) {
            stringBuffer.append("    ");
        }
        stringBuffer.append(node);
        if (node.hasAttributes()) {
            NamedNodeMap namedNodeMap = node.getAttributes();
            for (int i = 0; i < namedNodeMap.getLength(); ++i) {
                Node node2 = namedNodeMap.item(i);
                stringBuffer.append(" ");
                stringBuffer.append(node2);
            }
        }
        stringBuffer.append("\n");
        ++n;
        for (Node node3 = node.getFirstChild(); node3 != null; node3 = node3.getNextSibling()) {
            stringBuffer.append(XMLRepresentationOfDicomObjectFactory.toString(node3, n));
        }
        return stringBuffer.toString();
    }

    public static String toString(Node node) {
        return XMLRepresentationOfDicomObjectFactory.toString(node, 0);
    }

    public static void write(OutputStream outputStream, Document document) throws IOException, TransformerConfigurationException, TransformerException {
        DOMSource dOMSource = new DOMSource(document);
        StreamResult streamResult = new StreamResult(outputStream);
        Transformer transformer = TransformerFactory.newInstance().newTransformer();
        Properties properties = new Properties();
        properties.setProperty("method", "xml");
        properties.setProperty("indent", "yes");
        properties.setProperty("encoding", "UTF-8");
        transformer.setOutputProperties(properties);
        transformer.transform(dOMSource, streamResult);
    }

    public static void createDocumentAndWriteIt(AttributeList attributeList, OutputStream outputStream) throws IOException, DicomException {
        try {
            Document document = new XMLRepresentationOfDicomObjectFactory().getDocument(attributeList);
            XMLRepresentationOfDicomObjectFactory.write(outputStream, document);
        }
        catch (ParserConfigurationException parserConfigurationException) {
            throw new DicomException("Could not create XML document - problem creating object model from DICOM" + parserConfigurationException);
        }
        catch (TransformerConfigurationException transformerConfigurationException) {
            throw new DicomException("Could not create XML document - could not instantiate transformer" + transformerConfigurationException);
        }
        catch (TransformerException transformerException) {
            throw new DicomException("Could not create XML document - could not transform to XML" + transformerException);
        }
    }

    public static void main(String[] stringArray) {
        try {
            boolean bl = true;
            boolean bl2 = true;
            String string = null;
            if (stringArray.length == 1) {
                bl = false;
                bl2 = true;
                string = stringArray[0];
            } else if (stringArray.length == 2) {
                string = stringArray[1];
                if (stringArray[0].toLowerCase().equals("toxml")) {
                    bl = false;
                    bl2 = true;
                } else if (stringArray[0].toLowerCase().equals("todicom") || stringArray[0].toLowerCase().equals("todcm")) {
                    bl = false;
                    bl2 = false;
                }
            }
            if (bl) {
                System.err.println("usage: XMLRepresentationOfDicomObjectFactory [toDICOM|toXML] inputfile");
            } else if (bl2) {
                AttributeList attributeList = new AttributeList();
                attributeList.read(string, null, true, true);
                Document document = new XMLRepresentationOfDicomObjectFactory().getDocument(attributeList);
                XMLRepresentationOfDicomObjectFactory.write(System.out, document);
            } else {
                AttributeList attributeList = new XMLRepresentationOfDicomObjectFactory().getAttributeList(string);
                String string2 = Attribute.getSingleStringValueOrEmptyString(attributeList, TagFromName.SourceApplicationEntityTitle);
                attributeList.removeMetaInformationHeaderAttributes();
                FileMetaInformation.addFileMetaInformation(attributeList, "1.2.840.10008.1.2.1", string2);
                attributeList.write(System.out, "1.2.840.10008.1.2.1", true, true);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace(System.err);
        }
    }
}

