/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmed.network;

import com.pixelmed.network.DicomNetworkException;
import com.pixelmed.utils.HexDump;
import java.io.IOException;
import java.io.OutputStream;

public class AssociationOutputStream
extends OutputStream {
    private static final String identString = "@(#) $Header: /userland/cvs/pixelmed/imgbook/com/pixelmed/network/AssociationOutputStream.java,v 1.14 2005/04/14 20:24:33 dclunie Exp $";
    private static final int ourMaxPDUSize = 65536;
    private static final int ourMinPDUSize = 8;
    private OutputStream out;
    private int presentationContextID;
    private byte[] dataBuffer;
    private int dataBufferSize;
    private int dataBufferIndex;
    private boolean isCommand;
    private boolean isLastFragment;
    private int debugLevel;

    public AssociationOutputStream(OutputStream outputStream, int n, int n2, int n3) throws DicomNetworkException {
        this.out = outputStream;
        this.presentationContextID = n2;
        this.debugLevel = n3;
        if (n3 > 1) {
            System.err.println("AssociationOutputStream:maxPDUSize=" + n);
        }
        if (n3 > 1) {
            System.err.println("AssociationOutputStream:ourMinPDUSize=8");
        }
        if (n3 > 1) {
            System.err.println("AssociationOutputStream:ourMaxPDUSize=65536");
        }
        if (n != 0 && n < 8) {
            throw new DicomNetworkException("Maximum PDU Size too small to be usable (" + n + " bytes");
        }
        this.dataBufferSize = (n == 0 || n > 65536 ? 65536 : n) - 6;
        if (n3 > 0) {
            System.err.println("AssociationOutputStream:dataBufferSize=" + this.dataBufferSize);
        }
        this.dataBuffer = new byte[this.dataBufferSize];
        this.dataBufferIndex = 0;
        this.isCommand = false;
        this.isLastFragment = false;
    }

    public void write(int n) throws IOException {
        byte[] byArray = new byte[]{(byte)n};
        this.write(byArray, 0, 1);
    }

    public void write(byte[] byArray) throws IOException {
        this.write(byArray, 0, byArray.length);
    }

    public void write(byte[] byArray, int n, int n2) throws IOException {
        if (this.debugLevel > 3) {
            System.err.println("AssociationOutputStream:write() start: len=" + n2);
        }
        if (byArray == null) {
            throw new NullPointerException();
        }
        if (n < 0 || n > byArray.length || n2 < 0 || n + n2 > byArray.length || n + n2 < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (n2 == 0) {
            return;
        }
        while (this.dataBufferIndex + n2 > this.dataBufferSize) {
            int n3 = this.dataBufferSize - this.dataBufferIndex;
            if (this.debugLevel > 3) {
                System.err.println("AssociationOutputStream:write() looping to write useLen=" + n3);
            }
            System.arraycopy(byArray, n, this.dataBuffer, this.dataBufferIndex, n3);
            this.dataBufferIndex += n3;
            this.sendPDV();
            n += n3;
            n2 -= n3;
        }
        if (n2 > 0) {
            if (this.debugLevel > 3) {
                System.err.println("AssociationOutputStream:write() residual write len=" + n2);
            }
            System.arraycopy(byArray, n, this.dataBuffer, this.dataBufferIndex, n2);
            this.dataBufferIndex += n2;
        }
        if (this.debugLevel > 3) {
            System.err.println("AssociationOutputStream:write() done");
        }
    }

    private void sendPDV() throws IOException {
        if (this.debugLevel > 2) {
            System.err.println("AssociationOutputStream:flush() start");
        }
        if (this.dataBufferIndex % 2 != 0) {
            throw new IOException("PDV must be even length");
        }
        if (this.debugLevel > 2) {
            System.err.println("AssociationOutputStream:flush()=" + HexDump.dump(this.dataBuffer, this.dataBufferIndex));
        }
        int n = 2 + this.dataBufferIndex;
        int n2 = n + 4;
        if (this.debugLevel > 1) {
            System.err.println("AssociationOutputStream:flush() pduLength=" + n2);
        }
        this.out.write(4);
        this.out.write(0);
        this.out.write(n2 >> 24 & 0xFF);
        this.out.write(n2 >> 16 & 0xFF);
        this.out.write(n2 >> 8 & 0xFF);
        this.out.write(n2 & 0xFF);
        this.out.write(n >> 24 & 0xFF);
        this.out.write(n >> 16 & 0xFF);
        this.out.write(n >> 8 & 0xFF);
        this.out.write(n & 0xFF);
        this.out.write(this.presentationContextID);
        if (this.debugLevel > 1) {
            System.err.println("AssociationOutputStream:flush() isLastFragment=" + this.isLastFragment);
        }
        int n3 = (this.isLastFragment ? 1 : 0) << 1 | (this.isCommand ? 1 : 0);
        this.out.write(n3);
        if (this.debugLevel > 1) {
            System.err.println("AssociationOutputStream:flush() writing data length=" + this.dataBufferIndex);
        }
        if (this.dataBufferIndex > 0) {
            this.out.write(this.dataBuffer, 0, this.dataBufferIndex);
        }
        this.out.flush();
        this.dataBufferIndex = 0;
        if (this.debugLevel > 2) {
            System.err.println("AssociationOutputStream:flush() done");
        }
    }

    public void close() throws IOException {
        if (this.debugLevel > 1) {
            System.err.println("AssociationOutputStream:close() start");
        }
        this.isLastFragment = true;
        if (this.dataBufferIndex % 2 != 0) {
            if (this.debugLevel > 1) {
                System.err.println("AssociationOutputStream:close() padding with an extra null byte to get to even length");
            }
            this.dataBuffer[this.dataBufferIndex++] = 0;
        }
        this.sendPDV();
        if (this.debugLevel > 1) {
            System.err.println("AssociationOutputStream:close() done");
        }
    }

    public void flush() throws IOException {
        if (this.debugLevel > 1) {
            System.err.println("AssociationOutputStream:flush() does nothing");
        }
    }
}

