/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmed.network;

import com.pixelmed.network.ApplicationEntityMap;
import com.pixelmed.network.NetworkApplicationInformation;
import com.pixelmed.network.NetworkApplicationProperties;
import com.pixelmed.network.NetworkConfigurationFromLDAP;
import com.pixelmed.network.NetworkConfigurationFromMulticastDNS;
import com.pixelmed.network.NetworkConfigurationSource;
import com.pixelmed.web.WebServerApplicationProperties;
import java.util.ArrayList;
import java.util.ListIterator;
import java.util.Set;

public class NetworkApplicationInformationFederated
extends NetworkApplicationInformation {
    private static final String identString = "@(#) $Header: /userland/cvs/pixelmed/imgbook/com/pixelmed/network/NetworkApplicationInformationFederated.java,v 1.3 2007/04/19 13:32:31 dclunie Exp $";
    protected static final long RefreshFromSourcesInterval = 10000L;
    protected ArrayList sources = null;
    protected long lastTimeUpdateRan = 0L;

    public ApplicationEntityMap getApplicationEntityMap() {
        this.update();
        return super.getApplicationEntityMap();
    }

    public Set getListOfLocalNamesOfApplicationEntities() {
        this.update();
        return super.getListOfLocalNamesOfApplicationEntities();
    }

    public Set getListOfApplicationEntityTitlesOfApplicationEntities() {
        this.update();
        return super.getListOfApplicationEntityTitlesOfApplicationEntities();
    }

    public String getApplicationEntityTitleFromLocalName(String string) {
        this.update();
        return super.getApplicationEntityTitleFromLocalName(string);
    }

    public String getLocalNameFromApplicationEntityTitle(String string) {
        this.update();
        return super.getLocalNameFromApplicationEntityTitle(string);
    }

    protected synchronized void update() {
        if (System.currentTimeMillis() - this.lastTimeUpdateRan > 10000L) {
            this.removeAll();
            ListIterator listIterator = this.sources.listIterator();
            while (listIterator.hasNext()) {
                NetworkConfigurationSource networkConfigurationSource = (NetworkConfigurationSource)listIterator.next();
                NetworkApplicationInformation networkApplicationInformation = networkConfigurationSource.getNetworkApplicationInformation();
                this.addAll(networkApplicationInformation);
            }
            this.lastTimeUpdateRan = System.currentTimeMillis();
        }
    }

    public void addSource(NetworkConfigurationSource networkConfigurationSource) {
        if (this.sources == null) {
            this.sources = new ArrayList();
        }
        this.sources.add(networkConfigurationSource);
        this.lastTimeUpdateRan = 0L;
    }

    public void startupAllKnownSourcesAndRegister(NetworkApplicationProperties networkApplicationProperties) {
        this.startupAllKnownSourcesAndRegister(networkApplicationProperties, null);
    }

    public void startupAllKnownSourcesAndRegister(NetworkApplicationProperties networkApplicationProperties, WebServerApplicationProperties webServerApplicationProperties) {
        NetworkConfigurationSource networkConfigurationSource;
        String string;
        String string2;
        int n = 0;
        if (networkApplicationProperties != null) {
            n = networkApplicationProperties.getNetworkDynamicConfigurationDebugLevel();
        }
        NetworkConfigurationFromMulticastDNS networkConfigurationFromMulticastDNS = null;
        try {
            networkConfigurationFromMulticastDNS = new NetworkConfigurationFromMulticastDNS(n);
            networkConfigurationFromMulticastDNS.activateDiscovery();
            this.addSource(networkConfigurationFromMulticastDNS);
            if (networkApplicationProperties != null) {
                int n2 = networkApplicationProperties.getListeningPort();
                string2 = networkApplicationProperties.getCalledAETitle();
                string = networkApplicationProperties.getPrimaryDeviceType();
                networkConfigurationFromMulticastDNS.registerDicomService(string2, n2, string);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace(System.err);
        }
        if (n > 1) {
            System.err.println("NetworkApplicationInformationFederated.startupAllKnownSourcesAndRegister(): federatedNetworkApplicationInformation after DNS ...\n" + this);
        }
        try {
            networkConfigurationSource = new NetworkConfigurationFromLDAP(n);
            networkConfigurationSource.activateDiscovery(300000);
            this.addSource(networkConfigurationSource);
        }
        catch (Exception exception) {
            exception.printStackTrace(System.err);
        }
        if (n > 1) {
            System.err.println("NetworkApplicationInformationFederated.startupAllKnownSourcesAndRegister(): federatedNetworkApplicationInformation after LDAP ...\n" + this);
        }
        if (networkApplicationProperties != null) {
            try {
                networkConfigurationSource = networkApplicationProperties.getNetworkConfigurationSource();
                this.addSource(networkConfigurationSource);
            }
            catch (Exception exception) {
                exception.printStackTrace(System.err);
            }
        }
        if (webServerApplicationProperties != null && networkConfigurationFromMulticastDNS != null) {
            int n3 = webServerApplicationProperties.getListeningPort();
            string2 = webServerApplicationProperties.getRootURL();
            string = webServerApplicationProperties.getInstanceName();
            networkConfigurationFromMulticastDNS.registerWADOService(string, n3, string2);
        }
    }
}

