/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmed.utils;

import java.text.NumberFormat;
import java.util.ArrayList;

public class FloatFormatter {
    private static final String identString = "@(#) $Header: /userland/cvs/pixelmed/imgbook/com/pixelmed/utils/FloatFormatter.java,v 1.5 2005/01/27 19:36:54 dclunie Exp $";
    private static final int precisionToDisplayDouble = 4;
    private static final int maximumIntegerDigits = 8;
    private static final int maximumMaximumFractionDigits = 6;

    private FloatFormatter() {
    }

    public static String toString(double d) {
        NumberFormat numberFormat = NumberFormat.getInstance();
        numberFormat.setGroupingUsed(false);
        String string = null;
        int n = (int)(Math.log(d) / Math.log(10.0)) + 1;
        int n2 = 4 - n;
        if (n > 8 || n2 > 6) {
            string = Double.toString(d);
        } else {
            if (n2 < 0) {
                n2 = 0;
            }
            numberFormat.setMaximumFractionDigits(n2);
            string = numberFormat.format(d);
        }
        return string;
    }

    public static final double[] fromString(String string, int n, char c) {
        double[] dArray = new double[n];
        int n2 = 0;
        try {
            int n3 = 0;
            int n4 = 0;
            int n5 = string.length();
            while (n2 < n) {
                if (n4 >= n5 || string.charAt(n4) == c) {
                    dArray[n2++] = Double.parseDouble(string.substring(n3, n4));
                    n3 = ++n4;
                    if (n4 < n5) continue;
                    break;
                }
                ++n4;
            }
        }
        catch (NumberFormatException numberFormatException) {
            numberFormatException.printStackTrace(System.err);
            n2 = 0;
        }
        return n2 != n ? null : dArray;
    }

    public static final double[] fromString(String string, char c) {
        int n;
        ArrayList<Double> arrayList = new ArrayList<Double>();
        int n2 = 0;
        try {
            int n3 = 0;
            n = 0;
            int n4 = string.length();
            while (n3 < n4) {
                if (n >= n4 || string.charAt(n) == c) {
                    arrayList.add(new Double(Double.parseDouble(string.substring(n3, n))));
                    ++n2;
                    n3 = ++n;
                    if (n < n4) continue;
                    break;
                }
                ++n;
            }
        }
        catch (NumberFormatException numberFormatException) {
            numberFormatException.printStackTrace(System.err);
            n2 = 0;
        }
        double[] dArray = null;
        if (n2 > 0) {
            dArray = new double[n2];
            for (n = 0; n < n2; ++n) {
                dArray[n] = (Double)arrayList.get(n);
            }
        }
        return dArray;
    }
}

