/*
 * Decompiled with CFR 0.152.
 */
package org.nbirn.fbirn.utilities;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.UndoableEditListener;
import javax.swing.text.AbstractDocument;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.Position;
import javax.swing.text.Segment;
import javax.swing.text.SimpleAttributeSet;

public class AppendOnlyDocument
implements Document {
    private AbstractDocument.Content _content;
    private List<DocumentListener> _listeners;
    private Element[] _linemap;
    private int _linemaplen;
    private RootElement _root;
    private static final AttributeSet NULLATTRS = new SimpleAttributeSet();
    private static final int EOFINDEX = Integer.MAX_VALUE;
    private static final Element[] EMPTYELEMARRAY = new Element[0];
    private ReentrantReadWriteLock _lock;
    private ReentrantReadWriteLock.ReadLock _readLock;
    private ReentrantReadWriteLock.WriteLock _writeLock;
    private final EndElement _endElement;
    private final Comparator<Element> ELEMCOMPARATOR = new ElementComparator();

    public AppendOnlyDocument(AbstractDocument.Content content) {
        this._content = content;
        this._listeners = new ArrayList<DocumentListener>();
        this._lock = new ReentrantReadWriteLock();
        this._readLock = this._lock.readLock();
        this._writeLock = this._lock.writeLock();
        this._root = new RootElement();
        this._endElement = new EndElement();
        this._linemap = new Element[1];
        this._linemap[0] = this._endElement;
        this._linemaplen = 0;
    }

    public int getLength() {
        return this._content.length() - 1;
    }

    public void addDocumentListener(DocumentListener listener) {
        this._listeners.add(listener);
    }

    public void removeDocumentListener(DocumentListener listener) {
        this._listeners.remove(listener);
    }

    public void addUndoableEditListener(UndoableEditListener listener) {
    }

    public void removeUndoableEditListener(UndoableEditListener listener) {
    }

    public Object getProperty(Object key) {
        return null;
    }

    public void putProperty(Object key, Object value) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(int offs, int len) throws BadLocationException {
        this._writeLock.lock();
        try {
            final int cachedoffs = offs;
            final int cachedlen = len;
            LineElement compElem = new LineElement(offs, offs + len);
            int ind = Arrays.binarySearch(this._linemap, compElem, this.ELEMCOMPARATOR);
            if (ind < 0) {
                ind = -1 * (ind + 1);
            }
            final Element[] elems = Arrays.copyOfRange(this._linemap, ind, this._linemaplen);
            this._linemap[ind] = this._endElement;
            this._linemaplen = ind;
            this.notifyListeners(new DocumentEvent(){

                public int getOffset() {
                    return cachedoffs;
                }

                public int getLength() {
                    return cachedlen;
                }

                public Document getDocument() {
                    return AppendOnlyDocument.this;
                }

                public DocumentEvent.EventType getType() {
                    return DocumentEvent.EventType.REMOVE;
                }

                public DocumentEvent.ElementChange getChange(Element elem) {
                    if (elem == AppendOnlyDocument.this._root) {
                        return new DocumentEvent.ElementChange(){

                            public Element getElement() {
                                return AppendOnlyDocument.this._root;
                            }

                            public int getIndex() {
                                return 0;
                            }

                            public Element[] getChildrenRemoved() {
                                return elems;
                            }

                            public Element[] getChildrenAdded() {
                                return EMPTYELEMARRAY;
                            }
                        };
                    }
                    return null;
                }
            });
            this._content.remove(offs, len);
        }
        finally {
            this._writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void insertString(int offset, String str, AttributeSet a) throws BadLocationException {
        this._writeLock.lock();
        try {
            if (offset != this.getLength()) {
                throw new BadLocationException("Inserts only allowed at end of file (curlength=" + this.getLength() + ")", offset);
            }
            this._content.insertString(offset, str);
            final int localOffset = offset;
            final int localLength = str.length();
            final int localChangeIndex = this._linemaplen;
            int numlines = 0;
            int curStrIndex = 0;
            int nlInd = 0;
            while (curStrIndex < localLength) {
                if (this._linemaplen + 1 >= this._linemap.length) {
                    this._linemap = Arrays.copyOf(this._linemap, (int)((double)this._linemap.length + (double)this._linemap.length * 0.5 + 1.0));
                    Arrays.fill(this._linemap, this._linemaplen, this._linemap.length, this._endElement);
                }
                this._linemap[this._linemaplen] = new LineElement(offset + curStrIndex, (nlInd = str.indexOf(10, curStrIndex)) == -1 ? offset + str.length() : offset + nlInd + 1);
                ++this._linemaplen;
                ++numlines;
                if (nlInd == -1) break;
                curStrIndex = nlInd + 1;
            }
            final int localNumChanges = numlines;
            this.notifyListeners(new DocumentEvent(){

                public int getOffset() {
                    return localOffset;
                }

                public int getLength() {
                    return localLength;
                }

                public Document getDocument() {
                    return AppendOnlyDocument.this;
                }

                public DocumentEvent.EventType getType() {
                    return DocumentEvent.EventType.INSERT;
                }

                public DocumentEvent.ElementChange getChange(Element elem) {
                    if (elem == AppendOnlyDocument.this._root) {
                        return new DocumentEvent.ElementChange(){

                            public Element getElement() {
                                return AppendOnlyDocument.this._root;
                            }

                            public int getIndex() {
                                return localChangeIndex;
                            }

                            public Element[] getChildrenRemoved() {
                                return EMPTYELEMARRAY;
                            }

                            public Element[] getChildrenAdded() {
                                return Arrays.copyOfRange(AppendOnlyDocument.this._linemap, localChangeIndex, localChangeIndex + localNumChanges);
                            }
                        };
                    }
                    return null;
                }
            });
        }
        finally {
            this._writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getText(int offset, int length) throws BadLocationException {
        this._readLock.lock();
        try {
            String string = this._content.getString(offset, length);
            return string;
        }
        finally {
            this._readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getText(int offset, int length, Segment txt) throws BadLocationException {
        this._readLock.lock();
        try {
            this._content.getChars(offset, length, txt);
        }
        finally {
            this._readLock.unlock();
        }
    }

    public Position getStartPosition() {
        try {
            return this._content.createPosition(0);
        }
        catch (BadLocationException ex) {
            Logger.getLogger(AppendOnlyDocument.class.getName()).log(Level.SEVERE, null, ex);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Position getEndPosition() {
        this._readLock.lock();
        try {
            Position position = this._content.createPosition(this._content.length());
            return position;
        }
        catch (BadLocationException ex) {
            Logger.getLogger(AppendOnlyDocument.class.getName()).log(Level.SEVERE, null, ex);
            Position position = null;
            return position;
        }
        finally {
            this._readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int findEnclosingLineIndex(int offset) {
        this._readLock.lock();
        try {
            if (offset >= this.getLength()) {
                int n = Integer.MAX_VALUE;
                return n;
            }
            LineElement compElem = new LineElement(offset, 0);
            int ind = Arrays.binarySearch(this._linemap, compElem, this.ELEMCOMPARATOR);
            if (ind < 0) {
                ind = -1 * (ind + 1) - 1;
            } else if (ind >= this._linemaplen) {
                ind = this._linemaplen - 1;
            }
            int n = ind;
            return n;
        }
        finally {
            this._readLock.unlock();
        }
    }

    public Position createPosition(int offs) throws BadLocationException {
        return this._content.createPosition(offs);
    }

    public Element[] getRootElements() {
        return new Element[]{this._root};
    }

    public Element getDefaultRootElement() {
        return this._root;
    }

    public void render(Runnable r) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    private void notifyListeners(DocumentEvent e) {
        for (DocumentListener listener : this._listeners) {
            DocumentEvent.EventType type = e.getType();
            if (type == DocumentEvent.EventType.CHANGE) {
                listener.changedUpdate(e);
                continue;
            }
            if (type == DocumentEvent.EventType.INSERT) {
                listener.insertUpdate(e);
                continue;
            }
            if (type != DocumentEvent.EventType.REMOVE) continue;
            listener.removeUpdate(e);
        }
    }

    private class EndElement
    implements Element {
        private EndElement() {
        }

        public Document getDocument() {
            return AppendOnlyDocument.this;
        }

        public Element getParentElement() {
            return AppendOnlyDocument.this._root;
        }

        public String getName() {
            return "end-of-file";
        }

        public AttributeSet getAttributes() {
            return NULLATTRS;
        }

        public int getStartOffset() {
            return AppendOnlyDocument.this.getLength();
        }

        public int getEndOffset() {
            return AppendOnlyDocument.this.getLength();
        }

        public int getElementIndex(int offset) {
            return -1;
        }

        public int getElementCount() {
            return 0;
        }

        public Element getElement(int index) {
            return null;
        }

        public boolean isLeaf() {
            return true;
        }
    }

    private class LineElement
    implements Element {
        int _start;
        int _end;

        public LineElement(int start, int end) {
            this._start = start;
            this._end = end;
        }

        public Document getDocument() {
            return AppendOnlyDocument.this;
        }

        public Element getParentElement() {
            return AppendOnlyDocument.this._root;
        }

        public String getName() {
            return "line";
        }

        public AttributeSet getAttributes() {
            return NULLATTRS;
        }

        public int getStartOffset() {
            return this._start;
        }

        public int getEndOffset() {
            return this._end;
        }

        public int getElementIndex(int offset) {
            return -1;
        }

        public int getElementCount() {
            return 0;
        }

        public Element getElement(int index) {
            return null;
        }

        public boolean isLeaf() {
            return true;
        }
    }

    private class RootElement
    implements Element {
        public Document getDocument() {
            return AppendOnlyDocument.this;
        }

        public Element getParentElement() {
            return null;
        }

        public String getName() {
            return "root";
        }

        public AttributeSet getAttributes() {
            return NULLATTRS;
        }

        public int getStartOffset() {
            return 0;
        }

        public int getEndOffset() {
            return AppendOnlyDocument.this._content.length();
        }

        public int getElementIndex(int offset) {
            return AppendOnlyDocument.this.findEnclosingLineIndex(offset);
        }

        public int getElementCount() {
            return AppendOnlyDocument.this._linemaplen + 1;
        }

        public Element getElement(int index) {
            if (index == Integer.MAX_VALUE) {
                return AppendOnlyDocument.this._linemap[AppendOnlyDocument.this._linemaplen];
            }
            return AppendOnlyDocument.this._linemap[index];
        }

        public boolean isLeaf() {
            return false;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ElementComparator
    implements Comparator<Element> {
        private ElementComparator() {
        }

        @Override
        public int compare(Element o1, Element o2) {
            int end2;
            int off2;
            if (o1 == AppendOnlyDocument.this._endElement) {
                return -1;
            }
            if (o2 == AppendOnlyDocument.this._endElement) {
                return 1;
            }
            int off1 = o1.getStartOffset();
            if (off1 < (off2 = o2.getStartOffset())) {
                return -1;
            }
            if (off1 > off2) {
                return 1;
            }
            int end1 = o1.getEndOffset();
            if (end1 < (end2 = o2.getEndOffset())) {
                return -1;
            }
            if (end1 > end2) {
                return 1;
            }
            return 0;
        }
    }
}

