/*
 * Decompiled with CFR 0.152.
 */
package org.nbirn.fbirn.utilities;

import java.awt.Color;
import java.awt.Font;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.UndoableEditListener;
import javax.swing.text.AbstractDocument;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.Position;
import javax.swing.text.Segment;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.Style;
import javax.swing.text.StyleContext;
import javax.swing.text.StyledDocument;

public class AppendOnlyStyledDocument
implements StyledDocument {
    private static final int FRAGMENTSIZE = 8192;
    private static final AttributeSet NULLATTRS = new SimpleAttributeSet();
    private AbstractDocument.Content _content;
    private StyleContext _styles;
    private RootElement _rootElement;
    private List<DocumentListener> _listeners;

    public AppendOnlyStyledDocument(AbstractDocument.Content content) {
        this._content = content;
        this._styles = new StyleContext();
        this._rootElement = new RootElement();
        this._listeners = new ArrayList<DocumentListener>();
    }

    public Style addStyle(String nm, Style parent) {
        return this._styles.addStyle(nm, parent);
    }

    public void removeStyle(String nm) {
        this._styles.removeStyle(nm);
    }

    public Style getStyle(String nm) {
        return this._styles.getStyle(nm);
    }

    public void setCharacterAttributes(int offset, int length, AttributeSet s, boolean replace) {
    }

    public void setParagraphAttributes(int offset, int length, AttributeSet s, boolean replace) {
    }

    public void setLogicalStyle(int pos, Style s) {
    }

    public Style getLogicalStyle(int p) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public Element getParagraphElement(int pos) {
        return this.getCharacterElement(pos);
    }

    public Element getCharacterElement(int pos) {
        int ind = this._rootElement.getElementIndex(pos);
        if (ind != -1) {
            return this._rootElement.getElement(ind);
        }
        return null;
    }

    public Color getForeground(AttributeSet attr) {
        return Color.BLACK;
    }

    public Color getBackground(AttributeSet attr) {
        return Color.WHITE;
    }

    public Font getFont(AttributeSet attr) {
        return this._styles.getFont(attr);
    }

    public int getLength() {
        return this._content.length() - 1;
    }

    public void addDocumentListener(DocumentListener listener) {
        this._listeners.add(listener);
    }

    public void removeDocumentListener(DocumentListener listener) {
        this._listeners.remove(listener);
    }

    public void addUndoableEditListener(UndoableEditListener listener) {
    }

    public void removeUndoableEditListener(UndoableEditListener listener) {
    }

    public Object getProperty(Object key) {
        return null;
    }

    public void putProperty(Object key, Object value) {
    }

    public void remove(int offs, int len) throws BadLocationException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void insertString(int offset, String str, AttributeSet a) throws BadLocationException {
        this._content.insertString(offset, str);
        int strlen = str.length();
        this._rootElement.insert(offset, strlen);
    }

    public String getText(int offset, int length) throws BadLocationException {
        return this._content.getString(offset, length);
    }

    public void getText(int offset, int length, Segment txt) throws BadLocationException {
        this._content.getChars(offset, length, txt);
    }

    public Position getStartPosition() {
        try {
            return this._content.createPosition(0);
        }
        catch (BadLocationException ex) {
            Logger.getLogger(AppendOnlyStyledDocument.class.getName()).log(Level.SEVERE, null, ex);
            return null;
        }
    }

    public Position getEndPosition() {
        try {
            return this._content.createPosition(this._content.length());
        }
        catch (BadLocationException ex) {
            Logger.getLogger(AppendOnlyStyledDocument.class.getName()).log(Level.SEVERE, null, ex);
            return null;
        }
    }

    public Position createPosition(int offs) throws BadLocationException {
        return this._content.createPosition(offs);
    }

    public Element[] getRootElements() {
        return new Element[]{this.getDefaultRootElement()};
    }

    public Element getDefaultRootElement() {
        return this._rootElement;
    }

    public void render(Runnable r) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    private void notifyListeners(DocumentEvent e) {
        for (DocumentListener listener : this._listeners) {
            DocumentEvent.EventType type = e.getType();
            if (type == DocumentEvent.EventType.CHANGE) {
                listener.changedUpdate(e);
                continue;
            }
            if (type == DocumentEvent.EventType.INSERT) {
                listener.insertUpdate(e);
                continue;
            }
            if (type != DocumentEvent.EventType.REMOVE) continue;
            listener.removeUpdate(e);
        }
    }

    private class FragmentElement
    implements Element {
        private RootElement _root;
        private int _startOffset;
        private int _endOffset;

        public FragmentElement(RootElement root, int startOffset, int endOffset) {
            this._root = root;
            this._startOffset = startOffset;
            this._endOffset = endOffset;
        }

        public void setStartOffset(int startOffset) {
            this._startOffset = startOffset;
        }

        public void setEndOffset(int endOffset) {
            this._endOffset = endOffset;
        }

        public Document getDocument() {
            return AppendOnlyStyledDocument.this;
        }

        public Element getParentElement() {
            return this._root;
        }

        public String getName() {
            return "fragment";
        }

        public AttributeSet getAttributes() {
            return NULLATTRS;
        }

        public int getStartOffset() {
            return this._startOffset;
        }

        public int getEndOffset() {
            return this._endOffset;
        }

        public int getElementIndex(int offset) {
            return -1;
        }

        public int getElementCount() {
            return 0;
        }

        public Element getElement(int index) {
            return null;
        }

        public boolean isLeaf() {
            return true;
        }
    }

    private class RootElement
    implements Element {
        private List<FragmentElement> _children = new ArrayList<FragmentElement>();

        public RootElement() {
            this._children.add(new FragmentElement(this, 0, 1));
        }

        public void insert(int offset, int strlen) {
            int childcount = this.getElementCount();
            int childind = this.getElementIndex(offset);
            FragmentElement child = this._children.get(childind);
            int elemStart = child.getStartOffset();
            int elemEnd = child.getEndOffset();
            if (elemEnd + 1 - elemStart + strlen <= 8192) {
                child.setEndOffset(elemEnd + strlen);
                AppendOnlyStyledDocument.this.notifyListeners(new MyDocumentEvent(offset, strlen, DocumentEvent.EventType.INSERT, null));
                ++childind;
            } else {
                int newstrlen = strlen;
                if (elemStart != offset) {
                    child.setEndOffset(offset - 1);
                    AppendOnlyStyledDocument.this.notifyListeners(new MyDocumentEvent(offset, elemEnd + 1 - offset, DocumentEvent.EventType.REMOVE, null));
                    newstrlen += elemEnd + 1 - offset;
                    ++childind;
                    elemStart = offset;
                }
                int insertStart = elemStart;
                int insertLen = newstrlen;
                final int insertInd = childind;
                final Element[] inserted = new Element[(newstrlen + 8192 - 1) / 8192];
                int curind = 0;
                while (newstrlen > 0) {
                    int fragsize = 8192;
                    if (newstrlen < fragsize) {
                        fragsize = newstrlen;
                    }
                    FragmentElement newelem = new FragmentElement(this, elemStart, elemStart + fragsize);
                    this._children.add(childind, newelem);
                    ++childind;
                    inserted[curind] = newelem;
                    ++curind;
                    elemStart += fragsize;
                }
                HashMap<Element, DocumentEvent.ElementChange> changes = new HashMap<Element, DocumentEvent.ElementChange>();
                changes.put(this, new DocumentEvent.ElementChange(){

                    public Element getElement() {
                        return RootElement.this;
                    }

                    public int getIndex() {
                        return insertInd;
                    }

                    public Element[] getChildrenRemoved() {
                        return null;
                    }

                    public Element[] getChildrenAdded() {
                        return inserted;
                    }
                });
                AppendOnlyStyledDocument.this.notifyListeners(new MyDocumentEvent(insertStart, insertStart + insertLen - 1, DocumentEvent.EventType.CHANGE, changes));
            }
            while (childind < childcount) {
                FragmentElement curchild = this._children.get(childind);
                curchild.setStartOffset(curchild.getStartOffset() + strlen);
                curchild.setEndOffset(curchild.getEndOffset() + strlen);
                ++childind;
            }
        }

        public Document getDocument() {
            return AppendOnlyStyledDocument.this;
        }

        public Element getParentElement() {
            return null;
        }

        public String getName() {
            return "root";
        }

        public AttributeSet getAttributes() {
            return NULLATTRS;
        }

        public int getStartOffset() {
            return 0;
        }

        public int getEndOffset() {
            return this._children.get(this._children.size() - 1).getEndOffset();
        }

        public int getElementIndex(int offset) {
            int n = this._children.size();
            for (int i = 0; i < n; ++i) {
                Element child = this._children.get(i);
                if (offset < child.getStartOffset() || offset > child.getEndOffset()) continue;
                return i;
            }
            return -1;
        }

        public int getElementCount() {
            return this._children.size();
        }

        public Element getElement(int index) {
            return this._children.get(index);
        }

        public boolean isLeaf() {
            return false;
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        private class MyDocumentEvent
        implements DocumentEvent {
            private final int _offset;
            private final int _length;
            private final DocumentEvent.EventType _type;
            private final Map<Element, DocumentEvent.ElementChange> _changes;

            public MyDocumentEvent(int offset, int length, DocumentEvent.EventType type, Map<Element, DocumentEvent.ElementChange> changes) {
                this._offset = offset;
                this._length = length;
                this._type = type;
                this._changes = changes;
            }

            @Override
            public int getOffset() {
                return this._offset;
            }

            @Override
            public int getLength() {
                return this._length;
            }

            @Override
            public Document getDocument() {
                return AppendOnlyStyledDocument.this;
            }

            @Override
            public DocumentEvent.EventType getType() {
                return this._type;
            }

            @Override
            public DocumentEvent.ElementChange getChange(Element elem) {
                if (this._changes.containsKey(elem)) {
                    return this._changes.get(elem);
                }
                return null;
            }
        }
    }
}

