/*
 * Decompiled with CFR 0.152.
 */
package org.nbirn.fbirn.utilities;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.nbirn.fbirn.utilities.ProgressListener;
import org.nbirn.fbirn.utilities.ProgressUpdater;

public class ProxyProgressUpdater
extends ProgressListener
implements ProgressUpdater {
    List<ProgressListener> _listeners = null;
    List<ProgressUpdater> _updaters = new ArrayList<ProgressUpdater>();
    List<String> _updaterIDs = new ArrayList<String>();
    String _ID = null;
    int _numUpdaters = 0;
    int _numStarted = 0;
    double[] _progressArray = new double[0];
    boolean[] _startedArray = new boolean[0];

    public ProxyProgressUpdater() {
        this(null);
    }

    public ProxyProgressUpdater(String ID) {
        this._ID = ID;
    }

    public void addUpdater(ProgressUpdater updater) {
        this.addUpdater(updater, null);
    }

    public void addUpdater(ProgressUpdater updater, String id) {
        this._updaters.add(updater);
        this._updaterIDs.add(id);
        ++this._numUpdaters;
        updater.addProgressListener(this);
        if (this._progressArray.length < this._numUpdaters) {
            this._progressArray = Arrays.copyOf(this._progressArray, this._updaters.size() * 2);
            this._startedArray = Arrays.copyOf(this._startedArray, this._updaters.size() * 2);
        }
        this._progressArray[this._numUpdaters - 1] = 0.0;
        this._startedArray[this._numUpdaters - 1] = false;
    }

    public void removeUpdater(ProgressUpdater updater) {
        int ind = this._updaters.indexOf(updater);
        if (ind == -1) {
            return;
        }
        if (ind + 1 < this._numUpdaters) {
            System.arraycopy(this._progressArray, ind + 1, this._progressArray, ind, this._numUpdaters - (ind + 1));
            System.arraycopy(this._startedArray, ind + 1, this._startedArray, ind, this._numUpdaters - (ind + 1));
        }
        updater.removeProgressListener(this);
        this._updaters.remove(ind);
        this._updaterIDs.remove(ind);
        --this._numUpdaters;
        if (this._numUpdaters > 0) {
            this.reportAggregateProgress(null);
        }
    }

    public void removeAllUpdaters() {
        this._updaters.clear();
        this._numUpdaters = 0;
        this._numStarted = 0;
    }

    public void addProgressListener(ProgressListener listener) {
        if (this._listeners == null) {
            this._listeners = new ArrayList<ProgressListener>();
        }
        this._listeners.add(listener);
    }

    public void removeProgressListener(ProgressListener listener) {
        if (this._listeners == null) {
            return;
        }
        this._listeners.remove(listener);
    }

    private String getIDPrefix(int ind) {
        String ID = this._updaterIDs.get(ind);
        ID = ID == null ? (this._numUpdaters > 1 ? "[" + (ind + 1) + "/" + this._numUpdaters + "] " : "") : "[" + ID + "] ";
        return ID;
    }

    private void reportAggregateProgress(String msg) {
        double sum = 0.0;
        for (double subProgress : this._progressArray) {
            sum += subProgress;
        }
        this.setProgress(sum / (double)this._numUpdaters, msg);
    }

    public void progressStart(ProgressUpdater updater, String msg) {
        int ind = this._updaters.indexOf(updater);
        if (ind == -1) {
            return;
        }
        if (msg != null) {
            msg = this.getIDPrefix(ind) + msg;
        }
        if (this._numStarted == 0) {
            this.setProgressStart(msg);
        } else {
            this.reportAggregateProgress(msg);
        }
        if (!this._startedArray[ind]) {
            this._startedArray[ind] = true;
            ++this._numStarted;
        }
    }

    public void progressUpdate(ProgressUpdater updater, double progress, String msg) {
        int ind = this._updaters.indexOf(updater);
        if (ind == -1) {
            return;
        }
        if (progress < 0.0) {
            progress = 0.0;
        } else if (progress > 1.0) {
            progress = 1.0;
        }
        this._progressArray[ind] = progress;
        if (msg != null) {
            msg = this.getIDPrefix(ind) + msg;
        }
        this.reportAggregateProgress(msg);
    }

    public void progressFinish(ProgressUpdater updater, String msg) {
        int ind = this._updaters.indexOf(updater);
        if (ind == -1) {
            return;
        }
        if (this._startedArray[ind]) {
            this._startedArray[ind] = false;
            --this._numStarted;
        }
        if (msg != null) {
            msg = this.getIDPrefix(ind) + msg;
        }
        if (this._numStarted == 0) {
            this.setProgressFinish(msg);
        } else {
            this.reportAggregateProgress(msg);
        }
        if (this._numStarted == 0 && this._ID != null) {
            this.setProgressFinish("[" + this._ID + "] Finished.");
        }
    }

    protected void setProgressStart(String msg) {
        if (this._listeners == null) {
            return;
        }
        for (ProgressListener listener : this._listeners) {
            listener.progressStart(this, msg);
        }
    }

    protected void setProgressFinish(String msg) {
        if (this._listeners == null) {
            return;
        }
        for (ProgressListener listener : this._listeners) {
            listener.progressFinish(this, msg);
        }
    }

    protected void setProgress(double progress, String msg) {
        if (this._listeners == null) {
            return;
        }
        for (ProgressListener listener : this._listeners) {
            listener.progressUpdate(this, progress, msg);
        }
    }
}

