/*
 * Decompiled with CFR 0.152.
 */
package org.nbirn.fbirn.utilities.download;

import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import java.util.TimeZone;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executors;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.SwingUtilities;
import javax.swing.SwingWorker;
import javax.swing.border.EmptyBorder;
import javax.swing.border.TitledBorder;
import org.nbirn.fbirn.utilities.CanceledException;
import org.nbirn.fbirn.utilities.CredentialManager;
import org.nbirn.fbirn.utilities.ExceptionCollection;
import org.nbirn.fbirn.utilities.ExceptionDialog;
import org.nbirn.fbirn.utilities.download.DownloadException;
import org.nbirn.fbirn.utilities.download.DownloaderCatalog;
import org.nbirn.fbirn.utilities.download.DownloaderCatalogEntry;
import org.nbirn.fbirn.utilities.download.DownloaderCatalogPanels;
import org.nbirn.fbirn.utilities.download.ProgressUpdate;
import org.nbirn.fbirn.utilities.download.WorkerDownload;
import org.nbirn.fbirn.utilities.download.WorkerProgressReporter;
import org.nbirn.fbirn.utilities.download.WorkerURLUpdater;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WorkerDownloadFromCatalog
extends WorkerDownload
implements PropertyChangeListener {
    private static final Logger _logger = Logger.getLogger(WorkerDownloadFromCatalog.class.getName());
    private static final Font NORMALFONT = new Font("Dialog", 0, 12);
    private DownloaderCatalog _catalog = null;
    private File _dest = null;
    private JPanel _topprogpanel = null;
    private TitledBorder _border = null;
    private CredentialManager _credman = null;
    private boolean _updateOnly = false;
    private WorkerProgressReporter _parentworker = null;
    private double _parentProgressAmount = -1.0;
    private double _lastprogress = -1.0;
    private double _curprogress = 0.0;
    private int _logPriority = 0;
    final ArrayList<WorkerProgressReporter> _tasks;
    final ArrayList<WorkerProgressReporter> _idletasks;

    public WorkerDownloadFromCatalog(DownloaderCatalog catalog, File dest, TitledBorder border, CredentialManager credman, boolean updateOnly, boolean dryRun, WorkerProgressReporter parentworker, double parentProgressAmount) {
        super(dryRun);
        this._catalog = catalog;
        this._dest = dest;
        this._border = border;
        this._credman = credman;
        this._updateOnly = updateOnly;
        this._curprogress = 0.0;
        this._parentworker = parentworker;
        this._parentProgressAmount = parentProgressAmount;
        this._tasks = new ArrayList();
        this._idletasks = new ArrayList();
    }

    public void setLoggingPriority(int priority) {
        this._logPriority = priority;
    }

    @Override
    protected void process(List<ProgressUpdate> chunks) {
        for (int i = 0; i < chunks.size(); ++i) {
            ProgressUpdate update = chunks.get(i);
            double incprog = update.getIncrementalProgress();
            _logger.log(Level.FINE, "WorkerDownloadFromCatalog: catalog ''{0}'' processing incremental progress {1} (current progress {2}) message=''{3}", new Object[]{this._catalog.getName(), incprog, this._curprogress, update.getMessage()});
            this._curprogress += incprog;
            if (update.getMessage() == null && update.getSubMessage() == null) continue;
            String msg = (this._catalog == null ? "" : this._catalog.getName()) + " | " + update.getMessage() + (update.getSubMessage() == null ? "" : " [" + update.getSubMessage() + "]");
            if (this._parentworker != null) {
                this._parentworker.sendUpdate(new ProgressUpdate(msg, null, 0.0, update.getPriority()));
                continue;
            }
            if (this._parentworker != null) continue;
            if (this._catalog.getParentPanel() == null && update.getPriority() > this._logPriority) {
                _logger.info(msg);
                continue;
            }
            _logger.log(Level.FINE, msg);
        }
        if (this._curprogress > 100.0) {
            this._curprogress = 100.0;
        }
        this.setProgress((int)Math.floor(this._curprogress + 0.5));
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        String propName = evt.getPropertyName();
        if ("state".equals(propName) && evt.getNewValue() == SwingWorker.StateValue.DONE) {
            Throwable result = null;
            try {
                this.get();
            }
            catch (InterruptedException e) {
                result = new CanceledException("Operation canceled.");
            }
            catch (ExecutionException e) {
                result = e.getCause();
            }
            catch (CancellationException e) {
                result = new CanceledException("Operation canceled.");
            }
            if (this._border != null && result != null) {
                String title = this._border.getTitle();
                int errind = title.indexOf(" (ERR: ");
                if (errind != -1) {
                    title = title.substring(0, errind);
                }
                title = title + " (ERR: " + result.getMessage() + ")";
                this._border.setTitle(title);
            }
        } else if (propName.equals("progress")) {
            int val = (Integer)evt.getNewValue();
            _logger.log(Level.FINE, "WorkerDownloadFromCatalog: catalog ''{0}'' got progress {1} (last progress {2})", new Object[]{this._catalog.getName(), val, this._lastprogress});
            if (this._lastprogress == -1.0 || (double)val - this._lastprogress != 0.0) {
                double parentincval = (this._lastprogress == -1.0 ? (double)val : (double)val - this._lastprogress) * (this._parentProgressAmount / 100.0);
                if (this._lastprogress == -1.0) {
                    _logger.log(Level.FINE, "WorkerDownloadFromCatalog:   reporting incremental progress of {0} * ( {1} / 100.0) = {2} to parent", new Object[]{val, this._parentProgressAmount, parentincval});
                } else {
                    _logger.log(Level.FINE, "WorkerDownloadFromCatalog:   reporting incremental progress of ({0} - {1}) * ( {2} / 100.0) = {3} to parent", new Object[]{val, this._lastprogress, this._parentProgressAmount, parentincval});
                }
                this._parentworker.sendUpdate(new ProgressUpdate(null, parentincval));
            }
            this._lastprogress = val;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void cancelTasks() {
        ArrayList<WorkerProgressReporter> arrayList = this._tasks;
        synchronized (arrayList) {
            _logger.log(Level.FINE, "Canceling {0} subtasks for catalog ''{1}''.", new Object[]{this._tasks.size(), this._catalog.getName()});
            for (int i = 0; i < this._tasks.size(); ++i) {
                this._tasks.get(i).cancel(true);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void doDownload(DownloaderCatalog catalog) throws InvocationTargetException, CanceledException, ExceptionCollection {
        int numentries = catalog.getNumEntries();
        int numcatalogs = catalog.getNumCatalogs();
        int downloadtype = catalog.getDownloadType();
        TimeZone remoteTimeZone = catalog.getTimeZone();
        int timeStampCheckDepth = catalog.getTimeStampCheckDepth();
        double subfrac = 0.0;
        if (numentries + numcatalogs <= 0) {
            this.setProgress(100);
            return;
        }
        ExceptionCollection result = new ExceptionCollection();
        try {
            block58: {
                try {
                    Object subcat;
                    int i;
                    JPanel basePanel;
                    JPanel hiddenPanel = catalog.getSubPanels() == null ? null : catalog.getSubPanels().getHiddenPanel();
                    JPanel jPanel = basePanel = catalog.getSubPanels() == null ? catalog.getParentPanel() : catalog.getSubPanels().getSubPanel();
                    if (basePanel != null) {
                        int i2;
                        for (i2 = 0; i2 < numentries; ++i2) {
                            DownloaderCatalogEntry entry = catalog.getEntry(i2);
                            AddEntryProgressBar invokee = new AddEntryProgressBar(basePanel, entry.getName(), i2);
                            SwingUtilities.invokeAndWait(invokee);
                            if (downloadtype != 2) {
                                invokee._progbar.setEnabled(false);
                            }
                            entry.setProgressBar(invokee._progbar);
                            entry.setMessageLabel(invokee._messageLabel);
                            entry.setSubMessageLabel(invokee._submessageLabel);
                            entry.setCancelButton(invokee._cancelButton);
                            entry.setRefreshButton(invokee._refreshButton);
                        }
                        for (i2 = 0; i2 < numcatalogs; ++i2) {
                            DownloaderCatalog subcat2 = catalog.getCatalog(i2);
                            subcat2.setSubPanels(new DownloaderCatalogPanels(basePanel, subcat2.getName()));
                        }
                        ((JFrame)basePanel.getTopLevelAncestor()).pack();
                    }
                    if (hiddenPanel != null) {
                        hiddenPanel.removeAll();
                        hiddenPanel.add(new HiddenPanelLabel("In progress..."));
                    }
                    double progressChunk = 100.0 / (double)(numentries + numcatalogs);
                    for (i = 0; i < numentries; ++i) {
                        int tscd;
                        DownloaderCatalogEntry entry = catalog.getEntry(i);
                        TimeZone tz = entry.getTimeZone();
                        if (remoteTimeZone != null && tz == null) {
                            tz = remoteTimeZone;
                        }
                        if ((tscd = entry.getTimeStampCheckDepth()) == -1 && timeStampCheckDepth != -1) {
                            tscd = timeStampCheckDepth;
                        }
                        WorkerURLUpdater worker = new WorkerURLUpdater(entry, this._dest, this._credman, this._updateOnly, this._dryrun, tz, tscd, this, 1.0 * progressChunk);
                        ArrayList<WorkerProgressReporter> arrayList = this._tasks;
                        synchronized (arrayList) {
                            this._tasks.add(worker);
                        }
                        Executors.newCachedThreadPool().execute(worker);
                        if (catalog.getDownloadType() != 2) {
                            _logger.log(Level.FINE, "Doing serial download of entry {0}", entry.getURI().toString());
                            try {
                                worker.get();
                                this.publish(new ProgressUpdate(null, 0.0 * progressChunk));
                                continue;
                            }
                            catch (ExecutionException e) {
                                Throwable ret = e.getCause();
                                if (ret == null || ret.getClass() != CanceledException.class) continue;
                                if (hiddenPanel == null) throw (CanceledException)ret;
                                hiddenPanel.removeAll();
                                hiddenPanel.add(new HiddenPanelLabel("Canceled."));
                                throw (CanceledException)ret;
                            }
                        }
                        _logger.log(Level.FINE, "Doing parallel download of entry {0}", entry.getURI().toString());
                    }
                    for (i = 0; i < numcatalogs; ++i) {
                        subcat = catalog.getCatalog(i);
                        if (remoteTimeZone != null && subcat.getTimeZone() == null) {
                            subcat.setTimeZone(remoteTimeZone);
                        }
                        if (timeStampCheckDepth != -1 && subcat.getTimeStampCheckDepth() == -1) {
                            subcat.setTimeStampCheckDepth(timeStampCheckDepth);
                        }
                        WorkerDownloadFromCatalog worker = new WorkerDownloadFromCatalog((DownloaderCatalog)subcat, this._dest, ((DownloaderCatalog)subcat).getBorder(), this._credman, this._updateOnly, this._dryrun, this, 1.0 * progressChunk);
                        worker.addPropertyChangeListener(worker);
                        ArrayList<WorkerProgressReporter> tscd = this._tasks;
                        synchronized (tscd) {
                            this._tasks.add(worker);
                        }
                        Executors.newCachedThreadPool().execute(worker);
                        if (catalog.getDownloadType() != 2) {
                            _logger.log(Level.FINE, "Doing serial download of catalog {0}", subcat.getName());
                            try {
                                worker.get();
                                this.publish(new ProgressUpdate(null, 0.0 * progressChunk));
                                continue;
                            }
                            catch (ExecutionException e) {
                                Throwable ret = e.getCause();
                                if (ret == null || ret.getClass() != CanceledException.class) continue;
                                if (hiddenPanel == null) throw (CanceledException)ret;
                                hiddenPanel.removeAll();
                                hiddenPanel.add(new HiddenPanelLabel("Canceled."));
                                throw (CanceledException)ret;
                            }
                        }
                        _logger.log(Level.FINE, "Doing parallel download of catalog {0}", subcat.getName());
                    }
                    int numerrs = 0;
                    _logger.log(Level.FINE, "Catalog ''{0}'' waiting for {1} subtasks to complete.", new Object[]{this._catalog.getName(), this._tasks.size()});
                    while (true) {
                        if (this.isCancelled()) {
                            if (hiddenPanel == null) throw new InterruptedException("Catalog '" + this._catalog.getName() + "' was canceled.  Throwing interrupt...");
                            hiddenPanel.removeAll();
                            hiddenPanel.add(new HiddenPanelLabel("Canceled."));
                            throw new InterruptedException("Catalog '" + this._catalog.getName() + "' was canceled.  Throwing interrupt...");
                        }
                        subcat = this._tasks;
                        synchronized (subcat) {
                            for (int i3 = 0; i3 < this._tasks.size(); ++i3) {
                                Throwable subresult;
                                block57: {
                                    WorkerProgressReporter subworker = this._tasks.get(i3);
                                    if (!subworker.isDone()) continue;
                                    _logger.log(Level.FINE, "Catalog ''{0}'' removing completed task {1} ({2} tasks remaining)", new Object[]{this._catalog.getName(), i3, this._tasks.size() - 1});
                                    this._tasks.remove(i3);
                                    --i3;
                                    subresult = null;
                                    try {
                                        subworker.get();
                                        if (catalog.getDownloadType() == 2) {
                                            this.publish(new ProgressUpdate(null, 0.0 * progressChunk));
                                        }
                                    }
                                    catch (CancellationException e) {
                                        subresult = e;
                                    }
                                    catch (ExecutionException e) {
                                        subresult = e.getCause();
                                        if (subresult == null || subresult.getClass() != CanceledException.class) break block57;
                                        if (hiddenPanel == null) throw (CanceledException)subresult;
                                        hiddenPanel.removeAll();
                                        hiddenPanel.add(new HiddenPanelLabel("Canceled."));
                                        throw (CanceledException)subresult;
                                    }
                                }
                                _logger.log(Level.FINE, "Task {0} return value is {1}", new Object[]{i3 + 1, subresult});
                                if (subresult == null) continue;
                                if (subresult.getClass() == DownloadException.class && subresult.getCause() != null && subresult.getCause().getClass() == ExceptionCollection.class) {
                                    ArrayList<Throwable> errlist = ((ExceptionCollection)subresult.getCause()).getList();
                                    for (int errind = 0; errind < errlist.size(); ++errind) {
                                        result.add(errlist.get(errind));
                                    }
                                } else {
                                    result.add(subresult);
                                }
                                ++numerrs;
                                if (hiddenPanel == null) continue;
                                hiddenPanel.removeAll();
                                hiddenPanel.add(new HiddenPanelLabel("In progress... (" + numerrs + " errors)"));
                            }
                            if (this._tasks.isEmpty()) {
                                // MONITOREXIT @DISABLED, blocks:[0, 1, 56, 12, 30] lbl153 : MonitorExitStatement: MONITOREXIT : subcat
                                if (hiddenPanel != null) {
                                    break;
                                }
                                break block58;
                            }
                        }
                        try {
                            Thread.sleep(250L);
                        }
                        catch (InterruptedException e) {}
                    }
                    hiddenPanel.removeAll();
                    hiddenPanel.add(new HiddenPanelLabel("Completed " + (numerrs == 0 ? "without" : "with " + numerrs) + " errors."));
                    catalog.getSubPanels().hide();
                }
                catch (InterruptedException e) {
                    _logger.log(Level.FINE, "Catalog ''{0}'' got interrupted.", this._catalog.getName());
                    this.cancelTasks();
                    throw new CanceledException("Operation canceled.", e);
                }
                catch (CanceledException e) {
                    if (this._parentworker == null) {
                        _logger.log(Level.FINE, "Catalog ''{0}'' got a CanceledException.", this._catalog.getName());
                        this.cancelTasks();
                        throw e;
                    }
                    _logger.log(Level.FINE, "Catalog ''{0}'' got a CanceledException.  Passing it up to parent.", this._catalog.getName());
                    throw e;
                }
            }
            Object var24_35 = null;
        }
        catch (Throwable throwable) {
            Object var24_36 = null;
            while (true) {
                ArrayList<WorkerProgressReporter> arrayList = this._tasks;
                synchronized (arrayList) {
                    for (int i = 0; i < this._tasks.size(); ++i) {
                        WorkerProgressReporter subworker = this._tasks.get(i);
                        if (!subworker.isDone()) continue;
                        _logger.log(Level.FINE, "(Dying) Catalog ''{0}'' removing completed task {1} out of {2}", new Object[]{this._catalog.getName(), i, this._tasks.size()});
                        subworker.cleanup(false);
                        this._tasks.remove(i);
                        --i;
                    }
                    if (this._tasks.isEmpty()) {
                        // MONITOREXIT @DISABLED, blocks:[33, 39, 24, 11] lbl197 : MonitorExitStatement: MONITOREXIT : var25_38
                        _logger.log(Level.FINE, "All tasks for catalog ''{0}'' completed.", this._catalog.getName());
                        this.cleanup(false);
                        throw throwable;
                    }
                }
                try {
                    Thread.sleep(250L);
                }
                catch (InterruptedException e) {}
            }
        }
        while (true) {
            ArrayList<WorkerProgressReporter> arrayList = this._tasks;
            synchronized (arrayList) {
                for (int i = 0; i < this._tasks.size(); ++i) {
                    WorkerProgressReporter subworker = this._tasks.get(i);
                    if (!subworker.isDone()) continue;
                    _logger.log(Level.FINE, "(Dying) Catalog ''{0}'' removing completed task {1} out of {2}", new Object[]{this._catalog.getName(), i, this._tasks.size()});
                    subworker.cleanup(false);
                    this._tasks.remove(i);
                    --i;
                }
                if (this._tasks.isEmpty()) {
                    break;
                }
            }
            try {}
            catch (InterruptedException e) {}
            Thread.sleep(250L);
        }
        _logger.log(Level.FINE, "All tasks for catalog ''{0}'' completed.", this._catalog.getName());
        this.cleanup(false);
        if (!result.getList().isEmpty()) {
            _logger.log(Level.FINE, "doDownload() returning {0}", result);
            throw result;
        }
        _logger.log(Level.FINE, "doDownload() returning null");
    }

    @Override
    protected Void doInBackground() throws CanceledException, DownloadException {
        this.setProgress(0);
        try {
            this.doDownload(this._catalog);
        }
        catch (CanceledException e) {
            throw e;
        }
        catch (ExceptionCollection e) {
            throw new DownloadException("Error in download", e);
        }
        catch (Exception e) {
            throw new DownloadException("Error in download", e);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void cleanup(boolean error) {
        int i;
        ArrayList<WorkerProgressReporter> arrayList = this._tasks;
        synchronized (arrayList) {
            if (this._tasks != null) {
                for (i = 0; i < this._tasks.size(); ++i) {
                    this._tasks.get(i).cleanup(error);
                }
            }
        }
        arrayList = this._idletasks;
        synchronized (arrayList) {
            if (this._idletasks != null) {
                for (i = 0; i < this._idletasks.size(); ++i) {
                    this._idletasks.get(i).cleanup(error);
                }
            }
        }
    }

    @Override
    public void done() {
        block5: {
            if (this._parentworker != null) {
                return;
            }
            try {
                this.get();
            }
            catch (Exception e) {
                _logger.log(Level.FINE, "Download resulted in Exception ''{0}'': {1}", new Object[]{e.getClass().getCanonicalName(), e.getMessage()});
                if (this._catalog.getParentPanel() == null) break block5;
                if (e.getClass() == ExecutionException.class && e.getCause() != null && e.getCause().getClass() == DownloadException.class && e.getCause().getCause() != null && e.getCause().getCause().getClass() == ExceptionCollection.class) {
                    ExceptionCollection ec = (ExceptionCollection)e.getCause().getCause();
                    ArrayList<Throwable> errlist = ec.getList();
                    JTabbedPane tp = new JTabbedPane();
                    for (int i = 0; i < errlist.size(); ++i) {
                        _logger.log(Level.SEVERE, ExceptionDialog.getStackTraceAsString(errlist.get(i)));
                        JScrollPane pane = ExceptionDialog.getScrollPane(errlist.get(i));
                        tp.addTab("Error " + i, pane);
                    }
                    JOptionPane.showMessageDialog(this._catalog.getParentPanel(), tp);
                }
                if (e.getClass() == CancellationException.class || e.getClass() == ExecutionException.class && e.getCause() != null && e.getCause().getClass() == CanceledException.class) break block5;
                ExceptionDialog.show(this._catalog.getParentPanel(), new DownloadException("Error getting result of download", e));
            }
        }
        this.cleanup(false);
    }

    private class HiddenPanelLabel
    extends JLabel {
        public HiddenPanelLabel(String text) {
            super(text);
            super.setFont(NORMALFONT);
        }
    }

    private class AddEntryProgressBar
    implements Runnable {
        JPanel _parentpanel = null;
        String _title = null;
        JProgressBar _progbar = null;
        JLabel _messageLabel = null;
        JLabel _submessageLabel = null;
        JButton _cancelButton = null;
        JButton _refreshButton = null;
        int _rownum;

        AddEntryProgressBar(JPanel parentpanel, String title, int rownum) {
            this._parentpanel = parentpanel;
            this._title = title;
            this._rownum = rownum;
        }

        public void run() {
            GridBagConstraints constraints = new GridBagConstraints();
            JPanel panel = new JPanel(new GridBagLayout());
            constraints.gridx = 0;
            constraints.gridy = this._rownum;
            constraints.weightx = 1.0;
            constraints.fill = 2;
            panel.setBorder(new EmptyBorder(this._rownum == 0 ? 0 : 8, 0, 0, 0));
            this._parentpanel.add((Component)panel, constraints);
            constraints = new GridBagConstraints();
            JLabel label = new JLabel(this._title == null ? "" : this._title);
            constraints.gridx = 0;
            constraints.gridy = 0;
            constraints.anchor = 17;
            panel.add((Component)label, constraints);
            this._progbar = new JProgressBar();
            this._progbar.setBorder(new EmptyBorder(0, 10, 0, 0));
            constraints.gridx = 1;
            constraints.gridy = 0;
            constraints.fill = 2;
            constraints.weightx = 1.0;
            panel.add((Component)this._progbar, constraints);
            this._messageLabel = new JLabel(" ");
            constraints.gridx = 0;
            constraints.gridy = 1;
            constraints.gridwidth = 2;
            constraints.fill = 2;
            constraints.weightx = 1.0;
            this._messageLabel.setFont(new Font("Dialog", 0, 9));
            panel.add((Component)this._messageLabel, constraints);
            this._submessageLabel = new JLabel(" ");
            constraints.gridx = 1;
            constraints.gridy = 2;
            constraints.gridwidth = 1;
            constraints.fill = 2;
            constraints.weightx = 1.0;
            this._submessageLabel.setFont(new Font("Dialog", 0, 9));
            panel.add((Component)this._submessageLabel, constraints);
            this._progbar.setStringPainted(true);
            this._progbar.setIndeterminate(true);
            constraints = new GridBagConstraints();
            JPanel buttonpanel = new JPanel(new GridBagLayout());
            constraints.gridx = 1;
            constraints.gridy = this._rownum;
            buttonpanel.setBorder(new EmptyBorder(this._rownum == 0 ? 0 : 8, 0, 0, 0));
            this._parentpanel.add((Component)buttonpanel, constraints);
            constraints = new GridBagConstraints();
            this._cancelButton = new JButton();
            this._cancelButton.setIcon(new ImageIcon(this.getClass().getResource("/org/nbirn/fbirndownloader/resources/cancel.png")));
            this._cancelButton.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
            constraints.gridx = 0;
            constraints.gridy = 0;
            buttonpanel.add((Component)this._cancelButton, constraints);
            this._refreshButton = new JButton();
            this._refreshButton.setIcon(new ImageIcon(this.getClass().getResource("/org/nbirn/fbirndownloader/resources/refresh.png")));
            this._refreshButton.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
            constraints.gridx = 0;
            constraints.gridy = 1;
            buttonpanel.add((Component)this._refreshButton, constraints);
        }
    }
}

