/*
 * Decompiled with CFR 0.152.
 */
package org.birncommunity.sample.myproxy;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.birncommunity.sample.proxy.LocalCredentialHelper;
import org.globus.myproxy.MyProxy;
import org.globus.myproxy.MyProxyException;
import org.ietf.jgss.GSSCredential;

public class MyProxyHelper {
    private static Log log = LogFactory.getLog(MyProxyHelper.class);

    public static void main(String[] args) throws Exception {
        MyProxyHelper getCred = new MyProxyHelper();
        if (args.length != 4 || args[0].equals("-h") || args[0].equals("--help")) {
            log.error((Object)("Usage: java " + MyProxyHelper.class.getName() + " <host> <port> <username> <password>"));
            log.error((Object)"host: MyProxy server host");
            log.error((Object)"port: MyProxy server port");
            log.error((Object)"username: Name of the MyProxy user");
            log.error((Object)"password: MyProxy password of the specified user");
            System.exit(1);
        }
        String host = args[0];
        int port = new Integer(args[1]);
        String user = args[2];
        String pass = args[3];
        GSSCredential credential = getCred.getCredential(host, port, user, pass);
        new LocalCredentialHelper().saveDefaultCredential(credential);
    }

    public GSSCredential getCredential(String host, int port, String user, String pass) throws MyProxyException {
        return new MyProxy(host, port).get(user, pass, 0);
    }
}

