/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.jce.provider;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.math.BigInteger;
import java.security.GeneralSecurityException;
import java.security.InvalidAlgorithmParameterException;
import java.security.PublicKey;
import java.security.cert.CRLException;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateExpiredException;
import java.security.cert.CertificateNotYetValidException;
import java.security.cert.X509CRL;
import java.security.cert.X509CRLEntry;
import java.security.cert.X509Certificate;
import java.security.cert.X509Extension;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.bouncycastle.asn1.ASN1InputStream;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.ASN1OutputStream;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.ASN1TaggedObject;
import org.bouncycastle.asn1.DEREncodable;
import org.bouncycastle.asn1.DEREnumerated;
import org.bouncycastle.asn1.DERIA5String;
import org.bouncycastle.asn1.DERInteger;
import org.bouncycastle.asn1.DERObject;
import org.bouncycastle.asn1.DERObjectIdentifier;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.asn1.x509.BasicConstraints;
import org.bouncycastle.asn1.x509.GeneralName;
import org.bouncycastle.asn1.x509.GeneralSubtree;
import org.bouncycastle.asn1.x509.IssuingDistributionPoint;
import org.bouncycastle.asn1.x509.NameConstraints;
import org.bouncycastle.asn1.x509.PolicyInformation;
import org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import org.bouncycastle.asn1.x509.X509Extensions;
import org.bouncycastle.jce.PrincipalUtil;
import org.bouncycastle.jce.X509Principal;
import org.bouncycastle.jce.cert.CertPath;
import org.bouncycastle.jce.cert.CertPathParameters;
import org.bouncycastle.jce.cert.CertPathValidatorException;
import org.bouncycastle.jce.cert.CertPathValidatorResult;
import org.bouncycastle.jce.cert.CertPathValidatorSpi;
import org.bouncycastle.jce.cert.CertStore;
import org.bouncycastle.jce.cert.CertStoreException;
import org.bouncycastle.jce.cert.PKIXCertPathChecker;
import org.bouncycastle.jce.cert.PKIXCertPathValidatorResult;
import org.bouncycastle.jce.cert.PKIXParameters;
import org.bouncycastle.jce.cert.PolicyNode;
import org.bouncycastle.jce.cert.PolicyQualifierInfo;
import org.bouncycastle.jce.cert.TrustAnchor;
import org.bouncycastle.jce.cert.X509CRLSelector;
import org.bouncycastle.jce.cert.X509CertSelector;
import org.bouncycastle.jce.provider.PKIXPolicyNode;

public class PKIXCertPathValidatorSpi
extends CertPathValidatorSpi {
    private static final String CERTIFICATE_POLICIES = X509Extensions.CertificatePolicies.getId();
    private static final String POLICY_MAPPINGS = X509Extensions.PolicyMappings.getId();
    private static final String INHIBIT_ANY_POLICY = X509Extensions.InhibitAnyPolicy.getId();
    private static final String ISSUING_DISTRIBUTION_POINT = X509Extensions.IssuingDistributionPoint.getId();
    private static final String DELTA_CRL_INDICATOR = X509Extensions.DeltaCRLIndicator.getId();
    private static final String POLICY_CONSTRAINTS = X509Extensions.PolicyConstraints.getId();
    private static final String BASIC_CONSTRAINTS = X509Extensions.BasicConstraints.getId();
    private static final String SUBJECT_ALTERNATIVE_NAME = X509Extensions.SubjectAlternativeName.getId();
    private static final String NAME_CONSTRAINTS = X509Extensions.NameConstraints.getId();
    private static final String KEY_USAGE = X509Extensions.KeyUsage.getId();
    private static final String CRL_NUMBER = X509Extensions.CRLNumber.getId();
    private static final String ANY_POLICY = "2.5.29.32.0";
    private static final int KEY_CERT_SIGN = 5;
    private static final int CRL_SIGN = 6;
    private static final String[] crlReasons = new String[]{"unspecified", "keyCompromise", "cACompromise", "affiliationChanged", "superseded", "cessationOfOperation", "certificateHold", "unknown", "removeFromCRL", "privilegeWithdrawn", "aACompromise"};

    private DERObject getExtensionValue(X509Extension x509Extension, String string) throws CertPathValidatorException {
        byte[] byArray = x509Extension.getExtensionValue(string);
        if (byArray == null) {
            return null;
        }
        return this.getObject(string, byArray);
    }

    private DERObject getObject(String string, byte[] byArray) throws CertPathValidatorException {
        try {
            ASN1InputStream aSN1InputStream = new ASN1InputStream(byArray);
            ASN1OctetString aSN1OctetString = (ASN1OctetString)aSN1InputStream.readObject();
            aSN1InputStream = new ASN1InputStream(aSN1OctetString.getOctets());
            return aSN1InputStream.readObject();
        }
        catch (IOException iOException) {
            throw new CertPathValidatorException("exception processing extension " + string);
        }
    }

    private boolean withinDNSubtree(ASN1Sequence aSN1Sequence, ASN1Sequence aSN1Sequence2) {
        if (aSN1Sequence2.size() < 1) {
            return false;
        }
        if (aSN1Sequence2.size() > aSN1Sequence.size()) {
            return false;
        }
        int n = aSN1Sequence2.size() - 1;
        while (n >= 0) {
            if (!aSN1Sequence2.getObjectAt(n).equals(aSN1Sequence.getObjectAt(n))) {
                return false;
            }
            --n;
        }
        return true;
    }

    private void checkPermittedDN(Set set, ASN1Sequence aSN1Sequence) throws CertPathValidatorException {
        if (set.isEmpty()) {
            return;
        }
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            ASN1Sequence aSN1Sequence2 = (ASN1Sequence)iterator.next();
            if (!this.withinDNSubtree(aSN1Sequence, aSN1Sequence2)) continue;
            return;
        }
        throw new CertPathValidatorException("Subject distinguished name is not from a permitted subtree");
    }

    private void checkExcludedDN(Set set, ASN1Sequence aSN1Sequence) throws CertPathValidatorException {
        if (set.isEmpty()) {
            return;
        }
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            ASN1Sequence aSN1Sequence2 = (ASN1Sequence)iterator.next();
            if (!this.withinDNSubtree(aSN1Sequence, aSN1Sequence2)) continue;
            throw new CertPathValidatorException("Subject distinguished name is from an excluded subtree");
        }
    }

    private Set intersectDN(Set set, ASN1Sequence aSN1Sequence) {
        if (set.isEmpty()) {
            set.add(aSN1Sequence);
            return set;
        }
        HashSet<ASN1Sequence> hashSet = new HashSet<ASN1Sequence>();
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            ASN1Sequence aSN1Sequence2 = (ASN1Sequence)iterator.next();
            if (this.withinDNSubtree(aSN1Sequence, aSN1Sequence2)) {
                hashSet.add(aSN1Sequence);
                continue;
            }
            if (!this.withinDNSubtree(aSN1Sequence2, aSN1Sequence)) continue;
            hashSet.add(aSN1Sequence2);
        }
        return hashSet;
    }

    private Set unionDN(Set set, ASN1Sequence aSN1Sequence) {
        if (set.isEmpty()) {
            set.add(aSN1Sequence);
            return set;
        }
        HashSet<ASN1Sequence> hashSet = new HashSet<ASN1Sequence>();
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            ASN1Sequence aSN1Sequence2 = (ASN1Sequence)iterator.next();
            if (this.withinDNSubtree(aSN1Sequence, aSN1Sequence2)) {
                hashSet.add(aSN1Sequence2);
                continue;
            }
            if (this.withinDNSubtree(aSN1Sequence2, aSN1Sequence)) {
                hashSet.add(aSN1Sequence);
                continue;
            }
            hashSet.add(aSN1Sequence2);
            hashSet.add(aSN1Sequence);
        }
        return hashSet;
    }

    private Set intersectEmail(Set set, String string) {
        String string2 = string.substring(string.indexOf(64) + 1);
        if (set.isEmpty()) {
            set.add(string2);
            return set;
        }
        HashSet<String> hashSet = new HashSet<String>();
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            String string3 = (String)iterator.next();
            if (string2.endsWith(string3)) {
                hashSet.add(string2);
                continue;
            }
            if (!string3.endsWith(string2)) continue;
            hashSet.add(string3);
        }
        return hashSet;
    }

    private Set unionEmail(Set set, String string) {
        String string2 = string.substring(string.indexOf(64) + 1);
        if (set.isEmpty()) {
            set.add(string2);
            return set;
        }
        HashSet<String> hashSet = new HashSet<String>();
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            String string3 = (String)iterator.next();
            if (string2.endsWith(string3)) {
                hashSet.add(string3);
                continue;
            }
            if (string3.endsWith(string2)) {
                hashSet.add(string2);
                continue;
            }
            hashSet.add(string3);
            hashSet.add(string2);
        }
        return hashSet;
    }

    private Set intersectIP(Set set, byte[] byArray) {
        return set;
    }

    private Set unionIP(Set set, byte[] byArray) {
        return set;
    }

    private void checkPermittedEmail(Set set, String string) throws CertPathValidatorException {
        if (set.isEmpty()) {
            return;
        }
        String string2 = string.substring(string.indexOf(64) + 1);
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            String string3 = (String)iterator.next();
            if (!string2.endsWith(string3)) continue;
            return;
        }
        throw new CertPathValidatorException("Subject email address is not from a permitted subtree");
    }

    private void checkExcludedEmail(Set set, String string) throws CertPathValidatorException {
        if (set.isEmpty()) {
            return;
        }
        String string2 = string.substring(string.indexOf(64) + 1);
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            String string3 = (String)iterator.next();
            if (!string2.endsWith(string3)) continue;
            throw new CertPathValidatorException("Subject email address is from an excluded subtree");
        }
    }

    private void checkPermittedIP(Set set, byte[] byArray) throws CertPathValidatorException {
        if (set.isEmpty()) {
            return;
        }
    }

    private void checkExcludedIP(Set set, byte[] byArray) throws CertPathValidatorException {
        if (set.isEmpty()) {
            return;
        }
    }

    private PKIXPolicyNode removePolicyNode(PKIXPolicyNode pKIXPolicyNode, List[] listArray, PKIXPolicyNode pKIXPolicyNode2) {
        PKIXPolicyNode pKIXPolicyNode3 = (PKIXPolicyNode)pKIXPolicyNode2.getParent();
        if (pKIXPolicyNode == null) {
            return null;
        }
        if (pKIXPolicyNode3 == null) {
            int n = 0;
            while (n < listArray.length) {
                listArray[n] = new ArrayList();
                ++n;
            }
            return null;
        }
        pKIXPolicyNode3.removeChild(pKIXPolicyNode2);
        this.removePolicyNodeRecurse(listArray, pKIXPolicyNode2);
        return pKIXPolicyNode;
    }

    private void removePolicyNodeRecurse(List[] listArray, PKIXPolicyNode pKIXPolicyNode) {
        listArray[pKIXPolicyNode.getDepth()].remove(pKIXPolicyNode);
        if (pKIXPolicyNode.hasChildren()) {
            Iterator iterator = pKIXPolicyNode.getChildren();
            while (iterator.hasNext()) {
                PKIXPolicyNode pKIXPolicyNode2 = (PKIXPolicyNode)iterator.next();
                this.removePolicyNodeRecurse(listArray, pKIXPolicyNode2);
            }
        }
    }

    private boolean isSelfIssued(X509Certificate x509Certificate) {
        return x509Certificate.getSubjectDN().equals(x509Certificate.getIssuerDN());
    }

    private boolean isAnyPolicy(Set set) {
        return set == null || set.contains(ANY_POLICY) || set.isEmpty();
    }

    private AlgorithmIdentifier getAlgorithmIdentifier(PublicKey publicKey) throws CertPathValidatorException {
        try {
            ASN1InputStream aSN1InputStream = new ASN1InputStream(new ByteArrayInputStream(publicKey.getEncoded()));
            SubjectPublicKeyInfo subjectPublicKeyInfo = SubjectPublicKeyInfo.getInstance(aSN1InputStream.readObject());
            return subjectPublicKeyInfo.getAlgorithmId();
        }
        catch (IOException iOException) {
            throw new CertPathValidatorException("exception processing public key");
        }
    }

    private final Set getQualifierSet(ASN1Sequence aSN1Sequence) throws CertPathValidatorException {
        HashSet<PolicyQualifierInfo> hashSet = new HashSet<PolicyQualifierInfo>();
        if (aSN1Sequence == null) {
            return hashSet;
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        ASN1OutputStream aSN1OutputStream = new ASN1OutputStream(byteArrayOutputStream);
        Enumeration enumeration = aSN1Sequence.getObjects();
        while (enumeration.hasMoreElements()) {
            try {
                aSN1OutputStream.writeObject(enumeration.nextElement());
                hashSet.add(new PolicyQualifierInfo(byteArrayOutputStream.toByteArray()));
            }
            catch (IOException iOException) {
                throw new CertPathValidatorException("exception building qualifier set: " + iOException);
            }
            byteArrayOutputStream.reset();
        }
        return hashSet;
    }

    private boolean processCertD1i(int n, List[] listArray, DERObjectIdentifier dERObjectIdentifier, Set set) {
        List list = listArray[n - 1];
        int n2 = 0;
        while (n2 < list.size()) {
            PKIXPolicyNode pKIXPolicyNode = (PKIXPolicyNode)list.get(n2);
            Set set2 = pKIXPolicyNode.getExpectedPolicies();
            if (set2.contains(dERObjectIdentifier.getId())) {
                HashSet<String> hashSet = new HashSet<String>();
                hashSet.add(dERObjectIdentifier.getId());
                PKIXPolicyNode pKIXPolicyNode2 = new PKIXPolicyNode(new ArrayList(), n, hashSet, pKIXPolicyNode, set, dERObjectIdentifier.getId(), false);
                pKIXPolicyNode.addChild(pKIXPolicyNode2);
                listArray[n].add(pKIXPolicyNode2);
                return true;
            }
            ++n2;
        }
        return false;
    }

    private void processCertD1ii(int n, List[] listArray, DERObjectIdentifier dERObjectIdentifier, Set set) {
        List list = listArray[n - 1];
        int n2 = 0;
        while (n2 < list.size()) {
            PKIXPolicyNode pKIXPolicyNode = (PKIXPolicyNode)list.get(n2);
            Set set2 = pKIXPolicyNode.getExpectedPolicies();
            if (ANY_POLICY.equals(pKIXPolicyNode.getValidPolicy())) {
                HashSet<String> hashSet = new HashSet<String>();
                hashSet.add(dERObjectIdentifier.getId());
                PKIXPolicyNode pKIXPolicyNode2 = new PKIXPolicyNode(new ArrayList(), n, hashSet, pKIXPolicyNode, set, dERObjectIdentifier.getId(), false);
                pKIXPolicyNode.addChild(pKIXPolicyNode2);
                listArray[n].add(pKIXPolicyNode2);
                return;
            }
            ++n2;
        }
    }

    public CertPathValidatorResult engineValidate(CertPath certPath, CertPathParameters certPathParameters) throws CertPathValidatorException, InvalidAlgorithmParameterException {
        Iterator iterator;
        int n;
        Object object;
        Object object2;
        Object object3;
        Object object4;
        Object object5;
        PublicKey publicKey;
        X509Principal x509Principal;
        if (!(certPathParameters instanceof PKIXParameters)) {
            throw new InvalidAlgorithmParameterException("params must be a PKIXParameters instance");
        }
        PKIXParameters pKIXParameters = (PKIXParameters)certPathParameters;
        if (pKIXParameters.getTrustAnchors() == null) {
            throw new InvalidAlgorithmParameterException("trustAnchors is null, this is not allowed for path validation");
        }
        List list = certPath.getCertificates();
        int n2 = list.size();
        if (list.isEmpty()) {
            throw new CertPathValidatorException("CertPath is empty", null, certPath, 0);
        }
        Date date = pKIXParameters.getDate();
        if (date == null) {
            date = new Date();
        }
        Set set = pKIXParameters.getInitialPolicies();
        TrustAnchor trustAnchor = this.findTrustAnchor((X509Certificate)list.get(list.size() - 1), certPath, list.size() - 1, pKIXParameters.getTrustAnchors());
        if (trustAnchor == null) {
            throw new CertPathValidatorException("TrustAnchor for CertPath not found.", null, certPath, -1);
        }
        int n3 = 0;
        HashSet hashSet = new HashSet();
        HashSet hashSet2 = new HashSet();
        List[] listArray = new ArrayList[n2 + 1];
        int n4 = 0;
        while (n4 < listArray.length) {
            listArray[n4] = new ArrayList();
            ++n4;
        }
        HashSet<String> hashSet3 = new HashSet<String>();
        hashSet3.add(ANY_POLICY);
        PKIXPolicyNode pKIXPolicyNode = new PKIXPolicyNode(new ArrayList(), 0, hashSet3, null, new HashSet(), ANY_POLICY, false);
        listArray[0].add(pKIXPolicyNode);
        Set set2 = new HashSet();
        Set set3 = new HashSet();
        Set set4 = new HashSet();
        Set set5 = new HashSet();
        Set set6 = new HashSet();
        Set set7 = new HashSet();
        HashSet hashSet4 = null;
        int n5 = pKIXParameters.isExplicitPolicyRequired() ? 0 : n2 + 1;
        int n6 = pKIXParameters.isAnyPolicyInhibited() ? 0 : n2 + 1;
        int n7 = pKIXParameters.isPolicyMappingInhibited() ? 0 : n2 + 1;
        X509Certificate x509Certificate = trustAnchor.getTrustedCert();
        try {
            if (x509Certificate != null) {
                x509Principal = this.getSubjectPrincipal(x509Certificate);
                publicKey = x509Certificate.getPublicKey();
            } else {
                x509Principal = new X509Principal(trustAnchor.getCAName());
                publicKey = trustAnchor.getCAPublicKey();
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new CertPathValidatorException("TrustAnchor subjectDN: " + illegalArgumentException.toString());
        }
        AlgorithmIdentifier algorithmIdentifier = this.getAlgorithmIdentifier(publicKey);
        DERObjectIdentifier dERObjectIdentifier = algorithmIdentifier.getObjectId();
        DEREncodable dEREncodable = algorithmIdentifier.getParameters();
        int n8 = n2;
        if (pKIXParameters.getTargetCertConstraints() != null && !pKIXParameters.getTargetCertConstraints().match((X509Certificate)list.get(0))) {
            throw new CertPathValidatorException("target certificate in certpath does not match targetcertconstraints", null, certPath, 0);
        }
        List list2 = pKIXParameters.getCertPathCheckers();
        Iterator iterator2 = list2.iterator();
        while (iterator2.hasNext()) {
            ((PKIXCertPathChecker)iterator2.next()).init(false);
        }
        X509Certificate x509Certificate2 = null;
        n3 = list.size() - 1;
        while (n3 >= 0) {
            Iterator iterator3;
            Object object6;
            int n9 = n2 - n3;
            x509Certificate2 = (X509Certificate)list.get(n3);
            try {
                x509Certificate2.verify(publicKey, "BC");
            }
            catch (GeneralSecurityException generalSecurityException) {
                throw new CertPathValidatorException("Could not validate certificate signature.", (Throwable)generalSecurityException, certPath, n3);
            }
            try {
                x509Certificate2.checkValidity(date);
            }
            catch (CertificateExpiredException certificateExpiredException) {
                throw new CertPathValidatorException("Could not validate certificate: " + certificateExpiredException.getMessage(), (Throwable)certificateExpiredException, certPath, n3);
            }
            catch (CertificateNotYetValidException certificateNotYetValidException) {
                throw new CertPathValidatorException("Could not validate certificate: " + certificateNotYetValidException.getMessage(), (Throwable)certificateNotYetValidException, certPath, n3);
            }
            if (pKIXParameters.isRevocationEnabled()) {
                boolean bl = false;
                X509CRLSelector x509CRLSelector = new X509CRLSelector();
                try {
                    x509CRLSelector.addIssuerName(this.getEncodedIssuerPrincipal(x509Certificate2).getEncoded());
                }
                catch (IOException iOException) {
                    throw new CertPathValidatorException("Cannot extract issuer from certificate: " + iOException);
                }
                x509CRLSelector.setCertificateChecking(x509Certificate2);
                object5 = this.findCRLs(x509CRLSelector, pKIXParameters.getCertStores()).iterator();
                while (object5.hasNext()) {
                    Object object7;
                    object4 = (X509CRL)object5.next();
                    if (!x509Certificate2.getNotAfter().after(((X509CRL)object4).getThisUpdate())) continue;
                    if (((X509CRL)object4).getNextUpdate() == null || date.before(((X509CRL)object4).getNextUpdate())) {
                        bl = true;
                    }
                    if (x509Certificate != null && (object6 = (Object)x509Certificate.getKeyUsage()) != null && (((Object)object6).length < 7 || object6[6] == false)) {
                        throw new CertPathValidatorException("Issuer certificate keyusage extension does not permit crl signing.\n" + x509Certificate, null, certPath, n3);
                    }
                    try {
                        ((X509CRL)object4).verify(publicKey, "BC");
                    }
                    catch (Exception exception) {
                        throw new CertPathValidatorException("can't verify CRL: " + exception);
                    }
                    object3 = ((X509CRL)object4).getRevokedCertificate(x509Certificate2.getSerialNumber());
                    if (object3 != null && !date.before(((X509CRLEntry)object3).getRevocationDate())) {
                        Object object8;
                        object6 = null;
                        if (((X509CRLEntry)object3).hasExtensions() && (object8 = DEREnumerated.getInstance(this.getExtensionValue((X509Extension)object3, X509Extensions.ReasonCode.getId()))) != null) {
                            object6 = crlReasons[((DEREnumerated)object8).getValue().intValue()];
                        }
                        object8 = "Certificate revocation after " + ((X509CRLEntry)object3).getRevocationDate();
                        if (object6 != null) {
                            object8 = (String)object8 + ", reason: " + (String)object6;
                        }
                        throw new CertPathValidatorException((String)object8, null, certPath, n3);
                    }
                    object6 = this.getExtensionValue((X509Extension)object4, ISSUING_DISTRIBUTION_POINT);
                    DERObject dERObject = this.getExtensionValue((X509Extension)object4, DELTA_CRL_INDICATOR);
                    if (dERObject != null) {
                        object7 = new X509CRLSelector();
                        try {
                            ((X509CRLSelector)object7).addIssuerName(this.getIssuerPrincipal((X509CRL)object4).getEncoded());
                        }
                        catch (IOException iOException) {
                            throw new CertPathValidatorException("can't extract issuer from certificate: " + iOException);
                        }
                        ((X509CRLSelector)object7).setMinCRLNumber(((DERInteger)dERObject).getPositiveValue());
                        ((X509CRLSelector)object7).setMaxCRLNumber(((DERInteger)this.getExtensionValue((X509Extension)object4, CRL_NUMBER)).getPositiveValue().subtract(BigInteger.valueOf(1L)));
                        boolean bl2 = false;
                        iterator3 = this.findCRLs((X509CRLSelector)object7, pKIXParameters.getCertStores()).iterator();
                        while (iterator3.hasNext()) {
                            object2 = (X509CRL)iterator3.next();
                            object = this.getExtensionValue((X509Extension)object2, ISSUING_DISTRIBUTION_POINT);
                            if (object6 == null) {
                                if (object != null) continue;
                                bl2 = true;
                                break;
                            }
                            if (!((DERObject)object6).equals(object)) continue;
                            bl2 = true;
                            break;
                        }
                        if (!bl2) {
                            throw new CertPathValidatorException("No base CRL for delta CRL");
                        }
                    }
                    if (object6 == null) continue;
                    object7 = IssuingDistributionPoint.getInstance(object6);
                    BasicConstraints basicConstraints = BasicConstraints.getInstance(this.getExtensionValue(x509Certificate2, BASIC_CONSTRAINTS));
                    if (((IssuingDistributionPoint)object7).onlyContainsUserCerts() && (basicConstraints == null || basicConstraints.isCA())) {
                        throw new CertPathValidatorException("CA Cert CRL only contains user certificates");
                    }
                    if (((IssuingDistributionPoint)object7).onlyContainsCACerts() && (basicConstraints == null || !basicConstraints.isCA())) {
                        throw new CertPathValidatorException("End CRL only contains CA certificates");
                    }
                    if (!((IssuingDistributionPoint)object7).onlyContainsAttributeCerts()) continue;
                    throw new CertPathValidatorException("onlyContainsAttributeCerts boolean is asserted");
                }
                if (!bl) {
                    throw new CertPathValidatorException("no valid CRL found", null, certPath, n3);
                }
            }
            if (!this.getEncodedIssuerPrincipal(x509Certificate2).equals(x509Principal)) {
                throw new CertPathValidatorException("IssuerName(" + this.getEncodedIssuerPrincipal(x509Certificate2) + ") does not match SubjectName(" + x509Principal + ") of signing certificate", null, certPath, n3);
            }
            if (!this.isSelfIssued(x509Certificate2) || n9 >= n2) {
                object5 = this.getSubjectPrincipal(x509Certificate2);
                object3 = new ASN1InputStream(new ByteArrayInputStream(((X509Principal)object5).getEncoded()));
                try {
                    object4 = (ASN1Sequence)((ASN1InputStream)object3).readObject();
                }
                catch (IOException iOException) {
                    throw new CertPathValidatorException("exception extracting subject name when checking subtrees");
                }
                this.checkPermittedDN(set2, (ASN1Sequence)object4);
                this.checkExcludedDN(set5, (ASN1Sequence)object4);
                object6 = (ASN1Sequence)this.getExtensionValue(x509Certificate2, SUBJECT_ALTERNATIVE_NAME);
                if (object6 != null) {
                    int n10 = 0;
                    while (n10 < ((ASN1Sequence)object6).size()) {
                        ASN1TaggedObject aSN1TaggedObject = (ASN1TaggedObject)((ASN1Sequence)object6).getObjectAt(n10);
                        switch (aSN1TaggedObject.getTagNo()) {
                            case 1: {
                                String string = DERIA5String.getInstance(aSN1TaggedObject, true).getString();
                                this.checkPermittedEmail(set3, string);
                                this.checkExcludedEmail(set6, string);
                                break;
                            }
                            case 4: {
                                iterator3 = ASN1Sequence.getInstance(aSN1TaggedObject, true);
                                this.checkPermittedDN(set2, (ASN1Sequence)((Object)iterator3));
                                this.checkExcludedDN(set5, (ASN1Sequence)((Object)iterator3));
                                break;
                            }
                            case 7: {
                                object2 = ASN1OctetString.getInstance(aSN1TaggedObject, true).getOctets();
                                this.checkPermittedIP(set4, (byte[])object2);
                                this.checkExcludedIP(set7, (byte[])object2);
                            }
                        }
                        ++n10;
                    }
                }
            }
            if ((object5 = (ASN1Sequence)this.getExtensionValue(x509Certificate2, CERTIFICATE_POLICIES)) != null && pKIXPolicyNode != null) {
                object3 = ((ASN1Sequence)object5).getObjects();
                object4 = new HashSet();
                while (object3.hasMoreElements()) {
                    Set set8;
                    boolean bl;
                    object6 = PolicyInformation.getInstance(object3.nextElement());
                    DERObjectIdentifier dERObjectIdentifier2 = ((PolicyInformation)object6).getPolicyIdentifier();
                    object4.add(dERObjectIdentifier2.getId());
                    if (ANY_POLICY.equals(dERObjectIdentifier2.getId()) || (bl = this.processCertD1i(n9, listArray, dERObjectIdentifier2, set8 = this.getQualifierSet(((PolicyInformation)object6).getPolicyQualifiers())))) continue;
                    this.processCertD1ii(n9, listArray, dERObjectIdentifier2, set8);
                }
                if (hashSet4 == null || hashSet4.contains(ANY_POLICY)) {
                    hashSet4 = object4;
                } else {
                    object6 = hashSet4.iterator();
                    HashSet hashSet5 = new HashSet();
                    while (object6.hasNext()) {
                        Object e = object6.next();
                        if (!object4.contains(e)) continue;
                        hashSet5.add(e);
                    }
                    hashSet4 = hashSet5;
                }
                if (n6 > 0 || n9 < n2 && this.isSelfIssued(x509Certificate2)) {
                    object3 = ((ASN1Sequence)object5).getObjects();
                    while (object3.hasMoreElements()) {
                        object6 = PolicyInformation.getInstance(object3.nextElement());
                        if (!ANY_POLICY.equals(((PolicyInformation)object6).getPolicyIdentifier().getId())) continue;
                        Set set9 = this.getQualifierSet(((PolicyInformation)object6).getPolicyQualifiers());
                        List list3 = listArray[n9 - 1];
                        int n11 = 0;
                        while (n11 < list3.size()) {
                            iterator3 = (PKIXPolicyNode)list3.get(n11);
                            object2 = ((PKIXPolicyNode)((Object)iterator3)).getExpectedPolicies().iterator();
                            while (object2.hasNext()) {
                                Object object9;
                                String string;
                                object = object2.next();
                                if (object instanceof String) {
                                    string = (String)object;
                                } else {
                                    if (!(object instanceof DERObjectIdentifier)) continue;
                                    string = ((DERObjectIdentifier)object).getId();
                                }
                                boolean bl = false;
                                Iterator iterator4 = ((PKIXPolicyNode)((Object)iterator3)).getChildren();
                                while (iterator4.hasNext()) {
                                    object9 = (PKIXPolicyNode)iterator4.next();
                                    if (!string.equals(((PKIXPolicyNode)object9).getValidPolicy())) continue;
                                    bl = true;
                                }
                                if (bl) continue;
                                object9 = new HashSet();
                                object9.add(string);
                                PKIXPolicyNode pKIXPolicyNode2 = new PKIXPolicyNode(new ArrayList(), n9, (Set)object9, (PolicyNode)((Object)iterator3), set9, string, false);
                                ((PKIXPolicyNode)((Object)iterator3)).addChild(pKIXPolicyNode2);
                                listArray[n9].add(pKIXPolicyNode2);
                            }
                            ++n11;
                        }
                        break block51;
                    }
                }
                int n12 = n9 - 1;
                while (n12 >= 0) {
                    List list4 = listArray[n12];
                    int n13 = 0;
                    while (n13 < list4.size()) {
                        PKIXPolicyNode pKIXPolicyNode3 = (PKIXPolicyNode)list4.get(n13);
                        if (!pKIXPolicyNode3.hasChildren() && (pKIXPolicyNode = this.removePolicyNode(pKIXPolicyNode, listArray, pKIXPolicyNode3)) == null) break;
                        ++n13;
                    }
                    --n12;
                }
                Set<String> set10 = x509Certificate2.getCriticalExtensionOIDs();
                if (set10 != null) {
                    boolean bl = set10.contains(CERTIFICATE_POLICIES);
                    List list5 = listArray[n9];
                    int n14 = 0;
                    while (n14 < list5.size()) {
                        object2 = (PKIXPolicyNode)list5.get(n14);
                        ((PKIXPolicyNode)object2).setCritical(bl);
                        ++n14;
                    }
                }
            }
            if (object5 == null) {
                pKIXPolicyNode = null;
            }
            if (n5 <= 0 && pKIXPolicyNode == null) {
                throw new CertPathValidatorException("No valid policy tree found when one expected.");
            }
            if (n9 != n2) {
                boolean[] blArray;
                int n15;
                BigInteger bigInteger;
                BasicConstraints basicConstraints;
                int n16;
                DERInteger dERInteger;
                ASN1Sequence aSN1Sequence;
                if (x509Certificate2 != null && x509Certificate2.getVersion() == 1) {
                    throw new CertPathValidatorException("Version 1 certs can't be used as CA ones");
                }
                object3 = this.getExtensionValue(x509Certificate2, POLICY_MAPPINGS);
                if (object3 != null) {
                    object4 = (ASN1Sequence)object3;
                    int n17 = 0;
                    while (n17 < ((ASN1Sequence)object4).size()) {
                        ASN1Sequence aSN1Sequence2 = (ASN1Sequence)((ASN1Sequence)object4).getObjectAt(n17);
                        DERObjectIdentifier dERObjectIdentifier3 = (DERObjectIdentifier)aSN1Sequence2.getObjectAt(0);
                        DERObjectIdentifier dERObjectIdentifier4 = (DERObjectIdentifier)aSN1Sequence2.getObjectAt(1);
                        if (ANY_POLICY.equals(dERObjectIdentifier3.getId())) {
                            throw new CertPathValidatorException("IssuerDomainPolicy is anyPolicy");
                        }
                        if (ANY_POLICY.equals(dERObjectIdentifier4.getId())) {
                            throw new CertPathValidatorException("SubjectDomainPolicy is anyPolicy");
                        }
                        ++n17;
                    }
                }
                if ((object4 = (ASN1Sequence)this.getExtensionValue(x509Certificate2, NAME_CONSTRAINTS)) != null) {
                    ASN1Sequence aSN1Sequence3;
                    NameConstraints nameConstraints = new NameConstraints((ASN1Sequence)object4);
                    ASN1Sequence aSN1Sequence4 = nameConstraints.getPermittedSubtrees();
                    if (aSN1Sequence4 != null) {
                        Enumeration enumeration = aSN1Sequence4.getObjects();
                        while (enumeration.hasMoreElements()) {
                            GeneralSubtree generalSubtree = GeneralSubtree.getInstance(enumeration.nextElement());
                            GeneralName generalName = generalSubtree.getBase();
                            switch (generalName.getTagNo()) {
                                case 1: {
                                    set3 = this.intersectEmail(set3, DERIA5String.getInstance(generalName.getName()).getString());
                                    break;
                                }
                                case 4: {
                                    set2 = this.intersectDN(set2, (ASN1Sequence)generalName.getName());
                                    break;
                                }
                                case 7: {
                                    set4 = this.intersectIP(set4, ASN1OctetString.getInstance(generalName.getName()).getOctets());
                                }
                            }
                        }
                    }
                    if ((aSN1Sequence3 = nameConstraints.getExcludedSubtrees()) != null) {
                        Enumeration enumeration = aSN1Sequence3.getObjects();
                        while (enumeration.hasMoreElements()) {
                            GeneralSubtree generalSubtree = GeneralSubtree.getInstance(enumeration.nextElement());
                            object2 = generalSubtree.getBase();
                            switch (((GeneralName)object2).getTagNo()) {
                                case 1: {
                                    set6 = this.unionEmail(set6, DERIA5String.getInstance(((GeneralName)object2).getName()).getString());
                                    break;
                                }
                                case 4: {
                                    set5 = this.unionDN(set5, (ASN1Sequence)((GeneralName)object2).getName());
                                    break;
                                }
                                case 7: {
                                    set7 = this.unionIP(set7, ASN1OctetString.getInstance(((GeneralName)object2).getName()).getOctets());
                                }
                            }
                        }
                    }
                }
                if (!this.isSelfIssued(x509Certificate2)) {
                    if (n5 != 0) {
                        --n5;
                    }
                    if (n7 != 0) {
                        --n7;
                    }
                    if (n6 != 0) {
                        --n6;
                    }
                }
                if ((aSN1Sequence = (ASN1Sequence)this.getExtensionValue(x509Certificate2, POLICY_CONSTRAINTS)) != null) {
                    Enumeration enumeration = aSN1Sequence.getObjects();
                    while (enumeration.hasMoreElements()) {
                        ASN1TaggedObject aSN1TaggedObject = (ASN1TaggedObject)enumeration.nextElement();
                        switch (aSN1TaggedObject.getTagNo()) {
                            case 0: {
                                n = DERInteger.getInstance(aSN1TaggedObject).getValue().intValue();
                                if (n >= n5) break;
                                n5 = n;
                                break;
                            }
                            case 1: {
                                n = DERInteger.getInstance(aSN1TaggedObject).getValue().intValue();
                                if (n >= n7) break;
                                n7 = n;
                            }
                        }
                    }
                }
                if ((dERInteger = (DERInteger)this.getExtensionValue(x509Certificate2, INHIBIT_ANY_POLICY)) != null && (n16 = dERInteger.getValue().intValue()) < n6) {
                    n6 = n16;
                }
                if ((basicConstraints = BasicConstraints.getInstance(this.getExtensionValue(x509Certificate2, BASIC_CONSTRAINTS))) != null) {
                    if (!basicConstraints.isCA()) {
                        throw new CertPathValidatorException("Not a CA certificate");
                    }
                } else {
                    throw new CertPathValidatorException("Intermediate certificate lacks BasicConstraints");
                }
                if (!this.isSelfIssued(x509Certificate2)) {
                    if (n8 <= 0) {
                        throw new CertPathValidatorException("Max path length not greater than zero");
                    }
                    --n8;
                }
                if (basicConstraints != null && (bigInteger = basicConstraints.getPathLenConstraint()) != null && (n15 = bigInteger.intValue()) < n8) {
                    n8 = n15;
                }
                if ((blArray = x509Certificate2.getKeyUsage()) != null && !blArray[5]) {
                    throw new CertPathValidatorException("Issuer certificate keyusage extension is critical an does not permit key signing.\n", null, certPath, n3);
                }
                HashSet<String> hashSet6 = new HashSet<String>(x509Certificate2.getCriticalExtensionOIDs());
                hashSet6.remove(KEY_USAGE);
                hashSet6.remove(CERTIFICATE_POLICIES);
                hashSet6.remove(POLICY_MAPPINGS);
                hashSet6.remove(INHIBIT_ANY_POLICY);
                hashSet6.remove(ISSUING_DISTRIBUTION_POINT);
                hashSet6.remove(DELTA_CRL_INDICATOR);
                hashSet6.remove(POLICY_CONSTRAINTS);
                hashSet6.remove(BASIC_CONSTRAINTS);
                hashSet6.remove(SUBJECT_ALTERNATIVE_NAME);
                hashSet6.remove(NAME_CONSTRAINTS);
                iterator = list2.iterator();
                while (iterator.hasNext()) {
                    try {
                        ((PKIXCertPathChecker)iterator.next()).check(x509Certificate2, hashSet6);
                    }
                    catch (CertPathValidatorException certPathValidatorException) {
                        throw new CertPathValidatorException(certPathValidatorException.getMessage(), certPathValidatorException.getCause(), certPath, n3);
                    }
                }
                if (!hashSet6.isEmpty()) {
                    throw new CertPathValidatorException("Certificate has unsupported critical extension", null, certPath, n3);
                }
            }
            x509Certificate = x509Certificate2;
            publicKey = x509Certificate.getPublicKey();
            try {
                x509Principal = this.getSubjectPrincipal(x509Certificate);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw new CertPathValidatorException(x509Certificate.getSubjectDN().getName() + " :" + illegalArgumentException.toString());
            }
            algorithmIdentifier = this.getAlgorithmIdentifier(publicKey);
            dERObjectIdentifier = algorithmIdentifier.getObjectId();
            dEREncodable = algorithmIdentifier.getParameters();
            --n3;
        }
        if (!this.isSelfIssued(x509Certificate2) && n5 != 0) {
            --n5;
        }
        if ((object5 = (ASN1Sequence)this.getExtensionValue(x509Certificate2, POLICY_CONSTRAINTS)) != null) {
            object3 = ((ASN1Sequence)object5).getObjects();
            while (object3.hasMoreElements()) {
                object4 = (ASN1TaggedObject)object3.nextElement();
                switch (((ASN1TaggedObject)object4).getTagNo()) {
                    case 0: {
                        n = DERInteger.getInstance(object4).getValue().intValue();
                        if (n != 0) break;
                        n5 = 0;
                    }
                }
            }
        }
        if ((object3 = x509Certificate2.getCriticalExtensionOIDs()) != null) {
            object3 = new HashSet(object3);
            object3.remove(KEY_USAGE);
            object3.remove(CERTIFICATE_POLICIES);
            object3.remove(POLICY_MAPPINGS);
            object3.remove(INHIBIT_ANY_POLICY);
            object3.remove(ISSUING_DISTRIBUTION_POINT);
            object3.remove(DELTA_CRL_INDICATOR);
            object3.remove(POLICY_CONSTRAINTS);
            object3.remove(BASIC_CONSTRAINTS);
            object3.remove(SUBJECT_ALTERNATIVE_NAME);
            object3.remove(NAME_CONSTRAINTS);
        } else {
            object3 = new HashSet();
        }
        iterator = list2.iterator();
        while (iterator.hasNext()) {
            try {
                ((PKIXCertPathChecker)iterator.next()).check(x509Certificate2, (Collection)object3);
            }
            catch (CertPathValidatorException certPathValidatorException) {
                throw new CertPathValidatorException(certPathValidatorException.getMessage(), certPathValidatorException.getCause(), certPath, n3);
            }
        }
        if (!object3.isEmpty()) {
            throw new CertPathValidatorException("Certificate has unsupported critical extension", null, certPath, n3);
        }
        if (pKIXPolicyNode == null) {
            if (pKIXParameters.isExplicitPolicyRequired()) {
                throw new CertPathValidatorException("Explicit policy requested but none available.");
            }
            object4 = null;
        } else if (this.isAnyPolicy(set)) {
            if (pKIXParameters.isExplicitPolicyRequired()) {
                if (hashSet4.isEmpty()) {
                    throw new CertPathValidatorException("Explicit policy requested but none available.");
                }
                HashSet hashSet7 = new HashSet();
                int n18 = 0;
                while (n18 < listArray.length) {
                    ArrayList arrayList = listArray[n18];
                    int n19 = 0;
                    while (n19 < arrayList.size()) {
                        PKIXPolicyNode pKIXPolicyNode4 = (PKIXPolicyNode)arrayList.get(n19);
                        if (ANY_POLICY.equals(pKIXPolicyNode4.getValidPolicy())) {
                            object2 = pKIXPolicyNode4.getChildren();
                            while (object2.hasNext()) {
                                hashSet7.add(object2.next());
                            }
                        }
                        ++n19;
                    }
                    ++n18;
                }
                Iterator iterator5 = hashSet7.iterator();
                while (iterator5.hasNext()) {
                    PKIXPolicyNode pKIXPolicyNode5 = (PKIXPolicyNode)iterator5.next();
                    String string = pKIXPolicyNode5.getValidPolicy();
                    if (hashSet4.contains(string)) continue;
                    pKIXPolicyNode = this.removePolicyNode(pKIXPolicyNode, listArray, pKIXPolicyNode5);
                }
                if (pKIXPolicyNode != null) {
                    int n20 = n2 - 1;
                    while (n20 >= 0) {
                        List list6 = listArray[n20];
                        int n21 = 0;
                        while (n21 < list6.size()) {
                            object = (PKIXPolicyNode)list6.get(n21);
                            if (!((PKIXPolicyNode)object).hasChildren()) {
                                pKIXPolicyNode = this.removePolicyNode(pKIXPolicyNode, listArray, (PKIXPolicyNode)object);
                            }
                            ++n21;
                        }
                        --n20;
                    }
                }
            }
            object4 = pKIXPolicyNode;
        } else {
            HashSet<PKIXPolicyNode> hashSet8 = new HashSet<PKIXPolicyNode>();
            int n22 = 0;
            while (n22 < listArray.length) {
                ArrayList arrayList = listArray[n22];
                int n23 = 0;
                while (n23 < arrayList.size()) {
                    PKIXPolicyNode pKIXPolicyNode6 = (PKIXPolicyNode)arrayList.get(n23);
                    if (ANY_POLICY.equals(pKIXPolicyNode6.getValidPolicy())) {
                        object2 = pKIXPolicyNode6.getChildren();
                        while (object2.hasNext()) {
                            object = (PKIXPolicyNode)object2.next();
                            if (ANY_POLICY.equals(((PKIXPolicyNode)object).getValidPolicy())) continue;
                            hashSet8.add((PKIXPolicyNode)object);
                        }
                    }
                    ++n23;
                }
                ++n22;
            }
            Iterator iterator6 = hashSet8.iterator();
            while (iterator6.hasNext()) {
                PKIXPolicyNode pKIXPolicyNode7 = (PKIXPolicyNode)iterator6.next();
                String string = pKIXPolicyNode7.getValidPolicy();
                if (set.contains(string)) continue;
                pKIXPolicyNode = this.removePolicyNode(pKIXPolicyNode, listArray, pKIXPolicyNode7);
            }
            if (pKIXPolicyNode != null) {
                int n24 = n2 - 1;
                while (n24 >= 0) {
                    ArrayList arrayList = listArray[n24];
                    int n25 = 0;
                    while (n25 < arrayList.size()) {
                        object = (PKIXPolicyNode)arrayList.get(n25);
                        if (!((PKIXPolicyNode)object).hasChildren()) {
                            pKIXPolicyNode = this.removePolicyNode(pKIXPolicyNode, listArray, (PKIXPolicyNode)object);
                        }
                        ++n25;
                    }
                    --n24;
                }
            }
            object4 = pKIXPolicyNode;
        }
        if (n5 > 0 || object4 != null) {
            return new PKIXCertPathValidatorResult(trustAnchor, (PolicyNode)object4, publicKey);
        }
        throw new CertPathValidatorException("Path processing failed on policy.", null, certPath, n3);
    }

    private final Collection findCRLs(X509CRLSelector x509CRLSelector, List list) throws CertPathValidatorException {
        HashSet hashSet = new HashSet();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            CertStore certStore = (CertStore)iterator.next();
            try {
                hashSet.addAll(certStore.getCRLs(x509CRLSelector));
            }
            catch (CertStoreException certStoreException) {
                throw new CertPathValidatorException(certStoreException);
            }
        }
        return hashSet;
    }

    /*
     * Unable to fully structure code
     */
    final TrustAnchor findTrustAnchor(X509Certificate var1_1, CertPath var2_2, int var3_3, Set var4_4) throws CertPathValidatorException {
        var5_5 = var4_4.iterator();
        var6_6 = null;
        var7_7 = null;
        var8_8 = null;
        var9_9 = new X509CertSelector();
        try {
            var9_9.setSubject(this.getEncodedIssuerPrincipal(var1_1).getEncoded());
            if (true) ** GOTO lbl39
        }
        catch (IOException var10_10) {
            throw new CertPathValidatorException(var10_10);
        }
        do {
            block15: {
                if ((var6_6 = (TrustAnchor)var5_5.next()).getTrustedCert() != null) {
                    if (var9_9.match(var6_6.getTrustedCert())) {
                        var7_7 = var6_6.getTrustedCert().getPublicKey();
                    } else {
                        var6_6 = null;
                    }
                } else if (var6_6.getCAName() != null && var6_6.getCAPublicKey() != null) {
                    try {
                        var10_11 = this.getEncodedIssuerPrincipal(var1_1);
                        var11_14 = new X509Principal(var6_6.getCAName());
                        if (var10_11.equals(var11_14)) {
                            var7_7 = var6_6.getCAPublicKey();
                            break block15;
                        }
                        var6_6 = null;
                    }
                    catch (IllegalArgumentException var10_12) {
                        var6_6 = null;
                    }
                } else {
                    var6_6 = null;
                }
            }
            if (var7_7 == null) continue;
            try {
                var1_1.verify(var7_7);
            }
            catch (Exception var10_13) {
                var8_8 = var10_13;
                var6_6 = null;
            }
lbl39:
            // 4 sources

        } while (var5_5.hasNext() && var6_6 == null);
        if (var6_6 == null && var8_8 != null) {
            throw new CertPathValidatorException("TrustAnchor found but certificate validation failed.", var8_8, var2_2, var3_3);
        }
        return var6_6;
    }

    private X509Principal getIssuerPrincipal(X509CRL x509CRL) throws CertPathValidatorException {
        try {
            return PrincipalUtil.getIssuerX509Principal(x509CRL);
        }
        catch (CRLException cRLException) {
            throw new CertPathValidatorException("cannot extract issuer from CRL: " + cRLException.toString());
        }
    }

    private X509Principal getEncodedIssuerPrincipal(X509Certificate x509Certificate) throws CertPathValidatorException {
        try {
            return PrincipalUtil.getIssuerX509Principal(x509Certificate);
        }
        catch (CertificateEncodingException certificateEncodingException) {
            throw new CertPathValidatorException("cannot extract issuer from cert: " + certificateEncodingException.toString());
        }
    }

    private X509Principal getSubjectPrincipal(X509Certificate x509Certificate) throws CertPathValidatorException {
        try {
            return PrincipalUtil.getSubjectX509Principal(x509Certificate);
        }
        catch (CertificateEncodingException certificateEncodingException) {
            throw new CertPathValidatorException("cannot extract subject from cert: " + certificateEncodingException.toString());
        }
    }
}

