/*
 * Decompiled with CFR 0.152.
 */
package org.globus.ftp.dc;

import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.globus.ftp.Buffer;
import org.globus.ftp.DataSource;
import org.globus.ftp.dc.AbstractDataChannel;
import org.globus.ftp.dc.DataChannelWriter;
import org.globus.ftp.dc.LocalReply;
import org.globus.ftp.dc.SocketBox;
import org.globus.ftp.dc.TransferContext;
import org.globus.ftp.dc.TransferThread;
import org.globus.ftp.vanilla.BasicServerControlChannel;
import org.globus.ftp.vanilla.FTPServerFacade;

public class TransferSourceThread
extends TransferThread {
    protected static Log logger = LogFactory.getLog((class$org$globus$ftp$dc$TransferSourceThread == null ? (class$org$globus$ftp$dc$TransferSourceThread = TransferSourceThread.class$("org.globus.ftp.dc.TransferSourceThread")) : class$org$globus$ftp$dc$TransferSourceThread).getName());
    protected DataChannelWriter writer;
    protected DataSource source;
    protected BasicServerControlChannel localControlChannel;
    protected TransferContext context;
    protected SocketBox socketBox = null;
    static /* synthetic */ Class class$org$globus$ftp$dc$TransferSourceThread;

    public TransferSourceThread(AbstractDataChannel dataChannel, SocketBox socketBox, DataSource source, BasicServerControlChannel localControlChannel, TransferContext context) throws Exception {
        this.socketBox = socketBox;
        this.source = source;
        this.localControlChannel = localControlChannel;
        this.context = context;
        this.writer = dataChannel.getDataChannelSink(context);
        logger.debug("using socket " + socketBox.getSocket().toString());
        this.writer.setDataStream(socketBox.getSocket().getOutputStream());
    }

    public void run() {
        long transferred = 0L;
        boolean error = false;
        logger.debug("TransferSourceThread executing");
        try {
            this.startup();
            try {
                Buffer buf;
                while ((buf = this.source.read()) != null) {
                    transferred += (long)buf.getLength();
                    this.writer.write(buf);
                }
                logger.debug("finished sending data; sent " + transferred + " bytes");
            }
            catch (Exception e) {
                error = true;
                FTPServerFacade.exceptionToControlChannel(e, "exception during TransferSourceThread", this.localControlChannel);
            }
            Object quitToken = this.shutdown();
            if (!error && quitToken != null) {
                this.localControlChannel.write(new LocalReply(226));
            }
        }
        catch (Exception e) {
            FTPServerFacade.cannotPropagateError(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void startup() {
        BasicServerControlChannel basicServerControlChannel = this.localControlChannel;
        synchronized (basicServerControlChannel) {
            if (this.localControlChannel.getReplyCount() == 0) {
                this.localControlChannel.write(new LocalReply(125));
            }
        }
    }

    protected Object shutdown() throws IOException {
        logger.debug("shutdown");
        this.writer.close();
        this.socketBox.setSocket(null);
        Object quitToken = this.context.getQuitToken();
        if (quitToken != null) {
            this.source.close();
        }
        return quitToken;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

