/*
 * Decompiled with CFR 0.152.
 */
package org.globus.ftp.vanilla;

import java.io.IOException;
import java.io.InterruptedIOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.globus.ftp.GridFTPRestartMarker;
import org.globus.ftp.MarkerListener;
import org.globus.ftp.PerfMarker;
import org.globus.ftp.exception.FTPReplyParseException;
import org.globus.ftp.exception.ServerException;
import org.globus.ftp.exception.UnexpectedReplyCodeException;
import org.globus.ftp.vanilla.BasicClientControlChannel;
import org.globus.ftp.vanilla.Flag;
import org.globus.ftp.vanilla.Reply;
import org.globus.ftp.vanilla.TransferState;

public class TransferMonitor
implements Runnable {
    public static final int LOCAL = 1;
    public static final int REMOTE = 2;
    private int side;
    private Log logger = null;
    private int maxWait;
    private int ioDelay;
    private BasicClientControlChannel controlChannel;
    private TransferState transferState;
    private MarkerListener mListener;
    private TransferMonitor other;
    private boolean abortable;
    private Flag aborted = new Flag();
    private Thread thread;
    static /* synthetic */ Class class$org$globus$ftp$vanilla$TransferMonitor;

    public TransferMonitor(BasicClientControlChannel controlChannel, TransferState transferState, MarkerListener mListener, int maxWait, int ioDelay, int side) {
        this.logger = LogFactory.getLog((class$org$globus$ftp$vanilla$TransferMonitor == null ? (class$org$globus$ftp$vanilla$TransferMonitor = TransferMonitor.class$("org.globus.ftp.vanilla.TransferMonitor")) : class$org$globus$ftp$vanilla$TransferMonitor).getName() + (side == 1 ? ".Local" : ".Remote"));
        this.controlChannel = controlChannel;
        this.transferState = transferState;
        this.mListener = mListener;
        this.maxWait = maxWait;
        this.ioDelay = ioDelay;
        this.abortable = true;
        this.aborted.flag = false;
        this.side = side;
    }

    public String getLoggerName() {
        return this.logger.toString();
    }

    public void setOther(TransferMonitor other) {
        this.other = other;
    }

    public synchronized void abort() {
        this.logger.debug("abort");
        if (!this.abortable) {
            return;
        }
        this.controlChannel.abortTransfer();
        this.aborted.flag = true;
    }

    private synchronized void done() {
        this.abortable = false;
    }

    public void start(boolean blocking) {
        if (blocking) {
            this.thread = Thread.currentThread();
            this.run();
        } else {
            this.thread = new Thread(this);
            this.thread.setName("TransferMonitor" + this.thread.getName());
            this.thread.start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        try {
            if (this.transferState.hasError()) {
                this.logger.debug("the other thread terminated before this one started.");
                throw new InterruptedException();
            }
            this.logger.debug("waiting for 1st reply;  maxWait = " + this.maxWait + ", ioDelay = " + this.ioDelay);
            this.controlChannel.waitFor(this.aborted, this.ioDelay, this.maxWait);
            this.logger.debug("reading first reply");
            Reply firstReply = this.controlChannel.read();
            if (Reply.isPositivePreliminary(firstReply)) {
                Reply nextReply;
                this.transferState.transferStarted();
                this.logger.debug("first reply OK: " + firstReply.toString());
                while (true) {
                    this.logger.debug("reading next reply");
                    this.controlChannel.waitFor(this.aborted, this.ioDelay);
                    this.logger.debug("got next reply");
                    nextReply = this.controlChannel.read();
                    if (nextReply.getCode() == 112) {
                        this.logger.debug("marker arrived: " + nextReply.toString());
                        if (this.mListener == null) continue;
                        this.mListener.markerArrived(new PerfMarker(nextReply.getMessage()));
                        continue;
                    }
                    if (nextReply.getCode() != 111) break;
                    this.logger.debug("marker arrived: " + nextReply.toString());
                    if (this.mListener == null) continue;
                    this.mListener.markerArrived(new GridFTPRestartMarker(nextReply.getMessage()));
                }
                if (nextReply.getCode() == 226) {
                    this.abortable = false;
                    this.logger.debug("transfer complete: " + nextReply.toString());
                } else {
                    this.logger.debug("unexpected reply: " + nextReply.toString());
                    this.logger.debug("exiting the transfer thread");
                    ServerException e = ServerException.embedUnexpectedReplyCodeException(new UnexpectedReplyCodeException(nextReply), "Server reported transfer failure");
                    this.transferState.transferError(e);
                    this.other.abort();
                }
            } else {
                this.logger.debug("first reply bad: " + firstReply.toString());
                this.logger.debug("category: " + firstReply.getCategory());
                this.abortable = false;
                ServerException e = ServerException.embedUnexpectedReplyCodeException(new UnexpectedReplyCodeException(firstReply));
                this.transferState.transferError(e);
                this.other.abort();
            }
            this.logger.debug("thread dying naturally");
        }
        catch (InterruptedException td) {
            this.logger.debug("thread dying of InterruptedException.");
            this.transferState.transferError(td);
        }
        catch (InterruptedIOException td) {
            this.logger.debug("thread dying of InterruptedIOException.");
            this.transferState.transferError(td);
        }
        catch (IOException e) {
            this.logger.debug("thread dying of IOException");
            this.transferState.transferError(e);
            this.other.abort();
        }
        catch (FTPReplyParseException rpe) {
            this.logger.debug("thread dying of FTPReplyParseException");
            ServerException se = ServerException.embedFTPReplyParseException(rpe);
            this.transferState.transferError(se);
            this.other.abort();
        }
        catch (ServerException e) {
            this.logger.debug("thread dying of timeout");
            this.transferState.transferError(e);
            this.other.abort();
        }
        finally {
            this.done();
            this.transferState.transferDone();
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

