/*
 * Decompiled with CFR 0.152.
 */
package org.globus.myproxy;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.nio.charset.Charset;
import java.security.KeyPair;
import java.security.MessageDigest;
import java.security.SecureRandom;
import java.security.Signature;
import java.security.cert.X509Certificate;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.security.auth.x500.X500Principal;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.globus.common.CoGProperties;
import org.globus.gsi.CertUtil;
import org.globus.gsi.GlobusCredential;
import org.globus.gsi.OpenSSLKey;
import org.globus.gsi.bc.BouncyCastleCertProcessingFactory;
import org.globus.gsi.gssapi.GSSConstants;
import org.globus.gsi.gssapi.GlobusGSSCredentialImpl;
import org.globus.gsi.gssapi.auth.Authorization;
import org.globus.gsi.gssapi.auth.IdentityAuthorization;
import org.globus.gsi.gssapi.net.GssSocket;
import org.globus.gsi.gssapi.net.GssSocketFactory;
import org.globus.myproxy.ChangePasswordParams;
import org.globus.myproxy.CredentialInfo;
import org.globus.myproxy.DestroyParams;
import org.globus.myproxy.GetParams;
import org.globus.myproxy.GetTrustrootsParams;
import org.globus.myproxy.InfoParams;
import org.globus.myproxy.InitParams;
import org.globus.myproxy.MyProxyException;
import org.globus.myproxy.MyProxyServerAuthorization;
import org.globus.myproxy.MyTrustManager;
import org.globus.myproxy.StoreParams;
import org.globus.util.Base64;
import org.gridforum.jgss.ExtendedGSSManager;
import org.ietf.jgss.GSSContext;
import org.ietf.jgss.GSSCredential;
import org.ietf.jgss.GSSException;
import org.ietf.jgss.GSSManager;
import org.ietf.jgss.GSSName;
import org.ietf.jgss.Oid;

public class MyProxy {
    static Log logger = LogFactory.getLog((class$org$globus$myproxy$MyProxy == null ? (class$org$globus$myproxy$MyProxy = MyProxy.class$("org.globus.myproxy.MyProxy")) : class$org$globus$myproxy$MyProxy).getName());
    public static final int MIN_PASSWORD_LENGTH = 6;
    public static final String MYPROXY_PROTOCOL_VERSION = "MYPROXYv2";
    private static final String RESPONSE = "RESPONSE=";
    private static final String ERROR = "ERROR=";
    private static final String AUTHZ_DATA = "AUTHORIZATION_DATA=";
    private static final String CRED = "CRED_";
    private static final String OWNER = "OWNER=";
    private static final String START_TIME = "START_TIME=";
    private static final String END_TIME = "END_TIME=";
    private static final String DESC = "DESC=";
    private static final String RETRIEVER = "RETRIEVER=";
    private static final String RENEWER = "RENEWER=";
    private static final String TRUSTROOTS = "TRUSTED_CERTS=";
    private static final String CRED_START_TIME = "CRED_START_TIME=";
    private static final String CRED_END_TIME = "CRED_END_TIME=";
    private static final String CRED_OWNER = "CRED_OWNER=";
    private static final String CRED_DESC = "CRED_DESC=";
    private static final String CRED_RETRIEVER = "CRED_RETRIEVER=";
    private static final String CRED_RENEWER = "CRED_RENEWER=";
    private static final String CRED_NAME = "CRED_NAME=";
    public static final int DEFAULT_PORT = 7512;
    public static final int DEFAULT_KEYBITS = 1024;
    public static final int GET_PROXY = 0;
    public static final int PUT_PROXY = 1;
    public static final int INFO_PROXY = 2;
    public static final int DESTROY_PROXY = 3;
    public static final int CHANGE_PASSWORD = 4;
    public static final int STORE_CREDENTIAL = 5;
    public static final int RETRIEVE_CREDENTIAL = 6;
    public static final int GET_TRUSTROOTS = 7;
    protected String host;
    protected int port = 7512;
    protected Authorization authorization;
    protected GSSContext context;
    protected String[] trustrootFilenames;
    protected String[] trustrootData;
    private static final String TRUSTED_CERT_PATH = "/.globus/certificates";
    static /* synthetic */ Class class$org$globus$myproxy$MyProxy;

    public MyProxy() {
        this.setAuthorization(new MyProxyServerAuthorization());
    }

    public MyProxy(String host, int port) {
        this.setHost(host);
        this.setPort(port);
        this.setAuthorization(new MyProxyServerAuthorization());
    }

    public void setHost(String host) {
        this.host = host;
    }

    public String getHost() {
        return this.host;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public int getPort() {
        return this.port;
    }

    public void setAuthorization(Authorization authorization) {
        this.authorization = authorization;
    }

    public Authorization getAuthorization() {
        return this.authorization;
    }

    private GssSocket getSocket(GSSCredential credential) throws IOException, GSSException {
        int hostIdx;
        GSSManager manager = ExtendedGSSManager.getInstance();
        this.context = manager.createContext(null, GSSConstants.MECH_OID, credential, 0);
        this.context.requestCredDeleg(false);
        IOException exception = null;
        Socket socket = null;
        String goodAddr = "";
        String[] hosts = this.host.split(",");
        int socketTimeout = CoGProperties.getDefault().getSocketTimeout();
        block2: for (hostIdx = 0; hostIdx < hosts.length; ++hostIdx) {
            InetAddress[] addrs = InetAddress.getAllByName(hosts[hostIdx]);
            for (int addrIdx = 0; addrIdx < addrs.length; ++addrIdx) {
                exception = null;
                try {
                    if (logger.isDebugEnabled()) {
                        logger.debug("getSocket(): Trying " + addrs[addrIdx].toString());
                    }
                    socket = new Socket();
                    socket.connect(new InetSocketAddress(addrs[addrIdx], this.port), socketTimeout * 1000);
                    goodAddr = addrs[addrIdx].toString();
                    if (!logger.isDebugEnabled()) break block2;
                    logger.debug("             Succeeded.");
                    break block2;
                }
                catch (IOException e) {
                    exception = e;
                    if (!logger.isDebugEnabled()) continue;
                    logger.debug("             Failed.");
                    continue;
                }
            }
        }
        if (exception != null) {
            if (logger.isDebugEnabled()) {
                logger.debug("getSocket(): Unable to connect to a MyProxy host");
            }
            throw exception;
        }
        GssSocketFactory gssFactory = GssSocketFactory.getDefault();
        GssSocket gssSocket = (GssSocket)gssFactory.createSocket(socket, hosts[hostIdx], this.port, this.context);
        if (logger.isDebugEnabled()) {
            logger.debug("getSocket(): Connected to " + goodAddr);
        }
        gssSocket.setAuthorization(this.authorization);
        return gssSocket;
    }

    public void put(GSSCredential credential, String username, String passphrase, int lifetime) throws MyProxyException {
        InitParams request = new InitParams();
        request.setUserName(username);
        request.setPassphrase(passphrase);
        request.setLifetime(lifetime);
        this.put(credential, request);
    }

    public void put(GSSCredential credential, InitParams params) throws MyProxyException {
        if (credential == null) {
            throw new IllegalArgumentException("credential == null");
        }
        if (params == null) {
            throw new IllegalArgumentException("params == null");
        }
        if (!(credential instanceof GlobusGSSCredentialImpl)) {
            throw new IllegalArgumentException("wrong type of credentials");
        }
        String msg = params.makeRequest();
        GssSocket gsiSocket = null;
        OutputStream out = null;
        InputStream in = null;
        try {
            gsiSocket = this.getSocket(credential);
            out = ((Socket)gsiSocket).getOutputStream();
            in = ((Socket)gsiSocket).getInputStream();
            out.write(msg.getBytes());
            out.flush();
            if (logger.isDebugEnabled()) {
                logger.debug("Req sent:" + params);
            }
            this.handleReply(in);
            BouncyCastleCertProcessingFactory certFactory = BouncyCastleCertProcessingFactory.getDefault();
            GlobusGSSCredentialImpl pkiCred = (GlobusGSSCredentialImpl)credential;
            X509Certificate[] certs = pkiCred.getCertificateChain();
            X509Certificate cert = certFactory.createCertificate(in, certs[0], pkiCred.getPrivateKey(), -1, 3);
            ByteArrayOutputStream buffer = new ByteArrayOutputStream(2048);
            buffer.write((byte)(certs.length + 1));
            buffer.write(cert.getEncoded());
            for (int i = 0; i < certs.length; ++i) {
                buffer.write(certs[i].getEncoded());
                if (!logger.isDebugEnabled()) continue;
                logger.debug("Sent cert: " + certs[i].getSubjectDN());
            }
            out.write(buffer.toByteArray());
            out.flush();
            this.handleReply(in);
        }
        catch (Exception e) {
            try {
                throw new MyProxyException("MyProxy put failed.", e);
            }
            catch (Throwable throwable) {
                MyProxy.close(out, in, gsiSocket);
                throw throwable;
            }
        }
        MyProxy.close(out, in, gsiSocket);
    }

    public void store(GSSCredential credential, X509Certificate[] certs, OpenSSLKey key, StoreParams params) throws MyProxyException {
        if (credential == null) {
            throw new IllegalArgumentException("credential == null");
        }
        if (certs == null) {
            throw new IllegalArgumentException("certs == null");
        }
        if (key == null) {
            throw new IllegalArgumentException("key == null");
        }
        if (params == null) {
            throw new IllegalArgumentException("params == null");
        }
        if (!(credential instanceof GlobusGSSCredentialImpl)) {
            throw new IllegalArgumentException("wrong type of credentials");
        }
        String msg = params.makeRequest();
        GssSocket gsiSocket = null;
        OutputStream out = null;
        InputStream in = null;
        try {
            gsiSocket = this.getSocket(credential);
            out = ((Socket)gsiSocket).getOutputStream();
            in = ((Socket)gsiSocket).getInputStream();
            out.write(msg.getBytes());
            out.flush();
            if (logger.isDebugEnabled()) {
                logger.debug("Req sent:" + params);
            }
            this.handleReply(in);
            CertUtil.writeCertificate(out, certs[0]);
            key.writeTo(out);
            for (int i = 1; i < certs.length; ++i) {
                if (((Object)certs[i].getSubjectDN()).equals(certs[i].getIssuerDN())) continue;
                CertUtil.writeCertificate(out, certs[i]);
            }
            out.write(0);
            out.flush();
            this.handleReply(in);
        }
        catch (Exception e) {
            try {
                throw new MyProxyException("MyProxy store failed.", e);
            }
            catch (Throwable throwable) {
                MyProxy.close(out, in, gsiSocket);
                throw throwable;
            }
        }
        MyProxy.close(out, in, gsiSocket);
    }

    public void destroy(GSSCredential credential, String username, String passphrase) throws MyProxyException {
        DestroyParams request = new DestroyParams();
        request.setUserName(username);
        request.setPassphrase(passphrase);
        this.destroy(credential, request);
    }

    public void destroy(GSSCredential credential, DestroyParams params) throws MyProxyException {
        if (credential == null) {
            throw new IllegalArgumentException("credential == null");
        }
        if (params == null) {
            throw new IllegalArgumentException("params == null");
        }
        String msg = params.makeRequest();
        GssSocket gsiSocket = null;
        OutputStream out = null;
        InputStream in = null;
        try {
            gsiSocket = this.getSocket(credential);
            out = ((Socket)gsiSocket).getOutputStream();
            in = ((Socket)gsiSocket).getInputStream();
            out.write(msg.getBytes());
            out.flush();
            if (logger.isDebugEnabled()) {
                logger.debug("Req sent:" + params);
            }
            this.handleReply(in);
        }
        catch (Exception e) {
            try {
                throw new MyProxyException("MyProxy destroy failed.", e);
            }
            catch (Throwable throwable) {
                MyProxy.close(out, in, gsiSocket);
                throw throwable;
            }
        }
        MyProxy.close(out, in, gsiSocket);
    }

    public void changePassword(GSSCredential credential, ChangePasswordParams params) throws MyProxyException {
        if (credential == null) {
            throw new IllegalArgumentException("credential == null");
        }
        if (params == null) {
            throw new IllegalArgumentException("params == null");
        }
        GssSocket gsiSocket = null;
        OutputStream out = null;
        InputStream in = null;
        String msg = params.makeRequest();
        try {
            gsiSocket = this.getSocket(credential);
            out = ((Socket)gsiSocket).getOutputStream();
            in = ((Socket)gsiSocket).getInputStream();
            out.write(msg.getBytes());
            out.flush();
            if (logger.isDebugEnabled()) {
                logger.debug("Req sent:" + params);
            }
            this.handleReply(in);
        }
        catch (Exception e) {
            try {
                throw new MyProxyException("MyProxy change password failed.", e);
            }
            catch (Throwable throwable) {
                MyProxy.close(out, in, gsiSocket);
                throw throwable;
            }
        }
        MyProxy.close(out, in, gsiSocket);
    }

    public CredentialInfo info(GSSCredential credential, String username, String passphrase) throws MyProxyException {
        InfoParams request = new InfoParams();
        request.setUserName(username);
        request.setPassphrase(passphrase);
        return this.info(credential, request)[0];
    }

    public CredentialInfo[] info(GSSCredential credential, InfoParams params) throws MyProxyException {
        CredentialInfo[] credentialInfoArray;
        if (credential == null) {
            throw new IllegalArgumentException("credential == null");
        }
        if (params == null) {
            throw new IllegalArgumentException("params == null");
        }
        String msg = params.makeRequest();
        CredentialInfo[] creds = null;
        GssSocket gsiSocket = null;
        OutputStream out = null;
        InputStream in = null;
        try {
            gsiSocket = this.getSocket(credential);
            out = ((Socket)gsiSocket).getOutputStream();
            in = ((Socket)gsiSocket).getInputStream();
            out.write(msg.getBytes());
            out.flush();
            if (logger.isDebugEnabled()) {
                logger.debug("Req sent:" + params);
            }
            InputStream reply = this.handleReply(in);
            String line = null;
            String value = null;
            HashMap credMap = new HashMap();
            CredentialInfo info = new CredentialInfo();
            while ((line = MyProxy.readLine(reply)) != null) {
                String name;
                int pos;
                if (line.startsWith(CRED_START_TIME)) {
                    value = line.substring(CRED_START_TIME.length());
                    info.setStartTime(Long.parseLong(value) * 1000L);
                    continue;
                }
                if (line.startsWith(CRED_END_TIME)) {
                    value = line.substring(CRED_END_TIME.length());
                    info.setEndTime(Long.parseLong(value) * 1000L);
                    continue;
                }
                if (line.startsWith(CRED_OWNER)) {
                    info.setOwner(line.substring(CRED_OWNER.length()));
                    continue;
                }
                if (line.startsWith(CRED_NAME)) {
                    info.setName(line.substring(CRED_NAME.length()));
                    continue;
                }
                if (line.startsWith(CRED_DESC)) {
                    info.setDescription(line.substring(CRED_DESC.length()));
                    continue;
                }
                if (line.startsWith(CRED_RENEWER)) {
                    info.setRenewers(line.substring(CRED_RENEWER.length()));
                    continue;
                }
                if (line.startsWith(CRED_RETRIEVER)) {
                    info.setRetrievers(line.substring(CRED_RETRIEVER.length()));
                    continue;
                }
                if (!line.startsWith(CRED) || (pos = line.indexOf(61, CRED.length())) == -1) continue;
                value = line.substring(pos + 1);
                if (this.matches(line, pos + 1, OWNER)) {
                    name = this.getCredName(line, pos, OWNER);
                    this.getCredentialInfo(credMap, name).setOwner(value);
                    continue;
                }
                if (this.matches(line, pos + 1, START_TIME)) {
                    name = this.getCredName(line, pos, START_TIME);
                    this.getCredentialInfo(credMap, name).setStartTime(Long.parseLong(value) * 1000L);
                    continue;
                }
                if (this.matches(line, pos + 1, END_TIME)) {
                    name = this.getCredName(line, pos, END_TIME);
                    this.getCredentialInfo(credMap, name).setEndTime(Long.parseLong(value) * 1000L);
                    continue;
                }
                if (this.matches(line, pos + 1, DESC)) {
                    name = this.getCredName(line, pos, DESC);
                    this.getCredentialInfo(credMap, name).setDescription(value);
                    continue;
                }
                if (this.matches(line, pos + 1, RENEWER)) {
                    name = this.getCredName(line, pos, RENEWER);
                    this.getCredentialInfo(credMap, name).setRenewers(value);
                    continue;
                }
                if (!this.matches(line, pos + 1, RETRIEVER)) continue;
                name = this.getCredName(line, pos, RETRIEVER);
                this.getCredentialInfo(credMap, name).setRetrievers(value);
            }
            creds = new CredentialInfo[1 + credMap.size()];
            creds[0] = info;
            if (credMap.size() > 0) {
                int i = 1;
                Iterator iter = credMap.entrySet().iterator();
                while (iter.hasNext()) {
                    Map.Entry entry = iter.next();
                    creds[i++] = (CredentialInfo)entry.getValue();
                }
            }
            credentialInfoArray = creds;
        }
        catch (Exception e) {
            try {
                throw new MyProxyException("MyProxy info failed.", e);
            }
            catch (Throwable throwable) {
                MyProxy.close(out, in, gsiSocket);
                throw throwable;
            }
        }
        MyProxy.close(out, in, gsiSocket);
        return credentialInfoArray;
    }

    private boolean matches(String line, int pos, String arg) {
        return line.regionMatches(true, pos - arg.length(), arg, 0, arg.length());
    }

    private String getCredName(String line, int pos, String arg) {
        return line.substring(CRED.length(), pos - arg.length());
    }

    private CredentialInfo getCredentialInfo(Map map, String name) {
        CredentialInfo info = (CredentialInfo)map.get(name);
        if (info == null) {
            info = new CredentialInfo();
            info.setName(name);
            map.put(name, info);
        }
        return info;
    }

    public GSSCredential get(String username, String passphrase, int lifetime) throws MyProxyException {
        return this.get(null, username, passphrase, lifetime);
    }

    public GSSCredential get(GSSCredential credential, String username, String passphrase, int lifetime) throws MyProxyException {
        GetParams request = new GetParams();
        request.setUserName(username);
        request.setPassphrase(passphrase);
        request.setLifetime(lifetime);
        return this.get(credential, request);
    }

    public GSSCredential get(GSSCredential credential, GetParams params) throws MyProxyException {
        GlobusGSSCredentialImpl globusGSSCredentialImpl;
        if (params == null) {
            throw new IllegalArgumentException("params == null");
        }
        if (credential == null) {
            try {
                credential = this.getAnonymousCredential();
            }
            catch (GSSException e) {
                throw new MyProxyException("Failed to create anonymous credentials", e);
            }
        }
        String msg = params.makeRequest();
        GssSocket gsiSocket = null;
        OutputStream out = null;
        InputStream in = null;
        try {
            gsiSocket = this.getSocket(credential);
            if (credential.getName().isAnonymous()) {
                this.context.requestAnonymity(true);
            }
            out = ((Socket)gsiSocket).getOutputStream();
            in = ((Socket)gsiSocket).getInputStream();
            out.write(msg.getBytes());
            out.flush();
            if (logger.isDebugEnabled()) {
                logger.debug("Req sent:" + params);
            }
            this.handleReply(in, out, params.getAuthzCreds(), params.getWantTrustroots());
            KeyPair keyPair = CertUtil.generateKeyPair("RSA", 1024);
            BouncyCastleCertProcessingFactory certFactory = BouncyCastleCertProcessingFactory.getDefault();
            byte[] req = null;
            if (credential.getName().isAnonymous()) {
                req = certFactory.createCertificateRequest("CN=ignore", keyPair);
            } else {
                GlobusGSSCredentialImpl pkiCred = (GlobusGSSCredentialImpl)credential;
                req = certFactory.createCertificateRequest(pkiCred.getCertificateChain()[0], keyPair);
            }
            out.write(req);
            out.flush();
            int size = in.read();
            if (logger.isDebugEnabled()) {
                logger.debug("Reading " + size + " certs");
            }
            X509Certificate[] chain = new X509Certificate[size];
            for (int i = 0; i < size; ++i) {
                chain[i] = certFactory.loadCertificate(in);
                if (!logger.isDebugEnabled()) continue;
                logger.debug("Received cert: " + chain[i].getSubjectDN());
            }
            this.handleReply(in);
            RSAPublicKey pkey = (RSAPublicKey)chain[0].getPublicKey();
            RSAPrivateKey prkey = (RSAPrivateKey)keyPair.getPrivate();
            if (!pkey.getModulus().equals(prkey.getModulus())) {
                throw new MyProxyException("Private/Public key mismatch!");
            }
            GlobusCredential newCredential = null;
            newCredential = new GlobusCredential(keyPair.getPrivate(), chain);
            globusGSSCredentialImpl = new GlobusGSSCredentialImpl(newCredential, 0);
        }
        catch (Exception e) {
            try {
                throw new MyProxyException("MyProxy get failed.", e);
            }
            catch (Throwable throwable) {
                MyProxy.close(out, in, gsiSocket);
                throw throwable;
            }
        }
        MyProxy.close(out, in, gsiSocket);
        return globusGSSCredentialImpl;
    }

    public void getTrustroots(GSSCredential credential, GetTrustrootsParams params) throws MyProxyException {
        if (params == null) {
            throw new IllegalArgumentException("params == null");
        }
        if (credential == null) {
            try {
                credential = this.getAnonymousCredential();
            }
            catch (GSSException e) {
                throw new MyProxyException("Failed to create anonymous credentials", e);
            }
        }
        GssSocket gsiSocket = null;
        OutputStream out = null;
        InputStream in = null;
        String msg = params.makeRequest();
        try {
            gsiSocket = this.getSocket(credential);
            if (credential.getName().isAnonymous()) {
                this.context.requestAnonymity(true);
            }
            out = ((Socket)gsiSocket).getOutputStream();
            in = ((Socket)gsiSocket).getInputStream();
            out.write(msg.getBytes());
            out.flush();
            if (logger.isDebugEnabled()) {
                logger.debug("Req sent:" + params);
            }
            this.handleReply(in, out, null, true);
        }
        catch (Exception e) {
            try {
                throw new MyProxyException("MyProxy get-trustroots failed.", e);
            }
            catch (Throwable throwable) {
                MyProxy.close(out, in, gsiSocket);
                throw throwable;
            }
        }
        MyProxy.close(out, in, gsiSocket);
    }

    public void bootstrapTrust() throws MyProxyException {
        try {
            SSLContext sc = SSLContext.getInstance("SSL");
            MyTrustManager myTrustManager = new MyTrustManager();
            TrustManager[] trustAllCerts = new TrustManager[]{myTrustManager};
            sc.init(null, trustAllCerts, new SecureRandom());
            SSLSocketFactory sf = sc.getSocketFactory();
            SSLSocket socket = (SSLSocket)sf.createSocket(this.host, this.port);
            socket.setEnabledProtocols(new String[]{"SSLv3"});
            socket.startHandshake();
            socket.close();
            X509Certificate[] acceptedIssuers = myTrustManager.getAcceptedIssuers();
            if (acceptedIssuers == null) {
                throw new MyProxyException("Failed to determine MyProxy server trust roots in bootstrapTrust.");
            }
            for (int idx = 0; idx < acceptedIssuers.length; ++idx) {
                File x509Dir = new File(MyProxy.getTrustRootPath());
                if (x509Dir.exists()) continue;
                StringBuffer newSubject = new StringBuffer();
                String[] subjArr = acceptedIssuers[idx].getSubjectDN().getName().split(", ");
                for (int i = subjArr.length - 1; i > -1; --i) {
                    newSubject.append("/");
                    newSubject.append(subjArr[i]);
                }
                String subject = newSubject.toString();
                File tmpDir = new File(MyProxy.getTrustRootPath() + "-" + System.currentTimeMillis());
                if (tmpDir.mkdir()) {
                    String hash = MyProxy.opensslHash(acceptedIssuers[idx]);
                    String filename = tmpDir.getPath() + File.separator + hash + ".0";
                    FileOutputStream os = new FileOutputStream(new File(filename));
                    CertUtil.writeCertificate(os, acceptedIssuers[idx]);
                    os.close();
                    if (logger.isDebugEnabled()) {
                        logger.debug("wrote trusted certificate to " + filename);
                    }
                    filename = tmpDir.getPath() + File.separator + hash + ".signing_policy";
                    os = new FileOutputStream(new File(filename));
                    OutputStreamWriter wr = new OutputStreamWriter((OutputStream)os, Charset.forName("UTF-8"));
                    wr.write("access_id_CA X509 '");
                    wr.write(subject);
                    wr.write("'\npos_rights globus CA:sign\ncond_subjects globus \"*\"\n");
                    ((Writer)wr).flush();
                    ((Writer)wr).close();
                    os.close();
                    if (logger.isDebugEnabled()) {
                        logger.debug("wrote trusted certificate policy to " + filename);
                    }
                    if (tmpDir.renameTo(x509Dir)) {
                        if (!logger.isDebugEnabled()) continue;
                        logger.debug("renamed " + tmpDir.getPath() + " to " + x509Dir.getPath());
                        continue;
                    }
                    throw new MyProxyException("Unable to rename " + tmpDir.getPath() + " to " + x509Dir.getPath());
                }
                throw new MyProxyException("Cannot create temporary directory: " + tmpDir.getName());
            }
        }
        catch (Exception e) {
            throw new MyProxyException("MyProxy bootstrapTrust failed.", e);
        }
    }

    private static String readLine(InputStream is) throws IOException {
        StringBuffer sb = new StringBuffer();
        int c = is.read();
        while (c > 0 && c != 10) {
            sb.append((char)c);
            c = is.read();
        }
        if (sb.length() > 0) {
            if (logger.isDebugEnabled()) {
                logger.debug("Received line: " + sb);
            }
            return new String(sb);
        }
        return null;
    }

    private InputStream handleReply(InputStream in) throws IOException, MyProxyException {
        return this.handleReply(in, null, null, false);
    }

    private InputStream handleReply(InputStream in, OutputStream out, GSSCredential authzcreds, boolean wantTrustroots) throws IOException, MyProxyException {
        boolean authzchallenge;
        String tmp = null;
        tmp = MyProxy.readLine(in);
        if (tmp == null) {
            throw new EOFException();
        }
        if (!tmp.endsWith("VERSION=MYPROXYv2")) {
            throw new MyProxyException("Protocol version mismatch: " + tmp);
        }
        tmp = MyProxy.readLine(in);
        if (tmp == null) {
            throw new EOFException();
        }
        if (!tmp.startsWith(RESPONSE)) {
            throw new MyProxyException("Invalid reply: no response message");
        }
        boolean error = tmp.charAt(RESPONSE.length()) == '1';
        boolean bl = authzchallenge = tmp.charAt(RESPONSE.length()) == '2';
        if (error) {
            StringBuffer errorStr = new StringBuffer();
            while ((tmp = MyProxy.readLine(in)) != null) {
                if (!tmp.startsWith(ERROR)) continue;
                if (errorStr.length() > 0) {
                    errorStr.append(' ');
                }
                errorStr.append(tmp.substring(ERROR.length()));
            }
            if (errorStr.length() == 0) {
                errorStr.append("unspecified server error");
            }
            throw new MyProxyException(errorStr.toString());
        }
        if (authzchallenge) {
            if (authzcreds == null) {
                throw new MyProxyException("Unable to respond to server's authentication challenge. No credentials for renewal.");
            }
            if (out == null) {
                throw new MyProxyException("Internal error. Authz challenge but no OutputStream.");
            }
            String[] authzdata = null;
            while ((tmp = MyProxy.readLine(in)) != null) {
                int pos;
                if (!tmp.startsWith(AUTHZ_DATA) || (pos = tmp.indexOf(58, AUTHZ_DATA.length() + 1)) == -1) continue;
                authzdata = new String[]{tmp.substring(AUTHZ_DATA.length(), pos).trim(), tmp.substring(pos + 1).trim()};
            }
            if (authzdata == null) {
                throw new MyProxyException("Unable to parse authorization challenge from server.");
            }
            if (authzdata[0].equals("X509_certificate")) {
                GlobusGSSCredentialImpl pkiCred = (GlobusGSSCredentialImpl)authzcreds;
                try {
                    Signature sig = Signature.getInstance("SHA1withRSA");
                    sig.initSign(pkiCred.getPrivateKey());
                    sig.update(authzdata[1].getBytes());
                    byte[] sigbytes = sig.sign();
                    X509Certificate[] certs = pkiCred.getCertificateChain();
                    ByteArrayOutputStream buffer = new ByteArrayOutputStream(2048);
                    buffer.write(2);
                    buffer.write(0);
                    buffer.write(0);
                    buffer.write(0);
                    buffer.write(0);
                    buffer.write(0);
                    buffer.write(0);
                    buffer.write(sigbytes.length);
                    buffer.write(sigbytes);
                    buffer.write((byte)certs.length);
                    for (int i = 0; i < certs.length; ++i) {
                        buffer.write(certs[i].getEncoded());
                    }
                    out.write(buffer.toByteArray());
                    out.flush();
                }
                catch (Exception e) {
                    throw new MyProxyException("Authz response failed.", e);
                }
                return this.handleReply(in, out, authzcreds, wantTrustroots);
            }
            throw new MyProxyException("Unable to respond to server's authentication challenge. Unimplemented method: " + authzdata[0]);
        }
        if (wantTrustroots) {
            while ((tmp = MyProxy.readLine(in)) != null) {
                if (!tmp.startsWith(TRUSTROOTS)) continue;
                String filenameList = tmp.substring(TRUSTROOTS.length());
                this.trustrootFilenames = filenameList.split(",");
                this.trustrootData = new String[this.trustrootFilenames.length];
                for (int i = 0; i < this.trustrootFilenames.length; ++i) {
                    String lineStart = "FILEDATA_" + this.trustrootFilenames[i] + "=";
                    tmp = MyProxy.readLine(in);
                    if (tmp == null) {
                        throw new EOFException();
                    }
                    if (!tmp.startsWith(lineStart)) {
                        throw new MyProxyException("bad MyProxy protocol RESPONSE: expecting " + lineStart + " but received " + tmp);
                    }
                    this.trustrootData[i] = new String(Base64.decode(tmp.substring(lineStart.length()).getBytes()));
                }
            }
        }
        int avail = in.available();
        byte[] b = new byte[avail];
        if (avail > 0) {
            in.read(b);
        }
        ByteArrayInputStream inn = new ByteArrayInputStream(b);
        return inn;
    }

    private static void close(OutputStream out, InputStream in, Socket sock) {
        try {
            if (out != null) {
                out.close();
            }
            if (in != null) {
                in.close();
            }
            if (sock != null) {
                sock.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static void put(String host, int port, GSSCredential credential, String username, String passphrase, int lifetime) throws MyProxyException {
        MyProxy.put(host, port, credential, username, passphrase, lifetime, null);
    }

    public static void put(String host, int port, GSSCredential credential, String username, String passphrase, int lifetime, String subjectDN) throws MyProxyException {
        MyProxy myProxy = new MyProxy(host, port);
        myProxy.setAuthorization(MyProxy.getAuthorization(subjectDN));
        myProxy.put(credential, username, passphrase, lifetime);
    }

    public static void destroy(String host, int port, GSSCredential credential, String username, String passphrase) throws MyProxyException {
        MyProxy.destroy(host, port, credential, username, passphrase, null);
    }

    public static void destroy(String host, int port, GSSCredential credential, String username, String passphrase, String subjectDN) throws MyProxyException {
        MyProxy myProxy = new MyProxy(host, port);
        myProxy.setAuthorization(MyProxy.getAuthorization(subjectDN));
        myProxy.destroy(credential, username, passphrase);
    }

    public static GSSCredential get(String host, int port, GSSCredential credential, String username, String passphrase, int lifetime) throws MyProxyException {
        return MyProxy.get(host, port, credential, username, passphrase, lifetime, null);
    }

    public static GSSCredential get(String host, int port, GSSCredential credential, String username, String passphrase, int lifetime, String subjectDN) throws MyProxyException {
        MyProxy myProxy = new MyProxy(host, port);
        myProxy.setAuthorization(MyProxy.getAuthorization(subjectDN));
        return myProxy.get(credential, username, passphrase, lifetime);
    }

    private static Authorization getAuthorization(String subjectDN) {
        if (subjectDN == null) {
            return new MyProxyServerAuthorization();
        }
        return new IdentityAuthorization(subjectDN);
    }

    private GSSCredential getAnonymousCredential() throws GSSException {
        GSSManager manager = ExtendedGSSManager.getInstance();
        GSSName anonName = manager.createName((String)null, null);
        return manager.createCredential(anonName, Integer.MAX_VALUE, (Oid)null, 0);
    }

    public static String getTrustRootPath() {
        String path = System.getProperty("X509_CERT_DIR");
        if (path == null) {
            path = System.getProperty("user.home") + TRUSTED_CERT_PATH;
        }
        return path;
    }

    public boolean writeTrustRoots() throws IOException {
        return this.writeTrustRoots(MyProxy.getTrustRootPath());
    }

    public boolean writeTrustRoots(String directory) throws IOException {
        if (this.trustrootFilenames == null || this.trustrootData == null) {
            return false;
        }
        File rootDir = new File(directory);
        if (!rootDir.exists()) {
            rootDir.mkdirs();
        }
        for (int i = 0; i < this.trustrootFilenames.length; ++i) {
            FileOutputStream out = new FileOutputStream(directory + File.separator + this.trustrootFilenames[i]);
            out.write(this.trustrootData[i].getBytes());
            out.close();
        }
        return true;
    }

    private static String opensslHash(X509Certificate cert) {
        try {
            return MyProxy.openssl_X509_NAME_hash(cert.getSubjectX500Principal());
        }
        catch (Exception e) {
            throw new Error("MD5 isn't available!", e);
        }
    }

    private static String openssl_X509_NAME_hash(X500Principal p) throws Exception {
        byte[] derEncodedSubject = p.getEncoded();
        byte[] md5 = MessageDigest.getInstance("MD5").digest(derEncodedSubject);
        byte[] result = new byte[]{md5[3], md5[2], md5[1], md5[0]};
        return MyProxy.toHex(result);
    }

    private static String toHex(byte[] bin) {
        if (bin == null || bin.length == 0) {
            return "";
        }
        char[] buffer = new char[bin.length * 2];
        char[] hex = "0123456789abcdef".toCharArray();
        int j = 0;
        for (int i = 0; i < bin.length; ++i) {
            byte b = bin[i];
            buffer[j++] = hex[b >> 4 & 0xF];
            buffer[j++] = hex[b & 0xF];
        }
        return new String(buffer);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

