/*
 * Decompiled with CFR 0.152.
 */
package org.globus.tools.ui.util;

import java.awt.BorderLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.filechooser.FileFilter;

public class FileBrowser
extends JPanel
implements ActionListener {
    private JTextField file;
    private JButton browser;
    private FileFilter fileFilter;
    boolean specialfilter = false;
    private String title;
    private String okLabel;

    public FileBrowser(String title, String label, String okLabel) {
        this.title = title;
        this.okLabel = okLabel;
        this.file = new JTextField(30);
        this.browser = new JButton("...");
        this.browser.addActionListener(this);
        this.setLayout(new BorderLayout(5, 1));
        this.add("North", new JLabel(label));
        this.add("Center", this.file);
        this.add("East", this.browser);
    }

    public FileBrowser(String title, String okLabel) {
        this.title = title;
        this.okLabel = okLabel;
        this.file = new JTextField(30);
        this.browser = new JButton("...");
        this.browser.addActionListener(this);
        this.setLayout(new BorderLayout(5, 1));
        this.add("Center", this.file);
        this.add("East", this.browser);
    }

    @Override
    public Insets getInsets() {
        return new Insets(5, 2, 5, 2);
    }

    public void enableSpecialFilter() {
        this.specialfilter = true;
    }

    private File getSelectedFile() {
        JFileChooser filechooser = new JFileChooser();
        if (this.fileFilter != null) {
            filechooser.addChoosableFileFilter(this.fileFilter);
            filechooser.setFileFilter(this.fileFilter);
        }
        File ff = null;
        String tt = this.file.getText();
        ff = tt.trim().length() == 0 ? new File(".") : new File(this.file.getText());
        filechooser.setCurrentDirectory(ff);
        filechooser.setSelectedFile(ff);
        filechooser.setApproveButtonText(this.okLabel);
        filechooser.setDialogTitle(this.title);
        if (filechooser.showOpenDialog(this) == 0) {
            File f = filechooser.getSelectedFile();
            return f;
        }
        return null;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        File f = this.getSelectedFile();
        if (f != null) {
            this.file.setText(f.getAbsolutePath());
        }
    }

    public String getFile() {
        return this.file.getText().trim();
    }

    public void setFileFilter(FileFilter filter) {
        this.fileFilter = filter;
    }

    public void setFile(String f) {
        this.file.setText(f);
    }
}

