/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.core.env;

import org.springframework.core.env.AbstractPropertyResolver;
import org.springframework.core.env.PropertySource;
import org.springframework.core.env.PropertySources;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PropertySourcesPropertyResolver
extends AbstractPropertyResolver {
    private final PropertySources propertySources;

    public PropertySourcesPropertyResolver(PropertySources propertySources) {
        this.propertySources = propertySources;
    }

    @Override
    public boolean containsProperty(String key) {
        for (PropertySource propertySource : this.propertySources) {
            if (propertySource.getProperty(key) == null) continue;
            return true;
        }
        return false;
    }

    @Override
    public String getProperty(String key) {
        if (this.logger.isTraceEnabled()) {
            this.logger.trace((Object)String.format("getProperty(\"%s\") (implicit targetType [String])", key));
        }
        return this.getProperty(key, String.class);
    }

    @Override
    public <T> T getProperty(String key, Class<T> targetValueType) {
        boolean debugEnabled = this.logger.isDebugEnabled();
        if (this.logger.isTraceEnabled()) {
            this.logger.trace((Object)String.format("getProperty(\"%s\", %s)", key, targetValueType.getSimpleName()));
        }
        for (PropertySource propertySource : this.propertySources) {
            Object value;
            if (debugEnabled) {
                this.logger.debug((Object)String.format("Searching for key '%s' in [%s]", key, propertySource.getName()));
            }
            if ((value = propertySource.getProperty(key)) == null) continue;
            Class<?> valueType = value.getClass();
            if (debugEnabled) {
                this.logger.debug((Object)String.format("Found key '%s' in [%s] with type [%s] and value '%s'", key, propertySource.getName(), valueType.getSimpleName(), value));
            }
            if (!this.conversionService.canConvert(valueType, targetValueType)) {
                throw new IllegalArgumentException(String.format("Cannot convert value [%s] from source type [%s] to target type [%s]", value, valueType.getSimpleName(), targetValueType.getSimpleName()));
            }
            return this.conversionService.convert(value, targetValueType);
        }
        if (debugEnabled) {
            this.logger.debug((Object)String.format("Could not find key '%s' in any property source. Returning [null]", key));
        }
        return null;
    }
}

