/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.sql.SQLException;
import oracle.jdbc.driver.OracleStatement;

public class LRUStmtCache {
    private static final int _DEFAULT_CACHE_SIZE = 10;
    private int _cacheSize = 10;
    private OracleStatement _cacheS = null;
    private OracleStatement _cacheE = null;
    private int _cacheEles = 0;
    private static final boolean _DEBUG = false;

    public LRUStmtCache() {
        this(10);
    }

    public LRUStmtCache(int n) {
        this._cacheSize = n;
        this._cacheS = null;
        this._cacheE = null;
        this._cacheEles = 0;
    }

    public void add(OracleStatement oracleStatement) throws SQLException {
        if (oracleStatement.m_cacheState == OracleStatement.CACHE) {
            return;
        }
        if (this._cacheEles >= this._cacheSize) {
            OracleStatement oracleStatement2 = this._cacheE;
            this._cacheE = oracleStatement2.prev;
            if (this._cacheE != null) {
                this._cacheE.next = null;
            }
            oracleStatement2.prev = null;
            oracleStatement2.next = null;
            oracleStatement2.m_cacheState = OracleStatement.CLOSED;
            oracleStatement2.close();
            if (this._cacheS == oracleStatement2) {
                this._cacheS = null;
            }
            oracleStatement2 = null;
            --this._cacheEles;
        }
        oracleStatement.m_cacheState = OracleStatement.CACHE;
        oracleStatement.next = this._cacheS;
        if (this._cacheS != null) {
            this._cacheS.prev = oracleStatement;
        }
        if (this._cacheE == null) {
            this._cacheE = oracleStatement;
        }
        this._cacheS = oracleStatement;
        ++this._cacheEles;
    }

    public void close() throws SQLException {
        OracleStatement oracleStatement = this._cacheS;
        while (oracleStatement != null) {
            OracleStatement oracleStatement2 = oracleStatement;
            oracleStatement = oracleStatement2.next;
            oracleStatement2.m_cacheState = OracleStatement.CLOSED;
            oracleStatement2.close();
            oracleStatement2.next = null;
            oracleStatement2.prev = null;
            oracleStatement2 = null;
        }
        this._cacheSize = 0;
        this._cacheS = null;
        this._cacheE = null;
    }

    void debug() {
        System.out.println("_cacheSize is " + this._cacheSize);
        System.out.println("No of Elements in the Cache are " + this._cacheEles);
        System.out.println("Queries in the Cache are : ");
        OracleStatement oracleStatement = this._cacheS;
        while (oracleStatement != null) {
            System.out.println(oracleStatement.getKeyOrQuery());
            oracleStatement = oracleStatement.next;
        }
        if (this._cacheS != null) {
            System.out.println("Start points to " + this._cacheS.getKeyOrQuery());
        }
        if (this._cacheE != null) {
            System.out.println("End points to " + this._cacheE.getKeyOrQuery());
        }
    }

    public int getSize() {
        return this._cacheEles;
    }

    public OracleStatement lookup(String string, int n, int n2) {
        OracleStatement oracleStatement = this._cacheS;
        while (oracleStatement != null) {
            if (oracleStatement.m_stmtType == n && oracleStatement.m_userRsetType == n2 && oracleStatement.sameKey(string)) {
                if (oracleStatement == this._cacheS) {
                    this._cacheS = oracleStatement.next;
                    if (oracleStatement.next != null) {
                        oracleStatement.next.prev = null;
                    }
                } else {
                    if (oracleStatement.next != null) {
                        oracleStatement.next.prev = oracleStatement.prev;
                    }
                    if (oracleStatement.prev != null) {
                        oracleStatement.prev.next = oracleStatement.next;
                    }
                }
                --this._cacheEles;
                if (this._cacheE == oracleStatement) {
                    this._cacheE = oracleStatement.prev;
                }
                oracleStatement.prev = null;
                oracleStatement.next = null;
                oracleStatement.m_cacheState = OracleStatement.ACTIVE;
                return oracleStatement;
            }
            oracleStatement = oracleStatement.next;
        }
        return null;
    }

    public void setCacheSize(int n) throws SQLException {
        if (n >= this._cacheSize || n >= this._cacheEles) {
            this._cacheSize = n;
            return;
        }
        OracleStatement oracleStatement = this._cacheE;
        int n2 = this._cacheEles;
        while (n2 < n && oracleStatement != null) {
            oracleStatement.m_cacheState = OracleStatement.CLOSED;
            oracleStatement.close();
            oracleStatement = oracleStatement.prev;
            --n2;
        }
        if (oracleStatement != null) {
            this._cacheE = oracleStatement;
            oracleStatement.next = null;
            this._cacheEles = n;
            this._cacheSize = n;
        }
    }

    private void trace(String string) {
        System.out.println(string);
    }
}

