/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.xa.client;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Hashtable;
import java.util.Properties;
import javax.sql.XAConnection;
import javax.transaction.xa.XAException;
import oracle.jdbc.dbaccess.DBError;
import oracle.jdbc.xa.client.OracleXAConnection;
import oracle.jdbc.xa.client.OracleXAHeteroCloseCallback;
import oracle.jdbc.xa.client.OracleXAHeteroConnection;

public class OracleXADataSource
extends oracle.jdbc.xa.OracleXADataSource {
    private static final boolean DEBUG = false;
    private boolean m_nativeXA = false;
    private int m_rmid = -1;
    private String m_xaOpenString = null;
    private static boolean s_libraryLoaded = false;
    private static final String s_dbSuffix = "HeteroXA";
    private static final String s_dllName = "heteroxa9";

    private native int convert_oci_handles(String var1, long[] var2);

    private native int do_xa_open(String var1, int var2, int var3, int var4);

    private int generateRmid(String string) {
        return string.hashCode();
    }

    private String generateXACloseString(String string, boolean bl) {
        return new String("ORACLE_XA+DB=" + string + (bl ? "+CONNCACHE=t" : "+CONNCACHE=f"));
    }

    private String generateXAOpenString(String string, String string2, String string3, String string4, int n, int n2, boolean bl, boolean bl2, String string5, int n3, boolean bl3) {
        return new String("ORACLE_XA+DB=" + string + "+ACC=P/" + string3 + "/" + string4 + "+SESTM=" + n2 + "+SESWT=" + n + "+LOGDIR=" + string5 + "+SQLNET=" + string2 + (bl ? "+THREADS=true" : "") + (bl2 ? "+OBJECTS=true" : "") + "+DBGFL=0x" + n3 + (bl3 ? "+CONNCACHE=t" : "+CONNCACHE=f"));
    }

    public synchronized boolean getNativeXA() {
        return this.m_nativeXA;
    }

    synchronized int getRmid() {
        return this.m_rmid;
    }

    public XAConnection getXAConnection() throws SQLException {
        return this.getXAConnection(this.m_user, this.m_password);
    }

    public XAConnection getXAConnection(String string, String string2) throws SQLException {
        try {
            String string3 = this.getURL();
            if (this.m_nativeXA && (string3.startsWith("jdbc:oracle:oci8") || string3.startsWith("jdbc:oracle:oci"))) {
                Object object;
                long[] lArray = new long[2];
                Properties properties = new Properties();
                if (this.m_tnsentry == null) {
                    DBError.throwSqlException(207);
                }
                if (!s_libraryLoaded) {
                    object = this.getClass();
                    synchronized (object) {
                        if (!s_libraryLoaded) {
                            try {
                                System.loadLibrary(s_dllName);
                                s_libraryLoaded = true;
                            }
                            catch (Error error) {
                                s_libraryLoaded = false;
                                throw error;
                            }
                        }
                    }
                }
                object = String.valueOf(this.m_databaseName) + s_dbSuffix + System.currentTimeMillis();
                this.m_rmid = this.generateRmid((String)object);
                int n = 0;
                this.m_xaOpenString = this.generateXAOpenString((String)object, this.m_tnsentry, this.m_user, this.m_password, 60, 2000, true, false, ".", n, false);
                String string4 = this.generateXACloseString((String)object, false);
                int n2 = this.do_xa_open(this.m_xaOpenString, this.m_rmid, 0, 0);
                if (n2 != 0) {
                    DBError.throwSqlException(-1 * n2);
                }
                if ((n2 = this.convert_oci_handles((String)object, lArray)) != 0) {
                    DBError.throwSqlException(-1 * n2);
                }
                ((Hashtable)properties).put("user", this.m_user);
                ((Hashtable)properties).put("password", this.m_password);
                ((Hashtable)properties).put("OCISvcCtxHandle", String.valueOf(lArray[0]));
                ((Hashtable)properties).put("OCIEnvHandle", String.valueOf(lArray[1]));
                Connection connection = DriverManager.getConnection(this.getURL(), properties);
                OracleXAHeteroConnection oracleXAHeteroConnection = new OracleXAHeteroConnection(connection);
                oracleXAHeteroConnection.setRmid(this.m_rmid);
                oracleXAHeteroConnection.setXaCloseString(string4);
                oracleXAHeteroConnection.registerCloseCallback(new OracleXAHeteroCloseCallback(), oracleXAHeteroConnection);
                return oracleXAHeteroConnection;
            }
            return new OracleXAConnection(super.getPhysicalConnection(string, string2));
        }
        catch (XAException xAException) {
            return null;
        }
    }

    synchronized String getXaOpenString() {
        return this.m_xaOpenString;
    }

    public synchronized void setNativeXA(boolean bl) {
        this.m_nativeXA = bl;
    }

    synchronized void setRmid(int n) {
        this.m_rmid = n;
    }

    synchronized void setXaOpenString(String string) {
        this.m_xaOpenString = string;
    }
}

