/*
 * Decompiled with CFR 0.152.
 */
package org.birncommunity.sample.gridftp;

import java.io.File;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.birncommunity.sample.proxy.LocalCredentialHelper;
import org.birncommunity.util.MethodParameterChecker;
import org.globus.ftp.GridFTPClient;

public class TwoPartyTransfer {
    private static Log log = LogFactory.getLog(TwoPartyTransfer.class);
    private String host;
    private int port;
    private String source;
    private String dest;
    private String direction;

    public static void main(String[] args) throws Exception {
        if (args.length != 5 || args[0].equals("-h") || args[0].equals("--help")) {
            log.error((Object)("Usage: java " + TwoPartyTransfer.class.getName() + " <host> <port> <direction> <sourceFile> <base destFile>"));
            log.error((Object)"host: GridFTP server hostname");
            log.error((Object)"port: GridFTP server port");
            log.error((Object)"direction: \"download\" || \"upload\"");
            log.error((Object)"sourceFile: source file");
            log.error((Object)"destFile: destination file");
            log.error((Object)"");
            log.error((Object)"A user proxy certificate needs to be in place in /tmp");
            log.error((Object)"");
            log.error((Object)("Example: java " + TwoPartyTransfer.class.getName() + " chi-vm-4.isi.edu 2811 download /tmp/testfile /tmp/testfile"));
            log.error((Object)"This will transfer chi-vm-4.isi.edu/tmp/testfile into /tmp/testfile");
            System.exit(1);
        }
        String host = args[0];
        int port = new Integer(args[1]);
        String direction = args[2];
        String source = args[3];
        String dest = args[4];
        new TwoPartyTransfer(host, port, source, dest, direction).doTransfer();
    }

    public TwoPartyTransfer(String host, int port, String source, String dest, String direction) {
        new MethodParameterChecker().verifyNotNull(new Object[]{host, port, source, dest, direction});
        if (!direction.equals("download") && !direction.equals("upload")) {
            throw new IllegalArgumentException("Invalid direction: \"download\" || \"upload\"");
        }
        this.host = host;
        this.port = port;
        this.source = source;
        this.dest = dest;
        this.direction = direction;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doTransfer() throws Exception {
        GridFTPClient client = null;
        try {
            client = new GridFTPClient(this.host, this.port);
            client.authenticate(new LocalCredentialHelper().getDefaultCredential());
            client.setType(1);
            client.setPassive();
            client.setLocalActive();
            if (this.direction.equals("download")) {
                client.get(this.source, new File(this.dest));
            } else {
                client.put(new File(this.source), this.dest, false);
            }
        }
        finally {
            try {
                if (client != null) {
                    client.close(true);
                }
            }
            catch (Exception e) {
                log.error((Object)"Can't close connection.", (Throwable)e);
            }
        }
    }
}

