/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.examples.simpleviewer;

import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.Serializable;
import java.net.URL;
import java.net.URLConnection;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import javax.imageio.ImageIO;
import javax.media.jai.JAI;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextPane;
import javax.swing.text.BadLocationException;
import org.jpedal.PdfDecoder;
import org.jpedal.examples.simpleviewer.RecentDocuments;
import org.jpedal.examples.simpleviewer.Values;
import org.jpedal.examples.simpleviewer.gui.SwingGUI;
import org.jpedal.examples.simpleviewer.gui.generic.GUISearchWindow;
import org.jpedal.examples.simpleviewer.gui.generic.GUIThumbnailPanel;
import org.jpedal.examples.simpleviewer.gui.popups.AddHeaderFooterToPDFPages;
import org.jpedal.examples.simpleviewer.gui.popups.CropPDFPages;
import org.jpedal.examples.simpleviewer.gui.popups.DeletePDFPages;
import org.jpedal.examples.simpleviewer.gui.popups.EncryptPDFDocument;
import org.jpedal.examples.simpleviewer.gui.popups.ErrorDialog;
import org.jpedal.examples.simpleviewer.gui.popups.ExtractPDFPagesNup;
import org.jpedal.examples.simpleviewer.gui.popups.InsertBlankPDFPage;
import org.jpedal.examples.simpleviewer.gui.popups.RotatePDFPages;
import org.jpedal.examples.simpleviewer.gui.popups.SaveBitmap;
import org.jpedal.examples.simpleviewer.gui.popups.SaveImage;
import org.jpedal.examples.simpleviewer.gui.popups.SavePDF;
import org.jpedal.examples.simpleviewer.gui.popups.SaveText;
import org.jpedal.examples.simpleviewer.gui.popups.StampImageToPDFPages;
import org.jpedal.examples.simpleviewer.gui.popups.StampTextToPDFPages;
import org.jpedal.examples.simpleviewer.gui.swing.SearchList;
import org.jpedal.examples.simpleviewer.utils.Exporter;
import org.jpedal.examples.simpleviewer.utils.FileFilterer;
import org.jpedal.examples.simpleviewer.utils.IconiseImage;
import org.jpedal.examples.simpleviewer.utils.ItextFunctions;
import org.jpedal.examples.simpleviewer.utils.Printer;
import org.jpedal.examples.simpleviewer.utils.PropertiesFile;
import org.jpedal.exception.PdfException;
import org.jpedal.grouping.PdfGroupingAlgorithms;
import org.jpedal.io.JAIHelper;
import org.jpedal.objects.PdfFileInformation;
import org.jpedal.objects.PdfPageData;
import org.jpedal.objects.acroforms.rendering.AcroRenderer;
import org.jpedal.utils.BrowserLauncher;
import org.jpedal.utils.LogWriter;
import org.jpedal.utils.Messages;
import org.jpedal.utils.Strip;
import org.jpedal.utils.SwingWorker;

public class Commands {
    public static final int INFO = 1;
    public static final int BITMAP = 2;
    public static final int IMAGES = 3;
    public static final int TEXT = 4;
    public static final int SAVE = 5;
    public static final int PRINT = 6;
    public static final int EXIT = 7;
    public static final int AUTOSCROLL = 8;
    public static final int DOCINFO = 9;
    public static final int OPENFILE = 10;
    public static final int FIND = 12;
    public static final int SNAPSHOT = 13;
    public static final int OPENURL = 14;
    public static final int VISITWEBSITE = 15;
    public static final int PREVIOUSDOCUMENT = 16;
    public static final int NEXTDOCUMENT = 17;
    public static final int PREVIOUSRESULT = 18;
    public static final int NEXTRESULT = 19;
    public static final int FIRSTPAGE = 50;
    public static final int FBACKPAGE = 51;
    public static final int BACKPAGE = 52;
    public static final int FORWARDPAGE = 53;
    public static final int FFORWARDPAGE = 54;
    public static final int LASTPAGE = 55;
    public static final int GOTO = 56;
    public static final int SINGLE = 57;
    public static final int CONTINUOUS = 58;
    public static final int CONTINUOUS_FACING = 59;
    public static final int FACING = 60;
    public static final int FULLSCREEN = 61;
    public static final int QUALITY = 250;
    public static final int ROTATION = 251;
    public static final int SCALING = 252;
    public static final int SAVEFORM = 500;
    public static final int PDF = 501;
    public static final int ROTATE = 502;
    public static final int DELETE = 503;
    public static final int ADD = 504;
    public static final int SECURITY = 505;
    public static final int ADDHEADERFOOTER = 506;
    public static final int STAMPTEXT = 507;
    public static final int STAMPIMAGE = 508;
    public static final int SETCROP = 509;
    public static final int NUP = 510;
    public static final int HANDOUTS = 511;
    private Values commonValues;
    private SwingGUI currentGUI;
    private PdfDecoder decode_pdf;
    private GUIThumbnailPanel thumbnails;
    Window win;
    private BufferedImage img = null;
    private int noOfRecentDocs;
    private RecentDocuments recent;
    private JMenuItem[] recentDocuments;
    private final Font headFont = new Font("SansSerif", 1, 14);
    private boolean display = true;
    private PropertiesFile properties;
    private final GUISearchWindow searchFrame;
    private SearchList results;
    private Printer currentPrinter;
    private boolean isOpening;
    private boolean fileIsURL;
    private int lastSearchIndex = 0;

    public Commands(Values values, SwingGUI swingGUI, PdfDecoder pdfDecoder, GUIThumbnailPanel gUIThumbnailPanel, PropertiesFile propertiesFile, GUISearchWindow gUISearchWindow, Printer printer) {
        this.commonValues = values;
        this.currentGUI = swingGUI;
        this.decode_pdf = pdfDecoder;
        this.thumbnails = gUIThumbnailPanel;
        this.properties = propertiesFile;
        this.currentPrinter = printer;
        this.noOfRecentDocs = propertiesFile.getNoRecentDocumentsToDisplay();
        this.recentDocuments = new JMenuItem[this.noOfRecentDocs];
        this.recent = new RecentDocuments(this.noOfRecentDocs, propertiesFile);
        this.searchFrame = gUISearchWindow;
    }

    public void executeCommand(int n) {
        switch (n) {
            case 1: {
                this.currentGUI.getInfoBox();
                break;
            }
            case 2: {
                if (this.commonValues.getSelectedFile() == null) {
                    JOptionPane.showMessageDialog(this.currentGUI.getFrame(), Messages.getMessage("PdfViewer.OpenFile"));
                    break;
                }
                SaveBitmap saveBitmap = new SaveBitmap(this.commonValues.getInputDir(), this.commonValues.getPageCount(), this.commonValues.getCurrentPage());
                int n2 = saveBitmap.display(this.currentGUI.getFrame(), Messages.getMessage("PdfViewer.SaveAsBitmap"));
                if (this.fileIsURL) {
                    this.currentGUI.showMessageDialog(Messages.getMessage("PdfViewerMessage.CannotExportFromURL"));
                    break;
                }
                if (n2 != 0) break;
                Exporter exporter = new Exporter(this.currentGUI, this.commonValues.getSelectedFile(), this.decode_pdf);
                exporter.extractPagesAsImages(saveBitmap);
                break;
            }
            case 3: {
                if (this.commonValues.getSelectedFile() == null) {
                    this.currentGUI.showMessageDialog(Messages.getMessage("PdfViewer.NoFile"));
                    break;
                }
                SaveImage saveImage = new SaveImage(this.commonValues.getInputDir(), this.commonValues.getPageCount(), this.commonValues.getCurrentPage());
                int n3 = saveImage.display(this.currentGUI.getFrame(), Messages.getMessage("PdfViewerTitle.SaveImagesFromPageRange"));
                if (this.fileIsURL) {
                    this.currentGUI.showMessageDialog(Messages.getMessage("PdfViewerMessage.CannotExportFromURL"));
                    break;
                }
                if (n3 != 0) break;
                Exporter exporter = new Exporter(this.currentGUI, this.commonValues.getSelectedFile(), this.decode_pdf);
                exporter.extractImagesOnPages(saveImage);
                break;
            }
            case 4: {
                if (this.commonValues.getSelectedFile() == null) {
                    this.currentGUI.showMessageDialog(Messages.getMessage("PdfViewer.NoFile"));
                    break;
                }
                if (!this.decode_pdf.isExtractionAllowed()) {
                    this.currentGUI.showMessageDialog("Not allowed");
                    break;
                }
                SaveText saveText = new SaveText(this.commonValues.getInputDir(), this.commonValues.getPageCount(), this.commonValues.getCurrentPage());
                int n4 = saveText.display(this.currentGUI.getFrame(), Messages.getMessage("PdfViewerTitle.SaveTextFromPageRange"));
                if (this.fileIsURL) {
                    this.currentGUI.showMessageDialog(Messages.getMessage("PdfViewerMessage.CannotExportFromURL"));
                    break;
                }
                if (n4 != 0) break;
                Exporter exporter = new Exporter(this.currentGUI, this.commonValues.getSelectedFile(), this.decode_pdf);
                exporter.extractTextOnPages(saveText);
                break;
            }
            case 5: {
                this.saveFile();
                break;
            }
            case 6: {
                if (this.commonValues.getSelectedFile() != null) {
                    if (!this.currentPrinter.isPrinting()) {
                        if (!this.commonValues.isPDF()) {
                            this.currentGUI.showMessageDialog(Messages.getMessage("PdfViewer.ImagePrinting"));
                            break;
                        }
                        this.currentPrinter.printPDF(this.decode_pdf, this.currentGUI);
                        break;
                    }
                    this.currentGUI.showMessageDialog(Messages.getMessage("PdfViewerPrintFinish.message"));
                    break;
                }
                this.currentGUI.showMessageDialog(Messages.getMessage("PdfViewerNoFile.message"));
                break;
            }
            case 7: {
                if (this.currentPrinter.isPrinting()) {
                    this.currentGUI.showMessageDialog(Messages.getMessage("PdfViewerStillPrinting.text"));
                    break;
                }
                this.exit();
                break;
            }
            case 8: {
                this.currentGUI.toogleAutoScrolling();
                break;
            }
            case 9: {
                if (!this.commonValues.isPDF()) {
                    this.currentGUI.showMessageDialog(Messages.getMessage("PdfViewer.ImageSearch"));
                    break;
                }
                this.currentGUI.showDocumentProperties(this.commonValues.getSelectedFile(), this.commonValues.getInputDir(), this.commonValues.getFileSize(), this.commonValues.getPageCount(), this.commonValues.getCurrentPage());
                break;
            }
            case 10: {
                this.handleUnsaveForms();
                if (this.currentPrinter.isPrinting()) {
                    this.currentGUI.showMessageDialog(Messages.getMessage("PdfViewerPrintWait.message"));
                    break;
                }
                if (this.commonValues.isProcessing() || this.isOpening) {
                    this.currentGUI.showMessageDialog(Messages.getMessage("PdfViewerDecodeWait.message"));
                    break;
                }
                if (this.commonValues.isContentExtractor()) {
                    this.currentGUI.setPDFOutlineVisible(false);
                }
                this.selectFile();
                this.fileIsURL = false;
                break;
            }
            case 13: {
                if (this.decode_pdf.getDisplayView() != 1) {
                    this.currentGUI.showMessageDialog(Messages.getMessage("PageLayoutMessage.SinglePageOnly"));
                    break;
                }
                this.commonValues.toggleExtractImageOnSelection();
                this.currentGUI.toggleSnapshotButton();
                break;
            }
            case 12: {
                if (this.commonValues.getSelectedFile() == null) {
                    this.currentGUI.showMessageDialog(Messages.getMessage("PdfViewer.NoFile"));
                    break;
                }
                if (!this.commonValues.isPDF()) {
                    this.currentGUI.showMessageDialog(Messages.getMessage("PdfViewer.ImageSearch"));
                    break;
                }
                if (this.decode_pdf.getDisplayView() != 1) {
                    this.currentGUI.showMessageDialog(Messages.getMessage("PageLayoutMessage.SinglePageOnly"));
                    break;
                }
                if (!this.searchFrame.isSearchVisible()) {
                    this.searchFrame.find();
                    break;
                }
                this.searchFrame.grabFocusInInput();
                break;
            }
            case 14: {
                this.handleUnsaveForms();
                if (this.currentPrinter.isPrinting()) {
                    this.currentGUI.showMessageDialog(Messages.getMessage("PdfViewerPrintWait.message"));
                    break;
                }
                if (this.commonValues.isProcessing() || this.isOpening) {
                    this.currentGUI.showMessageDialog(Messages.getMessage("PdfViewerDecodeWait.message"));
                    break;
                }
                this.currentGUI.resetNavBar();
                String string = this.selectURL();
                if (string == null) break;
                this.commonValues.setSelectedFile(string);
                this.fileIsURL = true;
                break;
            }
            case 15: {
                try {
                    BrowserLauncher.openURL(Messages.getMessage("PdfViewer.VisitWebsite"));
                }
                catch (IOException iOException) {
                    this.currentGUI.showMessageDialog(Messages.getMessage("PdfViewer.ErrorWebsite"));
                }
                break;
            }
            case 16: {
                if (this.currentPrinter.isPrinting()) {
                    this.currentGUI.showMessageDialog(Messages.getMessage("PdfViewerPrintWait.message"));
                    break;
                }
                if (this.commonValues.isProcessing() || this.isOpening) {
                    this.currentGUI.showMessageDialog(Messages.getMessage("PdfViewerDecodeWait.message"));
                    break;
                }
                String string = this.recent.getPreviousDocument();
                if (string == null) break;
                this.open(string);
                break;
            }
            case 17: {
                if (this.currentPrinter.isPrinting()) {
                    this.currentGUI.showMessageDialog(Messages.getMessage("PdfViewerPrintWait.message"));
                    break;
                }
                if (this.commonValues.isProcessing() || this.isOpening) {
                    this.currentGUI.showMessageDialog(Messages.getMessage("PdfViewerDecodeWait.message"));
                    break;
                }
                String string = this.recent.getNextDocument();
                if (string == null) break;
                this.open(string);
                break;
            }
            case 18: {
                this.results = this.searchFrame.getResults();
                this.results.setSelectedIndex(this.results.getSelectedIndex() - 1);
                if (this.results.getSelectedIndex() == this.lastSearchIndex) {
                    int n5 = this.results.getLength();
                    this.results.setSelectedIndex(n5);
                    while (this.results.getSelectedIndex() == 0) {
                        this.results.setSelectedIndex(--n5);
                        if (n5 != 0) continue;
                        try {
                            throw new Exception("Error on Previous Loop");
                        }
                        catch (Exception exception) {
                            exception.printStackTrace();
                        }
                    }
                }
                this.lastSearchIndex = this.results.getSelectedIndex();
                if (this.commonValues.isProcessing()) break;
                float f = this.currentGUI.getScaling();
                int n6 = this.currentGUI.getPDFDisplayInset();
                int n7 = this.results.getSelectedIndex();
                this.decode_pdf.setFoundTextAreas(null);
                if (n7 == -1) break;
                Integer n8 = new Integer(n7);
                Object v = this.results.getTextPages().get(n8);
                if (v == null) break;
                int n9 = (Integer)v;
                Rectangle rectangle = (Rectangle)this.searchFrame.getTextRectangles().get(n8);
                if (this.commonValues.getCurrentPage() != n9) {
                    this.commonValues.setCurrentPage(n9);
                    this.currentGUI.resetStatusMessage(Messages.getMessage("PdfViewer.LoadingPage") + ' ' + this.commonValues.getCurrentPage());
                    this.decode_pdf.setPageParameters(f, this.commonValues.getCurrentPage());
                    this.currentGUI.decodePage(false);
                    this.decode_pdf.invalidate();
                }
                int n10 = this.decode_pdf.getScrollInterval();
                int n11 = (int)((float)(rectangle.x - this.currentGUI.cropX) * f) + n6;
                int n12 = (int)((float)(this.currentGUI.cropH - (rectangle.y - this.currentGUI.cropY)) * f) + n6;
                int n13 = (int)((float)rectangle.width * f);
                int n14 = (int)((float)rectangle.height * f);
                Rectangle rectangle2 = new Rectangle(n11 - n10, n12 - n14 - n10, n13 + n10 * 2, n14 + n10 * 2);
                this.decode_pdf.scrollRectToVisible(rectangle2);
                this.decode_pdf.setFoundTextArea(rectangle);
                this.decode_pdf.invalidate();
                this.decode_pdf.repaint();
                break;
            }
            case 19: {
                this.results = this.searchFrame.getResults();
                this.results.setSelectedIndex(this.results.getSelectedIndex() + 1);
                if (this.results.getSelectedIndex() == this.lastSearchIndex) {
                    this.results.setSelectedIndex(0);
                }
                this.lastSearchIndex = this.results.getSelectedIndex();
                if (this.commonValues.isProcessing()) break;
                float f = this.currentGUI.getScaling();
                int n15 = this.currentGUI.getPDFDisplayInset();
                int n16 = this.results.getSelectedIndex();
                this.decode_pdf.setFoundTextAreas(null);
                if (n16 == -1) break;
                Integer n17 = new Integer(n16);
                Object v = this.results.getTextPages().get(n17);
                if (v == null) break;
                int n18 = (Integer)v;
                Rectangle rectangle = (Rectangle)this.searchFrame.getTextRectangles().get(n17);
                if (this.commonValues.getCurrentPage() != n18) {
                    this.commonValues.setCurrentPage(n18);
                    this.currentGUI.resetStatusMessage(Messages.getMessage("PdfViewer.LoadingPage") + ' ' + this.commonValues.getCurrentPage());
                    this.decode_pdf.setPageParameters(f, this.commonValues.getCurrentPage());
                    this.currentGUI.decodePage(false);
                    this.decode_pdf.invalidate();
                }
                int n19 = this.decode_pdf.getScrollInterval();
                int n20 = (int)((float)(rectangle.x - this.currentGUI.cropX) * f) + n15;
                int n21 = (int)((float)(this.currentGUI.cropH - (rectangle.y - this.currentGUI.cropY)) * f) + n15;
                int n22 = (int)((float)rectangle.width * f);
                int n23 = (int)((float)rectangle.height * f);
                Rectangle rectangle3 = new Rectangle(n20 - n19, n21 - n23 - n19, n22 + n19 * 2, n23 + n19 * 2);
                this.decode_pdf.scrollRectToVisible(rectangle3);
                this.decode_pdf.setFoundTextArea(rectangle);
                this.decode_pdf.invalidate();
                this.decode_pdf.repaint();
                break;
            }
            case 50: {
                if (this.commonValues.getSelectedFile() == null || this.commonValues.getPageCount() <= 1 || this.commonValues.getCurrentPage() == 1) break;
                this.back(this.commonValues.getCurrentPage() - 1);
                break;
            }
            case 51: {
                if (this.commonValues.getSelectedFile() == null) break;
                if (this.commonValues.getCurrentPage() < 10) {
                    this.back(this.commonValues.getCurrentPage() - 1);
                    break;
                }
                this.back(10);
                break;
            }
            case 52: {
                if (this.commonValues.getSelectedFile() == null) break;
                this.back(1);
                break;
            }
            case 53: {
                if (this.commonValues.getSelectedFile() == null) break;
                this.forward(1);
                break;
            }
            case 54: {
                if (this.commonValues.getSelectedFile() == null) break;
                if (this.commonValues.getPageCount() < this.commonValues.getCurrentPage() + 10) {
                    this.forward(this.commonValues.getPageCount() - this.commonValues.getCurrentPage());
                    break;
                }
                this.forward(10);
                break;
            }
            case 55: {
                if (this.commonValues.getSelectedFile() == null || this.commonValues.getPageCount() <= 1 || this.commonValues.getPageCount() - this.commonValues.getCurrentPage() <= 0) break;
                this.forward(this.commonValues.getPageCount() - this.commonValues.getCurrentPage());
                break;
            }
            case 56: {
                String string = this.currentGUI.showInputDialog(Messages.getMessage("PdfViewer.EnterPageNumber"), Messages.getMessage("PdfViewer.GotoPage"), 3);
                if (string == null) break;
                this.gotoPage(string);
                break;
            }
            case 57: {
                this.currentGUI.alignLayoutMenuOption(1);
                this.decode_pdf.setDisplayView(1, 2);
                this.currentGUI.resetRotationBox();
                break;
            }
            case 58: {
                this.currentGUI.alignLayoutMenuOption(2);
                this.decode_pdf.setDisplayView(2, 2);
                this.currentGUI.setSelectedComboIndex(251, 0);
                break;
            }
            case 59: {
                this.currentGUI.alignLayoutMenuOption(4);
                this.decode_pdf.setDisplayView(4, 2);
                this.currentGUI.setSelectedComboIndex(251, 0);
                break;
            }
            case 60: {
                this.currentGUI.alignLayoutMenuOption(3);
                this.decode_pdf.setDisplayView(3, 2);
                this.currentGUI.decodePage(false);
                this.currentGUI.setSelectedComboIndex(251, 0);
                break;
            }
            case 61: {
                Component component;
                GraphicsEnvironment graphicsEnvironment = GraphicsEnvironment.getLocalGraphicsEnvironment();
                GraphicsDevice graphicsDevice = graphicsEnvironment.getDefaultScreenDevice();
                if (graphicsDevice.isFullScreenSupported()) {
                    // empty if block
                }
                if (this.win == null) {
                    component = new Frame(graphicsDevice.getDefaultConfiguration());
                    this.win = new Window((Frame)component);
                }
                this.currentGUI.getFrame().getContentPane().remove(this.currentGUI.getDisplayPane());
                this.win.add((Component)this.currentGUI.getDisplayPane(), "Center");
                component = new Button("Return");
                this.win.add(component, "North");
                ((Button)component).addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent actionEvent) {
                        GraphicsEnvironment graphicsEnvironment = GraphicsEnvironment.getLocalGraphicsEnvironment();
                        GraphicsDevice graphicsDevice = graphicsEnvironment.getDefaultScreenDevice();
                        graphicsDevice.setFullScreenWindow(null);
                        Commands.this.win.remove(Commands.this.currentGUI.getDisplayPane());
                        Commands.this.currentGUI.getFrame().getContentPane().add((Component)Commands.this.currentGUI.getDisplayPane(), "Center");
                        Commands.this.currentGUI.getDisplayPane().invalidate();
                        Commands.this.currentGUI.getDisplayPane().updateUI();
                        Commands.this.currentGUI.getFrame().getContentPane().validate();
                        Commands.this.win.dispose();
                    }
                });
                try {
                    graphicsDevice.setFullScreenWindow(this.win);
                    this.win.validate();
                }
                catch (Error error) {
                    this.currentGUI.showMessageDialog("Full screen mode not supported on this machine.\nJPedal will now exit");
                    this.exit();
                }
                break;
            }
            case 250: {
                if (this.commonValues.isProcessing()) break;
                boolean bl = true;
                if (this.currentGUI.getSelectedComboIndex(250) == 0) {
                    bl = false;
                }
                if (this.commonValues.getSelectedFile() == null) break;
                this.decode_pdf.unsetScaling();
                this.currentGUI.showMessageDialog(Messages.getMessage("PdfViewerReparseWait.message"));
                this.decode_pdf.useHiResScreenDisplay(bl);
                this.commonValues.setUseHiresImage(bl);
                try {
                    this.currentGUI.decodePage(false);
                }
                catch (Exception exception) {
                    System.err.println("Exception " + exception + "decoding page after image quality changes");
                    exception.printStackTrace();
                }
                break;
            }
            case 252: {
                if (this.commonValues.isProcessing() || this.commonValues.getSelectedFile() == null) break;
                this.currentGUI.zoom(false);
                break;
            }
            case 251: {
                if (this.commonValues.getSelectedFile() == null) break;
                this.currentGUI.rotate();
                break;
            }
            case 500: {
                this.saveChangedForm();
                break;
            }
            case 501: {
                if (this.commonValues.getSelectedFile() == null) {
                    this.currentGUI.showMessageDialog(Messages.getMessage("PdfViewer.NoFile"));
                    break;
                }
                SavePDF savePDF = new SavePDF(this.commonValues.getInputDir(), this.commonValues.getPageCount(), this.commonValues.getCurrentPage());
                int n24 = savePDF.display(this.currentGUI.getFrame(), Messages.getMessage("PdfViewerTitle.SavePagesAsPdf"));
                if (n24 != 0) break;
                ItextFunctions itextFunctions = new ItextFunctions(this.currentGUI, this.commonValues.getSelectedFile(), this.decode_pdf);
                itextFunctions.extractPagesToNewPDF(savePDF);
                break;
            }
            case 502: {
                if (this.commonValues.getSelectedFile() == null) {
                    this.currentGUI.showMessageDialog(Messages.getMessage("PdfViewer.NoFile"));
                    break;
                }
                RotatePDFPages rotatePDFPages = new RotatePDFPages(this.commonValues.getInputDir(), this.commonValues.getPageCount(), this.commonValues.getCurrentPage());
                int n25 = rotatePDFPages.display(this.currentGUI.getFrame(), Messages.getMessage("PdfViewerRotation.text"));
                if (n25 != 0) break;
                PdfPageData pdfPageData = this.decode_pdf.getPdfPageData();
                this.decode_pdf.closePdfFile();
                ItextFunctions itextFunctions = new ItextFunctions(this.currentGUI, this.commonValues.getSelectedFile(), this.decode_pdf);
                itextFunctions.rotate(this.commonValues.getPageCount(), pdfPageData, rotatePDFPages);
                this.open(this.commonValues.getSelectedFile());
                break;
            }
            case 509: {
                if (this.commonValues.getSelectedFile() == null) {
                    this.currentGUI.showMessageDialog(Messages.getMessage("PdfViewer.NoFile"));
                    break;
                }
                CropPDFPages cropPDFPages = new CropPDFPages(this.commonValues.getInputDir(), this.commonValues.getPageCount(), this.commonValues.getCurrentPage());
                int n26 = cropPDFPages.display(this.currentGUI.getFrame(), Messages.getMessage("PdfViewerTooltip.PDFCropPages"));
                if (n26 != 0) break;
                PdfPageData pdfPageData = this.decode_pdf.getPdfPageData();
                this.decode_pdf.closePdfFile();
                ItextFunctions itextFunctions = new ItextFunctions(this.currentGUI, this.commonValues.getSelectedFile(), this.decode_pdf);
                itextFunctions.setCrop(this.commonValues.getPageCount(), pdfPageData, cropPDFPages);
                this.open(this.commonValues.getSelectedFile());
                break;
            }
            case 510: {
                if (this.commonValues.getSelectedFile() == null) {
                    this.currentGUI.showMessageDialog(Messages.getMessage("PdfViewer.NoFile"));
                    break;
                }
                ExtractPDFPagesNup extractPDFPagesNup = new ExtractPDFPagesNup(this.commonValues.getInputDir(), this.commonValues.getPageCount(), this.commonValues.getCurrentPage());
                int n27 = extractPDFPagesNup.display(this.currentGUI.getFrame(), Messages.getMessage("PdfViewerNUP.titlebar"));
                if (n27 != 0) break;
                PdfPageData pdfPageData = this.decode_pdf.getPdfPageData();
                ItextFunctions itextFunctions = new ItextFunctions(this.currentGUI, this.commonValues.getSelectedFile(), this.decode_pdf);
                itextFunctions.nup(this.commonValues.getPageCount(), pdfPageData, extractPDFPagesNup);
                break;
            }
            case 511: {
                if (this.fileIsURL) {
                    this.currentGUI.showMessageDialog(Messages.getMessage("PdfViewerMessage.CannotExportFromURL"));
                }
                if (this.commonValues.getSelectedFile() == null) {
                    this.currentGUI.showMessageDialog(Messages.getMessage("PdfViewer.NoFile"));
                    break;
                }
                if (this.fileIsURL) break;
                JFileChooser jFileChooser = new JFileChooser();
                jFileChooser.setFileSelectionMode(0);
                int n28 = jFileChooser.showSaveDialog(null);
                if (n28 != 0) break;
                File file = jFileChooser.getSelectedFile();
                ItextFunctions itextFunctions = new ItextFunctions(this.currentGUI, this.commonValues.getSelectedFile(), this.decode_pdf);
                itextFunctions.handouts(file.getAbsolutePath());
                break;
            }
            case 503: {
                if (this.commonValues.getSelectedFile() == null) {
                    this.currentGUI.showMessageDialog(Messages.getMessage("PdfViewer.NoFile"));
                    break;
                }
                DeletePDFPages deletePDFPages = new DeletePDFPages(this.commonValues.getInputDir(), this.commonValues.getPageCount(), this.commonValues.getCurrentPage());
                int n29 = deletePDFPages.display(this.currentGUI.getFrame(), Messages.getMessage("PdfViewerDelete.text"));
                if (n29 != 0) break;
                PdfPageData pdfPageData = this.decode_pdf.getPdfPageData();
                this.decode_pdf.closePdfFile();
                ItextFunctions itextFunctions = new ItextFunctions(this.currentGUI, this.commonValues.getSelectedFile(), this.decode_pdf);
                itextFunctions.delete(this.commonValues.getPageCount(), pdfPageData, deletePDFPages);
                this.open(this.commonValues.getSelectedFile());
                break;
            }
            case 506: {
                if (this.commonValues.getSelectedFile() == null) {
                    this.currentGUI.showMessageDialog(Messages.getMessage("PdfViewer.NoFile"));
                    break;
                }
                AddHeaderFooterToPDFPages addHeaderFooterToPDFPages = new AddHeaderFooterToPDFPages(this.commonValues.getInputDir(), this.commonValues.getPageCount(), this.commonValues.getCurrentPage());
                int n30 = addHeaderFooterToPDFPages.display(this.currentGUI.getFrame(), Messages.getMessage("PdfViewerTitle.AddHeaderAndFooters"));
                if (n30 != 0) break;
                PdfPageData pdfPageData = this.decode_pdf.getPdfPageData();
                this.decode_pdf.closePdfFile();
                ItextFunctions itextFunctions = new ItextFunctions(this.currentGUI, this.commonValues.getSelectedFile(), this.decode_pdf);
                itextFunctions.addHeaderFooter(this.commonValues.getPageCount(), pdfPageData, addHeaderFooterToPDFPages);
                this.open(this.commonValues.getSelectedFile());
                break;
            }
            case 507: {
                if (this.commonValues.getSelectedFile() == null) {
                    this.currentGUI.showMessageDialog(Messages.getMessage("PdfViewer.NoFile"));
                    break;
                }
                StampTextToPDFPages stampTextToPDFPages = new StampTextToPDFPages(this.commonValues.getInputDir(), this.commonValues.getPageCount(), this.commonValues.getCurrentPage());
                int n31 = stampTextToPDFPages.display(this.currentGUI.getFrame(), Messages.getMessage("PdfViewerStampText.text"));
                if (n31 != 0) break;
                PdfPageData pdfPageData = this.decode_pdf.getPdfPageData();
                this.decode_pdf.closePdfFile();
                ItextFunctions itextFunctions = new ItextFunctions(this.currentGUI, this.commonValues.getSelectedFile(), this.decode_pdf);
                itextFunctions.stampText(this.commonValues.getPageCount(), pdfPageData, stampTextToPDFPages);
                this.open(this.commonValues.getSelectedFile());
                break;
            }
            case 508: {
                if (this.commonValues.getSelectedFile() == null) {
                    this.currentGUI.showMessageDialog(Messages.getMessage("PdfViewer.NoFile"));
                    break;
                }
                StampImageToPDFPages stampImageToPDFPages = new StampImageToPDFPages(this.commonValues.getInputDir(), this.commonValues.getPageCount(), this.commonValues.getCurrentPage());
                int n32 = stampImageToPDFPages.display(this.currentGUI.getFrame(), Messages.getMessage("PdfViewerStampImage.text"));
                if (n32 != 0) break;
                PdfPageData pdfPageData = this.decode_pdf.getPdfPageData();
                this.decode_pdf.closePdfFile();
                ItextFunctions itextFunctions = new ItextFunctions(this.currentGUI, this.commonValues.getSelectedFile(), this.decode_pdf);
                itextFunctions.stampImage(this.commonValues.getPageCount(), pdfPageData, stampImageToPDFPages);
                this.open(this.commonValues.getSelectedFile());
                break;
            }
            case 504: {
                if (this.commonValues.getSelectedFile() == null) {
                    this.currentGUI.showMessageDialog(Messages.getMessage("PdfViewer.NoFile"));
                    break;
                }
                InsertBlankPDFPage insertBlankPDFPage = new InsertBlankPDFPage(this.commonValues.getInputDir(), this.commonValues.getPageCount(), this.commonValues.getCurrentPage());
                int n33 = insertBlankPDFPage.display(this.currentGUI.getFrame(), Messages.getMessage("PdfViewer.BlankPage"));
                if (n33 != 0) break;
                PdfPageData pdfPageData = this.decode_pdf.getPdfPageData();
                this.decode_pdf.closePdfFile();
                ItextFunctions itextFunctions = new ItextFunctions(this.currentGUI, this.commonValues.getSelectedFile(), this.decode_pdf);
                itextFunctions.add(this.commonValues.getPageCount(), pdfPageData, insertBlankPDFPage);
                this.open(this.commonValues.getSelectedFile());
                break;
            }
            case 505: {
                if (this.commonValues.getSelectedFile() == null) {
                    this.currentGUI.showMessageDialog(Messages.getMessage("PdfViewer.NoFile"));
                    break;
                }
                EncryptPDFDocument encryptPDFDocument = new EncryptPDFDocument(this.commonValues.getInputDir(), this.commonValues.getPageCount(), this.commonValues.getCurrentPage());
                int n34 = encryptPDFDocument.display(this.currentGUI.getFrame(), "Standard Security");
                if (n34 != 0) break;
                PdfPageData pdfPageData = this.decode_pdf.getPdfPageData();
                this.decode_pdf.closePdfFile();
                ItextFunctions itextFunctions = new ItextFunctions(this.currentGUI, this.commonValues.getSelectedFile(), this.decode_pdf);
                itextFunctions.encrypt(this.commonValues.getPageCount(), pdfPageData, encryptPDFDocument);
                this.open(this.commonValues.getSelectedFile());
                break;
            }
            default: {
                System.out.println("No menu item set");
            }
        }
    }

    private void saveChangedForm() {
        AcroRenderer acroRenderer = this.decode_pdf.getCurrentFormRenderer();
        if (acroRenderer == null) {
            return;
        }
        List list = null;
        try {
            list = acroRenderer.getComponentNameList();
        }
        catch (PdfException pdfException) {
            pdfException.printStackTrace();
        }
        if (list == null) {
            this.currentGUI.showMessageDialog(Messages.getMessage("PdfViewer.NoFields"));
        } else {
            Object object;
            File file = null;
            String string = "";
            boolean bl = false;
            while (!bl) {
                object = new JFileChooser(this.commonValues.getInputDir());
                ((JFileChooser)object).setSelectedFile(new File(this.commonValues.getInputDir() + '/' + this.commonValues.getSelectedFile()));
                ((JFileChooser)object).addChoosableFileFilter(new FileFilterer(new String[]{"pdf"}, "Pdf (*.pdf)"));
                ((JFileChooser)object).addChoosableFileFilter(new FileFilterer(new String[]{"fdf"}, "fdf (*.fdf)"));
                ((JFileChooser)object).setFileSelectionMode(0);
                int n = ((JFileChooser)object).showSaveDialog(null);
                if (n == 0) {
                    int n2;
                    file = ((JFileChooser)object).getSelectedFile();
                    string = file.getAbsolutePath();
                    if (!string.endsWith(".pdf")) {
                        string = string + ".pdf";
                        file = new File(string);
                    }
                    if (string.equals(this.commonValues.getSelectedFile())) {
                        this.currentGUI.showMessageDialog(Messages.getMessage("PdfViewerMessage.SaveError"));
                        continue;
                    }
                    if (file.exists() && (n2 = this.currentGUI.showConfirmDialog(string + '\n' + Messages.getMessage("PdfViewerMessage.FileAlreadyExists") + ".\n" + Messages.getMessage("PdfViewerMessage.ConfirmResave"), Messages.getMessage("PdfViewerMessage.Resave"), 0)) == 1) continue;
                    bl = true;
                    continue;
                }
                return;
            }
            object = new ItextFunctions(this.currentGUI, this.commonValues.getSelectedFile(), this.decode_pdf);
            ((ItextFunctions)object).saveFormsData(string);
            this.commonValues.setFormsChanged(false);
            this.currentGUI.setViewerTitle(null);
        }
    }

    public void handleUnsaveForms() {
        int n;
        if (this.commonValues.isFormsChanged() && this.commonValues.isItextOnClasspath() && (n = this.currentGUI.showConfirmDialog(Messages.getMessage("PdfViewerFormsUnsavedOptions.message"), Messages.getMessage("PdfViewerFormsUnsavedWarning.message"), 0)) == 0) {
            this.saveChangedForm();
        }
        this.commonValues.setFormsChanged(false);
    }

    public void extractSelectedScreenAsImage() {
        int n = this.commonValues.m_x1;
        int n2 = this.commonValues.m_x2;
        int n3 = this.commonValues.m_y1;
        int n4 = this.commonValues.m_y2;
        if (this.commonValues.m_y1 < this.commonValues.m_y2) {
            n4 = this.commonValues.m_y1;
            n3 = this.commonValues.m_y2;
        }
        if (this.commonValues.m_x1 > this.commonValues.m_x2) {
            n2 = this.commonValues.m_x1;
            n = this.commonValues.m_x2;
        }
        float f = 100.0f;
        if (PdfDecoder.isRunningOnWindows) {
            f = 100.0f * this.currentGUI.getScaling();
        }
        BufferedImage bufferedImage = this.decode_pdf.getSelectedRectangleOnscreen(n, n3, n2, n4, f);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        if (bufferedImage == null) {
            return;
        }
        Object object = new IconiseImage(bufferedImage);
        jPanel.add((Component)new JLabel((Icon)object), "Center");
        object = new JScrollPane();
        ((JScrollPane)object).getViewport().add(jPanel);
        int n5 = bufferedImage.getWidth();
        if (n5 < bufferedImage.getHeight()) {
            n5 = bufferedImage.getHeight();
        }
        if ((n5 += 50) > 450) {
            n5 = 450;
        }
        JFrame jFrame = this.currentGUI.getFrame();
        final JDialog jDialog = new JDialog((Frame)jFrame, true);
        if (this.commonValues.getModeOfOperation() != 1) {
            jDialog.setLocationRelativeTo(null);
            jDialog.setLocation(jFrame.getLocationOnScreen().x + 10, jFrame.getLocationOnScreen().y + 10);
        }
        jDialog.setSize(n5, n5);
        jDialog.setTitle(Messages.getMessage("PdfViewerMessage.SaveImage"));
        jDialog.getContentPane().setLayout(new BorderLayout());
        jDialog.getContentPane().add((Component)object, "Center");
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new BorderLayout());
        jDialog.getContentPane().add((Component)jPanel2, "South");
        JButton jButton = new JButton(Messages.getMessage("PdfMessage.Yes"));
        jButton.setFont(new Font("SansSerif", 0, 12));
        jPanel2.add((Component)jButton, "West");
        jButton.addActionListener(new ActionListener((JScrollPane)object, bufferedImage){
            private final /* synthetic */ JScrollPane val$image_scroll;
            private final /* synthetic */ BufferedImage val$snapShot;
            {
                this.val$image_scroll = jScrollPane;
                this.val$snapShot = bufferedImage;
            }

            public void actionPerformed(ActionEvent actionEvent) {
                jDialog.setVisible(false);
                File file = null;
                String string = "";
                boolean bl = false;
                while (!bl) {
                    JFileChooser jFileChooser = new JFileChooser(System.getProperty("user.dir"));
                    jFileChooser.addChoosableFileFilter(new FileFilterer(new String[]{"tif", "tiff"}, "TIFF"));
                    jFileChooser.addChoosableFileFilter(new FileFilterer(new String[]{"jpg", "jpeg"}, "JPEG"));
                    int n = jFileChooser.showSaveDialog(this.val$image_scroll);
                    if (n == 0) {
                        int n2;
                        file = jFileChooser.getSelectedFile();
                        string = file.getAbsolutePath();
                        String string2 = jFileChooser.getFileFilter().getDescription();
                        if (string2.equals("All Files")) {
                            string2 = "TIFF";
                        }
                        if (!string.toLowerCase().endsWith(('.' + string2).toLowerCase())) {
                            string = string + '.' + string2;
                            file = new File(string);
                        }
                        if (file.exists() && (n2 = Commands.this.currentGUI.showConfirmDialog(string + '\n' + Messages.getMessage("PdfViewerMessage.FileAlreadyExists") + ".\n" + Messages.getMessage("PdfViewerMessage.ConfirmResave"), Messages.getMessage("PdfViewerMessage.Resave"), 0)) == 1) continue;
                        if (JAIHelper.isJAIused()) {
                            JAIHelper.confirmJAIOnClasspath();
                        }
                        if (this.val$snapShot != null) {
                            if (JAIHelper.isJAIused()) {
                                JAI.create((String)"filestore", (RenderedImage)this.val$snapShot, (Object)string, (Object)string2);
                            } else if (string2.toLowerCase().startsWith("tif")) {
                                Commands.this.currentGUI.showMessageDialog("Please setup JAI library for Tiffs");
                            } else {
                                try {
                                    ImageIO.write((RenderedImage)this.val$snapShot, string2, new File(string));
                                }
                                catch (IOException iOException) {
                                    iOException.printStackTrace();
                                }
                            }
                        }
                        bl = true;
                        continue;
                    }
                    return;
                }
                jDialog.dispose();
            }
        });
        JButton jButton2 = new JButton(Messages.getMessage("PdfMessage.No"));
        jButton2.setFont(new Font("SansSerif", 0, 12));
        jPanel2.add((Component)jButton2, "East");
        jButton2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                jDialog.dispose();
            }
        });
        jDialog.setVisible(true);
    }

    public void extractSelectedText() {
        Object object;
        Object object2;
        int n;
        int n2;
        if (!this.decode_pdf.isExtractionAllowed()) {
            this.currentGUI.showMessageDialog("Not allowed");
            return;
        }
        int n3 = this.commonValues.m_x1;
        int n4 = this.commonValues.m_x2;
        int n5 = this.commonValues.m_y1;
        int n6 = this.commonValues.m_y2;
        if (n5 < n6) {
            n2 = n6;
            n6 = n5;
            n5 = n2;
        }
        if (n3 > n4) {
            n2 = n4;
            n4 = n3;
            n3 = n2;
        }
        if (n3 < this.currentGUI.cropX) {
            n3 = this.currentGUI.cropX;
        }
        if (n3 > this.currentGUI.mediaW - this.currentGUI.cropX) {
            n3 = this.currentGUI.mediaW - this.currentGUI.cropX;
        }
        if (n4 < this.currentGUI.cropX) {
            n4 = this.currentGUI.cropX;
        }
        if (n4 > this.currentGUI.mediaW - this.currentGUI.cropX) {
            n4 = this.currentGUI.mediaW - this.currentGUI.cropX;
        }
        if (n5 < this.currentGUI.cropY) {
            n5 = this.currentGUI.cropY;
        }
        if (n5 > this.currentGUI.mediaH - this.currentGUI.cropY) {
            n5 = this.currentGUI.mediaH - this.currentGUI.cropY;
        }
        if (n6 < this.currentGUI.cropY) {
            n6 = this.currentGUI.cropY;
        }
        if (n6 > this.currentGUI.mediaH - this.currentGUI.cropY) {
            n6 = this.currentGUI.mediaH - this.currentGUI.cropY;
        }
        String[] stringArray = new String[]{Messages.getMessage("PdfViewerRect.label"), Messages.getMessage("PdfViewerRect.message"), Messages.getMessage("PdfViewerTable.label"), Messages.getMessage("PdfViewerTable.message"), Messages.getMessage("PdfViewerWordList.label"), Messages.getMessage("PdfViewerWordList.message"), Messages.getMessage("PdfViewerFind.label"), Messages.getMessage("PdfViewerFind.message")};
        boolean bl = true;
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 1));
        JLabel jLabel = new JLabel(Messages.getMessage("PdfViewerCoords.message") + ' ' + this.commonValues.m_x1 + " , " + this.commonValues.m_y1 + " , " + this.commonValues.m_x2 + " , " + this.commonValues.m_y2);
        jLabel.setFont(this.headFont);
        jPanel.add(jLabel);
        jPanel.add(new JLabel(" "));
        int n7 = stringArray.length / 2;
        Object[] objectArray = new Object[n7 + 2];
        for (n = 0; n < n7; ++n) {
            objectArray[n + 2] = stringArray[n * 2];
            object2 = new JLabel(stringArray[n * 2]);
            ((JComponent)object2).setForeground(Color.blue);
            ((JComponent)object2).setFont(this.headFont);
            jPanel.add((Component)object2);
            object = new JLabel(stringArray[n * 2 + 1]);
            ((JComponent)object).setFont(this.headFont);
            jPanel.add((Component)object);
            jPanel.add(new JLabel(" "));
        }
        objectArray[0] = Messages.getMessage("PdfViewerCancel.text");
        objectArray[1] = Messages.getMessage("PdfViewerHelpMenu.text");
        this.display = true;
        while (this.display) {
            n = this.currentGUI.showOptionDialog(jPanel, Messages.getMessage("PdfViewerGroupingOptions.message"), 0, 1, null, objectArray, objectArray[0]);
            object2 = null;
            try {
                Container container;
                Serializable serializable;
                Object object3;
                JComponent jComponent;
                object = null;
                if (n > 1) {
                    object = this.decode_pdf.getGroupingObject();
                }
                this.display = false;
                switch (n) {
                    case 1: {
                        jComponent = new JTextArea(Messages.getMessage("PdfViewerGroupingInfo.message"));
                        this.currentGUI.showMessageDialog((JTextArea)jComponent);
                        this.display = true;
                        break;
                    }
                    case 2: {
                        object2 = ((PdfGroupingAlgorithms)object).extractTextInRectangle(n3, n5, n4, n6, this.commonValues.getCurrentPage(), false, true);
                        int n8 = this.currentGUI.showConfirmDialog(Messages.getMessage("PdfViewerXmlMessage.message"), Messages.getMessage("PdfViewerOutputFormat.message"), 0);
                        if (object2 == null) {
                            this.currentGUI.showMessageDialog(Messages.getMessage("PdfViewerMessage.NoTextFound"));
                            break;
                        }
                        if (n8 != 0) {
                            object2 = Strip.stripXML((String)object2).toString();
                            bl = false;
                            break;
                        }
                        bl = true;
                        break;
                    }
                    case 3: {
                        bl = true;
                        int n9 = this.currentGUI.showConfirmDialog(Messages.getMessage("PdfViewerXHTML.message"), Messages.getMessage("PdfViewerOutputFormat.message"), 0);
                        object3 = n9 != 0 ? ((PdfGroupingAlgorithms)object).extractTextAsTable(n3, n5, n4, n6, this.commonValues.getCurrentPage(), true, false, false, false, 0, false) : ((PdfGroupingAlgorithms)object).extractTextAsTable(n3, n5, n4, n6, this.commonValues.getCurrentPage(), false, true, true, false, 1, false);
                        object2 = (String)object3.get("content");
                        break;
                    }
                    case 4: {
                        int n10;
                        int n11;
                        int n12;
                        PdfGroupingAlgorithms.useUnrotatedCoords = true;
                        serializable = this.decode_pdf.getPdfPageData();
                        int n13 = ((PdfPageData)serializable).getRotation(this.commonValues.getCurrentPage());
                        if (n13 != 0 && (n12 = this.currentGUI.showConfirmDialog(Messages.getMessage("PdfViewerRotatedCoords.message"), Messages.getMessage("PdfViewerOutputFormat.message"), 0)) == 0) {
                            PdfGroupingAlgorithms.useUnrotatedCoords = false;
                        }
                        Vector vector = ((PdfGroupingAlgorithms)object).extractTextAsWordlist(n3, n5, n4, n6, this.commonValues.getCurrentPage(), false, true, "()!;.,\\/\"\"''");
                        int n14 = this.currentGUI.showConfirmDialog(Messages.getMessage("PdfViewerXmlMessage.message"), Messages.getMessage("PdfViewerOutputFormat.message"), 0);
                        if (vector == null) {
                            this.currentGUI.showMessageDialog(Messages.getMessage("PdfViewerMessage.NoTextFound"));
                        } else {
                            bl = n14 == 0;
                        }
                        if (vector == null) break;
                        CharSequence charSequence = new StringBuffer();
                        Iterator iterator = vector.iterator();
                        while (iterator.hasNext()) {
                            String string = (String)iterator.next();
                            if (!bl) {
                                string = Strip.convertToText(string);
                            }
                            n11 = (int)Float.parseFloat((String)iterator.next());
                            n10 = (int)Float.parseFloat((String)iterator.next());
                            int n15 = (int)Float.parseFloat((String)iterator.next());
                            int n16 = (int)Float.parseFloat((String)iterator.next());
                            ((StringBuffer)charSequence).append(string).append(',').append(n11).append(',').append(n10).append(',').append(n15).append(',').append(n16).append('\n');
                        }
                        object2 = ((StringBuffer)charSequence).toString();
                        break;
                    }
                    case 5: {
                        CharSequence charSequence = this.currentGUI.showInputDialog(Messages.getMessage("PdfViewerMessage.GetUserInput"));
                        if (charSequence == null || ((String)charSequence).length() < 1) {
                            this.display = true;
                            break;
                        }
                        boolean bl2 = false;
                        int n17 = this.currentGUI.showConfirmDialog(Messages.getMessage("PdfViewercase.message"), null, 0);
                        if (n17 == 0) {
                            bl2 = true;
                        }
                        int n11 = 0;
                        int n10 = this.currentGUI.showConfirmDialog(Messages.getMessage("PdfViewerfindAll.message"), null, 0);
                        if (n10 == 0) {
                            n11 = 1;
                        }
                        if (charSequence == null) break;
                        float[] fArray = ((PdfGroupingAlgorithms)object).findTextInRectangle(n3, n5, n4, n6, this.commonValues.getCurrentPage(), (String)charSequence, bl2, n11 != 0);
                        if (fArray != null) {
                            if (fArray.length < 3) {
                                this.currentGUI.showMessageDialog(Messages.getMessage("PdfViewerMessage.Found") + ' ' + fArray[0] + ',' + fArray[1]);
                                break;
                            }
                            StringBuffer stringBuffer = new StringBuffer();
                            for (int i = 0; i < fArray.length / 2; ++i) {
                                stringBuffer.append(Messages.getMessage("PdfViewerMessage.FoundAt")).append(' ');
                                System.out.println("coord.length=" + fArray.length + " i=" + i);
                                stringBuffer.append(fArray[i * 2]);
                                stringBuffer.append(',');
                                stringBuffer.append(fArray[i * 2 + 1]);
                                stringBuffer.append('\n');
                            }
                            this.currentGUI.showMessageDialog(stringBuffer.toString());
                            break;
                        }
                        this.currentGUI.showMessageDialog(Messages.getMessage("PdfViewerMessage.NotFound"));
                        break;
                    }
                }
                if (object2 == null) continue;
                jComponent = new JScrollPane();
                try {
                    container = new JTextPane();
                    jComponent = this.currentGUI.createPane((JTextPane)container, (String)object2, bl);
                }
                catch (BadLocationException badLocationException) {
                    badLocationException.printStackTrace();
                }
                ((JScrollPane)jComponent).setHorizontalScrollBarPolicy(31);
                ((JScrollPane)jComponent).setVerticalScrollBarPolicy(20);
                jComponent.setPreferredSize(new Dimension(400, 400));
                container = new JDialog((Frame)this.currentGUI.getFrame(), true);
                if (this.commonValues.getModeOfOperation() != 1) {
                    object3 = this.currentGUI.getFrame();
                    ((Window)container).setLocation(((Component)object3).getLocationOnScreen().x + 10, ((Component)object3).getLocationOnScreen().y + 10);
                }
                ((Window)container).setSize(450, 450);
                ((Dialog)container).setTitle(Messages.getMessage("PdfViewerExtractedText.menu"));
                ((JDialog)container).getContentPane().setLayout(new BorderLayout());
                ((JDialog)container).getContentPane().add((Component)jComponent, "Center");
                object3 = new JPanel();
                ((Container)object3).setLayout(new BorderLayout());
                ((JDialog)container).getContentPane().add((Component)object3, "South");
                JButton jButton = new JButton(Messages.getMessage("PdfViewerMenu.return"));
                jButton.setFont(new Font("SansSerif", 0, 12));
                ((Container)object3).add((Component)jButton, "West");
                jButton.addActionListener(new ActionListener((JDialog)container){
                    private final /* synthetic */ JDialog val$displayFrame;
                    {
                        this.val$displayFrame = jDialog;
                    }

                    public void actionPerformed(ActionEvent actionEvent) {
                        Commands.this.display = true;
                        this.val$displayFrame.dispose();
                    }
                });
                serializable = new JButton(Messages.getMessage("PdfViewerFileMenuExit.text"));
                ((JComponent)serializable).setFont(new Font("SansSerif", 0, 12));
                ((Container)object3).add((Component)serializable, "East");
                ((AbstractButton)serializable).addActionListener(new ActionListener((JDialog)container){
                    private final /* synthetic */ JDialog val$displayFrame;
                    {
                        this.val$displayFrame = jDialog;
                    }

                    public void actionPerformed(ActionEvent actionEvent) {
                        this.val$displayFrame.dispose();
                    }
                });
                ((Dialog)container).setVisible(true);
            }
            catch (PdfException pdfException) {
                System.err.println("Exception " + pdfException.getMessage() + " in file " + this.commonValues.getSelectedFile());
                pdfException.printStackTrace();
            }
        }
    }

    private void decodeImage(final boolean bl) {
        this.decode_pdf.setFoundTextArea(null);
        this.decode_pdf.setFoundTextAreas(null);
        this.currentGUI.setRectangle(null);
        this.currentGUI.resetComboBoxes(false);
        this.decode_pdf.clearScreen();
        this.thumbnails.terminateDrawing();
        this.commonValues.setProcessing(true);
        SwingWorker swingWorker = new SwingWorker(){

            public Object construct() {
                try {
                    Commands.this.currentGUI.updateStatusMessage(Messages.getMessage("PdfViewerDecoding.page"));
                    if (Commands.this.img != null) {
                        Commands.this.decode_pdf.addImage(Commands.this.img);
                    }
                    PdfPageData pdfPageData = Commands.this.decode_pdf.getPdfPageData();
                    if (Commands.this.img != null) {
                        pdfPageData.setMediaBox("0 0 " + Commands.this.img.getWidth() + ' ' + Commands.this.img.getHeight());
                    }
                    pdfPageData.checkSizeSet(1);
                    Commands.this.currentGUI.resetRotationBox();
                    if (bl && Commands.this.thumbnails.isShownOnscreen()) {
                        Commands.this.currentGUI.zoom(false);
                    }
                    if (Thread.interrupted()) {
                        throw new InterruptedException();
                    }
                    Commands.this.currentGUI.setPageNumber();
                    Commands.this.currentGUI.setViewerTitle(null);
                }
                catch (Exception exception) {
                    Commands.this.currentGUI.setViewerTitle(null);
                }
                Commands.this.currentGUI.setStatusProgress(100);
                Commands.this.currentGUI.resetComboBoxes(true);
                Commands.this.decode_pdf.repaint();
                return null;
            }
        };
        swingWorker.start();
    }

    protected boolean openUpFile(String string) {
        this.commonValues.maxViewY = 0;
        boolean bl = true;
        this.decode_pdf.closePdfFile();
        this.currentGUI.setScalingToDefault();
        this.decode_pdf.markAllPagesAsUnread();
        try {
            if (this.commonValues.isPDF()) {
                if (string.startsWith("http:") || string.startsWith("file:")) {
                    try {
                        this.decode_pdf.openPdfFileFromURL(this.commonValues.getSelectedFile());
                    }
                    catch (Exception exception) {
                        this.currentGUI.showMessageDialog(Messages.getMessage("PdfViewer.UrlError"));
                        string = null;
                        bl = false;
                    }
                } else {
                    this.decode_pdf.openPdfFile(this.commonValues.getSelectedFile());
                }
                this.currentGUI.reinitThumbnails();
            } else {
                boolean bl2;
                boolean bl3;
                this.decode_pdf.resetForNonPDFPage();
                boolean bl4 = bl3 = string.toLowerCase().indexOf(".tif") != -1;
                if (JAIHelper.isJAIused()) {
                    JAIHelper.confirmJAIOnClasspath();
                }
                boolean bl5 = bl2 = string.startsWith("http:") || string.startsWith("file:");
                if (bl3 && JAIHelper.isJAIused()) {
                    try {
                        String string2 = this.commonValues.getSelectedFile();
                        this.img = JAI.create((String)"fileload", (Object)string).getAsBufferedImage();
                    }
                    catch (Exception exception) {
                        LogWriter.writeLog("Exception " + exception + Messages.getMessage("PdfViewerError.Loading") + this.commonValues.getSelectedFile());
                    }
                } else {
                    try {
                        this.img = bl2 ? ImageIO.read(new URL(string)) : ImageIO.read(new File(string));
                    }
                    catch (Exception exception) {
                        LogWriter.writeLog("Exception " + exception + "loading " + this.commonValues.getSelectedFile());
                    }
                }
            }
            this.currentGUI.updateStatusMessage("opening file");
            if (bl && this.decode_pdf.isEncrypted() && !this.decode_pdf.isFileViewable()) {
                bl = false;
                String string3 = this.currentGUI.showInputDialog(Messages.getMessage("PdfViewerPassword.message"));
                if (string3 != null) {
                    this.decode_pdf.setEncryptionPassword(string3);
                    if (this.decode_pdf.isFileViewable()) {
                        bl = true;
                    }
                }
                if (!bl) {
                    this.currentGUI.showMessageDialog(Messages.getMessage("PdfViewerPasswordRequired.message"));
                }
            }
            if (bl) {
                if (!this.commonValues.isContentExtractor()) {
                    this.properties.addRecentDocument(this.commonValues.getSelectedFile());
                    this.updateRecentDocuments(this.properties.getRecentDocuments());
                }
                this.recent.addToFileList(this.commonValues.getSelectedFile());
                this.commonValues.setCurrentPage(1);
            }
        }
        catch (Exception exception) {
            System.err.println("Exception " + exception + " opening file");
            ErrorDialog.showError(exception, Messages.getMessage("PdfViewerOpenerror"), this.currentGUI.getFrame());
            System.exit(1);
        }
        if (!this.decode_pdf.isOpen() && this.commonValues.isPDF()) {
            return false;
        }
        return bl;
    }

    public void openFile(String string) {
        String string2;
        String string3 = System.getProperty("org.jpedal.hires");
        if (string3 != null) {
            this.commonValues.setUseHiresImage(true);
        }
        if ((string2 = System.getProperty("org.jpedal.memory")) != null) {
            this.commonValues.setUseHiresImage(false);
        }
        this.thumbnails.resetToDefault();
        this.currentGUI.setNoPagesDecoded();
        if (this.searchFrame != null) {
            this.searchFrame.removeSearchWindow(false);
        }
        this.commonValues.maxViewY = 0;
        String string4 = string.toLowerCase().trim();
        this.commonValues.setPDF(string4.endsWith(".pdf") || string4.endsWith(".fdf"));
        this.currentGUI.setQualityBoxVisible(this.commonValues.isPDF());
        this.commonValues.setCurrentPage(1);
        boolean bl = this.openUpFile(this.commonValues.getSelectedFile());
        try {
            if (bl) {
                this.processPage();
            } else {
                this.currentGUI.setViewerTitle(Messages.getMessage("PdfViewer.NoFile"));
                this.decode_pdf.clearScreen();
                this.currentGUI.zoom(false);
                this.commonValues.setPageCount(1);
                this.commonValues.setCurrentPage(1);
            }
        }
        catch (Exception exception) {
            System.err.println(Messages.getMessage("PdfViewerError.Exception") + ' ' + exception + ' ' + Messages.getMessage("PdfViewerError.DecodeFile"));
        }
    }

    protected void processPage() {
        if (this.commonValues.isPDF() && (this.decode_pdf.isOpen() || !this.commonValues.isPDF())) {
            PdfFileInformation pdfFileInformation = this.decode_pdf.getFileInformationData();
            this.decode_pdf.setRenderMode(3);
            String[] stringArray = pdfFileInformation.getFieldValues();
            String[] stringArray2 = pdfFileInformation.getFieldNames();
            String[] stringArray3 = new String[]{"TeleForm", "dgn2pdf"};
            for (int i = 0; i < stringArray2.length; ++i) {
                boolean bl;
                if (stringArray2[i].equals("Creator") | stringArray2[i].equals("Producer")) {
                    for (bl = false; bl < stringArray3.length; bl += 1) {
                        if (!stringArray[i].equals(stringArray3[bl])) continue;
                        this.decode_pdf.setRenderMode(2);
                        this.decode_pdf.setEnableLegacyJPEGConversion(true);
                    }
                }
                bl = this.commonValues.isProcessing();
                this.commonValues.setProcessing(true);
                if (this.commonValues.isUseHiresImage()) {
                    this.decode_pdf.useHiResScreenDisplay(true);
                    this.currentGUI.setSelectedComboIndex(250, 1);
                } else {
                    this.decode_pdf.useHiResScreenDisplay(false);
                    this.currentGUI.setSelectedComboIndex(250, 0);
                }
                this.commonValues.setProcessing(bl);
            }
        }
        this.commonValues.setPageCount(this.decode_pdf.getPageCount());
        if (!this.commonValues.isPDF()) {
            this.commonValues.setPageCount(1);
            this.decode_pdf.useHiResScreenDisplay(true);
        }
        if (this.commonValues.getPageCount() < this.commonValues.getCurrentPage()) {
            this.commonValues.setCurrentPage(this.commonValues.getPageCount());
            System.err.println(this.commonValues.getCurrentPage() + " out of range. Opening on last page");
            LogWriter.writeLog(this.commonValues.getCurrentPage() + " out of range. Opening on last page");
        }
        this.decode_pdf.setExtractionMode(1, 72, this.currentGUI.getScaling());
        this.currentGUI.setPageNumber();
        this.currentGUI.resetRotationBox();
        if (this.commonValues.isPDF()) {
            this.currentGUI.messageShown = false;
            this.currentGUI.decodePage(true);
        } else {
            this.currentGUI.zoom(false);
            this.decode_pdf.setPDFBorder(BorderFactory.createLineBorder(Color.black, 1));
            this.decode_pdf.disableBorderForPrinting();
            this.decodeImage(true);
            this.commonValues.setProcessing(false);
        }
    }

    public void selectFile() {
        if (this.searchFrame != null) {
            this.searchFrame.removeSearchWindow(false);
        }
        this.currentGUI.resetNavBar();
        JFileChooser jFileChooser = new JFileChooser(this.commonValues.getInputDir());
        jFileChooser.setName("chooser");
        if (this.commonValues.getSelectedFile() != null) {
            jFileChooser.setSelectedFile(new File(this.commonValues.getSelectedFile()));
        }
        jFileChooser.setFileSelectionMode(0);
        String[] stringArray = new String[]{"pdf"};
        String[] stringArray2 = new String[]{"fdf"};
        String[] stringArray3 = new String[]{"png", "tif", "tiff", "jpg", "jpeg"};
        jFileChooser.addChoosableFileFilter(new FileFilterer(stringArray3, "Images (Tiff, Jpeg,Png)"));
        jFileChooser.addChoosableFileFilter(new FileFilterer(stringArray2, "fdf (*.fdf)"));
        jFileChooser.addChoosableFileFilter(new FileFilterer(stringArray, "Pdf (*.pdf)"));
        int n = jFileChooser.showOpenDialog(this.currentGUI.getFrame());
        File file = jFileChooser.getSelectedFile();
        if (file != null && n == 0) {
            boolean bl;
            String string = file.getName().toLowerCase();
            boolean bl2 = bl = string.endsWith(".pdf") || string.endsWith(".fdf") || string.endsWith(".tif") || string.endsWith(".tiff") || string.endsWith(".png") || string.endsWith(".jpg") || string.endsWith(".jpeg");
            if (bl) {
                try {
                    this.commonValues.setInputDir(jFileChooser.getCurrentDirectory().getCanonicalPath());
                    this.open(file.getAbsolutePath());
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
            } else {
                this.decode_pdf.repaint();
                this.currentGUI.showMessageDialog(Messages.getMessage("PdfViewer.NotValidPdfWarning"));
            }
        } else {
            this.decode_pdf.repaint();
            this.currentGUI.showMessageDialog(Messages.getMessage("PdfViewerMessage.NoSelection"));
        }
    }

    private String selectURL() {
        boolean bl;
        String string = this.currentGUI.showInputDialog(Messages.getMessage("PdfViewerMessage.RequestURL"));
        if (string != null) {
            string = string.trim();
        }
        if (string != null && !string.trim().startsWith("http://") && !string.trim().startsWith("file:/")) {
            this.currentGUI.showMessageDialog(Messages.getMessage("PdfViewerMessage.URLMustContain"));
            string = null;
        }
        if (string != null) {
            boolean bl2 = bl = string.endsWith(".pdf") || string.endsWith(".fdf") || string.endsWith(".tif") || string.endsWith(".tiff") || string.endsWith(".png") || string.endsWith(".jpg") || string.endsWith(".jpeg");
            if (!bl) {
                this.currentGUI.showMessageDialog(Messages.getMessage("PdfViewer.NotValidPdfWarning"));
                string = null;
            }
        }
        if (string != null) {
            this.commonValues.setSelectedFile(string);
            bl = false;
            try {
                URL uRL = new URL(string);
                URLConnection uRLConnection = uRL.openConnection();
                if (uRLConnection.getContent() == null) {
                    bl = true;
                }
            }
            catch (Exception exception) {
                bl = true;
            }
            if (bl) {
                string = null;
                this.currentGUI.showMessageDialog("URL " + string + ' ' + Messages.getMessage("PdfViewerError.DoesNotExist"));
            }
        }
        if (string != null) {
            try {
                this.commonValues.setFileSize(0L);
                this.currentGUI.setViewerTitle(null);
            }
            catch (Exception exception) {
                System.err.println(Messages.getMessage("PdfViewerError.Exception") + ' ' + exception + ' ' + Messages.getMessage("PdfViewerError.GettingPaths"));
            }
            if (string != null && !this.commonValues.isProcessing()) {
                this.thumbnails.terminateDrawing();
                this.decode_pdf.flushObjectValues(true);
                this.decode_pdf.resetViewableArea();
                this.currentGUI.stopThumbnails();
                this.openFile(this.commonValues.getSelectedFile());
            }
        } else {
            this.decode_pdf.repaint();
            this.currentGUI.showMessageDialog(Messages.getMessage("PdfViewerMessage.NoSelection"));
        }
        return string;
    }

    private void forward(int n) {
        if (!this.commonValues.isProcessing()) {
            int n2 = this.commonValues.getCurrentPage() + n;
            if (n2 <= this.commonValues.getPageCount()) {
                if ((this.decode_pdf.getDisplayView() == 3 || this.decode_pdf.getDisplayView() == 4) && (n2 & 1) == 1) {
                    if (n2 < this.commonValues.getPageCount()) {
                        ++n2;
                    } else if (this.commonValues.getPageCount() - n2 > 1) {
                        --n2;
                    }
                }
                this.commonValues.setCurrentPage(n2);
                this.currentGUI.setPageNumber();
                if (this.decode_pdf.getDisplayView() == 2 || this.decode_pdf.getDisplayView() == 4) {
                    this.currentGUI.decodePage(false);
                    return;
                }
                this.currentGUI.resetStatusMessage("Loading Page " + this.commonValues.getCurrentPage());
                this.decode_pdf.setPageParameters(this.currentGUI.getScaling(), this.commonValues.getCurrentPage());
                this.currentGUI.decodePage(false);
            }
        } else {
            this.currentGUI.showMessageDialog(Messages.getMessage("PdfViewerDecodeWait.message"));
        }
    }

    private void back(int n) {
        if (!this.commonValues.isProcessing()) {
            int n2 = this.commonValues.getCurrentPage() - n;
            if (n2 >= 1) {
                if ((this.decode_pdf.getDisplayView() == 3 || this.decode_pdf.getDisplayView() == 4) && (n2 & 1) == 1 && n2 != 1) {
                    --n2;
                }
                this.commonValues.setCurrentPage(n2);
                this.currentGUI.setPageNumber();
                if (this.decode_pdf.getDisplayView() == 2 || this.decode_pdf.getDisplayView() == 4) {
                    this.currentGUI.decodePage(false);
                    return;
                }
                this.currentGUI.resetStatusMessage("loading page " + this.commonValues.getCurrentPage());
                this.decode_pdf.setPageParameters(this.currentGUI.getScaling(), this.commonValues.getCurrentPage());
                this.currentGUI.decodePage(false);
            }
        } else {
            this.currentGUI.showMessageDialog(Messages.getMessage("PdfViewerDecodeWait.message"));
        }
    }

    public void gotoPage(String string) {
        int n;
        try {
            n = Integer.parseInt(string);
            if ((this.decode_pdf.getDisplayView() == 3 || this.decode_pdf.getDisplayView() == 4) && (n & 1) == 1 && n != 1) {
                --n;
            }
            if (n > this.decode_pdf.getPageCount() | n < 1) {
                this.currentGUI.showMessageDialog(Messages.getMessage("PdfViewerPageLabel.text") + ' ' + string + ' ' + Messages.getMessage("PdfViewerOutOfRange.text") + ' ' + this.decode_pdf.getPageCount());
                n = this.commonValues.getCurrentPage();
                this.currentGUI.setPageNumber();
            }
        }
        catch (Exception exception) {
            this.currentGUI.showMessageDialog('>' + string + "< " + Messages.getMessage("PdfViewerInvalidNumber.text"));
            n = this.commonValues.getCurrentPage();
            this.currentGUI.pageCounter2.setText(String.valueOf(this.commonValues.getCurrentPage()));
        }
        if (!this.commonValues.isProcessing() && this.commonValues.getCurrentPage() != n) {
            this.commonValues.setCurrentPage(n);
            this.currentGUI.decodePage(false);
        }
    }

    private void open(String string) {
        this.currentGUI.resetNavBar();
        boolean bl = string.startsWith("http:");
        try {
            if (!bl) {
                this.fileIsURL = false;
                this.commonValues.setFileSize(new File(string).length() >> 10);
            } else {
                this.fileIsURL = true;
            }
            this.commonValues.setSelectedFile(string);
            this.currentGUI.setViewerTitle(null);
        }
        catch (Exception exception) {
            LogWriter.writeLog("Exception " + exception + " getting paths");
        }
        File file = new File(this.commonValues.getSelectedFile());
        if (!bl && !file.exists()) {
            this.currentGUI.showMessageDialog(Messages.getMessage("PdfViewerFile.text") + this.commonValues.getSelectedFile() + Messages.getMessage("PdfViewerNotExist"));
        } else if (this.commonValues.getSelectedFile() != null && !this.commonValues.isProcessing()) {
            this.currentGUI.stopThumbnails();
            this.decode_pdf.flushObjectValues(true);
            this.decode_pdf.resetViewableArea();
            SwingWorker swingWorker = new SwingWorker(){

                public Object construct() {
                    if (!Commands.this.isOpening) {
                        Commands.this.isOpening = true;
                        Commands.this.openFile(Commands.this.commonValues.getSelectedFile());
                        Commands.this.isOpening = false;
                    }
                    return null;
                }
            };
            swingWorker.start();
        }
    }

    private void updateRecentDocuments(String[] stringArray) {
        if (stringArray == null) {
            return;
        }
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i] == null) continue;
            String string = this.recent.getShortenedFileName(stringArray[i]);
            this.recentDocuments[i].setText(i + 1 + ": " + string);
            if (this.recentDocuments[i].getText().equals(i + 1 + ": ")) {
                this.recentDocuments[i].setVisible(false);
            } else {
                this.recentDocuments[i].setVisible(true);
            }
            this.recentDocuments[i].setName(stringArray[i]);
        }
    }

    protected void recentDocumentsOption(JMenu jMenu) {
        String[] stringArray = this.properties.getRecentDocuments();
        if (stringArray == null) {
            return;
        }
        for (int i = 0; i < this.noOfRecentDocs; ++i) {
            if (stringArray[i] == null) {
                stringArray[i] = "";
            }
            String string = stringArray[i];
            String string2 = this.recent.getShortenedFileName(string);
            this.recentDocuments[i] = new JMenuItem(i + 1 + ": " + string2);
            if (this.recentDocuments[i].getText().equals(i + 1 + ": ")) {
                this.recentDocuments[i].setVisible(false);
            }
            this.recentDocuments[i].setName(string);
            this.recentDocuments[i].addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    if (Commands.this.currentPrinter.isPrinting()) {
                        Commands.this.currentGUI.showMessageDialog(Messages.getMessage("PdfViewerPrintWait.message"));
                    } else if (Commands.this.commonValues.isProcessing() || Commands.this.isOpening) {
                        Commands.this.currentGUI.showMessageDialog(Messages.getMessage("PdfViewerDecodeWait.message"));
                    } else {
                        Commands.this.handleUnsaveForms();
                        JMenuItem jMenuItem = (JMenuItem)actionEvent.getSource();
                        String string = jMenuItem.getName();
                        if (string.length() != 0) {
                            Commands.this.open(string);
                        }
                    }
                }
            });
            jMenu.add(this.recentDocuments[i]);
        }
    }

    private void saveFile() {
        File file = null;
        String string = "";
        boolean bl = false;
        while (!bl) {
            JFileChooser jFileChooser = new JFileChooser(this.commonValues.getInputDir());
            jFileChooser.setSelectedFile(new File(this.commonValues.getInputDir() + '/' + this.commonValues.getSelectedFile()));
            jFileChooser.addChoosableFileFilter(new FileFilterer(new String[]{"pdf"}, "Pdf (*.pdf)"));
            jFileChooser.addChoosableFileFilter(new FileFilterer(new String[]{"fdf"}, "fdf (*.fdf)"));
            jFileChooser.setFileSelectionMode(0);
            int n = jFileChooser.showSaveDialog(null);
            if (n == 0) {
                int n2;
                FileInputStream fileInputStream = null;
                FileOutputStream fileOutputStream = null;
                file = jFileChooser.getSelectedFile();
                string = file.getAbsolutePath();
                if (!string.endsWith(".pdf")) {
                    string = string + ".pdf";
                    file = new File(string);
                }
                if (string.equals(this.commonValues.getSelectedFile())) {
                    return;
                }
                if (file.exists() && (n2 = this.currentGUI.showConfirmDialog(string + '\n' + Messages.getMessage("PdfViewerMessage.FileAlreadyExists") + '\n' + Messages.getMessage("PdfViewerMessage.ConfirmResave"), Messages.getMessage("PdfViewerMessage.Resave"), 0)) == 1) continue;
                try {
                    int n3;
                    fileInputStream = new FileInputStream(this.commonValues.getSelectedFile());
                    fileOutputStream = new FileOutputStream(string);
                    byte[] byArray = new byte[4096];
                    while ((n3 = fileInputStream.read(byArray)) != -1) {
                        fileOutputStream.write(byArray, 0, n3);
                    }
                }
                catch (Exception exception) {
                    this.currentGUI.showMessageDialog(Messages.getMessage("PdfViewerException.NotSaveInternetFile"));
                }
                try {
                    fileInputStream.close();
                    fileOutputStream.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                bl = true;
                continue;
            }
            return;
        }
    }

    private void exit() {
        this.thumbnails.terminateDrawing();
        this.handleUnsaveForms();
        this.currentGUI.showConfirmDialog(new JLabel(Messages.getMessage("PdfViewerExiting")), Messages.getMessage("PdfViewerprogramExit"), -1, -1);
        this.decode_pdf.closePdfFile();
        this.flush();
        System.exit(1);
    }

    public final void flush() {
        File file;
        String[] stringArray;
        String string = this.commonValues.getTarget();
        if (string != null && (stringArray = (file = new File(string)).list()) != null) {
            for (int i = 0; i < stringArray.length; ++i) {
                File file2 = new File(string + this.commonValues.getSeparator() + stringArray[i]);
                file2.delete();
            }
        }
    }
}

